/*****************************************************************************
** File:        KeyClick.c
**
** Author:      Daniel Vik
**
** Description: Emulation of key klick sound
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "KeyClick.h"
#include <stdlib.h>
#include <string.h>

#define BUFFER_SIZE     1024


Int32 envelope[] = {
    1200, 9200, 16000, 12800, 3200, 600, 60
};

static Int32* audioKeyClickSync(void* ref, UInt32 count);

struct AudioKeyClick
{
    Mixer* mixer;
    UInt32 phase;
    Int32  buffer[BUFFER_SIZE];
};

Int32 audioKeyClickGetSize() {
    return sizeof(AudioKeyClick);
}

AudioKeyClick* audioKeyClickCreate(Mixer* mixer, UInt32 cpuClock)
{
    AudioKeyClick* keyClick = (AudioKeyClick*)calloc(1, sizeof(AudioKeyClick));

    keyClick->mixer = mixer;
    keyClick->phase = sizeof(envelope) / sizeof(Int32);

    mixerRegisterChannel(mixer, MIXER_CHANNEL_KEYBOARD, 0, audioKeyClickSync, keyClick);

    return keyClick;
}

void audioKeyClickDestroy(AudioKeyClick* keyClick)
{
    mixerUnregisterChannel(keyClick->mixer, MIXER_CHANNEL_KEYBOARD);
    free(keyClick);
}

void audioKeyClick(AudioKeyClick* keyClick, UInt32 cpuClock)
{
    mixerSync(keyClick->mixer, cpuClock);
    keyClick->phase = 0;
}

static Int32* audioKeyClickSync(void* ref, UInt32 count)
{
    AudioKeyClick* keyClick = (AudioKeyClick*)ref;
    Int32 index = 0;

    memset(keyClick->buffer, 0, sizeof(envelope) * sizeof(Int32));

    while (count-- > 0 && keyClick->phase < sizeof(envelope) / sizeof(Int32)) {
        keyClick->buffer[index++] = envelope[keyClick->phase++];
    }

    return keyClick->buffer;
}
