/*****************************************************************************
** File:
**      SlotManager.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Slot handling methods
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef SLOT_MANAGER_H
#define SLOT_MANAGER_H

#include "MSXTypes.h"
#include "KeyClick.h"

typedef struct {
    void  (*destroy)(void* arg);
    UInt8 (*read)(void*, UInt16, UInt32);
    void  (*write)(void*, UInt16, UInt8, UInt32);
    int   (*getState)(void* arg, UInt8* buffer, UInt32 systemTime);
    int   (*setState)(void* arg, UInt8* buffer, UInt32 systemTime);
} SlotCallbacks;


void slotManagerCreate(UInt8* keymap, AudioKeyClick* keyClick);
void slotManagerDestroy();

int slotGetState(void* ref, UInt8* buffer, UInt32 systemTime);
int slotSetState(void* ref, UInt8* buffer, UInt32 systemTime);

void slotWrite(UInt16 address, UInt8 value, UInt32 systemTime);
UInt8 slotRead(UInt16 address, UInt32 systemTime);

void slotRegister(int type, int slot, int sslot, int startpage, int pages,
                  SlotCallbacks* callbacks, void* ref);
void slotUnregister(int slot, int sslot, int startpage);

void slotRemove(int slot, int sslot, int startpage);

int slotRegisterUnslotted(int type, SlotCallbacks* callbacks, void* ref);
void slotUnregisterUnslotted(int slotHandle);

void slotRegisterWrite0(SlotCallbacks* callbacks, void* ref);
void slotUnregisterWrite0();

void slotMapRamPage(int slot, int sslot, int page);

void slotMapPage(int slot, int sslot, int page, UInt8* pageData, 
                 int readEnable, int writeEnable);
void slotUnmapPage(int slot, int sslot, int page);

void slotSetSubslotted(int slot, int subslotted);

#endif
