/*****************************************************************************
** File:
**      Video.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Contains methods to render PAL emulated video images.
**      The source bitmap shall contain 32 bit pixels with
**      color values that are get from the videoGetColor
**      method.
**
******************************************************************************
*/
#ifndef VIDEO_RENDER_H
#define VIDEO_RENDER_H

#include "msxTypes.h"

typedef enum { 
    VIDEO_GREEN, 
    VIDEO_COLOR, 
    VIDEO_BLACKWHITE 
} VideoColorMode;

typedef enum { 
    VIDEO_PAL_FAST, 
    VIDEO_PAL_SHARP, 
    VIDEO_PAL_BLUR, 
    VIDEO_PAL_SHARP_NOISE, 
    VIDEO_PAL_BLUR_NOISE,
	VIDEO_PAL_SCALE2X
} VideoPalMode;

typedef struct Video Video;

Video* videoCreate();

void videoDestroy(Video* pVideo);

void videoSetFrameSkip(Video* pVideo, UInt32 skipCount);

void videoSetColorMode(Video* pVideo, VideoColorMode colorMode);

void videoSetPalMode(Video* pVideo, VideoPalMode palMode);

void videoRender(Video* pVideo, int bitDepth, int zoom, int evenOddPage, int interlace,
                 void* pSrc, int srcWidth, int srcHeight, int* srcDoubleWidth,
                 void* pDst, int srcPitch, int dstPitch);

UInt32 videoGetColor(Video* pVideo, int R, int G, int B);

#endif
