#ifndef LANGUAGE_ENGLISH_H
#define LANGUAGE_ENGLISH_H

#include "LanguageStrings.h"
 
void langInitEnglish(LanguageStrings* ls) 
{
    ls->statusBarStopped        = "  Stopped";
    ls->statusBarPaused         = "  Paused";
    ls->statusBarRunning        = "  Running";
    
    ls->menuHardReset           = "Hard Reset";
    ls->menuSoftReset           = "Soft Reset";
    
    ls->menuCartInsert          = "Insert";
    ls->menuCartRemove          = "Remove";
    ls->menuCartAutoReset       = "Reset After Insert/Remove";
    ls->menuCartNoRecentFiles   = "- no recent files -";
    ls->menuCartSCCPlus         = "SCC+ Cartridge";
    ls->menuCartFMPac           = "FM-PAC Cartridge";
    ls->menuCartSpecial         = "Special";

    ls->menuDiskInsert          = "Insert";
    ls->menuDiskEject           = "Eject";
    ls->menuDiskAutoStart       = "Reset After Insert";
    ls->menuDiskNoRecentFiles   = "- no recent files -";
    
    ls->menuCasInsert           = "Insert";
    ls->menuCasEject            = "Eject";
    ls->menuCasSetPosition      = "Set Position";
    ls->menuCasRewind           = "Rewind";
    ls->menuDiskNoRecentFiles   = "- no recent files -";

    ls->menuZoomNormal          = "Normal Size";
    ls->menuZoomDouble          = "Double Size";
    ls->menuZoomFullscreen      = "Fullscreen";
    
    ls->menuPropsEmulation      = "Emulation";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "Sound";
    ls->menuPropsControls       = "Controls";
    ls->menuPropsPerformance    = "Performance";
    ls->menuPropsLanguage       = "Language";
    
    ls->menuHelpHelp            = "Help Topics";
    ls->menuHelpAbout           = "About blueMSX";

    ls->menuFileCart1           = "Cartridge Slot 1";
    ls->menuFileCart2           = "Cartridge Slot 2";
    ls->menuFileDiskA           = "Disk Drive A";
    ls->menuFileDiskB           = "Disk Drive B";
    ls->menuFileCas             = "Cassette";
    ls->menuFileLoadState       = "Load CPU State";
    ls->menuFileSaveState       = "Save CPU State";
    ls->menuFileQLoadState      = "Quick Load State";
    ls->menuFileQSaveState      = "Quick Save State";
    ls->menuFileCaptureAudio    = "Capture Audio";
    ls->menuFileScreenShot      = "Save Screenshot";
    ls->menuFileExit            = "Exit";

    ls->menuRunRun              = "Run";
    ls->menuRunPause            = "Pause";
    ls->menuRunStop             = "Stop";
    ls->menuRunSoftReset        = "Soft Reset";
    ls->menuRunHardReset        = "Hard Reset";
    ls->menuRunCleanReset       = "General Reset";

    ls->menuFile                = "File";
    ls->menuRun                 = "Run";
    ls->menuWindow              = "Window";
    ls->menuOptions             = "Options";
    ls->menuHelp                = "Help";
    
    ls->errorTitle              = "blueMSX - Error";
    ls->errorEnterFullscreen    = "Failed to enter fullscreen mode.           \n";
    ls->errorDirectXFailed      = "Failed to create DirectX objects.           \nUsing GDI instead.\nCheck Video properties.";
    ls->errorNoRomInZip         = "Could not locate a .rom file in the zip archive.";
    ls->errorNoDskInZip         = "Could not locate a .dsk file in the zip archive.";
    ls->errorNoCasInZip         = "Could not locate a .cas file in the zip archive.";
    ls->errorNoHelp             = "Could not locate the blueMSX help file.";
    ls->errorStartEmu           = "Failed to Start MSX emulator.";

    ls->tooltipReset            = "Reset MSX";
    ls->tooltipCart1            = "Insert Cartridge in Slot 1";
    ls->tooltipCart2            = "Insert Cartridge in Slot 2";
    ls->tooltipDiskA            = "Insert Disk in Drive A";
    ls->tooltipDiskB            = "Insert Disk in Drive B";
    ls->tooltipCas              = "Insert Tape in Cassette Player";
    ls->tooltipStart            = "Start Emulation";
    ls->tooltipResume           = "Resume Emulation";
    ls->tooltipPause            = "Pause Emulation";
    ls->tooltipWindowSize       = "Set Window Size";
    ls->tooltipProperties       = "Open Properties Dialog";
    ls->tooltipHelp             = "Open Help Window";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - Select a rom image to load";
    ls->dlgLoadDsk              = "blueMSX - Select a dsk image to load";
    ls->dlgLoadCas              = "blueMSX - Select a cas image to load";
    ls->dlgLoadRomDskCas        = "blueMSX - Select a rom, dsk, or cas file to load";
    ls->dlgLoadRomDesc          = "Choose a rom image to load:";
    ls->dlgLoadDskDesc          = "Choose a disk image to load:";
    ls->dlgLoadCasDesc          = "Choose a tape image to load:";
    ls->dlgLoadRomDskCasDesc    = "Choose a rom, disk, or tape image to load:";
    ls->dlgLoadState            = "Load CPU state";
    ls->dlgSaveState            = "Save CPU state";
    ls->dlgInsertRom1           = "Insert ROM cartridge into slot 1";
    ls->dlgInsertRom2           = "Insert ROM cartridge into slot 2";
    ls->dlgInsertDiskA          = "Insert disk image into drive A";
    ls->dlgInsertDiskB          = "Insert disk image into drive B";
    ls->dlgInsertCas            = "Insert cassette tape";

    ls->dlgOK                   = "OK";
    ls->dlgCancel               = "Cancel";

    ls->dlgTapeTitle            = "blueMSX - Tape Position";
    ls->dlgTapeFrameText        = "Tape Position";
    ls->dlgTapeCurrentPos       = "Current Position";
    ls->dlgTapeTotalTime        = "Total Time";

    ls->dlgZipReset             = "Reset after insert";

    ls->dlgAboutTitle           = "blueMSX - About";

    ls->dlgJoyTitle1            = "blueMSX - Joystick keyset A";
    ls->dlgJoyTitle2            = "blueMSX - Joystick keyset B";
    ls->dlgJoyUpText            = "Up";
    ls->dlgJoyDownText          = "Down";
    ls->dlgJoyLeftText          = "Left";
    ls->dlgJoyRightText         = "Right";
    ls->dlgJoyButton1Text       = "Button 1";
    ls->dlgJoyButton2Text       = "Button 2";
    ls->dlgJoyGB                = "Keyset Configuration ";

    ls->dlgLangLangText         = "Choose the language that blueMSX will use";
    ls->dlgLangLangTitle        = "blueMSX - Language";

    ls->propTitle               = "blueMSX - Properties";
    ls->propEmulation           = "Emulation";
    ls->propVideo               = "Video";
    ls->propSound               = "Sound";
    ls->propControls            = "Controls";
    ls->propPerformance         = "Performance";
    
    ls->propEmuGeneralGB        = "General ";
    ls->propEmuFamilyText       = "MSX family:";
    ls->propEmuMemoryGB         = "Memory ";
    ls->propEmuRamSizeText      = "RAM size:";
    ls->propEmuVramSizeText     = "VRAM size:";
    ls->propEmuSpeedGB          = "Emulation Speed ";

    ls->propMonMonGB            = "Monitor ";
    ls->propMonTypeText         = "Monitor type:";
    ls->propMonEmuText          = "Monitor emulation:";
    ls->propVideoYypeText       = "Video type:";
    ls->propWindowSizeText      = "Window size:";

    ls->propPerfVideoDrvGB      = "Video Driver ";
    ls->propPerfVideoDispDrvText= "Display driver:";
    ls->propPerfFrameSkipText   = "Frame skipping:";
    ls->propPerfAudioDrvGB      = "Audio Driver ";
    ls->propPerfAudioDrvText    = "Sound driver:";
    ls->propPerfAudioBufSzText  = "Sound buffer size:";
    ls->propPerfEmuGB           = "Emulation ";
    ls->propPerfSyncModeText    = "SYNC Mode:";

    ls->propSndChipEmuGB        = "Sound Chip Emulation ";
    ls->propSndMixerGB          = "Audio Mixer ";
    ls->propSndMonoText         = "mono";
    ls->propSndStereoText       = "stereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (YM-2413 sound chip)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (Y8950 sound chip)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "Joystick in port #1 ";
    ls->propJoyPort2GB          = "Joystick in port #2 ";
    ls->propJoyAutofireText     = "Autofire:";
    ls->propJoyKeysetGB         = "Joystick keysets ";
    ls->propJoyKeyest1          = "Config keyset A";
    ls->propJoyKeyest2          = "Config keyset B";

    ls->enumVideoMonColor       = "Color";
    ls->enumVideoMonGrey        = "Black and white";
    ls->enumVideoMonGreen       = "Green";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "None";
    ls->enumVideoEmuYc          = "Y/C cable (sharp)";
    ls->enumVideoEmuYcBlur      = "Noisy Y/C cable (sharp)";
    ls->enumVideoEmuComp        = "Composite (blurry)";
    ls->enumVideoEmuCompBlur    = "Noisy Composite (blurry)";
    ls->enumVideoEmuScale2x     = "Scale 2x";

    ls->enumVideoSize1x         = "Normal - 320x200";
    ls->enumVideoSize2x         = "Double - 640x400";
    ls->enumVideoSizeFullscreen = "Fullscreen";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "None";
    ls->enumVideoFrameskip1     = "1 frame";
    ls->enumVideoFrameskip2     = "2 frames";
    ls->enumVideoFrameskip3     = "3 frames";
    ls->enumVideoFrameskip4     = "4 frames";
    ls->enumVideoFrameskip5     = "5 frames";

    ls->enumSoundDrvNone        = "No Sound";
    ls->enumSoundDrvWMM         = "WMM driver";
    ls->enumSoundDrvDirectX     = "DirectX driver";

    ls->enumEmuSync1ms          = "1ms (best)";
    ls->enumEmuSyncAuto         = "Auto (fast)";

    ls->enumControlsJoyNone     = "None";
    ls->enumControlsJoyNumpad   = "Numpad";
    ls->enumControlsJoyKeysetA  = "Keyset A";
    ls->enumControlsJoyKeysetB  = "Keyset B";
    ls->enumControlsJoyPCjoy1   = "PC joystick #1";
    ls->enumControlsJoyPCjoy2   = "PC joystick #2";
    ls->enumControlsJoyMouse    = "Mouse";

    ls->enumControlsAfOff       = "Off";
    ls->enumControlsAfSlow      = "Slow";
    ls->enumControlsAfMedium    = "Medium";
    ls->enumControlsAfFast      = "Fast";

    ls->dlgAboutAbout           = "ABOUT\r\n====";
    ls->dlgAboutVersion         = "Version:";
    ls->dlgAboutBuildNumber     = "Build:";
    ls->dlgAboutBuildDate       = "Date:";
    ls->dlgAboutDevel           = "Developed by Daniel Vik";
    ls->dlgAboutInfo            = "SPECIAL THANKS TO\r\n"
                                  "============\r\n\r\n"
                                  "Shimanuki Koshi\r\n"
                                  "Roger Filipe\r\n"
                                  "Kobayashi Michiko\r\n"
                                  "Benot Delvaux\r\n"
                                  "SLotman\r\n"
                                  "Fabio Albergaria Dias\r\n"
                                  "Glafouk\r\n"
                                  "Martijn van Tienen\r\n"
                                  "Vctor Fernndez Snchez\r\n"
                                  "William Ouwehand\r\n"
                                  "Marat Fayzullin\r\n"
                                  "Jarek Burczynski\r\n"
                                  "Tatsuyuki Satoh\r\n"
                                  "Gilles Vollant\r\n\r\n\r\n"
                                  "LICENSE\r\n"
                                  "======\r\n\r\n"
                                  "This software is provided 'as-is', without any express or implied "
                                  "warranty. In no event will the author(s) be held liable for any damages "
                                  "arising from the use of this software.\r\n\r\n"
                                  "Permission is granted to anyone to use this software for non-commercial "
                                  "purposes only.\r\n\r\n\r\n"
                                  "Visit www.vik.cc/blueMSX for more details.";
};

#endif

