#include <xtl.h>
#include "MSX.h"
#include "Machine.h"
#include "audioMixer.h"
#include "videoRender.h"
#include "ziphelper.h"
#include "MegaromCartridge.h"
#include "Casette.h"
#include "Disk.h"
#include "joystickio.h"
#include "romMSX.h"
#include "romMSXBR.h"
#include "romMSXJ.h"
#include "romMSX2.h"
#include "romMSX2EXT.h"
#include "romMSX2J.h"
//#include "romMSX2EXTJ.h"
#include "romMSX2P.h"
#include "romMSX2PEXT.h"
#include "romMSXKR.h"
#include "romMSXHAN.h"
#include "romMSX2KR.h"
#include "romMSX2HAN.h"
//#include "romMSX2EXTKR.h"

#define UInt32 unsigned int
#define UInt8 unsigned char

unsigned int g_Frequency = 3568884;
unsigned int g_Base      = 0x2876AA63UL ;

UInt32  emuFixedPalette[256];
UInt32* emuFrameBuffer;
int*    emuLineWidth;
UInt32  emuPalette0;
UInt32  emuPalette[300];
int diskBusy[2];
int casBusy;
int doquit = 0 ;

char *xbox_save_path();
void emulatorSetFrequency(int logFrequency, int* syncPeriod, int* frequency);
void emulatorSuspend();
void emulatorResume();
void emulatorStart(int hard);
void emulatorStop();

static int mouseDX = 0;
static int mouseDY = 0;

static int          emuExitFlag = 0 ;
extern Mixer* TheMixer;
extern int  SyncPeriod;
extern int MsxFrequency;

#include "propinclude.h"

Properties* pProperties = 0;

char *machineNames[] = {
	"MSX",
	"MSX - Brazilian",
	"MSX - Japanese",
	"MSX - Korean",
	"MSX2",
	"MSX2 - Arabic",
	"MSX2 - Brazilian",
	"MSX2 - French",
	"MSX2 - German",
	"MSX2 - Japanese",
	"MSX2 - Korean",
	"MSX2 - Russian",
	"MSX2+"
};

void propInitDefaults(Properties* pProperties) ;

typedef struct {
    int showMenu;
    int showDialog;
    
    // Frame buffer
    void* frameBuffer[2];
    int*  frameLine[2];
    int   frameBufferIndex;
    void* bmBits;
    int*  srcArr;

    //
    void* bmBitsGDI;
    UInt8 keyMap[16];
    EmuState emuState;
    int updatePending;
    char pStoredState[MAX_PATH];
    char pCurDir[MAX_PATH];
    Video* pVideo;
    int logSound;
    Mixer* mixer;
    int enteringFullscreen;
    DeviceInfo deviceInfo;
    Machine* machine;
    int screenMode;
    int evenOdd;
    int interlace;
    int autostart;
    int noautostart;
    UInt32 ledState;
    int maxSpeed;
    int maxSpeedCount;
    int mouseLock;
    int X;
    int Y;
    int DX;
    int DY;
    int DDY;
    int DTY;
} Port;

#define WIDTH  320
#define HEIGHT 240

static Port Prt;

void global_init()
{
	pProperties = (Properties*)malloc( sizeof(Properties) ) ;
	memset( pProperties, 0, sizeof(Properties) ) ;
    pProperties->joy1.id = 1;
    pProperties->joy2.id = 2;
    propInitDefaults(pProperties);

	memset( &Prt, 0, sizeof(Port) ) ;
}

void xbox_sound( unsigned char *buf, unsigned int bufsize );

static Int32 xboxWrite(void* dummy, Int16 *buffer, UInt32 count)
{
	xbox_sound( (unsigned char*)buffer, count ) ;
	return 1 ;
}

void init_xmsx()
{
	int i ;

	doquit = 0 ;


	if ( Prt.pVideo )
	{
		free( Prt.pVideo ) ;
		Prt.pVideo = NULL ;
	}
	if ( Prt.machine )
	{
		free( Prt.machine ) ;
		Prt.machine = NULL ;
	}
	if ( Prt.mixer )
	{
		free( Prt.mixer) ;
		Prt.mixer = NULL ;
	}
	if ( Prt.frameBuffer[0] )
	{
		free( Prt.frameBuffer[0] ) ;
		Prt.frameBuffer[0] = NULL ;
	}

	if ( Prt.frameLine[0] )
	{
		free( Prt.frameLine[0] ) ;
		Prt.frameLine[0] = NULL ;
	}
	if ( Prt.frameBuffer[1] )
	{
		free( Prt.frameBuffer[1] ) ;
		Prt.frameBuffer[1] = NULL ;
	}

	if ( Prt.frameLine[1] )
	{
		free( Prt.frameLine[1] ) ;
		Prt.frameLine[1] = NULL ;
	}


	memset( &Prt, 0, sizeof(Port) ) ;
    memset(Prt.keyMap, 0xff, 16);

    Prt.ledState = 0;
    Prt.autostart = 0;
    Prt.noautostart = 0;
    Prt.screenMode = 0;
    Prt.emuState = EMU_STOPPED;
    Prt.updatePending = 0;
    Prt.enteringFullscreen = 0;
    Prt.pVideo = videoCreate();
    Prt.mixer  = mixerCreate();

    for (i = 0; i < MIXER_CHANNEL_COUNT; i++) {
        mixerSetChannelVolume(Prt.mixer, i, pProperties->sound.mixerChannel[i].volume);
        mixerSetChannelPan(Prt.mixer, i, pProperties->sound.mixerChannel[i].pan);
        mixerEnableChannel(Prt.mixer, i, pProperties->sound.mixerChannel[i].enable);
    }
    
    mixerSetMasterVolume(Prt.mixer, pProperties->sound.masterVolume);

    mixerSetStereo(Prt.mixer, 1);
    mixerSetWriteCallback(Prt.mixer, xboxWrite, NULL);

	strcpy( Prt.pCurDir, xbox_save_path() ) ;
    /* Set SCREEN8 colors */

    //Prt.X = CW_USEDEFAULT;
    //Prt.Y = CW_USEDEFAULT;

    initDefaultMachines();

    Prt.frameBuffer[0] = calloc(8 * WIDTH * HEIGHT, sizeof(UInt32));
    Prt.frameBuffer[1] = calloc(8 * WIDTH * HEIGHT, sizeof(UInt32));
    Prt.frameLine[0] = calloc(512, sizeof(int));
    Prt.frameLine[1] = calloc(512, sizeof(int));

    Prt.bmBits = Prt.frameBuffer[0];
    Prt.srcArr = Prt.frameLine[0];

    Prt.logSound = 0;
    Prt.maxSpeed      = 0;
    Prt.maxSpeedCount = 0;

    tapeSetReadOnly(pProperties->cassette.readOnly);
    joystickIoSetType(0, pProperties->joy1.type == P_JOY_NONE  ? 0 : pProperties->joy1.type == P_JOY_MOUSE ? 2 : 1, pProperties->joy1.type);
    joystickIoSetType(1, pProperties->joy2.type == P_JOY_NONE  ? 0 : pProperties->joy2.type == P_JOY_MOUSE ? 2 : 1, pProperties->joy2.type);

}
void emulatorSetFrequency(int logFrequency, int* syncPeriod, int* frequency) {
    //int sync = (int)(((float)GLOBAL_FREQ/1000.0f) * emulatorGetSyncPeriod() * pow(2.0, (logFrequency - 50) / 15.0515));
    int sync = (int)(3580 * emulatorGetSyncPeriod() * pow(2.0, (logFrequency - 50) / 15.0515));
    //int freq = (int)(3579545 * pow(2.0, (logFrequency - 50) / 15.0515));
    int freq = (int)(GLOBAL_FREQ * pow(2.0, (logFrequency - 50) / 15.0515));

    if (syncPeriod != NULL && frequency != NULL) {
        *syncPeriod = sync;
        *frequency  = freq;
    }
    else {
        msxSetFrequency(sync, freq);
    }
}

void updateMsxFreq( int newFreq )
{
	if ( ( ((int)g_Frequency) + newFreq < 3000000 ) || ( ((int)g_Frequency) + newFreq > 4000000 ) )
		return ;

	g_Frequency += newFreq ;
	g_Base = ( 1 << 28 ) * g_Frequency / (32*44100) ;


	emulatorSetFrequency( 50, NULL, NULL ) ;
}

//void emulatorSetFrequency(int logFrequency) {
    //SyncPeriod = (int)(3580 * emulatorGetSyncPeriod() * pow(2.0, (logFrequency - 50) / 15.0515));
    //MsxFrequency = (int)(3579545 * pow(2.0, (logFrequency - 50) / 15.0515));
    //MsxFrequency = (int)(3568884 * pow(2.0, (logFrequency - 50) / 15.0515));
    //MsxFrequency = (int)(GLOBAL_FREQ * pow(2.0, (logFrequency - 50) / 15.0515));
//}

char* getCmdArgument(char* szLine, int argNo) {
    static char argBuf[512];
    int i;

    for (i = 0; i <= argNo; i++) {
        char* arg = argBuf;

        while (*szLine == ' ') szLine++;

        if (*szLine == 0) return NULL;

        if (*szLine == '\"') {
            szLine++;
            while (*szLine != '\"' && *szLine != 0) {
                *arg++ = *szLine++;
            }
            *arg = 0;
            if (*szLine != 0) szLine++;
        }
        else {
            do {
                *arg++ = *szLine++;
            } while (*szLine != ' ' && *szLine != 0);
            *arg = 0;
            if (*szLine != 0) szLine++;
        }
    }
    return argBuf;
}



static int insertCartridge(int drive, char* fname, char* inZipFile) {
    int autostart = Prt.autostart | pProperties->cartridge.autoReset;
    char romName[512] = "";
    char filename[512] = "";
    int isZip = toupper(fname[strlen(fname) - 3]) == 'Z' &&
                toupper(fname[strlen(fname) - 2]) == 'I' &&
                toupper(fname[strlen(fname) - 1]) == 'P';

    if (fname) strcpy(filename, fname);

    Prt.autostart = 0;
/*
    if (isZip) {
        if (inZipFile != NULL) {
            strcpy(romName, inZipFile);
        }
        else {
            // This is really ugly and should be done nicer...
            // The idea is to get files of three types and merge them into
            // one list. Maybe it should be done in zipGetFileList?
            int i;
            char* fileList;
            int countRom;
            int countMx1;
            int countMx2;
            char* fileListRom = zipGetFileList(filename, ".rom", &countRom);
            char* fileListMx1 = zipGetFileList(filename, ".mx1", &countMx1);
            char* fileListMx2 = zipGetFileList(filename, ".mx2", &countMx2);
            int count = countRom + countMx1 + countMx2;
            int sizeRom = 0;
            int sizeMx1 = 0;
            int sizeMx2 = 0;

            for (i = 0; i < countRom; i++) {
                sizeRom += strlen(fileListRom + sizeRom) + 1;
            }
            for (i = 0; i < countMx1; i++) {
                sizeMx1 += strlen(fileListMx1 + sizeMx1) + 1;
            }
            for (i = 0; i < countMx2; i++) {
                sizeMx2 += strlen(fileListMx2 + sizeMx2) + 1;
            }

            fileList = malloc(sizeRom + sizeMx1 + sizeMx2);
            memcpy(fileList, fileListRom, sizeRom);
            memcpy(fileList + sizeRom, fileListMx1, sizeMx1);
            memcpy(fileList + sizeRom + sizeMx1, fileListMx2, sizeMx2);

            if (count == 0) {
                MessageBox(NULL, langErrorNoRomInZip(), langErrorTitle(), MB_OK);
                return 0;
            }

            if (count == 1) {
                strcpy(romName, fileList);
            }
            else {
                ZipFileDlgInfo dlgInfo;

                _stprintf(dlgInfo.title, "%s", langDlgLoadRom());
                _stprintf(dlgInfo.description, "%s", langDlgLoadRomDesc());
                dlgInfo.fileList = fileList;
                dlgInfo.fileListCount = count;
                dlgInfo.autoReset = autostart;

                dlgInfo.selectFileIndex = -1;
                strcpy(dlgInfo.selectFile, drive == 0 ? pProperties->cartridge.slotAZip : pProperties->cartridge.slotBZip);

                DialogBoxParam(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ZIPDSK), Prt.hwnd, dskZipDlgProc, (LPARAM)&dlgInfo);

                if (dlgInfo.selectFile[0] == '\0') {
                    free(fileList);
                    return 0;
                }
                autostart = dlgInfo.autoReset;
                strcpy(romName, dlgInfo.selectFile);
            }
            free(fileList);
        }
    }
*/
    if (drive == 0) {
        strcpy(pProperties->cartridge.slotA, filename);
        strcpy(pProperties->cartridge.slotAZip, romName);
        //updateFileHistory(*pProperties->filehistory.cartridgeA, filename);
    }
    else {
        strcpy(pProperties->cartridge.slotB, filename);
        strcpy(pProperties->cartridge.slotBZip, romName);
        //updateFileHistory(*pProperties->filehistory.cartridgeB, filename);
    }

    if (autostart && !Prt.noautostart) {
        emulatorStop();
        emulatorStart(1);
    }
    else if (Prt.emuState != EMU_STOPPED) {
        //emulatorSuspend();
        msxChangeCartridge(drive, 0 == strcmp(CARTNAME_SCCPLUS, filename) ? ROM_SCCPLUS :
                                  0 == strcmp(CARTNAME_FMPAC, filename) ? ROM_FMPAC :
                                  0 == strcmp(CARTNAME_PAC, filename) ? ROM_PAC :
                                  0 == strcmp(CARTNAME_MEGARAM128, filename) ? ROM_MEGARAM128 :
                                  0 == strcmp(CARTNAME_MEGARAM256, filename) ? ROM_MEGARAM256 :
                                  0 == strcmp(CARTNAME_MEGARAM512, filename) ? ROM_MEGARAM512 :
                                  0 == strcmp(CARTNAME_MEGARAM768, filename) ? ROM_MEGARAM768 :
                                  0 == strcmp(CARTNAME_MEGARAM2M,  filename) ? ROM_MEGARAM2M  :
                                  ROM_UNKNOWN, 
                                  filename, isZip ? romName : NULL);
        //emulatorResume();
    }

    return 1;
}

static int insertDiskette(int drive, char* fname, char* inZipFile) {
    char diskName[512] = "";
    char filename[512] = "";
    int autostart = Prt.autostart | (drive == 0 ? pProperties->diskdrive.autostartA : 0);
    int isZip = toupper(fname[strlen(fname) - 3]) == 'Z' &&
                toupper(fname[strlen(fname) - 2]) == 'I' &&
                toupper(fname[strlen(fname) - 1]) == 'P';

    if (fname) strcpy(filename, fname);

    Prt.autostart = 0;
	/*
    if (isZip) {
        if (inZipFile != NULL) {
            strcpy(diskName, inZipFile);
        }
        else {
            // This is really ugly and should be done nicer...
            // The idea is to get files of three types and merge them into
            // one list. Maybe it should be done in zipGetFileList?
            int i;
            char* fileList;
            int countDsk;
            int countDi1;
            int countDi2;
            char* fileListDsk = zipGetFileList(filename, ".dsk", &countDsk);
            char* fileListDi1 = zipGetFileList(filename, ".di1", &countDi1);
            char* fileListDi2 = zipGetFileList(filename, ".di2", &countDi2);
            int count = countDsk + countDi1 + countDi2;
            int sizeDsk = 0;
            int sizeDi1 = 0;
            int sizeDi2 = 0;

            for (i = 0; i < countDsk; i++) {
                sizeDsk += strlen(fileListDsk + sizeDsk) + 1;
            }
            for (i = 0; i < countDi1; i++) {
                sizeDi1 += strlen(fileListDi1 + sizeDi1) + 1;
            }
            for (i = 0; i < countDi2; i++) {
                sizeDi2 += strlen(fileListDi2 + sizeDi2) + 1;
            }

            fileList = malloc(sizeDsk + sizeDi1 + sizeDi2);
            memcpy(fileList, fileListDsk, sizeDsk);
            memcpy(fileList + sizeDsk, fileListDi1, sizeDi1);
            memcpy(fileList + sizeDsk + sizeDi1, fileListDi2, sizeDi2);

            if (count == 0) {
                MessageBox(NULL, langErrorNoDskInZip(), langErrorTitle(), MB_OK);
                return 0;
            }

            if (count == 1) {
                strcpy(diskName, fileList);
            }
            else {
                ZipFileDlgInfo dlgInfo;

                _stprintf(dlgInfo.title, "%s", langDlgLoadDsk());
                _stprintf(dlgInfo.description, "%s", langDlgLoadDskDesc());
                dlgInfo.fileList = fileList;
                dlgInfo.fileListCount = count;
                dlgInfo.autoReset = autostart;

                dlgInfo.selectFileIndex = -1;
                strcpy(dlgInfo.selectFile, drive == 0 ? pProperties->diskdrive.slotAZip : pProperties->diskdrive.slotBZip);

                DialogBoxParam(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ZIPDSK), Prt.hwnd, dskZipDlgProc, (LPARAM)&dlgInfo);

                if (dlgInfo.selectFile[0] == '\0') {
                    free(fileList);
                    return 0;
                }
                strcpy(diskName, dlgInfo.selectFile);
                autostart = dlgInfo.autoReset;
            }
            free(fileList);
        }
    }
*/
    if (drive == 0) {
        strcpy(pProperties->diskdrive.slotA, filename);
        strcpy(pProperties->diskdrive.slotAZip, diskName);
        //updateFileHistory(*pProperties->filehistory.diskdriveA, filename);
    }
    else {
        strcpy(pProperties->diskdrive.slotB, filename);
        strcpy(pProperties->diskdrive.slotBZip, diskName);
        //updateFileHistory(*pProperties->filehistory.diskdriveB, filename);
    }

    if (autostart && !Prt.noautostart) {
        emulatorStop();
        emulatorStart(1);
    }
    else if (Prt.emuState != EMU_STOPPED) {
        //emulatorSuspend();
        msxChangeDiskette(drive, filename, isZip ? diskName : NULL);
        //emulatorResume();
    }

    return 1;
}

static int insertCassette(char* fname, char* inZipFile) {
    int autostart = Prt.autostart;
    char tapeName[512] = "";
    char filename[512] = "";
    int isZip = toupper(fname[strlen(fname) - 3]) == 'Z' &&
                toupper(fname[strlen(fname) - 2]) == 'I' &&
                toupper(fname[strlen(fname) - 1]) == 'P';

    if (fname) strcpy(filename, fname);

    Prt.autostart = 0;
/*
    if (isZip) {
        if (inZipFile != NULL) {
            strcpy(tapeName, inZipFile);
        }
        else {
            int count;
            char* fileList = zipGetFileList(filename, ".cas", &count);

            if (fileList == NULL) {
                MessageBox(NULL, langErrorNoCasInZip(), langErrorTitle(), MB_OK);
                return 0;
            }

            if (count == 1) {
                strcpy(tapeName, fileList);
            }
            else {
                ZipFileDlgInfo dlgInfo;

                _stprintf(dlgInfo.title, "%s", langDlgLoadCas());
                _stprintf(dlgInfo.description, "%s", langDlgLoadCasDesc());
                dlgInfo.fileList = fileList;
                dlgInfo.fileListCount = count;
                dlgInfo.autoReset = autostart;

                dlgInfo.selectFileIndex = -1;
                strcpy(dlgInfo.selectFile, pProperties->cassette.tapeZip);

                DialogBoxParam(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ZIPDSK), Prt.hwnd, dskZipDlgProc, (LPARAM)&dlgInfo);

                autostart = dlgInfo.autoReset;
                if (dlgInfo.selectFile[0] == '\0') {
                    free(fileList);
                    return 0;
                }
                strcpy(tapeName, dlgInfo.selectFile);
            }
            free(fileList);
        }
    }
*/
    strcpy(pProperties->cassette.tape, filename);
    strcpy(pProperties->cassette.tapeZip, tapeName);
    //updateFileHistory(*pProperties->filehistory.cassette, filename);

    if (autostart && !Prt.noautostart) {
        emulatorStart(1);
    }
    else if (Prt.emuState != EMU_STOPPED) {
        //emulatorSuspend();
        msxChangeCassette(filename, isZip ? tapeName : NULL);
        //emulatorResume();
    }

    return 1;
}











void xboxRender( unsigned char *dstbits, unsigned int dstpitch )
{
		videoRender(Prt.pVideo, 16, 1, Prt.evenOdd, Prt.interlace,
					Prt.bmBits, WIDTH, HEIGHT, Prt.srcArr, dstbits, sizeof(DWORD) * WIDTH, dstpitch);
}

int emulatorGetSyncPeriod() {
    return pProperties->emulation.syncMethod == P_EMU_SYNC1MS ? 1 : 10;
}


int emuCheckResetArgument(PSTR szLine) {
    int i;
    char*   argument;
    
    for (i = 0; argument = getCmdArgument(szLine, i); i++) {
        if (strcmp(argument, "/reset") == 0) {
            return 1;
        }
    }

    return 0;
}


static RomType romNameToType(char* name) {
    RomType romType = ROM_UNKNOWN;

    if (name == NULL) {
        return ROM_UNKNOWN;
    }

    romType = romMapperTypeFromString(name);

    if (romType == ROM_UNKNOWN) {
        romType = atoi(name);
        if (romType < ROM_STANDARD || romType > ROM_MAXROMID) {
            romType = ROM_UNKNOWN;
        }
    }

    return romType;
}

int isRomFileType(char* fname) {
    int len = strlen(fname);

//    if (fname[len-1] == '\"') len--;

    if (len > 4) {
        if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'R' &&
            toupper(fname[len - 2]) == 'O' &&
            toupper(fname[len - 1]) == 'M')
        {
            return 1;
        }
        else if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'Z' &&
            toupper(fname[len - 2]) == 'I' &&
            toupper(fname[len - 1]) == 'P')
        {
            return 1;
        }
    }
    return 0;
}

int isDskFileType(char* fname) {
    int len = strlen(fname);

    if (len > 4) {
        if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'D' &&
            toupper(fname[len - 2]) == 'S' &&
            toupper(fname[len - 1]) == 'K')
        {
            return 1;
        }
        else if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'Z' &&
            toupper(fname[len - 2]) == 'I' &&
            toupper(fname[len - 1]) == 'P')
        {
            return 1;
        }
    }
    return 0;
}
int isCasFileType(char* fname) {
    int len = strlen(fname);

    if (len > 4) {
        if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'C' &&
            toupper(fname[len - 2]) == 'A' &&
            toupper(fname[len - 1]) == 'S')
        {
            return 1;
        }
        else if (toupper(fname[len - 4]) == '.' &&
            toupper(fname[len - 3]) == 'Z' &&
            toupper(fname[len - 2]) == 'I' &&
            toupper(fname[len - 1]) == 'P')
        {
            return 1;
        }
    }
    return 0;
}

static void getDeviceInfo(DeviceInfo* deviceInfo) 
{
    strcpy(pProperties->cartridge.slotA,    deviceInfo->cartridge[0].name);
    //strcpy(pProperties->cartridge.slotAZip, deviceInfo->cartridge[0].inZipName);

    strcpy(pProperties->cartridge.slotB,    deviceInfo->cartridge[1].name);
    //strcpy(pProperties->cartridge.slotBZip, deviceInfo->cartridge[1].inZipName);

    strcpy(pProperties->diskdrive.slotA,    deviceInfo->diskette[0].name);
    //strcpy(pProperties->diskdrive.slotAZip, deviceInfo->diskette[0].inZipName);

    strcpy(pProperties->diskdrive.slotB,    deviceInfo->diskette[1].name);
    //strcpy(pProperties->diskdrive.slotBZip, deviceInfo->diskette[1].inZipName);

    strcpy(pProperties->cassette.tape,      deviceInfo->cassette.name);
    //strcpy(pProperties->cassette.tapeZip,   deviceInfo->cassette.inZipName);
    
    pProperties->sound.chip.enableYM2413    = deviceInfo->audio.enableYM2413;
    pProperties->sound.chip.enableY8950     = deviceInfo->audio.enableY8950;
    pProperties->sound.chip.enableMoonsound = deviceInfo->audio.enableMoonsound;
    pProperties->sound.chip.moonsoundSRAM   = deviceInfo->audio.moonsoundSRAM;
}

static void setDeviceInfo(DeviceInfo* deviceInfo) 
{
    /* Set cart A */
    deviceInfo->cartridge[0].inserted =  strlen(pProperties->cartridge.slotA);
    deviceInfo->cartridge[0].type = ROM_UNKNOWN;
    if (0 == strcmp(CARTNAME_SCCPLUS, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_SCCPLUS;
    }
    if (0 == strcmp(CARTNAME_FMPAC, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_FMPAC;
    }
    if (0 == strcmp(CARTNAME_PAC, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_PAC;
    }
    if (0 == strcmp(CARTNAME_MEGARAM128, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_MEGARAM128;
    }
    if (0 == strcmp(CARTNAME_MEGARAM256, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_MEGARAM256;
    }
    if (0 == strcmp(CARTNAME_MEGARAM512, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_MEGARAM512;
    }
    if (0 == strcmp(CARTNAME_MEGARAM768, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_MEGARAM768;
    }
    if (0 == strcmp(CARTNAME_MEGARAM2M, pProperties->cartridge.slotA)) {
        deviceInfo->cartridge[0].type = ROM_MEGARAM2M;
    }

    strcpy(deviceInfo->cartridge[0].name,      pProperties->cartridge.slotA);
    //strcpy(deviceInfo->cartridge[0].inZipName, pProperties->cartridge.slotAZip);

    /* Set cart B */
    deviceInfo->cartridge[1].inserted =  strlen(pProperties->cartridge.slotB);
    deviceInfo->cartridge[1].type = ROM_UNKNOWN;
    if (0 == strcmp(CARTNAME_SCCPLUS, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_SCCPLUS;
    }
    if (0 == strcmp(CARTNAME_FMPAC, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_FMPAC;
    }
    if (0 == strcmp(CARTNAME_PAC, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_PAC;
    }
    if (0 == strcmp(CARTNAME_MEGARAM128, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_MEGARAM128;
    }
    if (0 == strcmp(CARTNAME_MEGARAM256, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_MEGARAM256;
    }
    if (0 == strcmp(CARTNAME_MEGARAM512, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_MEGARAM512;
    }
    if (0 == strcmp(CARTNAME_MEGARAM768, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_MEGARAM768;
    }
    if (0 == strcmp(CARTNAME_MEGARAM2M, pProperties->cartridge.slotB)) {
        deviceInfo->cartridge[1].type = ROM_MEGARAM2M;
    }

    strcpy(deviceInfo->cartridge[1].name,      pProperties->cartridge.slotB);
    //strcpy(deviceInfo->cartridge[1].inZipName, pProperties->cartridge.slotBZip);

    /* Set disk A */
    deviceInfo->diskette[0].inserted =  strlen(pProperties->diskdrive.slotA);
    strcpy(deviceInfo->diskette[0].name,      pProperties->diskdrive.slotA);
    //strcpy(deviceInfo->diskette[0].inZipName, pProperties->diskdrive.slotAZip);

    /* Set disk B */
    deviceInfo->diskette[1].inserted =  strlen(pProperties->diskdrive.slotB);
    strcpy(deviceInfo->diskette[1].name,      pProperties->diskdrive.slotB);
    //strcpy(deviceInfo->diskette[1].inZipName, pProperties->diskdrive.slotBZip);

    /* Set tape */
    deviceInfo->cassette.inserted =  strlen(pProperties->cassette.tape);
    strcpy(deviceInfo->cassette.name,      pProperties->cassette.tape);
    //strcpy(deviceInfo->cassette.inZipName, pProperties->cassette.tapeZip);
    
    /* Set audio config */
    deviceInfo->audio.enableYM2413    = pProperties->sound.chip.enableYM2413;
    deviceInfo->audio.enableY8950     = pProperties->sound.chip.enableY8950;
    deviceInfo->audio.enableMoonsound = pProperties->sound.chip.enableMoonsound;
    deviceInfo->audio.moonsoundSRAM   = pProperties->sound.chip.moonsoundSRAM;
}


BOOL propSetVideoSize(Properties* pProperties, PropVideoSize size) {
    BOOL changed = pProperties->video.size != size;
    pProperties->video.size = size;
    return changed;
}



void updateVideoRender() {
    switch (pProperties->video.monType) {
    case P_VIDEO_COLOR:
        videoSetColorMode(Prt.pVideo, VIDEO_COLOR);
        break;
    case P_VIDEO_BW:
        videoSetColorMode(Prt.pVideo, VIDEO_BLACKWHITE);
        break;
    case P_VIDEO_GREEN:
        videoSetColorMode(Prt.pVideo, VIDEO_GREEN);
        break;
    }

    switch (pProperties->video.palEmu) {
    case P_VIDEO_PALNONE:
        videoSetPalMode(Prt.pVideo, VIDEO_PAL_FAST);
        break;
    case P_VIDEO_PALYC:
        videoSetPalMode(Prt.pVideo, VIDEO_PAL_SHARP);
        break;
    case P_VIDEO_PALNYC:
        videoSetPalMode(Prt.pVideo, VIDEO_PAL_SHARP_NOISE);
        break;
    case P_VIDEO_PALCOMP:
        videoSetPalMode(Prt.pVideo, VIDEO_PAL_BLUR);
        break;
    case P_VIDEO_PALNCOMP:
        videoSetPalMode(Prt.pVideo, VIDEO_PAL_BLUR_NOISE);
        break;
	case P_VIDEO_PALSCALE2X:
		videoSetPalMode(Prt.pVideo, VIDEO_PAL_SCALE2X);
		break;
	case P_VIDEO_PAL_STRETCHED:
		videoSetPalMode(Prt.pVideo, VIDEO_PAL_STRETCHED);
		break;
    }

    videoSetFrameSkip(Prt.pVideo, pProperties->video.frameSkip);
}




void emulatorStart(int hard) {
    DWORD id;
    int i;

    emuExitFlag = 0;

    for(i=0; i<256; i++) {
        emuFixedPalette[i] = videoGetColor(Prt.pVideo, (i & 0x1c) << 3, (i & 0xe0), ((i & 3) == 3 ? 7 : 2 * (i & 3)) << 5);
    }

    Prt.machine = createMachine(pProperties->emulation.machineName);

    if (Prt.machine == NULL) {  
        //MessageBox(NULL, langErrorStartEmu(), langErrorTitle(), MB_ICONHAND | MB_OK);
        return;
    }

    emuFrameBuffer = (UInt32*)Prt.bmBits;
    emuLineWidth   = (int*)Prt.srcArr;

    //emuSyncSem  = CreateSemaphore(NULL, 0, 10, NULL);
    //emuStartSem = CreateSemaphore(NULL, 0, 10, NULL);
    //emuTimer   = StartTimer(Prt.hwnd, emuSyncSem, emulatorGetSyncPeriod(), pProperties->emulation.syncMethod == P_EMU_SYNC1MS);
    
    setDeviceInfo(&Prt.deviceInfo);    

    //soundResume();

    //if (kbdLockEnable != NULL && pProperties->emulation.disableWinKeys) {
        //kbdLockEnable();
    //}

    //emuThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)emulatorThread, (void*)hard, 0, &id);
    
    //WaitForSingleObject(emuStartSem, INFINITE);
    
    Prt.emuState = EMU_RUNNING;
    //mouseEmuUpdateRunState(1);

    //getDeviceInfo(&Prt.deviceInfo);

    //joystickIoGetType(0, &pProperties->joy1.type);
    //joystickIoGetType(1, &pProperties->joy2.type);

    strcpy(pProperties->emulation.machineName, Prt.machine->name);
} 




void emulatorStop() {
    if (Prt.emuState == EMU_STOPPED) {
        return;
    }

    Prt.emuState = EMU_STOPPED;
    //mouseEmuUpdateRunState(0);
    emuExitFlag = 1;
    //ReleaseSemaphore(emuSyncSem, 100, NULL);
    //WaitForSingleObject(emuThread, INFINITE);
    Prt.pStoredState[0] = 0;
    //soundSuspend();
    //destroyMachine(Prt.machine);
    //CloseHandle(emuThread);
    //CloseHandle(emuSyncSem);
}


int emuStartWithArguments(PSTR szLine) {
    int i;
    char*   argument;
    char    rom1[512] = "";
    char    rom2[512] = "";
    RomType romType1  = ROM_UNKNOWN;
    RomType romType2  = ROM_UNKNOWN;
    char    machineName[64] = "";
    char    diskA[512] = "";
    char    diskB[512] = "";
	char    tape[512]  = "" ;
    int     fullscreen = 0;
    int     startEmu = 0;
    int syncPeriod;
    int frequency;
    int success = 0;

	init_xmsx() ;

	updateVideoRender() ;
    
	// If one argument, assume it is a rom or disk to run
	/*
    if (!getCmdArgument(szLine, 1)) {
        argument = getCmdArgument(szLine, 0);
        
        if (*argument != '/') {
            if (*argument == '\"') argument++;

            if (*argument) {
                Prt.autostart = 1;
                return tryLaunchUnknownFile(argument);
            }
            return 0;
        }
    }*/

    // If more than one argument, check arguments,
    // set configuration and then run
/*
    for (i = 0; argument = getCmdArgument(szLine, i); i++) {
        if (strcmp(argument, "/rom1") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL || !isRomFileType(argument)) return 0; // Invaid argument
            strcpy(rom1, argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/romtype1") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL) return 0; // Invaid argument
            romType1 = romNameToType(argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/rom2") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL || !isRomFileType(argument)) return 0; // Invaid argument
            strcpy(rom2, argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/romtype2") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL) return 0; // Invaid argument
            romType2 = romNameToType(argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/diskA") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL || !isDskFileType(argument)) return 0; // Invaid argument
            strcpy(diskA, argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/tape") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL || !isCasFileType(argument)) return 0; // Invaid argument
            strcpy(tape, argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/diskB") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL || !isDskFileType(argument)) return 0; // Invaid argument
            strcpy(diskB, argument);
            startEmu = 1;
        }
        if (strcmp(argument, "/family") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL) return 0; // Invaid argument
            strcpy(machineName, argument); // FIXME verify arg
            if (!machineIsValid(machineName)) return 0;
            startEmu = 1;
        }
        if (strcmp(argument, "/machine") == 0) {
            argument = getCmdArgument(szLine, ++i);
            if (argument == NULL) return 0; // Invaid argument
            strcpy(machineName, argument);
            if (!machineIsValid(machineName)) return 0;
            startEmu = 1;
        }
        if (strcmp(argument, "/fullscreen") == 0) {
            fullscreen = 1;
        }
    }
*/
    //if (!startEmu) {
        //return 1;
    //}
/*
    pProperties->cassette.tape[0] = 0;
    pProperties->cassette.tapeZip[0] = 0;

    pProperties->cartridge.slotA[0] = 0;
    pProperties->cartridge.slotAZip[0] = 0;
    pProperties->cartridge.slotB[0] = 0;
    pProperties->cartridge.slotBZip[0] = 0;

    pProperties->diskdrive.slotA[0] = 0;
    pProperties->diskdrive.slotAZip[0] = 0;
    pProperties->diskdrive.slotB[0] = 0;
    pProperties->diskdrive.slotBZip[0] = 0;
  */  
    Prt.noautostart = 1;

    //if (strlen(rom1)  && !insertCartridge(0, rom1, NULL)) return 0;
    //if (strlen(rom2)  && !insertCartridge(1, rom2, NULL)) return 0;
    //if (strlen(diskA) && !insertDiskette(0, diskA, NULL)) return 0;
    //if (strlen(diskB) && !insertDiskette(1, diskB, NULL)) return 0;
    //if (strlen(tape)  && !insertCassette(tape, NULL)) return 0;

    //if (strlen(machineName)) strcpy(pProperties->emulation.machineName, machineName);

    //propSetVideoSize(pProperties, fullscreen ? P_VIDEO_SIZEFULLSCREEN : P_VIDEO_SIZEX2);

    Prt.noautostart = 0;

    emulatorStop();
    emulatorStart(1);


    emulatorSetFrequency(pProperties->emulation.speed, &syncPeriod, &frequency);

    msxSetFrontSwitch(pProperties->emulation.frontSwitch);
    msxSetAudioSwitch(pProperties->emulation.audioSwitch);

    success = msxRun(Prt.machine,
                     &Prt.deviceInfo,
                     Prt.mixer,
                     strlen(Prt.pStoredState) ? Prt.pStoredState : NULL,
                     syncPeriod,
                     frequency,
                     1);



    return 1;
}


unsigned char xbox_controller( unsigned char N ) ;

UInt8 Joystick(register UInt8 N) {
	return xbox_controller( N ) ;

}

void xbox_get_mousestate(int* dx, int* dy, int* buttons) ;

void Mouse(int* dx, int* dy, int* buttons) {
	xbox_get_mousestate( dx, dy, buttons ) ;
    //mouseEmuGetState(dx, dy, buttons);
	return  ;
}

void Keyboard(unsigned char* keybardMap) {
    //memcpy(keybardMap, Prt.keyMap, 16);
}

void SetCapslockLed(int enable) {
    //if (enable) Prt.ledState |= 1;
    //else        Prt.ledState &= ~1;
}

void SetKanaLed(int enable) {
    //if (enable) Prt.ledState |= 2;
    //else        Prt.ledState &= ~2;
}

int WaitForSync(void) {
    //do {
        //emuSuspendFlag = 1;
        //WaitForSingleObject(emuSyncSem, INFINITE);
    //} while (!emuExitFlag && Prt.emuState != EMU_RUNNING);
    ///emuSuspendFlag = 0;

	return doquit ;
    //return emuExitFlag;
}
void xbox_mp3_process();

void RefreshScreen(int screenMode, int evenOdd, int interlace) {
    //static int frameSkip = 0;
    //if (frameSkip++ < pProperties->video.frameSkip) {
        //return;
    //}
    //frameSkip = 0;


    Prt.updatePending++;
    if (Prt.updatePending <= 1) {
        Prt.bmBits = emuFrameBuffer;
        Prt.srcArr = emuLineWidth;
        Prt.screenMode = screenMode;
        Prt.evenOdd = evenOdd;
        Prt.interlace = interlace;

        if (!interlace) {
            Prt.frameBufferIndex ^= 1;
            emuFrameBuffer = (UInt32*)Prt.frameBuffer[Prt.frameBufferIndex];
            emuLineWidth   = (int*)Prt.frameLine[Prt.frameBufferIndex];
        }

    }

	xbox_mp3_process();

	xbox_frame() ;

	if ( xbox_check_events( ) )
		doquit = 1 ;
	
	Prt.updatePending = 0;
}

void SetColor(int palEntry, unsigned int rgbColor) {
    UInt32 color = videoGetColor(Prt.pVideo, ((rgbColor >> 16) & 0xff), ((rgbColor >> 8) & 0xff), rgbColor & 0xff);
    //UInt32 color = videoGetColor(Prt.pVideo, ((rgbColor >> 16) & 0xff)>>3, ((rgbColor >> 8) & 0xff)>>2, (rgbColor & 0xff)>>3);
    if (palEntry == 0) {
        emuPalette0 = color;
    }
    else {
        emuPalette[palEntry] = color;
    }
}

int msx_refreshrate()
{
	if (     pProperties->video.videoType        == P_VIDEO_PAL )
		return 50 ;
	else 
		return 60 ;
}

void propInitDefaults(Properties* pProperties) 
{
    int i;
    //pProperties->language                 = EMU_LANG_ENGLISH;

    pProperties->settings.disableScreensaver = 0;

    pProperties->emulation.statsDefDir[0] = 0;
    strcpy(pProperties->emulation.machineName, "MSX2");
    pProperties->emulation.speed             = 50;
    pProperties->emulation.syncMethod        = P_EMU_SYNCAUTO;
    pProperties->emulation.frontSwitch       = 0;
    pProperties->emulation.audioSwitch       = 0;
    pProperties->emulation.registerFileTypes = 0;
    pProperties->emulation.disableWinKeys    = 0;

    pProperties->video.monType            = P_VIDEO_COLOR;
    pProperties->video.palEmu             = P_VIDEO_PALNONE;
    pProperties->video.size               = P_VIDEO_SIZEX2;
    pProperties->video.driver             = P_VIDEO_DRVDIRECTX_VIDEOSYSMEM;
    pProperties->video.frameSkip          = P_VIDEO_FSKIP0;
    pProperties->video.fullRes            = P_VIDEO_FRES640X480_32;
    pProperties->video.horizontalStretch  = 1;
    pProperties->video.verticalStretch    = 0;

    pProperties->sound.driver           = P_SOUND_DRVDIRECTX;
    pProperties->sound.frequency        = P_SOUND_FREQ44;
    pProperties->sound.bufSize          = 150;
    pProperties->sound.syncMethod       = P_SOUND_SYNCQADJUST;

    pProperties->sound.stereo = 1;
    pProperties->sound.masterVolume = 100;
    pProperties->sound.chip.enableYM2413 = 1;
    pProperties->sound.chip.enableY8950 = 1;
    pProperties->sound.chip.enableMoonsound = 1;
    pProperties->sound.chip.moonsoundSRAM = 640;

    pProperties->sound.mixerChannel[MCT_PSG].enable = 1;
    pProperties->sound.mixerChannel[MCT_PSG].pan = 42;
    pProperties->sound.mixerChannel[MCT_PSG].volume = 100;

    pProperties->sound.mixerChannel[MCT_SCC].enable = 1;
    pProperties->sound.mixerChannel[MCT_SCC].pan = 58;
    pProperties->sound.mixerChannel[MCT_SCC].volume = 86;

    pProperties->sound.mixerChannel[MCT_MSXMUSIC].enable = 1;
    pProperties->sound.mixerChannel[MCT_MSXMUSIC].pan = 58;
    pProperties->sound.mixerChannel[MCT_MSXMUSIC].volume = 100;

    pProperties->sound.mixerChannel[MCT_MSXAUDIO].enable = 1;
    pProperties->sound.mixerChannel[MCT_MSXAUDIO].pan = 50;
    pProperties->sound.mixerChannel[MCT_MSXAUDIO].volume = 100;

    pProperties->sound.mixerChannel[MCT_MOONSOUND].enable = 1;
    pProperties->sound.mixerChannel[MCT_MOONSOUND].pan = 50;
    pProperties->sound.mixerChannel[MCT_MOONSOUND].volume = 100;

    pProperties->sound.mixerChannel[MCT_KEYBOARD].enable = 1;
    pProperties->sound.mixerChannel[MCT_KEYBOARD].pan = 54;
    pProperties->sound.mixerChannel[MCT_KEYBOARD].volume = 55;
    
    pProperties->joy1.type              = P_JOY_HW1;
    pProperties->joy1.autofire          = P_JOY_AFOFF;
    pProperties->joy1.keyUp             = 0xff;
    pProperties->joy1.keyDown           = 0xff;
    pProperties->joy1.keyLeft           = 0xff;
    pProperties->joy1.keyRight          = 0xff;
    pProperties->joy1.button1           = 0xff;
    pProperties->joy1.button2           = 0xff;
    
    pProperties->joy2.type              = P_JOY_HW1;
    pProperties->joy2.autofire          = P_JOY_AFOFF;
    pProperties->joy2.keyUp             = 0xff;
    pProperties->joy2.keyDown           = 0xff;
    pProperties->joy2.keyLeft           = 0xff;
    pProperties->joy2.keyRight          = 0xff;
    pProperties->joy2.button1           = 0xff;
    pProperties->joy2.button2           = 0xff;
    
    pProperties->keyboard.keySet        = P_CHAR_EUROPEAN;
    
    pProperties->cartridge.defDir[0]    = 0;
    pProperties->cartridge.slotA[0]     = 0;
    pProperties->cartridge.slotB[0]     = 0;
    pProperties->cartridge.slotAZip[0]  = 0;
    pProperties->cartridge.slotBZip[0]  = 0;
    pProperties->cartridge.autoReset    = 1;
    
    pProperties->diskdrive.defDir[0]    = 0;
    pProperties->diskdrive.slotA[0]     = 0;
    pProperties->diskdrive.slotB[0]     = 0;
    pProperties->diskdrive.slotAZip[0]  = 0;
    pProperties->diskdrive.slotBZip[0]  = 0;
    pProperties->diskdrive.autostartA   = 0;

    pProperties->cassette.defDir[0]       = 0;
    pProperties->cassette.tape[0]         = 0;
    pProperties->cassette.tapeZip[0]      = 0;
    pProperties->cassette.showCustomFiles = 1;
    pProperties->cassette.readOnly        = 1;
    pProperties->cassette.autoRewind      = 0;

    for (i = 0; i < MAX_HISTORY; i++) {
        pProperties->filehistory.cartridgeA[i][0] = 0;
        pProperties->filehistory.cartridgeB[i][0] = 0;
        pProperties->filehistory.diskdriveA[i][0] = 0;
        pProperties->filehistory.diskdriveB[i][0] = 0;
        pProperties->filehistory.cassette[i][0] = 0;
    }

    pProperties->filehistory.quicksave[0] = 0;
    pProperties->filehistory.count        = 10;

	

}

void xbox_get_mousestate(int* dx, int* dy, int* buttons) ;

void mouseEmuGetState(int* dx, int* dy) {

	int buttons ;

	xbox_get_mousestate( dx, dy, &buttons ) ;
}

int  mouseEmuGetButtonState(int checkAlways) {
    int dx, dy, buttons;

	xbox_get_mousestate( &dx, &dy, &buttons ) ;

	//return 3 ;
    return buttons;
}
