/*****************************************************************************
** File:
**      Win32Properties.h
**
** Author:
**      Daniel Vik
**
** Description:
**      blueMSX properties dialog
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef WIN32_PROPERTIES_H
#define WIN32_PROPERTIES_H


#include <windows.h>
#include "audioMixer.h"
#include "Language.h"

#define CARTNAME_SCCPLUS    "SCC+ Cartridge"
#define CARTNAME_FMPAC      "FM-PAC Cartridge"
#define CARTNAME_PAC        "PAC Cartridge"
#define CARTNAME_MEGARAM128 "128kB MegaRAM"
#define CARTNAME_MEGARAM256 "256kB MegaRAM"
#define CARTNAME_MEGARAM512 "512kB MegaRAM"
#define CARTNAME_MEGARAM768 "768kB MegaRAM"
#define CARTNAME_MEGARAM2M  "2MB MegaRAM"

typedef enum { PROP_EMULATION = 0, PROP_VIDEO, PROP_SOUND, PROP_CONTROLS, PROP_PERFORMANCE, PROP_SETTINGS } PropPage;

typedef enum { P_EMU_SYNC1MS = 0, P_EMU_SYNCAUTO } PropEmuSync;
typedef enum { P_VIDEO_COLOR = 0, P_VIDEO_BW, P_VIDEO_GREEN } PropVideoMon;
typedef enum { P_VIDEO_PALNONE = 0, P_VIDEO_PALYC, P_VIDEO_PALNYC, P_VIDEO_PALCOMP, P_VIDEO_PALNCOMP, P_VIDEO_PALSCALE2X, P_VIDEO_PAL_STRETCHED } PropVideoPalEmu;
typedef enum { P_VIDEO_PAL, P_VIDEO_NTSC } PropVideoType;
typedef enum { P_VIDEO_SIZEX1 = 0, P_VIDEO_SIZEX2, P_VIDEO_SIZEFULLSCREEN } PropVideoSize;
typedef enum { P_VIDEO_DRVDIRECTX_VIDEO = -1, P_VIDEO_DRVDIRECTX_VIDEOSYSMEM = 0, P_VIDEO_DRVDIRECTX, P_VIDEO_DRVGDI } PropVideoDriver;
typedef enum { P_VIDEO_FSKIP0 = 0, P_VIDEO_FSKIP1, P_VIDEO_FSKIP2, P_VIDEO_FSKIP3, P_VIDEO_FSKIP4, P_VIDEO_FSKIP5 } PropVideoFrameSkip;
typedef enum { P_VIDEO_FRES320X240_16 = 0, P_VIDEO_FRES320X240_32, P_VIDEO_FRES640X480_16, P_VIDEO_FRES640X480_32 } PropVideoFullRes;
typedef enum { P_SOUND_DRVNONE = 0, P_SOUND_DRVWMM, P_SOUND_DRVDIRECTX } PropSoundDriver;
typedef enum { P_SOUND_FREQ11 = 0, P_SOUND_FREQ22, P_SOUND_FREQ44 } PropSoundFrequency;
typedef enum { P_SOUND_SYNCFAST = 0, P_SOUND_SYNCQADJUST, P_SOUND_SYNCEADJUST } PropSoundSync;
typedef enum { P_JOY_NONE = 0, P_JOY_NUMPAD, P_JOY_KEYSETA, P_JOY_KEYSETB, P_JOY_HW1, P_JOY_HW2, P_JOY_MOUSE } PropControlsJoy;
typedef enum { P_JOY_AFOFF = 0, P_JOY_AFSLOW, P_JOY_AFMEDIUM, P_JOY_AFFAST } PropControlsAutofire;
typedef enum { P_CHAR_EUROPEAN = 0, P_CHAR_RUSSIAN, P_CHAR_JAPANESE, P_CHAR_KOREAN } PropControlsLanguage;

#define MAX_HISTORY 30

typedef struct {
    char         statsDefDir[MAX_PATH];
    char         machineName[MAX_PATH];
    int          frontSwitch;
    int          audioSwitch;
    int          speed;
    int          registerFileTypes;
    int          disableWinKeys;
    PropEmuSync  syncMethod;
} EmulationProperties;

typedef struct {
    PropVideoMon        monType;
    PropVideoPalEmu     palEmu;
    PropVideoType       videoType;
    PropVideoSize       size;
    PropVideoDriver     driver;
    PropVideoFrameSkip  frameSkip;
    PropVideoFullRes    fullRes;
    int                 horizontalStretch;
    int                 verticalStretch;
} VideoProperties;

typedef struct {
    int enable;
    int volume;
    int pan;
} MixerChannel;

enum MixerChannelType {
    MCT_PSG = 0,
    MCT_SCC,
    MCT_MSXMUSIC,
    MCT_MSXAUDIO,
    MCT_MOONSOUND,
    MCT_KEYBOARD,
    MCT_NUMENTRIES
};

typedef struct {
    int enableY8950;
    int enableYM2413;
    int enableMoonsound;
    int moonsoundSRAM;
} SoundChip;

typedef struct {
    PropSoundDriver     driver;
    PropSoundFrequency  frequency;
    int                 bufSize;
    PropSoundSync       syncMethod;
    SoundChip           chip;
    int                 stereo;
    int                 masterVolume;
    MixerChannel        mixerChannel[6]; // See MixerChannelType
    char                log[MAX_PATH];
} SoundProperties;

typedef struct {
    int id;
    PropControlsJoy      type;
    PropControlsAutofire autofire;
    int keyUp;
    int keyDown;
    int keyLeft;
    int keyRight;
    int button1;
    int button2;
}  JoystickProperties;

typedef struct {
    PropControlsLanguage keySet;
} KeyboardProperties;

typedef struct {
    char defDir[MAX_PATH];
    char slotA[MAX_PATH];
    char slotB[MAX_PATH];
    char slotAZip[MAX_PATH];
    char slotBZip[MAX_PATH];
    int  autoReset;
} CartridgeProperties;

typedef struct {
    char defDir[MAX_PATH];
    char slotA[MAX_PATH];
    char slotB[MAX_PATH];
    char slotAZip[MAX_PATH];
    char slotBZip[MAX_PATH];
    int autostartA;
} DiskdriveProperties;

typedef struct {
    char defDir[MAX_PATH];
    char tape[MAX_PATH];
    char tapeZip[MAX_PATH];
    int showCustomFiles;
    int readOnly;
    int autoRewind;
} CassetteProperties;

typedef struct {
    int count;
    char cartridgeA[MAX_HISTORY][MAX_PATH];
    char cartridgeB[MAX_HISTORY][MAX_PATH];
    char diskdriveA[MAX_HISTORY][MAX_PATH];
    char diskdriveB[MAX_HISTORY][MAX_PATH];
    char cassette[MAX_HISTORY][MAX_PATH];
    char quicksave[MAX_PATH];
} FileHistory;

typedef struct {
    int disableScreensaver;
} Settings;

typedef struct {
    EmulationProperties emulation;
    VideoProperties     video;
    SoundProperties     sound;
    JoystickProperties  joy1;
    JoystickProperties  joy2;
    KeyboardProperties  keyboard;
    CartridgeProperties cartridge;
    DiskdriveProperties diskdrive;
    CassetteProperties  cassette;
    FileHistory         filehistory;
    EmuLanguageType     language;
    Settings            settings;
} Properties;

int showProperties(Properties* pProperties, HWND hwndOwner, PropPage startPage, Mixer* mixer);

Properties* propCreate(int useDefault, int useIniFile);
void propSave(Properties* pProperties);
void propDestroy(Properties* pProperties);
BOOL propSetVideoSize(Properties* pProperties, PropVideoSize size);

#endif
