/*****************************************************************************
** File:        Y8950.h
**
** Author:      Daniel Vik
**
** Description: Emulation of the Y8950 sound chip
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef Y8950_H
#define Y8950_H

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct Y8950 Y8950;

/* Constructor and destructor */
int y8950Create(Mixer* mixer, UInt32 cpuClock);

int y8950GetState(Y8950* y8950, UInt8* buffer, UInt32 systemTime);
int y8950SetState(Y8950* y8950, UInt8* buffer, UInt32 systemTime);

void y8950Tick(UInt32 cpuClock);

#endif
