/*****************************************************************************
** File:        LanguageStrings.h
**
** Author:      Daniel Vik
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_STRINGS_H
#define LANGUAGE_STRINGS_H

#include <windows.h>
#include <tchar.h>


typedef struct {
    _TCHAR* statusBarStopped;
    _TCHAR* statusBarPaused;
    _TCHAR* statusBarRunning;

    _TCHAR* menuHardReset;
    _TCHAR* menuSoftReset;

    _TCHAR* menuCartInsert;
    _TCHAR* menuCartRemove;
    _TCHAR* menuCartAutoReset;
    _TCHAR* menuCartNoRecentFiles;
    _TCHAR* menuCartSCCPlus;
    _TCHAR* menuCartFMPac;
    _TCHAR* menuCartPac;
    _TCHAR* menuCartSpecial;
    
    _TCHAR* menuDiskInsert;
    _TCHAR* menuDiskEject;
    _TCHAR* menuDiskAutoStart;
    _TCHAR* menuDiskNoRecentFiles;

    _TCHAR* menuCasInsert;
    _TCHAR* menuCasEject;
    _TCHAR* menuCasRewindAfterInsert;
    _TCHAR* menuCasUseReadOnly;
    _TCHAR* lmenuCasSaveAs;
    _TCHAR* menuCasSetPosition;
    _TCHAR* menuCasRewind;
    _TCHAR* menuCasNoRecentFiles;

    _TCHAR* menuZoomNormal;
    _TCHAR* menuZoomDouble;
    _TCHAR* menuZoomFullscreen;

    _TCHAR* menuPropsEmulation;
    _TCHAR* menuPropsVideo;
    _TCHAR* menuPropsSound;
    _TCHAR* menuPropsControls;
    _TCHAR* menuPropsPerformance;
    _TCHAR* menuPropsSettings;
    _TCHAR* menuTools;
    _TCHAR* menuPropsLanguage;

    _TCHAR* menuToolsMachine;
    
    _TCHAR* menuHelpHelp;
    _TCHAR* menuHelpAbout;
    
    _TCHAR* menuFileCart1;
    _TCHAR* menuFileCart2;
    _TCHAR* menuFileDiskA;
    _TCHAR* menuFileDiskB;
    _TCHAR* menuFileCas;
    _TCHAR* menuFileLoadState;
    _TCHAR* menuFileSaveState;
    _TCHAR* menuFileQLoadState;
    _TCHAR* menuFileQSaveState;
    _TCHAR* menuFileCaptureAudio;
    _TCHAR* menuFileScreenShot;
    _TCHAR* menuFileExit;

    _TCHAR* menuRunRun;
    _TCHAR* menuRunPause;
    _TCHAR* menuRunStop;
    _TCHAR* menuRunSoftReset;
    _TCHAR* menuRunHardReset;
    _TCHAR* menuRunCleanReset;
    
    _TCHAR* menuFile;
    _TCHAR* menuRun;
    _TCHAR* menuWindow;
    _TCHAR* menuOptions;
    _TCHAR* menuHelp;

    _TCHAR* errorTitle;
    _TCHAR* errorEnterFullscreen;
    _TCHAR* errorDirectXFailed;
    _TCHAR* errorNoRomInZip;
    _TCHAR* errorNoDskInZip;
    _TCHAR* errorNoCasInZip;
    _TCHAR* errorNoHelp;
    _TCHAR* errorStartEmu;
    
    _TCHAR* tooltipReset;
    _TCHAR* tooltipCart1;
    _TCHAR* tooltipCart2;
    _TCHAR* tooltipDiskA;
    _TCHAR* tooltipDiskB;
    _TCHAR* tooltipCas;
    _TCHAR* tooltipStart;
    _TCHAR* tooltipResume;
    _TCHAR* tooltipPause;
    _TCHAR* tooltipWindowSize;
    _TCHAR* tooltipProperties;
    _TCHAR* tooltipHelp;
    
    _TCHAR* dlgMainWindow;
    _TCHAR* dlgLoadRom;
    _TCHAR* dlgLoadDsk;
    _TCHAR* dlgLoadCas;
    _TCHAR* dlgLoadRomDskCas;
    _TCHAR* dlgLoadRomDesc;
    _TCHAR* dlgLoadDskDesc;
    _TCHAR* dlgLoadCasDesc;
    _TCHAR* dlgLoadRomDskCasDesc;
    _TCHAR* dlgLoadState;
    _TCHAR* dlgSaveState;
    _TCHAR* dlgInsertRom1;
    _TCHAR* dlgInsertRom2;
    _TCHAR* dlgInsertDiskA;
    _TCHAR* dlgInsertDiskB;
    _TCHAR* dlgInsertCas;

    _TCHAR* dlgOK;
    _TCHAR* dlgOpen;
    _TCHAR* dlgCancel;
    _TCHAR* dlgTapeTitle;
    _TCHAR* dlgTapeFrameText;
    _TCHAR* dlgTapeCurrentPos;
    _TCHAR* dlgTapeTotalTime;
    _TCHAR* dlgTapeCustom;
    _TCHAR* dlgTapeSetPosText;
    _TCHAR* dlgTabPosition;
    _TCHAR* dlgTabType;
    _TCHAR* dlgTabFilename;

    _TCHAR* dlgSaveCassette;

    _TCHAR* dlgZipReset;

    _TCHAR* dlgAboutTitle;

    _TCHAR* dlgJoyTitle1;
    _TCHAR* dlgJoyTitle2;
    _TCHAR* dlgJoyUpText;
    _TCHAR* dlgJoyDownText;
    _TCHAR* dlgJoyLeftText;
    _TCHAR* dlgJoyRightText;
    _TCHAR* dlgJoyButton1Text;
    _TCHAR* dlgJoyButton2Text;
    _TCHAR* dlgJoyGB;

    _TCHAR* dlgLangLangText;
    _TCHAR* dlgLangLangTitle;

    _TCHAR* propTitle;
    _TCHAR* propEmulation;
    _TCHAR* propVideo;
    _TCHAR* propSound;
    _TCHAR* propControls;
    _TCHAR* propPerformance;
    _TCHAR* propSettings;

    _TCHAR* propEmuGeneralGB;
    _TCHAR* propEmuFamilyText;
    _TCHAR* propEmuMemoryGB;
    _TCHAR* propEmuRamSizeText;
    _TCHAR* propEmuVramSizeText;
    _TCHAR* propEmuSpeedGB;
    _TCHAR* propEmuSpeedText;
    _TCHAR* propEmuFrontSwitchGB;
    _TCHAR* propEmuFrontSwitch;
    _TCHAR* propEmuAudioSwitch;

    _TCHAR* propMonMonGB;
    _TCHAR* propMonTypeText;
    _TCHAR* propMonEmuText;
    _TCHAR* propVideoYypeText;
    _TCHAR* propWindowSizeText;
    _TCHAR* propMonHorizStretch;
    _TCHAR* propMonVertStretch;

    _TCHAR* propPerfVideoDrvGB;
    _TCHAR* propPerfVideoDispDrvText;
    _TCHAR* propPerfFrameSkipText;
    _TCHAR* propPerfAudioDrvGB;
    _TCHAR* propPerfAudioDrvText;
    _TCHAR* propPerfAudioBufSzText;
    _TCHAR* propPerfEmuGB;
    _TCHAR* propPerfSyncModeText;

    _TCHAR* propSndChipEmuGB;
    _TCHAR* propSndMixerGB;
    _TCHAR* propSndMonoText;
    _TCHAR* propSndStereoText;
    _TCHAR* propSndMsxMusicText;
    _TCHAR* propSndMsxAudioText;
    _TCHAR* propSndMoonsound;
    _TCHAR* propSndMsxMasterText;

    _TCHAR* propJoyPort1GB;
    _TCHAR* propJoyPort2GB;
    _TCHAR* propJoyAutofireText;
    _TCHAR* propJoyKeysetGB;
    _TCHAR* propJoyKeyest1;
    _TCHAR* propJoyKeyest2;
    
    _TCHAR* propSetFileHistoryGB;
    _TCHAR* propSetFileHistorySize;
    _TCHAR* propSetFileHistoryClear;
    _TCHAR* propSetScreenSaverGB;
    _TCHAR* propFileTypesGB;
    _TCHAR* propWindowsEnvGB;
    _TCHAR* propSetScreenSaver;
    _TCHAR* propFileTypes;
    _TCHAR* propDisableWinKeys;
    _TCHAR* propClearHistory;

    _TCHAR* enumVideoMonColor;
    _TCHAR* enumVideoMonGrey;
    _TCHAR* enumVideoMonGreen;

    _TCHAR* enumVideoTypePAL;
    _TCHAR* enumVideoTypeNTSC;

    _TCHAR* enumVideoEmuNone;
    _TCHAR* enumVideoEmuYc;
    _TCHAR* enumVideoEmuYcBlur;
    _TCHAR* enumVideoEmuComp;
    _TCHAR* enumVideoEmuCompBlur;
    _TCHAR* enumVideoEmuScale2x;

    _TCHAR* enumVideoSize1x;
    _TCHAR* enumVideoSize2x;
    _TCHAR* enumVideoSizeFullscreen;

    _TCHAR* enumVideoDrvDirectDrawHW;
    _TCHAR* enumVideoDrvDirectDrawHWSys;
    _TCHAR* enumVideoDrvDirectDraw;
    _TCHAR* enumVideoDrvGDI;

    _TCHAR* enumVideoFrameskip0;
    _TCHAR* enumVideoFrameskip1;
    _TCHAR* enumVideoFrameskip2;
    _TCHAR* enumVideoFrameskip3;
    _TCHAR* enumVideoFrameskip4;
    _TCHAR* enumVideoFrameskip5;

    _TCHAR* enumSoundDrvNone;
    _TCHAR* enumSoundDrvWMM;
    _TCHAR* enumSoundDrvDirectX;

    _TCHAR* enumEmuSync1ms;
    _TCHAR* enumEmuSyncAuto;

    _TCHAR* enumControlsJoyNone;
    _TCHAR* enumControlsJoyNumpad;
    _TCHAR* enumControlsJoyKeysetA;
    _TCHAR* enumControlsJoyKeysetB;
    _TCHAR* enumControlsJoyPCjoy1;
    _TCHAR* enumControlsJoyPCjoy2;
    _TCHAR* enumControlsJoyMouse;

    _TCHAR* enumControlsAfOff;
    _TCHAR* enumControlsAfSlow;
    _TCHAR* enumControlsAfMedium;
    _TCHAR* enumControlsAfFast;

    _TCHAR* dlgAboutAbout;
    _TCHAR* dlgAboutVersion;
    _TCHAR* dlgAboutBuildNumber;
    _TCHAR* dlgAboutBuildDate;
    _TCHAR* dlgAboutCreat;
    _TCHAR* dlgAboutDevel;
    _TCHAR* dlgAboutThanks;
    _TCHAR* dlgAboutLisence;
    
    _TCHAR* confTitle;
    _TCHAR* confSave;
    _TCHAR* confSaveAs;
    _TCHAR* confRun;
    _TCHAR* confClose;
    _TCHAR* confConfigText;
    _TCHAR* confSlotLayout;
    _TCHAR* confMemory;
    _TCHAR* confChipEmulation;
        
    _TCHAR* confChipVideoGB;
    _TCHAR* confChipVideoChip;
    _TCHAR* confChipVideoRam;
    _TCHAR* confChipSoundGB;
        
    _TCHAR* confSlotLayoutGB;
    _TCHAR* confSlotExtSlotGB;
    _TCHAR* confSlotSlot0;
    _TCHAR* confSlotSlot1;
    _TCHAR* confSlotSlot2;
    _TCHAR* confSlotSlot3;
    _TCHAR* confSlotCart1;
    _TCHAR* confSlotCart2;
    _TCHAR* confSlotPrimary;
    _TCHAR* confSlotExpanded;

    _TCHAR* confMemAdd;
    _TCHAR* confMemEdit;
    _TCHAR* confMemRemove;
    _TCHAR* confMemSlot;
    _TCHAR* confMemAddresss;
    _TCHAR* confMemType;
    _TCHAR* confMemRomImage;
    
    _TCHAR* confMemSaveTitle;
    _TCHAR* confMemSaveText;
        
    _TCHAR* slotEditMemTitle;
    _TCHAR* slotEditMemGB;
    _TCHAR* slotEditMemType;
    _TCHAR* slotEditMemFile;
    _TCHAR* slotEditMemAddress;
    _TCHAR* slotEditMemSize;
    _TCHAR* slotEditMemSlot;

    _TCHAR* confSaveTitle;
    _TCHAR* confSaveText;

    _TCHAR* confDiscardTitle;
    _TCHAR* confExitSaveTitle;
    _TCHAR* confExitSaveText;

    _TCHAR* confSaveAsTitle;
    _TCHAR* confSaveAsMachineName;

    _TCHAR* confEditMemInternalRoms;
} LanguageStrings;

#endif

