/*****************************************************************************
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_JAPANESE_H
#define LANGUAGE_JAPANESE_H

#include "LanguageStrings.h"

void langInitJapanese(LanguageStrings* ls) 
{
    ls->statusBarStopped        = " ~";
    ls->statusBarPaused         = " f";
    ls->statusBarRunning        = " s";
    
    ls->menuHardReset           = "n[hZbg";
    ls->menuSoftReset           = "\\tgZbg";
    
    ls->menuCartInsert          = "}";
    ls->menuCartRemove          = "o";
    ls->menuCartAutoReset       = "}/oナZbg";
    ls->menuCartNoRecentFiles   = "- gpt@CȂ -";
    ls->menuCartSCCPlus         = "SCC+J[gbW";
    ls->menuCartFMPac         = "FMPAC+J[gbW";
    ls->menuCartPac           = "PAC+J[gbW";
    ls->menuCartSpecial         = "̑";

    ls->menuDiskInsert          = "}";
    ls->menuDiskEject           = "o";
    ls->menuDiskAutoStart       = "}/oナZbg";
    ls->menuDiskNoRecentFiles   = "- gpt@CȂ -";
    
    ls->menuCasInsert           = "}";
    ls->menuCasEject            = "o";
    ls->menuCasSetPosition      = "e[vʒuZbg";
    ls->menuCasRewind           = "߂";
    ls->menuCasNoRecentFiles   = "- gpt@CȂ -";

    ls->menuZoomNormal          = "WTCY";
    ls->menuZoomDouble          = "2{TCY";
    ls->menuZoomFullscreen      = "tXN[";
    
    ls->menuPropsEmulation      = "G~[V";
    ls->menuPropsVideo          = "rfI";
    ls->menuPropsSound          = "TEh";
    ls->menuPropsControls       = "Rg[";
    ls->menuPropsPerformance    = "ptH[}X";
    ls->menuPropsLanguage       = "";
    
    ls->menuHelpHelp            = "wvڎ";
    ls->menuHelpAbout           = "blueMSXɂ";

    ls->menuFileCart1           = "ROMXbg 1";
    ls->menuFileCart2           = "ROMXbg 2";
    ls->menuFileDiskA           = "fBXNhCu A";
    ls->menuFileDiskB           = "fBXNhCu B";
    ls->menuFileCas             = "JZbge[v";
    ls->menuFileLoadState       = "CPUXe[g ǂݍ";
    ls->menuFileSaveState       = "CPUXe[g ۑ";
    ls->menuFileQLoadState      = "NCbN[h";
    ls->menuFileQSaveState      = "NCbNZ[u";
    ls->menuFileCaptureAudio    = "^";
    ls->menuFileScreenShot      = "XN[Vbg";
    ls->menuFileExit            = "I";

    ls->menuRunRun              = "s";
    ls->menuRunPause            = "ꎞ~";
    ls->menuRunStop             = "~";
    ls->menuRunSoftReset        = "\\tgZbg";
    ls->menuRunHardReset        = "n[hZbg";
    ls->menuRunCleanReset       = "N[Zbg";

    ls->menuFile                = "t@C";
    ls->menuRun                 = "s";
    ls->menuWindow              = "EBhE";
    ls->menuOptions             = "IvV";
    ls->menuHelp                = "wv";
    
    ls->errorTitle              = "blueMSX G[";
    ls->errorEnterFullscreen    = "tXN[[hɂł܂.           \n";
    ls->errorDirectXFailed      = "DirectX IuWFNg쐬ł܂.           \nGDIɎgp܂.\nOtBbNJ[h̐ݒmFĂ.";
    ls->errorNoRomInZip         = "zipt@C̒.romt@C܂.";
    ls->errorNoDskInZip         = "zipt@C̒.dskt@C܂.";
    ls->errorNoCasInZip         = "zipt@C̒.cast@C܂.";
    ls->errorNoHelp             = "blueMSX̃wvt@C܂.";
    ls->errorStartEmu           = "MSXG~[^̊JnɎs܂.";

    ls->tooltipReset            = "MSXZbg܂";
    ls->tooltipCart1            = "Xbg1ɃJ[gbW}܂";
    ls->tooltipCart2            = "Xbg2ɃJ[gbW}܂";
    ls->tooltipDiskA            = "hCuAɃfBXN}܂";
    ls->tooltipDiskB            = "hCuBɃfBXN}܂";
    ls->tooltipCas              = "JZbge[v}܂";
    ls->tooltipStart            = "G~[VJn܂";
    ls->tooltipResume           = "G~[V𑱍s܂";
    ls->tooltipPause            = "G~[Vꎞ~܂";
    ls->tooltipWindowSize       = "EBhẼTCYύX܂";
    ls->tooltipProperties       = "ݒ_CAOJ܂";
    ls->tooltipHelp             = "wvJ܂";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - romC[WI";
    ls->dlgLoadDsk              = "blueMSX - dskC[WI";
    ls->dlgLoadCas              = "blueMSX - casC[WI";
    ls->dlgLoadRomDskCas        = "blueMSX - rom, dsk, ܂casC[WI";
    ls->dlgLoadRomDesc          = "ǂݍromC[W:";
    ls->dlgLoadDskDesc          = "ǂݍdskC[W:";
    ls->dlgLoadCasDesc          = "ǂݍcasC[W:";
    ls->dlgLoadRomDskCasDesc    = "ǂݍrom, dsk, casC[W:";
    ls->dlgLoadState            = "CPUXe[g ǂݍ";
    ls->dlgSaveState            = "CPUXe[g ۑ";
    ls->dlgInsertRom1           = "ROMJ[gbWXbg1ɑ}";
    ls->dlgInsertRom2           = "ROMJ[gbWXbg2ɑ}";
    ls->dlgInsertDiskA          = "fBXNC[WhCuAɑ}";
    ls->dlgInsertDiskB          = "fBXNC[WhCuBɑ}";
    ls->dlgInsertCas            = "JZbge[v}";

    ls->dlgOK                   = "OK";
    ls->dlgCancel               = "LZ";

    ls->dlgTapeTitle            = "blueMSX - JZbge[v";
    ls->dlgTapeFrameText        = "e[vʒu";
    ls->dlgTapeCurrentPos       = "݈ʒu";
    ls->dlgTapeTotalTime        = "g[^^C";

    ls->dlgZipReset             = "}ナZbg";

    ls->dlgAboutTitle           = "blueMSXɂ";

    ls->dlgJoyTitle1            = "blueMSX - WCXeBbN Zbg A";
    ls->dlgJoyTitle2            = "blueMSX - WCXeBbN Zbg B";
    ls->dlgJoyUpText            = "";
    ls->dlgJoyDownText          = "";
    ls->dlgJoyLeftText          = "";
    ls->dlgJoyRightText         = "E";
    ls->dlgJoyButton1Text       = "{^1";
    ls->dlgJoyButton2Text       = "{^2";
    ls->dlgJoyGB                = "L[ݒ";

    ls->dlgLangLangText         = "blueMSXŎgp錾IĂ";
    ls->dlgLangLangTitle        = "blueMSX - ";

    ls->propTitle               = "blueMSX - ݒ";
    ls->propEmulation           = "G~[V";
    ls->propVideo               = "rfI";
    ls->propSound               = "TEh";
    ls->propControls            = "Rg[";
    ls->propPerformance         = "ptH[}X";
    
    ls->propEmuGeneralGB        = " ";
    ls->propEmuFamilyText       = "MSX̎:";
    ls->propEmuMemoryGB         = " ";
    ls->propEmuRamSizeText      = "CRAM:";
    ls->propEmuVramSizeText     = "VRAM:";
    ls->propEmuSpeedGB          = "Xs[h ";
    ls->propEmuSpeedText        = "Xs[h:";

    ls->propMonMonGB            = "j^[ ";
    ls->propMonTypeText         = "j^[̎:";
    ls->propMonEmuText          = "j^[G~[V:";
    ls->propVideoYypeText       = "f:";
    ls->propWindowSizeText      = "EBhETCY:";

    ls->propPerfVideoDrvGB      = "rfIhCo ";
    ls->propPerfVideoDispDrvText= "fBXvChCo:";
    ls->propPerfFrameSkipText   = "t[XLbv:";
    ls->propPerfAudioDrvGB      = "TEhhCo ";
    ls->propPerfAudioDrvText    = "TEhhCo:";
    ls->propPerfAudioBufSzText  = "TEhobt@:";
    ls->propPerfEmuGB           = "G~[V ";
    ls->propPerfSyncModeText    = "SYNC[h:";

    ls->propSndChipEmuGB        = "TEh̃G~[V ";
    ls->propSndMixerGB          = "~LT[ ";
    ls->propSndMonoText         = "mono";
    ls->propSndStereoText       = "stereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (YM-2413)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (Y8950)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "WCXeBbN|[g 1 ";
    ls->propJoyPort2GB          = "WCXeBbN|[g 2 ";
    ls->propJoyAutofireText     = "A:";
    ls->propJoyKeysetGB         = "WCXeBbNݒ ";
    ls->propJoyKeyest1          = "ZbgA̐ݒ ";
    ls->propJoyKeyest2          = "ZbgB̐ݒ ";

    ls->enumVideoMonColor       = "J[";
    ls->enumVideoMonGrey        = "mN";
    ls->enumVideoMonGreen       = "O[";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Ȃ";
    ls->enumVideoEmuYc          = "Y/CP[u (N)";
    ls->enumVideoEmuYcBlur      = "Y/CP[u{mCY (N)";
    ls->enumVideoEmuComp        = "R|Wbg (sN)";
    ls->enumVideoEmuCompBlur    = "R|Wbg{mCY (sN)";
    ls->enumVideoEmuScale2x     = "Scale 2x";

    ls->enumVideoSize1x         = "WTCY - 320x200";
    ls->enumVideoSize2x         = "2{TCY - 640x400";
    ls->enumVideoSizeFullscreen = "tXN[";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "Ȃ";
    ls->enumVideoFrameskip1     = "1t[";
    ls->enumVideoFrameskip2     = "2t[";
    ls->enumVideoFrameskip3     = "3t[";
    ls->enumVideoFrameskip4     = "4t[";
    ls->enumVideoFrameskip5     = "5t[";

    ls->enumSoundDrvNone        = "TEhȂ";
    ls->enumSoundDrvWMM         = "WMMhCo";
    ls->enumSoundDrvDirectX     = "DirectXhCo";

    ls->enumEmuSync1ms          = "1ms (m)";
    ls->enumEmuSyncAuto         = " ()";

    ls->enumControlsJoyNone     = "Ȃ";
    ls->enumControlsJoyNumpad   = "eL[";
    ls->enumControlsJoyKeysetA  = "ZbgA";
    ls->enumControlsJoyKeysetB  = "ZbgB";
    ls->enumControlsJoyPCjoy1   = "PCWCXeBbN#1";
    ls->enumControlsJoyPCjoy2   = "PCWCXeBbN#2";
    ls->enumControlsJoyMouse    = "}EX";

    ls->enumControlsAfOff       = "Ȃ";
    ls->enumControlsAfSlow      = "ᑬ";
    ls->enumControlsAfMedium    = "";
    ls->enumControlsAfFast      = "";

    ls->dlgAboutAbout           = "̃\\tgɂ\r\n==========";
    ls->dlgAboutVersion         = "o[W:";
    ls->dlgAboutBuildNumber     = "rh:";
    ls->dlgAboutBuildDate       = "t:";
    ls->dlgAboutCreat           = " Daniel Vik";
    ls->dlgAboutThanks          = "͂X\r\n============";
    ls->dlgAboutLisence         = "======\r\n\r\n"
                                  "̃\\tgEFA͌̂܂܂̏ԂŔzẑł , I܂"
                                  "َI킸؂̕ۏ؂͂ ܂. ܂̃\\tgEFA̎gp̌ʐ"
                                  "Ȃ鑹QɂĂ, ҂͐ӔC𕉂܂.\r\n\r\n"
                                  "c̎gpɌ肷邱ƂƂ, Nł̃\\tgEFA"
                                  "gp邱Ƃ܂.\r\n\r\n\r\n"
                                  "ڂɂĂ, www.vik.cc/blueMSX . ";


    
    ls->dlgAboutDevel           = "J\r\n========";

    // New entries
    ls->menuTools                = "c[";
    ls->menuToolsMachine         = "}V\\ҏW";
    ls->menuPropsSettings        = "̑";
    ls->menuCasRewindAfterInsert = "}㊪߂";
    ls->menuCasUseReadOnly       = "e[vǂݍݐpɂ";
    ls->lmenuCasSaveAs           = "e[vʖŕۑ...";

    ls->dlgSaveCassette          = "blueMSX - e[vۑ";
    ls->dlgTapeCustom            = "JX^t@C\\";
    ls->dlgTapeSetPosText        = "e[vʒu:";
    ls->dlgTabPosition           = "ʒu";
    ls->dlgTabType               = "^Cv";
    ls->dlgTabFilename           = "t@C";

    ls->propSettings             = "̑";
    
    ls->propSetFileHistoryGB     = "t@CqXg ";
    ls->propSetFileHistorySize   = "t@CqXǧ:";
    ls->propSetFileHistoryClear  = "qXg̏";
    ls->propSetScreenSaverGB     = "XN[Z[o ";
    ls->propSetScreenSaver       = " blueMSX̓쒆̓XN[Z[o𖳌ɂ";

    ls->confTitle                = "blueMSX - }V\\ҏW";
    ls->confSave                 = "ۑ";
    ls->confSaveAs               = "ʖۑ...";
    ls->confRun                  = "N";
    ls->confClose                = "";
    ls->confConfigText           = "}V\\";
    ls->confSlotLayout           = "Xbg\\";
    ls->confMemory               = "";
    ls->confChipEmulation        = "`bv";

    ls->confSlotLayoutGB         = "Xbg\\ ";
    ls->confSlotExtSlotGB        = "gXbg ";
    ls->confSlotSlot0            = "Xbg 0";
    ls->confSlotSlot1            = "Xbg 1";
    ls->confSlotSlot2            = "Xbg 2";
    ls->confSlotSlot3            = "Xbg 3";
    ls->confSlotCart1            = "J[gbW 1:";
    ls->confSlotCart2            = "J[gbW 2:";
    ls->confSlotPrimary          = "{";
    ls->confSlotExpanded         = "g (4̕Xbg)";

    ls->confMemAdd               = "ǉ...";
    ls->confMemEdit              = "ҏW...";
    ls->confMemRemove            = "폜";
    ls->confMemSlot              = "Xbg";
    ls->confMemAddresss          = "AhX";
    ls->confMemType              = "^Cv";
    ls->confMemRomImage          = "";
    
    ls->confChipVideoGB          = "rfI ";
    ls->confChipVideoChip        = "rfI`bv:";
    ls->confChipVideoRam         = "rfIRAM:";
    ls->confChipSoundGB          = "TEh ";

    ls->slotEditMemTitle         = "blueMSX - }bp̕ҏW";
    ls->slotEditMemGB            = "}bp̏ڍ ";
    ls->slotEditMemType          = "^Cv:";
    ls->slotEditMemFile          = "t@C:";
    ls->slotEditMemAddress       = "AhX:";
    ls->slotEditMemSize          = "TCY:";
    ls->slotEditMemSlot          = "Xbg:";

    ls->confSaveAsTitle          = "blueMSX - }V\\ʖŕۑ...";
    ls->confSaveAsMachineName    = "\\:";

    ls->confSaveTitle            = "blueMSX - }V\\̕ۑ";
    ls->confSaveText             = "}V\\㏑Ă낵ł?";

    ls->dlgOpen                  = "J";
    ls->confEditMemInternalRoms  = "blueMSX - ";

    ls->confSaveTitle            = "blueMSX - }V\\ҏW̏I";
    ls->confSaveText             = "݂̍\\܂A낵ł?";
    
    ls->confExitSaveTitle        = "blueMSX - }V\\ҏW̏I";
    ls->confExitSaveText         = "݂̍\\܂A낵ł?";

    ls->confDiscardTitle         = "blueMSX - }V\\ҏW";
    

    ls->propSndMoonsound         = " Moonsound";

    ls->propFileTypesGB          = "t@C ";
    ls->propFileTypes            = " blueMSXɊ֘Att@C (.rom, .dsk, .cas, .sta)";
    ls->propDisableWinKeys       = " blueMSXgpɍEWindowsL[𖳌"; 
    ls->propWindowsEnvGB         = "EBhEY ";
    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW accel."; 
    ls->enumVideoDrvDirectDrawHWSys = "DirectDraw mix."; 
    ls->propMonHorizStretch      = "  Xgb`";  
    ls->propClearHistory         = "qXg̏sāA낵ł?"; 

    ls->propEmuFrontSwitchGB     = "pi\\jbNXCb` "; 
    ls->propEmuFrontSwitch       = " OʃXCb` (MSX2+)"; 
    ls->propEmuAudioSwitch       = " MSX-AUDIO J[gbW XCb`"; 
    ls->propMonVertStretch       = "  Xgb`";

};

#endif
