#include "Win32ScreenShot.h"
#include "Language.h"
#include <stdio.h>
#include <direct.h>

static int ttshots = 0;
static char baseDir[512];

static HRESULT SaveBitmap(char *strFileName, PBITMAPINFO pbi, HBITMAP hBMP, HDC hDC)
{
    HRESULT             hr = E_FAIL;
    HANDLE              hf;         // file handle
    BITMAPFILEHEADER    hdr;        // bitmap file-header
    PBITMAPINFOHEADER   pbih;       // bitmap info-header
    LPBYTE              lpBits;     // memorypointer
    DWORD               dwTotal;    // total count of bytes
    DWORD               cb;         // incremental count of bytes
    BYTE                *hp;        // byte pointer
    DWORD               dwTmp;      // temp-variable


    if( pbi == NULL ){
        return E_FAIL;
    }

    pbih    = ( PBITMAPINFOHEADER ) pbi;
    lpBits  = ( LPBYTE ) GlobalAlloc( GMEM_FIXED, pbih->biSizeImage );

    if( !lpBits ){
        return E_FAIL;
    }


    //
    // Retrieve the colortable ( RGBQUAD-array ) and the bits
    // ( array of palette indices ) from the DIB.
    //
    if( !GetDIBits( hDC, hBMP, 0, ( WORD )pbih->biHeight, lpBits, pbi, DIB_RGB_COLORS ) ){
        return E_FAIL;
    }


    //
    // Create the .BMP file.
    //
    hf = CreateFile( strFileName, GENERIC_READ|GENERIC_WRITE, ( DWORD ) 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, ( HANDLE ) NULL );

    if( hf == INVALID_HANDLE_VALUE ){
        return E_FAIL;
    }

    hdr.bfType = 0x4D42;    // 0x42 = "B", 0x4D = "M"


    //
    // Compute the size of the entire file
    //
    hdr.bfSize = ( DWORD )( sizeof( BITMAPFILEHEADER ) + pbih->biSize + pbih->biClrUsed * sizeof( RGBQUAD ) + pbih->biSizeImage );
    hdr.bfReserved1 = 0;
    hdr.bfReserved2 = 0;

    //
    // Compute the offset to the array of color indices
    //
    hdr.bfOffBits = ( DWORD ) sizeof( BITMAPFILEHEADER ) + pbih->biSize + pbih->biClrUsed * sizeof( RGBQUAD );


    //
    // Copy the BITMAPFILEHEADER into the .BMP file
    //
    if( !WriteFile( hf, ( LPVOID ) &hdr, sizeof( BITMAPFILEHEADER ), ( LPDWORD ) &dwTmp, NULL ) ){
        return E_FAIL;
    }


    //
    // Copy the BITMAPINFOHEADER and RGBQUAD array into the file
    //
    if( !WriteFile( hf, ( LPVOID ) pbih, sizeof( BITMAPINFOHEADER ) + pbih->biClrUsed * sizeof( RGBQUAD ), ( LPDWORD ) &dwTmp, ( NULL ) ) ){
        return E_FAIL;
    }


    //
    // Copy the array of color indices into the .BMP file
    //
    dwTotal = cb = pbih->biSizeImage;
    hp      = lpBits;

    if( !WriteFile( hf, ( LPSTR ) hp, ( int ) cb, ( LPDWORD ) &dwTmp, NULL ) ){
        return E_FAIL;
    }


    //
    // Now close the .BMP file
    //
    if( !CloseHandle( hf ) ){
        return E_FAIL;
    }


    //
    // Free the memory reserved
    //
    GlobalFree( ( HGLOBAL ) lpBits );


    return S_OK;
}

static PBITMAPINFO CreateBitmapInfoStructure(HBITMAP hBmp)
{
    BITMAP      bmp;
    PBITMAPINFO pbmi;
    WORD        cClrBits;


    //
    // Get the width, height and the colordepth of the image
    //
    if( !GetObject( hBmp, sizeof( BITMAP ), (LPSTR)&bmp ) ){
        return NULL;
    }


    //
    // Convert the color format to a count of bits
    //
    cClrBits = 24;


    //
    // Allocate memory for the BITMAPINFO-structure. This structure
    // contains a BITMAPINFOHEADER-structure and an array of RGBQUAD
    // datastructures.
    //
    if( cClrBits < 24 )
        pbmi = ( PBITMAPINFO ) LocalAlloc( LPTR, sizeof( BITMAPINFOHEADER ) + sizeof( RGBQUAD ) * ( 1 << cClrBits ) );
    else
        pbmi = ( PBITMAPINFO ) LocalAlloc( LPTR, sizeof( BITMAPINFOHEADER ) );

    //
    // Initialize the fields in the BITMAPINFO-structure.
    //
    pbmi->bmiHeader.biSize      = sizeof( BITMAPINFOHEADER );
    pbmi->bmiHeader.biWidth     = bmp.bmWidth;
    pbmi->bmiHeader.biHeight    = bmp.bmHeight;
    pbmi->bmiHeader.biPlanes    = bmp.bmPlanes;
    pbmi->bmiHeader.biBitCount  = cClrBits;//bmp.bmBitsPixel;

    if( cClrBits < 24 )
        pbmi->bmiHeader.biClrUsed = ( 1 << cClrBits );

    //
    // If the bitmap isn't compressed, set the BI_RGB flag
    //
    pbmi->bmiHeader.biCompression   = BI_RGB;

    //
    // Compute the number of bytes in the array of color indices
    // and store the result in biSizeImage.
    //
    pbmi->bmiHeader.biSizeImage     = ( pbmi->bmiHeader.biWidth + 7 ) / 8 * pbmi->bmiHeader.biHeight * cClrBits;

    //
    // Set biClrImportant to 0 to indicate that all of the device
    // colors are important.
    //
    pbmi->bmiHeader.biClrImportant  = 0;

    //
    // And finally return the info-structure.
    //
    return pbmi;
}

void ScreenShot(HWND hwnd, int width, int height, int xOffset, int yOffset)
{
    HDC hdcScreen;
    HDC hdcCompatible;
    HBITMAP  hbmScreen;
    PBITMAPINFO pbi;
    char fname[512];

    hdcScreen=GetDC(hwnd);
    if (hdcScreen==NULL)
    {
        MessageBox(NULL,"No hDC found!",langErrorTitle(),MB_OK);
        return;
    }
    hdcCompatible = CreateCompatibleDC(hdcScreen);
    if (hdcCompatible==NULL)
    {
        MessageBox(NULL,"Error creating Compatible DC",langErrorTitle(),MB_OK);
        return;
    }

    hbmScreen = CreateCompatibleBitmap(hdcScreen, width, height);
    if (hbmScreen==NULL)
    {
        MessageBox(NULL,"Error creating Compatible Bitmap",langErrorTitle(),MB_OK);
        return;
    }

    SelectObject(hdcCompatible, hbmScreen);
    BitBlt(hdcCompatible, 0, 0, width, height, hdcScreen, xOffset, yOffset, SRCCOPY);

    ttshots++; if (ttshots>9999) ttshots=1;
    sprintf(fname,"%s\\msx%04i.bmp",baseDir,ttshots);
    pbi = CreateBitmapInfoStructure(hbmScreen);
    if (SaveBitmap(fname, pbi, hbmScreen, hdcCompatible)==E_FAIL) {
        MessageBox(NULL,"Error saving bitmap!",langErrorTitle(),MB_OK);
    }
    if (pbi != NULL) {
        LocalFree(pbi);
    }

    ReleaseDC(hwnd,hdcScreen);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void ScreenShot2(HWND hwnd, int double_width, int interlaced, int *frame_buffer, int *pRgbTable32)
{
	struct
	{
		/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
		unsigned long		Size, Reserved1, OffRaster, OffBits, Width, Height;
		short unsigned int	Planes, BitCount;
		unsigned long		Compression, SizeImage, XPelsPerMeter, YPelsPerMeter, ClrUsed, ClrImportant;
		/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	} BMPHeader;

	/*~~~~~~~~~~~~~~~~~~*/
	char	fname[1024];
	FILE	*poOutput;
	int		width, height;
	int		x, y, sy, sx;
	/*~~~~~~~~~~~~~~~~~~*/

	ttshots++;
	if(ttshots > 9999) ttshots = 1;
	sprintf(fname, "%s\\msx%04i.bmp", baseDir, ttshots);

	if(interlaced || double_width)
	{
		width = 640;
		height = 480;
	}
	else
	{
		width = 320;
		height = 240;
	}

	BMPHeader.BitCount = 24;
	BMPHeader.Size = width * height * BMPHeader.BitCount / 8 + 0x36;
	BMPHeader.Reserved1 = 0;
	BMPHeader.OffRaster = 0x36;
	BMPHeader.OffBits = 0x28;
	BMPHeader.Width = width;
	BMPHeader.Height = height;
	BMPHeader.Planes = 1;
	BMPHeader.Compression = 0;
	BMPHeader.SizeImage = width * height * BMPHeader.BitCount / 8;
	BMPHeader.XPelsPerMeter = 0;
	BMPHeader.YPelsPerMeter = 0;
	BMPHeader.ClrUsed = BMPHeader.ClrImportant = 0;

	poOutput = fopen(fname, "wb");
    if (poOutput == NULL) {
        return;
    }
	fwrite("BM", 2, 1, poOutput);
	fwrite(&BMPHeader, sizeof(BMPHeader), 1, poOutput);

	for(y = height - 1; y >= 0; y--)
	{
		for(x = 0; x < width; x++)
		{
			if(double_width || interlaced)
				sy = y >> 1;
			else
				sy = y;

			if(!double_width && interlaced)
				sx = x >> 1;
			else
				sx = x;

			fwrite
			(
				pRgbTable32 + frame_buffer[640 * sy + sx + ((interlaced && (y & 1)) ? 640 * 240 : 0)],
				3,
				1,
				poOutput
			);
		}
	}

	fclose(poOutput);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */

void InitScreenShot(char* directory) 
{
    WIN32_FIND_DATA fileData;
    FILETIME writeTime;
    HANDLE hFile;
    char lastfile[512];
    char filename[512];
    char filenum[32];

    // save directory
    strcpy(baseDir, directory);

    // screenshot ammount
    ttshots=0;

    mkdir(baseDir);

    sprintf(filename, "%s\\msx????.bmp", baseDir);

    hFile = FindFirstFile(filename,&fileData);
    if (hFile==INVALID_HANDLE_VALUE) 
    {
        ttshots=0;
    } 
    else 
    {
        writeTime = fileData.ftLastWriteTime;
        strcpy(lastfile,fileData.cFileName);
        while (FindNextFile(hFile, &fileData )!=0)
        {
            if (CompareFileTime(&fileData.ftLastWriteTime, &writeTime) < 0) 
            {
                break;
            }
            writeTime = fileData.ftLastWriteTime;
            strcpy(lastfile,fileData.cFileName);
        }
        // now make some sense out of it
        filenum[0]=lastfile[4];
        filenum[1]=lastfile[5];
        filenum[2]=lastfile[6];
        filenum[3]=lastfile[7];
        filenum[4]='\0';
        ttshots=atoi(filenum);
    }
}

