/*****************************************************************************
** File:
**      Win32Menu.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Methods to show create menus.
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef WIN32_MENU_H
#define WIN32_MENU_H

#include <windows.h>
#include "Win32Properties.h"

HMENU menuCreate(Properties* pProperties, 
                 int isRunning, 
                 int isStopped,
                 int logSound,
                 int tempStateExits);

int menuShow(HWND hwnd, 
             Properties* pProperties, 
             int isRunning, 
             int isStopped, 
             int logSound,
             int tempStateExits,
             int show);


HMENU menuCreateReset(Properties* pProperties);
HMENU menuCreateCartA(Properties* pProperties);
HMENU menuCreateCartB(Properties* pProperties);
HMENU menuCreateRun(Properties* pProperties, int isRunning, int isStopped);
HMENU menuCreateDiskA(Properties* pProperties);
HMENU menuCreateDiskB(Properties* pProperties);
HMENU menuCreateCassette(Properties* pProperties);
HMENU menuCreateZoom(Properties* pProperties);
HMENU menuCreateOptions(Properties* pProperties);
HMENU menuCreateHelp(Properties* pProperties);
HMENU menuCreateFile(Properties* pProperties, int isStopped, int logSound, int tempStateExits);

#endif
