/*****************************************************************************
**
** This command engine may be used in any MSX emulator. It does not matter 
** under which conditions that the emulator gets distributed. Be it open-
** source or closed-source. Be it commercially or free-of-charge.
** 
** This command engine may not be used in any other kind of softwares.
** Using this command engine is at own risk. The author is not responsible 
** nor liable for any damages that may occur intentionally or unintentionally 
** from it's usage.
**
******************************************************************************
*/
#ifndef VDPCMD_H
#define VDPCMD_H

#include "MSXTypes.h"


/*************************************************************
** vdpCmdInit
**
** Description:
**      Initializes the command engine.
**************************************************************
*/
void  vdpCmdInit();


/*************************************************************
** vdpCmdRead
**
** Description:
**      Reads current command from the VDP
**************************************************************
*/
UInt8 vdpCmdRead();


/*************************************************************
** vdpCmdWrite
**
** Description:
**      Writes a new command to the VDP
**************************************************************
*/
void  vdpCmdWrite(UInt8 value);


/*************************************************************
** vdpCmdSetCommand
**
** Description:
**      Set VDP command to ececute
**************************************************************
*/
UInt8 vdpCmdSetCommand(UInt8 command);


/*************************************************************
** vdpCmdExecute
**
** Description:
**      Executes a number of cycles of the VDP Command engine
**      (in 3579545 Hz)
**************************************************************
*/
void  vdpCmdExecute(int cycles);


/*************************************************************
** vdpCmdFlush
**
** Description:
**      Flushes current VDP command
**************************************************************
*/
void  vdpCmdFlush();


/*************************************************************
** vdpCmdGetState
**
** Description:
**      Gets the state of the command engine. The method
**      returns the size of the sate.
**************************************************************
*/
int   vdpCmdGetState(void* buffer);


/*************************************************************
** vdpCmdSetState
**
** Description:
**      Sets the state of the command engine. The method
**      returns the size of the sate.
**************************************************************
*/
int   vdpCmdSetState(void* buffer);

#endif /* VDPCMD_H */
