/*****************************************************************************
** File:
**      Casette.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Bios patch for cassette support
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef CASSETTE_H
#define CASSETTE_H

#include "MSXTypes.h"

typedef enum { TAPE_ASCII = 0, TAPE_BINARY, TAPE_BASIC, TAPE_CUSTOM } TapeContentType;

typedef enum { TAPE_UNKNOWN = 0, TAPE_FMSXDOS, TAPE_FMSX98AT } TapeFormat;

typedef struct {
    int             pos;
    TapeContentType type;
    char            fileName[8];
} TapeContent;

void   tapeInit(char* baseDir);
int    tapeInsert(char *name, const char *fileInZipFile);
int    tapeSave(char *name, TapeFormat format);
UInt32 tapeGetLength();
UInt32 tapeGetCurrentPos();
void   tapeSetCurrentPos(int pos);
TapeContent* tapeGetContent(int* count);
TapeFormat   tapeGetFormat();
void tapeSetReadOnly(int readOnly);

/* Internal interface */
UInt8 TapeWrite(UInt8 value);
UInt8 TapeRead(UInt8* value);
UInt8 TapeReadHeader();
UInt8 TapeWriteHeader();

#endif

