/*****************************************************************************
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_ITALIAN_H
#define LANGUAGE_ITALIAN_H

#include "LanguageStrings.h"
 
void langInitItalian(LanguageStrings* ls) 
{
    ls->statusBarStopped        = "  Fermato";
    ls->statusBarPaused         = "  In pausa";
    ls->statusBarRunning        = "  In esecuzione";
    
    ls->menuHardReset           = "Riavvio hardware";
    ls->menuSoftReset           = "Riavvio software";
    
    ls->menuCartInsert          = "Inserisci";
    ls->menuCartRemove          = "Rimuovi";
    ls->menuCartAutoReset       = "Riavvia dopo aver inserito/rimosso";
    ls->menuCartNoRecentFiles   = "- nessun file recente -";
    ls->menuCartSCCPlus         = "Cartuccia SCC+";
    ls->menuCartFMPac           = "Cartuccia FM-PAC";
    ls->menuCartPac             = "Cartuccia PAC";
    ls->menuCartSpecial         = "Speciale";

    ls->menuDiskInsert          = "Inserisci";
    ls->menuDiskEject           = "Espelli";
    ls->menuDiskAutoStart       = "Riavvia dopo l'inserimento";
    ls->menuDiskNoRecentFiles   = "- nessun file recente -";
    
    ls->menuCasInsert           = "Inserisci";
    ls->menuCasEject            = "Espelli";
    ls->menuCasSetPosition      = "Imposta la posizione";
    ls->menuCasRewind           = "Riavvolgi";
    ls->menuDiskNoRecentFiles   = "- nessun file recente -";

    ls->menuZoomNormal          = "Dimensione normale";
    ls->menuZoomDouble          = "Dimensione doppia";
    ls->menuZoomFullscreen      = "Schermo intero";
    
    ls->menuPropsEmulation      = "Emulazione";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "Sonoro";
    ls->menuPropsControls       = "Controlli";
    ls->menuPropsPerformance    = "Prestazioni";
    ls->menuPropsLanguage       = "Lingua";
    
    ls->menuHelpHelp            = "Argomenti";
    ls->menuHelpAbout           = "Informazioni su blueMSX";

    ls->menuFileCart1           = "Cartuccia Slot 1";
    ls->menuFileCart2           = "Cartuccia Slot 2";
    ls->menuFileDiskA           = "Disco floppy A";
    ls->menuFileDiskB           = "Disco floppy B";
    ls->menuFileCas             = "Cassetta";
    ls->menuFileLoadState       = "Carica lo stato della CPU";
    ls->menuFileSaveState       = "Salva lo stato della CPU";
    ls->menuFileQLoadState      = "Carica rapidamente lo stato";
    ls->menuFileQSaveState      = "Salva rapidamente lo stato";
    ls->menuFileCaptureAudio    = "Cattura l'audio";
    ls->menuFileScreenShot      = "Salva la schermata";
    ls->menuFileExit            = "Esci";

    ls->menuRunRun              = "Esegui";
    ls->menuRunPause            = "Pausa";
    ls->menuRunStop             = "Ferma";
    ls->menuRunSoftReset        = "Riavvio software";
    ls->menuRunHardReset        = "Riavvio hardware";
    ls->menuRunCleanReset       = "Riavvio generale";

    ls->menuFile                = "File";
    ls->menuRun                 = "Esecuzione";
    ls->menuWindow              = "Finestra";
    ls->menuOptions             = "Opzioni";
    ls->menuHelp                = "Aiuto";
    
    ls->errorTitle              = "blueMSX - Errore";
    ls->errorEnterFullscreen    = "Non riesco ad attivare la visualizzazione a schermo intero.           \n";
    ls->errorDirectXFailed      = "Non riesco a creare gli oggetti DirectX.          \nUtilizzo GDI.\nControllo le propriet Video.";
    ls->errorNoRomInZip         = "Nessun file .rom trovato nell'archivio zip.";
    ls->errorNoDskInZip         = "Nessun file .dsk trovato nell'archivio zip.";
    ls->errorNoCasInZip         = "Nessun file .cas trovato nell'archivio zip.";
    ls->errorNoHelp             = "Non trovo il file di Aiuto di blueMSX.";
    ls->errorStartEmu           = "Avvio dell'emulatore MSX fallito.";

    ls->tooltipReset            = "Riavvia l'MSX";
    ls->tooltipCart1            = "Inserisce una cartuccia nello Slot 1";
    ls->tooltipCart2            = "Inserisce una cartuccia nello Slot 2";
    ls->tooltipDiskA            = "Inserisce un dischetto nell'unit A";
    ls->tooltipDiskB            = "Inserisce un dischetto nell'unit B";
    ls->tooltipCas              = "Inserisce un nastro nel riproduttore";
    ls->tooltipStart            = "Avvia l'emulazione";
    ls->tooltipResume           = "Riprende l'emulazione";
    ls->tooltipPause            = "Mette in pausa l'emulatore";
    ls->tooltipWindowSize       = "Imposta le dimensioni della finestra";
    ls->tooltipProperties       = "Apre il pannello delle propriet";
    ls->tooltipHelp             = "Apre la finestra di aiuto";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - Seleziona un'immagine rom da caricare";
    ls->dlgLoadDsk              = "blueMSX - Seleziona un'immagine dsk da caricare";
    ls->dlgLoadCas              = "blueMSX - Seleziona un'immagine cas da caricare";
    ls->dlgLoadRomDskCas        = "blueMSX - Seleziona un file rom, dsk, o cas da caricare";
    ls->dlgLoadRomDesc          = "Scegli un'immagine rom da caricare:";
    ls->dlgLoadDskDesc          = "Scegli un'immagine dischetto da caricare:";
    ls->dlgLoadCasDesc          = "Scegli un'immagine cassetta da caricare:";
    ls->dlgLoadRomDskCasDesc    = "Scegli l'immagine di una rom, di un dischetto, o di un nastro da caricare:";
    ls->dlgLoadState            = "Carica lo stato della CPU";
    ls->dlgSaveState            = "Salva lo stato della CPU";
    ls->dlgInsertRom1           = "Inserisci una cartuccia ROM nello slot 1";
    ls->dlgInsertRom2           = "Inserisci una cartuccia ROM nello slot 2";
    ls->dlgInsertDiskA          = "Inserisci un'immagine dischetto nell'unit A";
    ls->dlgInsertDiskB          = "Inserisci un'immagine dischetto nell'unit B";
    ls->dlgInsertCas            = "Inserisci un'immagine cassetta";

    ls->dlgOK                   = "OK";
    ls->dlgOpen                 = "Aprire";
    ls->dlgCancel               = "Annulla";

    ls->dlgTapeTitle            = "blueMSX - Posizione del nastro";
    ls->dlgTapeFrameText        = "Posizione del nastro";
    ls->dlgTapeCurrentPos       = "Posizione attuale";
    ls->dlgTapeTotalTime        = "Durata totale";

    ls->dlgZipReset             = "Riavvia dopo l'inserimento";

    ls->dlgAboutTitle           = "blueMSX - Informazioni";

    ls->dlgJoyTitle1            = "blueMSX - Configurazione del joystick A";
    ls->dlgJoyTitle2            = "blueMSX - Configurazione del joystick B";
    ls->dlgJoyUpText            = "S";
    ls->dlgJoyDownText          = "Gi";
    ls->dlgJoyLeftText          = "Sinistra";
    ls->dlgJoyRightText         = "Destra";
    ls->dlgJoyButton1Text       = "Pulsante 1";
    ls->dlgJoyButton2Text       = "Pulsante 2";
    ls->dlgJoyGB                = "Configurazione dei tasti ";

    ls->dlgLangLangText         = "Scegli la lingua per l'interfaccia di blueMSX";
    ls->dlgLangLangTitle        = "blueMSX - Lingua";

    ls->propTitle               = "blueMSX - Propriet";
    ls->propEmulation           = "Emulazione";
    ls->propVideo               = "Video";
    ls->propSound               = "Audio";
    ls->propControls            = "Controlli";
    ls->propPerformance         = "Prestazioni";
    
    ls->propEmuGeneralGB        = "Generale ";
    ls->propEmuFamilyText       = "Modello MSX:";
    ls->propEmuMemoryGB         = "Memoria ";
    ls->propEmuRamSizeText      = "Dimensioni della RAM:";
    ls->propEmuVramSizeText     = "Dimensioni della VRAM:";
    ls->propEmuSpeedGB          = "Velocit di emulazione ";
    ls->propEmuSpeedText        = "Velocit di emulazione:";

    ls->propMonMonGB            = "Monitor ";
    ls->propMonTypeText         = "Tipo monitor:";
    ls->propMonEmuText          = "Emulazione monitor:";
    ls->propVideoYypeText       = "Tipo di video:";
    ls->propWindowSizeText      = "Dimensioni della finestra:";

    ls->propPerfVideoDrvGB      = "Driver video ";
    ls->propPerfVideoDispDrvText= "Mostra il driver:";
    ls->propPerfFrameSkipText   = "Salta fotogrammi:";
    ls->propPerfAudioDrvGB      = "Driver audio ";
    ls->propPerfAudioDrvText    = "Driver del suono:";
    ls->propPerfAudioBufSzText  = "Dimensioni del buffer audio:";
    ls->propPerfEmuGB           = "Emulazione ";
    ls->propPerfSyncModeText    = "SYNC Modo sincronizzato:";

    ls->propSndChipEmuGB        = "Emulazione del chip audio ";
    ls->propSndMixerGB          = "Mixer audio ";
    ls->propSndMonoText         = "mono";
    ls->propSndStereoText       = "stereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (chip audio YM-2413)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (chip audio Y8950)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "Porta #1 ";
    ls->propJoyPort2GB          = "Porta #2 ";
    ls->propJoyAutofireText     = "Sparo auto:";
    ls->propJoyKeysetGB         = "Configurazione joysticks ";
    ls->propJoyKeyest1          = "Configura il joystick A";
    ls->propJoyKeyest2          = "Configura il joystick B";

    ls->enumVideoMonColor       = "Colore";
    ls->enumVideoMonGrey        = "Bianco e nero";
    ls->enumVideoMonGreen       = "Verde";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Nessuna";
    ls->enumVideoEmuYc          = "Cavo Y/C (Sharp)";
    ls->enumVideoEmuYcBlur      = "Cavo Y/C rumoroso (Sharp)";
    ls->enumVideoEmuComp        = "Composito (Blurry)";
    ls->enumVideoEmuCompBlur    = "Composito rumoroso (Blurry)";
    ls->enumVideoEmuScale2x     = "Dimensioni doppie";

    ls->enumVideoSize1x         = "Normale - 320x200";
    ls->enumVideoSize2x         = "Doppia - 640x400";
    ls->enumVideoSizeFullscreen = "Schermo intero";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "Nessuno";
    ls->enumVideoFrameskip1     = "1 fotogramma";
    ls->enumVideoFrameskip2     = "2 fotogrammi";
    ls->enumVideoFrameskip3     = "3 fotogrammi";
    ls->enumVideoFrameskip4     = "4 fotogrammi";
    ls->enumVideoFrameskip5     = "5 fotogrammi";

    ls->enumSoundDrvNone        = "Nessun suono";
    ls->enumSoundDrvWMM         = "Driver WMM";
    ls->enumSoundDrvDirectX     = "Driver DirectX";

    ls->enumEmuSync1ms          = "1ms (migliore)";
    ls->enumEmuSyncAuto         = "Automatico (veloce)";

    ls->enumControlsJoyNone     = "Nessuno";
    ls->enumControlsJoyNumpad   = "Tastierino numerico";
    ls->enumControlsJoyKeysetA  = "Controlli per A";
    ls->enumControlsJoyKeysetB  = "Controlli per B";
    ls->enumControlsJoyPCjoy1   = "PC joystick #1";
    ls->enumControlsJoyPCjoy2   = "PC joystick #2";
    ls->enumControlsJoyMouse    = "Mouse";

    ls->enumControlsAfOff       = "Disattivato";
    ls->enumControlsAfSlow      = "Lento";
    ls->enumControlsAfMedium    = "Medio";
    ls->enumControlsAfFast      = "Rapido";

    ls->dlgAboutAbout           = "INFORMAZIONI\r\n====";
    ls->dlgAboutVersion         = "Versione:";
    ls->dlgAboutBuildNumber     = "Compilazione:";
    ls->dlgAboutBuildDate       = "Data:";
    ls->dlgAboutCreat           = "Creato da Daniel Vik";
    ls->dlgAboutDevel           = "SVILUPPATORI\r\n========";
    ls->dlgAboutThanks          = "RINGRAZIAMENTI SPECIALI A\r\n============";
    ls->dlgAboutLisence         = "LICENZA\r\n"
                                  "======\r\n\r\n"
                                  "Questo programma  fornito \"cos com'\", senza alcuna esplicita o implicita "
                                  "garanzia. In nessun caso l'autore potr essere ritenuto responsabile per "
                                  "qualunque danno derivante dall'uso di questo programma.\r\n\r\n"
                                  "E' permesso a chiunque utilizzare questo programma solamente per scopi "
                                  "non commerciali.\r\n\r\n\r\n"
                                  "Visita www.vik.cc/blueMSX per maggiori dettagli.";

    // New entries
    ls->menuTools                = "Strumenti";
    ls->menuToolsMachine         = "Editor della macchina";
    ls->menuPropsSettings        = "Impostazioni";
    ls->menuCasRewindAfterInsert = "Riavvolgi dopo l'inserimento";
    ls->menuCasUseReadOnly       = "Usa un'immagine nastro a sola lettura";
    ls->lmenuCasSaveAs           = "Salva l'immagine nastro con nome";

    ls->dlgSaveCassette          = "blueMSX - Salva l'immagine nastro";
    ls->dlgTapeCustom            = "Mostra i files personalizzati";
    ls->dlgTapeSetPosText        = "Posizione del nastro:";
    ls->dlgTabPosition           = "Posizione";
    ls->dlgTabType               = "Tipo";
    ls->dlgTabFilename           = "Nome del file";

    ls->propSettings             = "Impostazioni";
    
    ls->propSetFileHistoryGB     = "Files recenti ";
    ls->propSetFileHistorySize   = "Numero di voci in Files recenti:";
    ls->propSetFileHistoryClear  = "Cancella la lista";
    ls->propSetScreenSaverGB     = "Salvaschermo ";
    ls->propSetScreenSaver       = " Disabilita il salvaschermo durante l'esecuzione di blueMSX";

    ls->confTitle                = "blueMSX - Editor di configurazione della macchina";
    ls->confSave                 = "Salva";
    ls->confSaveAs               = "Salva con";
    ls->confRun                  = "Esegui";
    ls->confClose                = "Chiudi";
    ls->confConfigText           = "Configurazione";
    ls->confSlotLayout           = "Disposizione degli slots";
    ls->confMemory               = "Memoria";
    ls->confChipEmulation        = "Emulazione del chip";

    ls->confSlotLayoutGB         = "Disposizione degli slots ";
    ls->confSlotExtSlotGB        = "Slots esterni ";
    ls->confSlotSlot0            = "Slot 0";
    ls->confSlotSlot1            = "Slot 1";
    ls->confSlotSlot2            = "Slot 2";
    ls->confSlotSlot3            = "Slot 3";
    ls->confSlotCart1            = "Cartuccia 1:";
    ls->confSlotCart2            = "Cartuccia 2:";
    ls->confSlotPrimary          = "Primario";
    ls->confSlotExpanded         = "Espanso (4 subslots)";

    ls->confMemAdd               = "Aggiungi...";
    ls->confMemEdit              = "Modifica...";
    ls->confMemRemove            = "Rimuovi";
    ls->confMemSlot              = "Slot";
    ls->confMemAddresss          = "Indirizzo";
    ls->confMemType              = "Tipo";
    ls->confMemRomImage          = "Immagine ROM";
    
    ls->confSaveTitle            = "blueMSX - Salva la configurazione";
    ls->confSaveText             = "Vuoi sovrascrivere la configurazione della macchina?";

    ls->confChipVideoGB          = "Video ";
    ls->confChipVideoChip        = "Chip video:";
    ls->confChipVideoRam         = "RAM video:";
    ls->confChipSoundGB          = "Audio ";

    ls->slotEditMemTitle         = "blueMSX - Modifica il Mapper";
    ls->slotEditMemGB            = "Dettagli del Mapper ";
    ls->slotEditMemType          = "Tipo:";
    ls->slotEditMemFile          = "File:";
    ls->slotEditMemAddress       = "Indirizzo";
    ls->slotEditMemSize          = "Dimensioni";
    ls->slotEditMemSlot          = "Slot";

    ls->confDiscardTitle         = "blueMSX - Configurazione";
    ls->confExitSaveTitle        = "blueMSX - Esci dall'editor di configurazione";
    ls->confExitSaveText         = "Vuoi annullare i cambiamenti apportati alla configurazione attuale?";

    ls->confSaveAsTitle          = "blueMSX - Salva la configurazione con nome";
    ls->confSaveAsMachineName    = "Nome della macchina:";
    
    ls->confEditMemInternalRoms  = "blueMSX - Roms interne"; 


    ls->propSndMoonsound         = " Moonsound";

    ls->propFileTypesGB          = "Tipi di file ";
    ls->propFileTypes            = " Associare alcuni tipi di file con blueMSX"; 
    ls->propDisableWinKeys       = " Funzione MSX automatica per le chiavi Windows"; 
    ls->propWindowsEnvGB         = "Ambiente Windows";

    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW accel.";
    ls->enumVideoDrvDirectDrawHWSys = "DirectDraw mix."; 
    ls->propMonHorizStretch      = " Allungamento Orizzontale";
    ls->propClearHistory         = "Desiderate realmente cancellare la lista ?";
    ls->propEmuFrontSwitchGB     = "Panasonic Switches "; 
    ls->propEmuFrontSwitch       = " Front Switch (MSX2+)"; 
    ls->propEmuAudioSwitch       = " MSX-AUDIO cartridge switch"; 
    ls->propMonVertStretch       = " Allungamento Verticale";

};

#endif


