#include "Win32StatusBar.h"
#include "Language.h"
#include "Resource.h"
#include <windows.h>
#include <CommCtrl.h>
#include <tchar.h>
#include <stdio.h>
#include <math.h>

static HICON hIconDisc[2];
static HICON hIconCas;
static HICON hIconCaps;
static HICON hIconKana;
static HICON hIconCapsKana;
static HWND  hwndParent;
static HWND  hwndStatus;
static int oldEmuSpeed = -1;
static _TCHAR oldRunField[32] = { 0 };
static _TCHAR oldScreenField[32] = { 0 };
static DWORD oldLedState = 0;
static HICON hIconCasCur = NULL;
static HICON hIconDisk1  = NULL;
static HICON hIconDisk2  = NULL;
 
static _TCHAR* txtScreenMode[14] = {
    "  SCREEN 0",  "  SCREEN 1", "  SCREEN 2",  "  SCREEN 3",
    "  SCREEN 4",  "  SCREEN 5", "  SCREEN 6",  "  SCREEN 7",
    "  SCREEN 8",  "  SCREEN 9", "  SCREEN 10", "  SCREEN 11",
    "  SCREEN 12", "  TEXT80"
};

int diskBusy[2];
int casBusy;

static _TCHAR* strEmuSpeed(int logSpeed) {
    DWORD speed = (DWORD)(3579545 * pow(2.0, (logSpeed - 50) / 15.0515));
    static _TCHAR buf[32];
    if (speed >= 10000000) {
        _stprintf(buf, "%d.%02dMHz", speed / 1000000, (speed / 10000) % 100);
    }
    else {
        _stprintf(buf, "%d.%03dMHz", speed / 1000000, (speed / 1000) % 1000);
    }
    return buf;

}

HWND statusBarInit(HWND parent) {
    HINSTANCE hInstance = GetModuleHandle(NULL);

    hwndParent    = parent;
    hIconCas      = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_CAS));
    hIconCaps     = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_CAPS));
    hIconKana     = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_KANA));
    hIconCapsKana = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_CAPSKANA));
    hIconDisc[0]  = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_DISK1));
    hIconDisc[1]  = LoadIcon(hInstance, MAKEINTRESOURCE(IDB_DISK2));

    hwndStatus = CreateWindowEx(0, STATUSCLASSNAME, NULL, WS_CHILD | WS_VISIBLE, 
                                0, 0, 50, 50, parent, (HMENU) 443, hInstance, NULL);

    return hwndStatus;
}

void statusBarUpdate(int emuStopped, 
                     int emuPaused, 
                     int screenMode, 
                     int emulationSpeed,
                     int ledState) 
{
    RECT cr;
    int parts[7];

    GetClientRect(hwndParent, &cr);
    parts[0] = cr.right - 235;
    parts[1] = cr.right - 174;
    parts[2] = cr.right - 141;
    parts[3] = cr.right - 118;
    parts[4] = cr.right - 95;
    parts[5] = cr.right - 72;
    parts[6] = cr.right - 0;

    SendMessage(hwndStatus, SB_SETPARTS, (WPARAM)7, (LPARAM) parts); 
    if (emuStopped) {
        if (_tcscmp(oldRunField, langStatusBarStopped())) {
            _tcscpy(oldRunField, langStatusBarStopped());
            SendMessage(hwndStatus, SB_SETTEXT, 0, (LPARAM)oldRunField);
        }
        if (_tcscmp(oldScreenField, "")) {
            _tcscpy(oldScreenField, "");
            SendMessage(hwndStatus, SB_SETTEXT, 6, (LPARAM)oldScreenField);
        }
    }
    else if (emuPaused) {
        if (_tcscmp(oldRunField, langStatusBarPaused())) {
            _tcscpy(oldRunField, langStatusBarPaused());
            SendMessage(hwndStatus, SB_SETTEXT, 0, (LPARAM)oldRunField);
        }
        if (_tcscmp(oldScreenField, txtScreenMode[screenMode])) {
            _tcscpy(oldScreenField, txtScreenMode[screenMode]);
            SendMessage(hwndStatus, SB_SETTEXT, 6, (LPARAM)oldScreenField);
        }
    }
    else {
        if (_tcscmp(oldRunField, langStatusBarRunning())) {
            _tcscpy(oldRunField, langStatusBarRunning());
            SendMessage(hwndStatus, SB_SETTEXT, 0, (LPARAM)oldRunField);
        }
        if (_tcscmp(oldScreenField, txtScreenMode[screenMode])) {
            _tcscpy(oldScreenField, txtScreenMode[screenMode]);
            SendMessage(hwndStatus, SB_SETTEXT, 6, (LPARAM)oldScreenField);
        }
    }

    if (oldEmuSpeed != emulationSpeed) {
        oldEmuSpeed = emulationSpeed;
        SendMessage(hwndStatus, SB_SETTEXT, 1, (LPARAM)strEmuSpeed(oldEmuSpeed));
    }

    if (oldLedState != ledState) {
        oldLedState = ledState;
        switch (oldLedState) {
        default:
            SendMessage(hwndStatus, SB_SETICON, 2, (LPARAM)NULL);
            break;
        case 1:
            SendMessage(hwndStatus, SB_SETICON, 2, (LPARAM)hIconCaps);
            break;
        case 2:
            SendMessage(hwndStatus, SB_SETICON, 2, (LPARAM)hIconKana);
            break;
        case 3:
            SendMessage(hwndStatus, SB_SETICON, 2, (LPARAM)hIconCapsKana);
            break;
        }
    }

    if (casBusy) {
        if (hIconCasCur != hIconCas) {
            hIconCasCur = hIconCas;
            SendMessage(hwndStatus, SB_SETICON, 3, (LPARAM)hIconCasCur);
        }
        casBusy = 0;
    }
    else {
        if (hIconCasCur != NULL) {
            hIconCasCur = NULL;
            SendMessage(hwndStatus, SB_SETICON, 3, (LPARAM)hIconCasCur);
        }
    }

    if (diskBusy[0]) {
        if (hIconDisk1 != hIconDisc[0]) {
            hIconDisk1 = hIconDisc[0];
            SendMessage(hwndStatus, SB_SETICON, 4, (LPARAM)hIconDisk1);
        }
        diskBusy[0] = 0;
    }
    else {
        if (hIconDisk1 != NULL) {
            hIconDisk1 = NULL;
            SendMessage(hwndStatus, SB_SETICON, 4, (LPARAM)hIconDisk1);
        }
    }

    if (diskBusy[1]) {
        if (hIconDisk2 != hIconDisc[1]) {
            hIconDisk2 = hIconDisc[1];
            SendMessage(hwndStatus, SB_SETICON, 5, (LPARAM)hIconDisk2);
        }
        diskBusy[1] = 0;
    }
    else {
        if (hIconDisk2 != NULL) {
            hIconDisk2 = NULL;
            SendMessage(hwndStatus, SB_SETICON, 5, (LPARAM)hIconDisk2);
        }
    }
}

void statusBarShow(int show) {
    ShowWindow(hwndStatus, show);
}

void statusBarUpdatePos() {
    MoveWindow(hwndStatus, 0, 0, 0, 0, TRUE);
}
