/*****************************************************************************
** File:
**      Win32MouseEmu.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Mouse support
**
******************************************************************************
*/

#include "Win32MouseEmu.h"
 
static HWND mouseHwnd;
static int mouseIsRunning = 0;
static int mouseTimerId;
static RECT mouseCapRect;
static int mouseActive;
static int mouseEnable;
static int mouseDX;
static int mouseDY;
static int mouseLockDX;
static int mouseLockDY;
static int hasMouseLock;

static void CALLBACK mouseEmuTimerCallback(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
    POINT pt;

    if (!mouseIsRunning || !mouseActive) {
        if (hasMouseLock) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }
        return;
    }

    GetCursorPos(&pt);

    ScreenToClient(mouseHwnd, &pt);
    
    if (!PtInRect(&mouseCapRect, pt)) {
        if (hasMouseLock) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }
        return;
    }

    if (!hasMouseLock) {
        mouseLockDX = 0;
        mouseLockDY = 0;
        mouseDX = 0;
        mouseDY = 0;
        hasMouseLock = 1;
        ShowCursor(FALSE);
        SetCapture(mouseHwnd);
        if (mouseEnable) {
            pt.x = 100;
            pt.y = 100;
            ClientToScreen(mouseHwnd, &pt);
            SetCursorPos(pt.x, pt.y);
        }
    }
    else if (mouseEnable) {
        int DX = 100 - pt.x;
        int DY = 100 - pt.y;

        mouseDX += DX;
        mouseDY += DY;
        mouseLockDX -= DX;
        mouseLockDY -= DY;

        pt.x = mouseLockDX < -600 ? mouseCapRect.left   - 3  : 100;
        pt.x = mouseLockDX >  600 ? mouseCapRect.right  + 3  : pt.x;
        pt.y = mouseLockDY < -600 ? mouseCapRect.top    - 3  : 100;
        pt.y = mouseLockDY >  600 ? mouseCapRect.bottom + 3  : pt.y;

        if (mouseLockDX < -600 || mouseLockDX > 600 || mouseLockDY < -600 || mouseLockDY > 600) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }

        ClientToScreen(mouseHwnd, &pt);
        SetCursorPos(pt.x, pt.y);
    }
}

void mouseEmuInit(HWND hwnd, int timerId) {
    mouseHwnd = hwnd;
    mouseTimerId = timerId;
    SetTimer(mouseHwnd, mouseTimerId, 50, mouseEmuTimerCallback);
}

void mouseEmuSetCaptureInfo(RECT* captureRect) {
    if (captureRect != NULL) {
        memcpy(&mouseCapRect, captureRect, sizeof(RECT));
    }
    else {
        mouseActive = 0;
        memset(&mouseCapRect, 0, sizeof(RECT));
    }
}

void mouseEmuUpdateRunState(int isRunning) {
    mouseIsRunning = isRunning;
}

void mouseEmuEnable(int enable) {
    mouseEnable = enable;
}

void mouseEmuActivate(int activate) {
    mouseActive = activate;
}

void mouseEmuGetState(int* dx, int* dy, int* buttons) {
    *dx = 0;
    *dy = 0;
    *buttons = 0;

    if (hasMouseLock) {
        *dx = mouseDX;
        *dy = mouseDY;

        mouseDX = 0;
        mouseDY = 0;

        if (GetKeyState(VK_LBUTTON) > 1UL) {
            *buttons |= 0x10000UL;
        }

        if (GetKeyState(VK_MBUTTON) > 1UL || GetKeyState(VK_RBUTTON) > 1UL) {
            *buttons |= 0x20000UL;
        }
    }
}

