/*****************************************************************************
** File:        Win32Help.c
**
** Author:      Daniel Vik
**
** Description: Methods to show create menus.
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
******************************************************************************
*/
#include <tchar.h>
#include <stdio.h>
#include "Win32Menu.h"
#include "Win32FileHistory.h"
#include "Language.h"
#include "Resource.h"
 
HMENU menuCreateReset(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();

    _stprintf(langBuffer, "%s%hs", langMenuRunHardReset(), "\tF12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_RESET, langBuffer);
    _stprintf(langBuffer, "%s%hs", langMenuRunSoftReset(), "        \tCtrl+F12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_SOFTRESET, langBuffer);
    _stprintf(langBuffer, "%s%hs", langMenuRunCleanReset(), "        \tCtrl+Alt+F12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_CLEANRESET, langBuffer);

    return hMenu;
}

HMENU menuCreateCartA(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();
    HMENU hSpec = CreateMenu();
    int i;

    _stprintf(langBuffer, "%s%hs", langMenuCartInsert(), "      \tCtrl+F7");
    AppendMenu(hMenu, MF_STRING, ID_FILE_INSERT_CARTRIDGEA, langBuffer);

    _stprintf(langBuffer, "%s%hs%hs", langMenuCartRemove(), (*pProperties->cartridge.slotA ? ": " : ""), stripPath(pProperties->cartridge.slotA));
    AppendMenu(hMenu, MF_STRING | (*pProperties->cartridge.slotA ? 0 : MF_GRAYED), ID_FILE_REMOVE_CARTRIDGEA, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuCartAutoReset());
    AppendMenu(hMenu, MF_STRING | (pProperties->cartridge.autoReset ? MFS_CHECKED : 0), ID_FILE_CARTRIDGE_AUTORESET, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    if (*pProperties->filehistory.cartridgeA[0] == 0) {
        _stprintf(langBuffer, "%s", langMenuCartNoRecentFiles());
        AppendMenu(hMenu, MF_STRING | MF_GRAYED,  0, langBuffer);
    }

    verifyFileHistory(*pProperties->filehistory.cartridgeA);

    for (i = 0; i < MAX_HISTORY && *pProperties->filehistory.cartridgeA[i]; i++) {
        _stprintf(langBuffer, "%hs", stripPath(pProperties->filehistory.cartridgeA[i]));
        AppendMenu(hMenu, MF_STRING, ID_CARTRIDGEA_HISTORY + i, langBuffer);
    }

    _stprintf(langBuffer, "%s", langMenuCartSCCPlus());
    AppendMenu(hSpec, MF_STRING, ID_FILE_CARTA_SCCPLUS, langBuffer);

    _stprintf(langBuffer, "%s", langMenuCartFMPac());
    AppendMenu(hSpec, MF_STRING, ID_FILE_CARTA_FMPAC, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuCartSpecial());
    AppendMenu(hMenu, MF_POPUP,     (UINT)hSpec, langBuffer);

    return hMenu;
}

HMENU menuCreateCartB(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();
    HMENU hSpec = CreateMenu();
    int i;

    _stprintf(langBuffer, "%s%hs", langMenuCartInsert(), "      \tCtrl+F8");
    AppendMenu(hMenu, MF_STRING, ID_FILE_INSERT_CARTRIDGEB, langBuffer);

    _stprintf(langBuffer, "%s%hs%hs", langMenuCartRemove(), (*pProperties->cartridge.slotB ? ": " : ""), stripPath(pProperties->cartridge.slotB));
    AppendMenu(hMenu, MF_STRING | (*pProperties->cartridge.slotB ? 0 : MF_GRAYED), ID_FILE_REMOVE_CARTRIDGEB, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuCartAutoReset());
    AppendMenu(hMenu, MF_STRING | (pProperties->cartridge.autoReset ? MFS_CHECKED : 0), ID_FILE_CARTRIDGE_AUTORESET, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    if (*pProperties->filehistory.cartridgeB[0] == 0) {
        _stprintf(langBuffer, "%s", langMenuCartNoRecentFiles());
        AppendMenu(hMenu, MF_STRING | MF_GRAYED,  0, langBuffer);
    }

    verifyFileHistory(*pProperties->filehistory.cartridgeB);

    for (i = 0; i < MAX_HISTORY && *pProperties->filehistory.cartridgeB[i]; i++) {
        _stprintf(langBuffer, "%hs", stripPath(pProperties->filehistory.cartridgeB[i]));
        AppendMenu(hMenu, MF_STRING, ID_CARTRIDGEB_HISTORY + i, langBuffer);
    }

    _stprintf(langBuffer, "%s", langMenuCartSCCPlus());
    AppendMenu(hSpec, MF_STRING, ID_FILE_CARTB_SCCPLUS, langBuffer);

    _stprintf(langBuffer, "%s", langMenuCartFMPac());
    AppendMenu(hSpec, MF_STRING, ID_FILE_CARTB_FMPAC, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuCartSpecial());
    AppendMenu(hMenu, MF_POPUP,     (UINT)hSpec, langBuffer);

    return hMenu;
}

HMENU menuCreateDiskA(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();
    int i;

    _stprintf(langBuffer, "%s%hs", langMenuDiskInsert(), "      \tCtrl+F9");
    AppendMenu(hMenu, MF_STRING, ID_FILE_INSERT_DISKETTEA, langBuffer);

    _stprintf(langBuffer, "%s%hs%hs", langMenuDiskEject(), (*pProperties->diskdrive.slotA ? ": " : ""), stripPath(pProperties->diskdrive.slotA));
    AppendMenu(hMenu, MF_STRING | (*pProperties->diskdrive.slotA ? 0 : MF_GRAYED), ID_FILE_REMOVE_DISKETTEA, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuDiskAutoStart());
    AppendMenu(hMenu, MF_STRING | (pProperties->diskdrive.autostartA ? MFS_CHECKED : 0), ID_FILE_INSERT_DISKETTEA_RESET, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    if (*pProperties->filehistory.diskdriveA[0] == 0) {
        _stprintf(langBuffer, "%s", langMenuDiskNoRecentFiles());
        AppendMenu(hMenu, MF_STRING | MF_GRAYED,  0, langBuffer);
    }

    verifyFileHistory(*pProperties->filehistory.diskdriveA);

    for (i = 0; i < MAX_HISTORY && *pProperties->filehistory.diskdriveA[i]; i++) {
        _stprintf(langBuffer, "%hs", stripPath(pProperties->filehistory.diskdriveA[i]));
        AppendMenu(hMenu, MF_STRING, ID_DISKDRIVEA_HISTORY + i, langBuffer);
    }

    return hMenu;
}

HMENU menuCreateDiskB(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();
    int i;

    _stprintf(langBuffer, "%s%hs", langMenuDiskInsert(), "      \tCtrl+F10");
    AppendMenu(hMenu, MF_STRING, ID_FILE_INSERT_DISKETTEB, langBuffer);

    _stprintf(langBuffer, "%s%hs%hs", langMenuDiskEject(), (*pProperties->diskdrive.slotB ? ": " : ""), stripPath(pProperties->diskdrive.slotB));
    AppendMenu(hMenu, MF_STRING | (*pProperties->diskdrive.slotB ? 0 : MF_GRAYED), ID_FILE_REMOVE_DISKETTEB, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    if (*pProperties->filehistory.diskdriveB[0] == 0) {
        _stprintf(langBuffer, "%s", langMenuDiskNoRecentFiles());
        AppendMenu(hMenu, MF_STRING | MF_GRAYED,  0, langBuffer);
    }

    verifyFileHistory(*pProperties->filehistory.diskdriveB);
    
    for (i = 0; i < MAX_HISTORY && *pProperties->filehistory.diskdriveB[i]; i++) {
        _stprintf(langBuffer, "%hs", stripPath(pProperties->filehistory.diskdriveB[i]));
        AppendMenu(hMenu, MF_STRING, ID_DISKDRIVEB_HISTORY + i, langBuffer);
    }

    return hMenu;
}

HMENU menuCreateCassette(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();
    int i;

    _stprintf(langBuffer, "%s", langMenuCasInsert());
    AppendMenu(hMenu, MF_STRING, ID_FILE_INSERT_CASSETTE, langBuffer);

    _stprintf(langBuffer, "%s%hs%hs", langMenuCasEject(), (*pProperties->cassette.tape ? ": " : ""), stripPath(pProperties->cassette.tape));
    AppendMenu(hMenu, MF_STRING | (*pProperties->cassette.tape ? 0 : MF_GRAYED), ID_FILE_REMOVE_CASSETTE, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuCasSetPosition());
    AppendMenu(hMenu, MF_STRING | (*pProperties->cassette.tape ? 0 : MF_GRAYED), ID_FILE_POSITION_CASSETTE, langBuffer);

    _stprintf(langBuffer, "%s", langMenuCasRewind());
    AppendMenu(hMenu, MF_STRING | (*pProperties->cassette.tape ? 0 : MF_GRAYED), ID_FILE_REWIND_CASSETTE, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    if (*pProperties->filehistory.cassette[0] == 0) {
        _stprintf(langBuffer, "%s", langMenuCasNoRecentFiles());
        AppendMenu(hMenu, MF_STRING | MF_GRAYED,  0, langBuffer);
    }

    verifyFileHistory(*pProperties->filehistory.cassette);

    for (i = 0; i < MAX_HISTORY && *pProperties->filehistory.cassette[i]; i++) {
        _stprintf(langBuffer, "%hs", stripPath(pProperties->filehistory.cassette[i]));
        AppendMenu(hMenu, MF_STRING, ID_CASSETTE_HISTORY + i, langBuffer);
    }

    return hMenu;
}

HMENU menuCreateZoom(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();

    _stprintf(langBuffer, "%s%hs", langMenuZoomNormal(), "      \tAlt+F10");
    AppendMenu(hMenu, MF_STRING | (pProperties->video.size == P_VIDEO_SIZEX1 ? MFS_CHECKED : 0), ID_SIZE_NORMAL, langBuffer);

    _stprintf(langBuffer, "%s%hs", langMenuZoomDouble(), "\tAlt+F11");
    AppendMenu(hMenu, MF_STRING | (pProperties->video.size == P_VIDEO_SIZEX2 ? MFS_CHECKED : 0), ID_SIZE_X2, langBuffer);

    _stprintf(langBuffer, "%s%hs", langMenuZoomFullscreen(), "\tAlt+F12");
    AppendMenu(hMenu, MF_STRING | (pProperties->video.size == P_VIDEO_SIZEFULLSCREEN ? MFS_CHECKED : 0), ID_SIZE_FULLSCREEN, langBuffer);

    return hMenu;
}

HMENU menuCreateOptions(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();

    _stprintf(langBuffer, "%s", langMenuPropsEmulation());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_EMULATION, langBuffer);

    _stprintf(langBuffer, "%s", langMenuPropsVideo());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_VIDEO, langBuffer);

    _stprintf(langBuffer, "%s", langMenuPropsSound());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_AUDIO, langBuffer);

    _stprintf(langBuffer, "%s", langMenuPropsControls());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_CONTROLS, langBuffer);

    _stprintf(langBuffer, "%s", langMenuPropsPerformance());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_PERFORMANCE, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuPropsLanguage());
    AppendMenu(hMenu, MF_STRING, ID_OPTIONS_LANGUAGE, langBuffer);

    return hMenu;
}

HMENU menuCreateHelp(Properties* pProperties) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();

    _stprintf(langBuffer, "%s", langMenuHelpHelp());
    AppendMenu(hMenu, MF_STRING, ID_HELP_HELP, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s", langMenuHelpAbout());
    AppendMenu(hMenu, MF_STRING, ID_HELP_ABOUT, langBuffer);

    return hMenu;
}

HMENU menuCreateFile(Properties* pProperties, int isStopped, int logSound, int tempStateExits) {
    HMENU hMenu = CreatePopupMenu();
    _TCHAR menuBuffer[512];

    _stprintf(menuBuffer, "%s", langMenuFileCart1());
    AppendMenu(hMenu, MF_POPUP,     (UINT)menuCreateCartA(pProperties), menuBuffer);

    _stprintf(menuBuffer, "%s", langMenuFileCart2());
    AppendMenu(hMenu, MF_POPUP,     (UINT)menuCreateCartB(pProperties), menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(menuBuffer, "%s", langMenuFileDiskA());
    AppendMenu(hMenu, MF_POPUP,     (UINT)menuCreateDiskA(pProperties), menuBuffer);

    _stprintf(menuBuffer, "%s", langMenuFileDiskB());
    AppendMenu(hMenu, MF_POPUP,     (UINT)menuCreateDiskB(pProperties), menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(menuBuffer, "%s", langMenuFileCas());
    AppendMenu(hMenu, MF_POPUP,     (UINT)menuCreateCassette(pProperties), menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(menuBuffer, "%s%hs", langMenuFileLoadState(), "\tAlt+F7");
    AppendMenu(hMenu, MF_STRING, ID_FILE_LOAD, menuBuffer);

    _stprintf(menuBuffer, "%s%hs", langMenuFileSaveState(), "\tAlt+F8");
    AppendMenu(hMenu, MF_STRING | (!isStopped ? 0 : MF_GRAYED), ID_FILE_SAVE, menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(menuBuffer, "%s%hs", langMenuFileQLoadState(), "\tF7");
    AppendMenu(hMenu, MF_STRING | (tempStateExits ? 0 : MF_GRAYED), ID_FILE_QLOAD, menuBuffer);

    _stprintf(menuBuffer, "%s%hs", langMenuFileQSaveState(), "\tF8");
    AppendMenu(hMenu, MF_STRING | (!isStopped ? 0 : MF_GRAYED), ID_FILE_QSAVE, menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(menuBuffer, "%s%hs", langMenuFileCaptureAudio(), "        \tF6");
    AppendMenu(hMenu, MF_STRING | (logSound ? MFS_CHECKED : 0), ID_LOG_WAV, menuBuffer);

    _stprintf(menuBuffer, "%s%hs", langMenuFileScreenShot(), "\tPrtSc");
    AppendMenu(hMenu, MF_STRING, ID_PRT_SCR, menuBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);  

    _stprintf(menuBuffer, "%s%hs", langMenuFileExit(), "\tCtrl+Pause");
    AppendMenu(hMenu, MF_STRING, ID_FILE_EXIT, menuBuffer);

    return hMenu;
}

HMENU menuCreateRun(Properties* pProperties, int isRunning, int isStopped) {
    _TCHAR langBuffer[560];
    HMENU hMenu = CreatePopupMenu();

    if (isRunning) {
        _stprintf(langBuffer, "%s%hs", langMenuRunRun(), "\tF9");
        AppendMenu(hMenu, MF_STRING, ID_RUN_RUN, langBuffer);
    }
    else {
        _stprintf(langBuffer, "%s%hs", langMenuRunPause(), "\tF9");
        AppendMenu(hMenu, MF_STRING, ID_RUN_RUN, langBuffer);
    }

    _stprintf(langBuffer, "%s%hs", langMenuRunStop(), "\tF10");
    AppendMenu(hMenu, MF_STRING | (!isStopped ? 0 : MF_GRAYED), ID_RUN_STOP, langBuffer);

    AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);

    _stprintf(langBuffer, "%s%hs", langMenuRunHardReset(), "\tF12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_RESET, langBuffer);

    _stprintf(langBuffer, "%s%hs", langMenuRunSoftReset(), "        \tCtrl+F12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_SOFTRESET, langBuffer);

    _stprintf(langBuffer, "%s%hs", langMenuRunCleanReset(), "        \tCtrl+Alt+F12");
    AppendMenu(hMenu, MF_STRING, ID_RUN_CLEANRESET, langBuffer);

    return hMenu;
}


HMENU menuCreate(Properties* pProperties, int isRunning, int isStopped, int logSound, int tempStateExits) {
    HMENU hMenu = CreateMenu();

    /* Main menu */
    AppendMenu(hMenu, MF_POPUP, (UINT)menuCreateFile(pProperties, isStopped, logSound, tempStateExits), langMenuFile());
    AppendMenu(hMenu, MF_POPUP, (UINT)menuCreateRun(pProperties, isRunning, isStopped), langMenuRun());
    AppendMenu(hMenu, MF_POPUP, (UINT)menuCreateZoom(pProperties), langMenuWindow());
    AppendMenu(hMenu, MF_POPUP, (UINT)menuCreateOptions(pProperties), langMenuOptions());
    AppendMenu(hMenu, MF_POPUP, (UINT)menuCreateHelp(pProperties), langMenuHelp());

    return hMenu;
}

int menuShow(HWND hwnd, 
             Properties* pProperties, 
             int isRunning, 
             int isStopped, 
             int logSound,
             int tempStateExits,
             int show) 
{
    HMENU hMenu = GetMenu(hwnd);

    if (hMenu != NULL) {
        DestroyMenu(hMenu);
    }

    if (show) {
        hMenu = menuCreate(pProperties, isRunning, isStopped, logSound, tempStateExits);

        SetMenu(hwnd, hMenu);
    }
    else {
        SetMenu(hwnd, NULL);
    }

    return GetMenu(hwnd) == NULL ? 0 : 1;
}

