/*****************************************************************************
** File:        Win32FileHistory.c
**
** Author:      Daniel Vik
**
** Description: Methods manage the file history.
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
******************************************************************************
*/
#include <stdio.h>
#include <windows.h>
#include "Win32FileHistory.h"
#include "Win32Properties.h"
 

char* stripPath(char* filename) {
    char* ptr = filename + strlen(filename) - 1;

    while (--ptr >= filename) {
        if (*ptr == '/' || *ptr == '\\') {
            return ptr + 1;
        }
    }

    return filename;
}

void updateFileHistory(char* history, char* filename) {
    char fname[MAX_PATH];
    int i = 0;

    strcpy(fname, filename);

    for (i = 0; i < MAX_HISTORY - 1; i++) {
        if (*(history + MAX_PATH * i) == 0 || 0 == strcmp(history + MAX_PATH * i, fname)) {
            break;
        }
    }
    while (i > 0) {
        strcpy(history + MAX_PATH * i, history + MAX_PATH * (i - 1));
        i--;
    }
    strcpy(history, fname);
}

void verifyFileHistory(char* history) {
    int i, j;

    for (i = 0; i < MAX_HISTORY; i++) {
        char *fname = history + MAX_PATH * i;
        if (fname[0] != '\0' && strcmp(fname, CARTNAME_SCCPLUS) && strcmp(fname, CARTNAME_FMPAC)) {
            FILE* file = fopen(fname, "r");
            if (file != NULL) {
                fclose(file);
            }

            else {
                for (j = i + 1; j < MAX_HISTORY; j++) {
                    strcpy(history + MAX_PATH * (j - 1), history + MAX_PATH * j);
                    *(history + MAX_PATH * j) = 0;
                }
                i--;
            }
        }
    }
}
