/*****************************************************************************
** File:        ym2413.c
**
** Author:      Daniel Vik
**
** Description: Emulation of the YM2413 sound chip
**
******************************************************************************
*/
#ifndef YM2413_H
#define YM2413_H

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct YM_2413 YM_2413;

/* Constructor and destructor */
YM_2413* ym2413Create(Mixer* mixer, UInt32 cpuClock);
void ym2413Destroy(YM_2413* ym2413);

/* Register read/write methods */
void ym2413WriteAddress(YM_2413* ym2413, UInt8 address);
void ym2413WriteData(YM_2413* ym2413, UInt8 data, UInt32 cpuClock);

/* Misc methods */
int ym2413LoadState(YM_2413* ym2413, FILE* file, UInt32 cpuClock);
int ym2413SaveState(YM_2413* ym2413, FILE* file, UInt32 cpuClock);

#ifdef __cplusplus
}
#endif

#endif

