/*****************************************************************************
** File:        Y8950.h
**
** Author:      Daniel Vik
**
** Description: Emulation of the Y8950 sound chip
**
******************************************************************************
*/
#ifndef Y8950_H
#define Y8950_H

#include <stdio.h>

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct Y8950 Y8950;

/* Constructor and destructor */
Y8950* y8950Create(Mixer* mixer, UInt32 cpuClock);
void y8950Destroy(Y8950* y8950);

/* Register read/write methods */
UInt8 y8950ReadAddress(Y8950* y8950);
UInt8 y8950ReadData(Y8950* y8950);

void y8950WriteAddress(Y8950* y8950, UInt8 address);
void y8950WriteData(Y8950* y8950, UInt8 data, UInt32 cpuClock);

/* Misc methods */
int y8950LoadState(Y8950* y8950, FILE* file, UInt32 cpuClock);
int y8950SaveState(Y8950* y8950, FILE* file, UInt32 cpuClock);

#endif
