/*****************************************************************************
** File:
**      scc.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of the Konami SCC sound chip.
**
******************************************************************************
*/
#ifndef SCC_H
#define SCC_H

#include <stdio.h>

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct SCC SCC;

/* Constructor and destructor */
SCC* sccCreate(Mixer* mixer, UInt32 cpuClock);
void sccDestroy(SCC* scc);
void sccReset(SCC* scc);

/* Register read/write methods */
UInt8 sccRead(SCC* scc, UInt8 address);
UInt8 sccPlusRead(SCC* scc, UInt8 address);
void sccWrite(SCC* scc, UInt8 address, UInt8 value, UInt32 cpuClock);
void sccPlusWrite(SCC* scc, UInt8 address, UInt8 value, UInt32 cpuClock);

/* The following method are to minimize updates of MSX.c */
int sccLoadState(SCC* scc, FILE* file, UInt32 cpuClock);
int sccSaveState(SCC* scc, FILE* file, UInt32 cpuClock);

#endif

