#include "Win32ScreenShot.h"
#include <stdio.h>
#include <direct.h>

static int ttshots = 0;
static char baseDir[512];

static HRESULT SaveBitmap(char *strFileName, PBITMAPINFO pbi, HBITMAP hBMP, HDC hDC)
{
    HRESULT             hr = E_FAIL;
    HANDLE              hf;         // file handle
    BITMAPFILEHEADER    hdr;        // bitmap file-header
    PBITMAPINFOHEADER   pbih;       // bitmap info-header
    LPBYTE              lpBits;     // memorypointer
    DWORD               dwTotal;    // total count of bytes
    DWORD               cb;         // incremental count of bytes
    BYTE                *hp;        // byte pointer
    DWORD               dwTmp;      // temp-variable


    if( pbi == NULL ){
        return E_FAIL;
    }
 
    pbih    = ( PBITMAPINFOHEADER ) pbi;
    lpBits  = ( LPBYTE ) GlobalAlloc( GMEM_FIXED, pbih->biSizeImage );

    if( !lpBits ){
        return E_FAIL;
    }


    //
    // Retrieve the colortable ( RGBQUAD-array ) and the bits
    // ( array of palette indices ) from the DIB.
    //
    if( !GetDIBits( hDC, hBMP, 0, ( WORD )pbih->biHeight, lpBits, pbi, DIB_RGB_COLORS ) ){
        return E_FAIL;
    }


    //
    // Create the .BMP file.
    //
    hf = CreateFile( strFileName, GENERIC_READ|GENERIC_WRITE, ( DWORD ) 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, ( HANDLE ) NULL );

    if( hf == INVALID_HANDLE_VALUE ){
        return E_FAIL;
    }

    hdr.bfType = 0x4D42;    // 0x42 = "B", 0x4D = "M"


    //
    // Compute the size of the entire file
    //
    hdr.bfSize = ( DWORD )( sizeof( BITMAPFILEHEADER ) + pbih->biSize + pbih->biClrUsed * sizeof( RGBQUAD ) + pbih->biSizeImage );
    hdr.bfReserved1 = 0;
    hdr.bfReserved2 = 0;

    //
    // Compute the offset to the array of color indices
    //
    hdr.bfOffBits = ( DWORD ) sizeof( BITMAPFILEHEADER ) + pbih->biSize + pbih->biClrUsed * sizeof( RGBQUAD );


    //
    // Copy the BITMAPFILEHEADER into the .BMP file
    //
    if( !WriteFile( hf, ( LPVOID ) &hdr, sizeof( BITMAPFILEHEADER ), ( LPDWORD ) &dwTmp, NULL ) ){
        return E_FAIL;
    }


    //
    // Copy the BITMAPINFOHEADER and RGBQUAD array into the file
    //
    if( !WriteFile( hf, ( LPVOID ) pbih, sizeof( BITMAPINFOHEADER ) + pbih->biClrUsed * sizeof( RGBQUAD ), ( LPDWORD ) &dwTmp, ( NULL ) ) ){
        return E_FAIL;
    }


    //
    // Copy the array of color indices into the .BMP file
    //
    dwTotal = cb = pbih->biSizeImage;
    hp      = lpBits;

    if( !WriteFile( hf, ( LPSTR ) hp, ( int ) cb, ( LPDWORD ) &dwTmp, NULL ) ){
        return E_FAIL;
    }


    //
    // Now close the .BMP file
    //
    if( !CloseHandle( hf ) ){
        return E_FAIL;
    }


    //
    // Free the memory reserved
    //
    GlobalFree( ( HGLOBAL ) lpBits );


    return S_OK;
}

static PBITMAPINFO CreateBitmapInfoStructure(HBITMAP hBmp)
{
    BITMAP      bmp;
    PBITMAPINFO pbmi;
    WORD        cClrBits;


    //
    // Get the width, height and the colordepth of the image
    //
    if( !GetObject( hBmp, sizeof( BITMAP ), (LPSTR)&bmp ) ){
        return NULL;
    }


    //
    // Convert the color format to a count of bits
    //
    cClrBits = 24;


    //
    // Allocate memory for the BITMAPINFO-structure. This structure
    // contains a BITMAPINFOHEADER-structure and an array of RGBQUAD
    // datastructures.
    //
    if( cClrBits < 24 )
        pbmi = ( PBITMAPINFO ) LocalAlloc( LPTR, sizeof( BITMAPINFOHEADER ) + sizeof( RGBQUAD ) * ( 1 << cClrBits ) );
    else
        pbmi = ( PBITMAPINFO ) LocalAlloc( LPTR, sizeof( BITMAPINFOHEADER ) );

    //
    // Initialize the fields in the BITMAPINFO-structure.
    //
    pbmi->bmiHeader.biSize      = sizeof( BITMAPINFOHEADER );
    pbmi->bmiHeader.biWidth     = bmp.bmWidth;
    pbmi->bmiHeader.biHeight    = bmp.bmHeight;
    pbmi->bmiHeader.biPlanes    = bmp.bmPlanes;
    pbmi->bmiHeader.biBitCount  = cClrBits;//bmp.bmBitsPixel;

    if( cClrBits < 24 )
        pbmi->bmiHeader.biClrUsed = ( 1 << cClrBits );

    //
    // If the bitmap isn't compressed, set the BI_RGB flag
    //
    pbmi->bmiHeader.biCompression   = BI_RGB;

    //
    // Compute the number of bytes in the array of color indices
    // and store the result in biSizeImage.
    //
    pbmi->bmiHeader.biSizeImage     = ( pbmi->bmiHeader.biWidth + 7 ) / 8 * pbmi->bmiHeader.biHeight * cClrBits;

    //
    // Set biClrImportant to 0 to indicate that all of the device
    // colors are important.
    //
    pbmi->bmiHeader.biClrImportant  = 0;

    //
    // And finally return the info-structure.
    //
    return pbmi;
}

void ScreenShot(HWND hwnd, int width, int height, int yOffset)
{
    HDC hdcScreen;
    HDC hdcCompatible;
    HBITMAP  hbmScreen;
    PBITMAPINFO pbi;
    char fname[512];

    hdcScreen=GetDC(hwnd);
    if (hdcScreen==NULL)
    {
       MessageBox(NULL,"No hDC found!","",MB_OK);
       return;
    }
    hdcCompatible = CreateCompatibleDC(hdcScreen);
    if (hdcCompatible==NULL)
    {
       MessageBox(NULL,"Error creating Compatible DC","",MB_OK);
       return;
    }
    
    hbmScreen = CreateCompatibleBitmap(hdcScreen, width, height);
    if (hbmScreen==NULL)
    {
       MessageBox(NULL,"Error creating Compatible Bitmap","",MB_OK);
       return;
    }

    SelectObject(hdcCompatible, hbmScreen);
    BitBlt(hdcCompatible, 0, 0, width, height, hdcScreen, 0, yOffset, SRCCOPY);

    ttshots++; if (ttshots>9999) ttshots=1;
    sprintf(fname,"%s\\msx%04i.bmp",baseDir,ttshots);
    pbi = CreateBitmapInfoStructure(hbmScreen);
    if (SaveBitmap(fname, pbi, hbmScreen, hdcCompatible)==E_FAIL) {
        MessageBox(NULL,"Error saving bitmap!","",MB_OK);
    }
    if (pbi != NULL) {
        LocalFree(pbi);
    }

    ReleaseDC(hwnd,hdcScreen);
}

void InitScreenShot(char* directory) 
{
    WIN32_FIND_DATA FileData;
    HANDLE hFile;
    char lastfile[512];
    char filename[512];
    char filenum[32];

    // save directory
    strcpy(baseDir, directory);

    // screenshot ammount
    ttshots=0;

    mkdir(baseDir);

    sprintf(filename, "%s\\msx????.bmp", baseDir);

    hFile = FindFirstFile(filename,&FileData);
    if (hFile==INVALID_HANDLE_VALUE) 
    {
       ttshots=0;
    } 
    else 
    {
        strcpy(lastfile,FileData.cFileName);
        while (FindNextFile(hFile, &FileData )!=0)
        {
           strcpy(lastfile,FileData.cFileName);
        }
        // now make some sense out of it
        filenum[0]=lastfile[4];
        filenum[1]=lastfile[5];
        filenum[2]=lastfile[6];
        filenum[3]=lastfile[7];
        filenum[4]='\0';
        ttshots=atoi(filenum);
    }
}

