/*****************************************************************************
** File:
**      Win32Menu.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Methods to show create menus.
**
******************************************************************************
*/
#ifndef WIN32_MENU_H
#define WIN32_MENU_H

#include <windows.h>
#include "Win32Properties.h"

HMENU menuCreate(Properties* pProperties, 
                 int isRunning, 
                 int isStopped,
                 int logSound,
                 int tempStateExits);

int menuShow(HWND hwnd, 
             Properties* pProperties, 
             int isRunning, 
             int isStopped, 
             int logSound,
             int tempStateExits,
             int show);


HMENU menuCreateReset(Properties* pProperties);
HMENU menuCreateCartA(Properties* pProperties);
HMENU menuCreateCartB(Properties* pProperties);
HMENU menuCreateRun(Properties* pProperties, int isRunning, int isStopped);
HMENU menuCreateDiskA(Properties* pProperties);
HMENU menuCreateDiskB(Properties* pProperties);
HMENU menuCreateCassette(Properties* pProperties);
HMENU menuCreateZoom(Properties* pProperties);
HMENU menuCreateOptions(Properties* pProperties);
HMENU menuCreateHelp(Properties* pProperties);
HMENU menuCreateFile(Properties* pProperties, int isStopped, int logSound, int tempStateExits);

#endif
