/*****************************************************************************
** File:
**      Win32directXSound.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Direct X sound driver
**
******************************************************************************
*/
#ifndef WIN32_DIRECTX_SOUND
#define WIN32_DIRECTX_SOUND

#include <windows.h>
#include "msxTypes.h"
#include "audioMixer.h"

typedef struct DxSound DxSound;

DxSound* dxSoundCreate(HWND hwnd, Mixer* mixer, UInt32 sampleRate, UInt32 bufferSize, Int16 channels);
void dxSoundDestroy(DxSound* dxSound);
void dxSoundSuspend(DxSound* dxSound);
void dxSoundResume(DxSound* dxSound);

#endif //WIN32_DIRECTX_SOUND
