#ifndef LANGUAGE_H
#define LANGUAGE_H

#include <xtl.h>
#include <tchar.h>

typedef enum { 
    EMU_LANG_ENGLISH    = 0, 
    EMU_LANG_SWEDISH    = 1, 
    EMU_LANG_JAPANESE   = 2, 
    EMU_LANG_PORTUGUESE = 3, 
    EMU_LANG_FRENCH     = 4, 
    EMU_LANG_DUTCH      = 5,
    EMU_LANG_SPANISH    = 6,
    EMU_LANG_COUNT      = 7,
    EMU_LANG_UNKNOWN    = -1 
} EmuLanguageType;

void langInit();

int langSetLanguage(EmuLanguageType languageType);
int langShowDlg(HWND hwnd, int oldLanguage);
EmuLanguageType langFromName(_TCHAR* name);

_TCHAR* langStatusBarStopped();
_TCHAR* langStatusBarPaused();
_TCHAR* langStatusBarRunning();

_TCHAR* langMenuHardReset();
_TCHAR* langMenuSoftReset();

_TCHAR* langMenuCartInsert();
_TCHAR* langMenuCartRemove();
_TCHAR* langMenuCartAutoReset();
_TCHAR* langMenuCartNoRecentFiles();
_TCHAR* langMenuCartSCCPlus();
_TCHAR* langMenuCartFMPac();
_TCHAR* langMenuCartSpecial();

_TCHAR* langMenuDiskInsert();
_TCHAR* langMenuDiskEject();
_TCHAR* langMenuDiskAutoStart();
_TCHAR* langMenuDiskNoRecentFiles();

_TCHAR* langMenuCasInsert();
_TCHAR* langMenuCasEject();
_TCHAR* langMenuCasSetPosition();
_TCHAR* langMenuCasRewind();
_TCHAR* langMenuCasNoRecentFiles();

_TCHAR* langMenuZoomNormal();
_TCHAR* langMenuZoomDouble();
_TCHAR* langMenuZoomFullscreen();

_TCHAR* langMenuPropsEmulation();
_TCHAR* langMenuPropsVideo();
_TCHAR* langMenuPropsSound();
_TCHAR* langMenuPropsControls();
_TCHAR* langMenuPropsPerformance();
_TCHAR* langMenuPropsLanguage();

_TCHAR* langMenuHelpHelp();
_TCHAR* langMenuHelpAbout();

_TCHAR* langMenuFileCart1();
_TCHAR* langMenuFileCart2();
_TCHAR* langMenuFileDiskA();
_TCHAR* langMenuFileDiskB();
_TCHAR* langMenuFileCas();
_TCHAR* langMenuFileLoadState();
_TCHAR* langMenuFileSaveState();
_TCHAR* langMenuFileQLoadState();
_TCHAR* langMenuFileQSaveState();
_TCHAR* langMenuFileCaptureAudio();
_TCHAR* langMenuFileScreenShot();
_TCHAR* langMenuFileExit();

_TCHAR* langMenuRunRun();
_TCHAR* langMenuRunPause();
_TCHAR* langMenuRunStop();
_TCHAR* langMenuRunSoftReset();
_TCHAR* langMenuRunHardReset();
_TCHAR* langMenuRunCleanReset();

_TCHAR* langMenuFile();
_TCHAR* langMenuRun();
_TCHAR* langMenuWindow();
_TCHAR* langMenuOptions();
_TCHAR* langMenuHelp();

_TCHAR* langErrorTitle();
_TCHAR* langErrorEnterFullscreen();
_TCHAR* langErrorDirectXFailed();
_TCHAR* langErrorNoRomInZip();
_TCHAR* langErrorNoDskInZip();
_TCHAR* langErrorNoCasInZip();
_TCHAR* langErrorNoHelp();
_TCHAR* langErrorStartEmu();

_TCHAR* langTooltipReset();
_TCHAR* langTooltipCart1();
_TCHAR* langTooltipCart2();
_TCHAR* langTooltipDiskA();
_TCHAR* langTooltipDiskB();
_TCHAR* langTooltipCas();
_TCHAR* langTooltipStart();
_TCHAR* langTooltipResume();
_TCHAR* langTooltipPause();
_TCHAR* langTooltipWindowSize();
_TCHAR* langTooltipProperties();
_TCHAR* langTooltipHelp();

_TCHAR* langDlgMainWindow();
_TCHAR* langDlgLoadRom();
_TCHAR* langDlgLoadDsk();
_TCHAR* langDlgLoadCas();
_TCHAR* langDlgLoadRomDskCas();
_TCHAR* langDlgLoadRomDesc();
_TCHAR* langDlgLoadDskDesc();
_TCHAR* langDlgLoadCasDesc();
_TCHAR* langDlgLoadRomDskCasDesc();
_TCHAR* langDlgLoadState();
_TCHAR* langDlgSaveState();
_TCHAR* langDlgInsertRom1();
_TCHAR* langDlgInsertRom2();
_TCHAR* langDlgInsertDiskA();
_TCHAR* langDlgInsertDiskB();
_TCHAR* langDlgInsertCas();

_TCHAR* langDlgOK();
_TCHAR* langDlgCancel();

_TCHAR* langDlgTapeTitle();
_TCHAR* langDlgTapeFrameText();
_TCHAR* langDlgTapeCurrentPos();
_TCHAR* langDlgTapeTotalTime();
_TCHAR* langDlgZipReset();

_TCHAR* langDlgAboutTitle();

_TCHAR* langDlgJoyTitle1();
_TCHAR* langDlgJoyTitle2();
_TCHAR* langDlgJoyUpText();
_TCHAR* langDlgJoyDownText();
_TCHAR* langDlgJoyLeftText();
_TCHAR* langDlgJoyRightText();
_TCHAR* langDlgJoyButton1Text();
_TCHAR* langDlgJoyButton2Text();
_TCHAR* langDlgJoyGB();

_TCHAR* langDlgLangLangText();
_TCHAR* langDlgLangTitle();

_TCHAR* langPropTitle();
_TCHAR* langPropEmulation();
_TCHAR* langPropVideo();
_TCHAR* langPropSound();
_TCHAR* langPropControls();
_TCHAR* langPropPerformance();

_TCHAR* langPropEmuGeneralGB();
_TCHAR* langPropEmuFamilyText();
_TCHAR* langPropEmuMemoryGB();
_TCHAR* langPropEmuRamSizeText();
_TCHAR* langPropEmuVramSizeText();
_TCHAR* langPropEmuSpeedGB();

_TCHAR* langPropMonMonGB();
_TCHAR* langPropMonTypeText();
_TCHAR* langPropMonEmuText();
_TCHAR* langPropVideoYypeText();
_TCHAR* langPropWindowSizeText();

_TCHAR* langPropPerfVideoDrvGB();
_TCHAR* langPropPerfVideoDispDrvText();
_TCHAR* langPropPerfFrameSkipText();
_TCHAR* langPropPerfAudioDrvGB();
_TCHAR* langPropPerfAudioDrvText();
_TCHAR* langPropPerfAudioBufSzText();
_TCHAR* langPropPerfEmuGB();
_TCHAR* langPropPerfSyncModeText();

_TCHAR* langPropSndChipEmuGB();
_TCHAR* langPropSndMixerGB();
_TCHAR* langPropSndMonoText();
_TCHAR* langPropSndStereoText();
_TCHAR* langPropSndMsxMusicText();
_TCHAR* langPropSndMsxAudioText();
_TCHAR* langPropSndMasterText();

_TCHAR* langPropJoyPort1GB();
_TCHAR* langPropJoyPort2GB();
_TCHAR* langPropJoyAutofireText();
_TCHAR* langPropJoyKeysetGB();
_TCHAR* langPropJoyKeyest1();
_TCHAR* langPropJoyKeyest2();

_TCHAR* langEnumVideoMonColor();
_TCHAR* langEnumVideoMonGrey();
_TCHAR* langEnumVideoMonGreen();

_TCHAR* langEnumVideoTypePAL();
_TCHAR* langEnumVideoTypeNTSC();

_TCHAR* langEnumVideoEmuNone();
_TCHAR* langEnumVideoEmuYc();
_TCHAR* langEnumVideoEmuYcBlur();
_TCHAR* langEnumVideoEmuComp();
_TCHAR* langEnumVideoEmuCompBlur();
_TCHAR* langEnumVideoEmuScale2x();

_TCHAR* langEnumVideoSize1x();
_TCHAR* langEnumVideoSize2x();
_TCHAR* langEnumVideoSizeFullscreen();

_TCHAR* langEnumVideoDrvDirectDraw();
_TCHAR* langEnumVideoDrvGDI();

_TCHAR* langEnumVideoFrameskip0();
_TCHAR* langEnumVideoFrameskip1();
_TCHAR* langEnumVideoFrameskip2();
_TCHAR* langEnumVideoFrameskip3();
_TCHAR* langEnumVideoFrameskip4();
_TCHAR* langEnumVideoFrameskip5();

_TCHAR* langEnumSoundDrvNone();
_TCHAR* langEnumSoundDrvWMM();
_TCHAR* langEnumSoundDrvDirectX();

_TCHAR* langEnumEmuSync1ms();
_TCHAR* langEnumEmuSyncAuto();

_TCHAR* langEnumControlsJoyNone();
_TCHAR* langEnumControlsJoyNumpad();
_TCHAR* langEnumControlsJoyKeysetA();
_TCHAR* langEnumControlsJoyKeysetB();
_TCHAR* langEnumControlsJoyPCjoy1();
_TCHAR* langEnumControlsJoyPCjoy2();
_TCHAR* langEnumControlsJoyMouse();

_TCHAR* langEnumControlsAfOff();
_TCHAR* langEnumControlsAfSlow();
_TCHAR* langEnumControlsAfMedium();
_TCHAR* langEnumControlsAfFast();

_TCHAR* langDlgAboutAbout();
_TCHAR* langDlgAboutVersion();
_TCHAR* langDlgAboutBuildNumber();
_TCHAR* langDlgAboutBuildDate();
_TCHAR* langDlgAboutDevel();
_TCHAR* langDlgAboutInfo();
#endif

