/** fMSX: portable MSX emulator ******************************/
/**                                                         **/
/**                           MSX.h                         **/
/**                                                         **/
/** This file contains declarations relevant to the drivers **/
/** and MSX emulation itself. See Z80.h for #defines        **/
/** related to Z80 emulation.                               **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1994-2003                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef MSX_H
#define MSX_H
 
#include "Z80.h"            /* Z80 CPU emulation             */
#include "V9938.h"          /* V9938 VDP opcode emulation    */
#include "I8255.h"          /* Intel 8255 PPI emulation      */
#include "I8251.h"          /* Intel 8251 UART emulation     */
#include "romMapper.h"
#include <stdio.h>

//#define GLOBAL_FREQ  3579545
//#define GLOBAL_BASE  0x28959becUL  
#define GLOBAL_FREQ  ((VPeriod == CPU_VPERIOD_PAL) ? 3568884 : 3570259 )
#define GLOBAL_BASE  ((VPeriod == CPU_VPERIOD_PAL) ? 0x2876AA63UL  : 0x287AA811UL  )

#define CPU_CLOCK    GLOBAL_FREQ //3570259 //3568884 //3579545       /* CPU clock frequency, Hz  */

#define HPERIOD      1368          /* HPeriod, VDP cycles      */
#define VPERIOD_PAL  (HPERIOD*313) /* PAL VPeriod, VDP ccls    */
#define VPERIOD_NTSC (HPERIOD*262) /* NTSC VPeriod, VDP ccls   */ 
#define HREFRESH_240 960           /* 240dot scanline refresh  */
#define HREFRESH_256 1024          /* 256dot scanline refresh  */

#define CPU_VPERIOD_PAL  (VPERIOD_PAL/6)
#define CPU_VPERIOD_NTSC (VPERIOD_NTSC/6)
#define CPU_HPERIOD  (HPERIOD/6)
#define CPU_H240     (10+HREFRESH_240/6)
#define CPU_H256     (8+HREFRESH_256/6)

#define INT_IE0     0x01
#define INT_IE1     0x02
#define INT_IE2     0x04

#define NORAM       0xFF    /* Byte to be returned from      */
                            /* non-existing pages and ports  */


/*************************************************************/

/** Variables used to control emulator behavior **************/
extern byte MSXVersion;               /* 0=MSX,1=MSX2,2=MSX2+*/
extern byte* MSXSysRom;
extern byte* MSXSysRomExt;
extern byte* KoreaMSX1;
extern byte* KoreaMSX2;
extern char* CMOSname;
extern int enableYM2413;
extern int enableY8950;
extern int  RAMPages,VRAMPages;       /* Number of RAM pages */
extern int  VPeriod;                  /* CPU cycles / VBlank */
extern int  HPeriod;                  /* CPU cycles / HBlank */
extern byte JoyTypeA,JoyTypeB;        /* 0=No,1=Jstk,2/3=Mse */
extern RomType ROMTypeA;
extern RomType ROMTypeB;
extern char *ProgDir;                 /* Program directory   */
extern char *CartA;                   /* Cartridge A ROM file*/
extern char *CartB;                   /* Cartridge B ROM file*/
extern char *CartAZip;
extern char *CartBZip;
extern char *DiskA;                   /* Drive A disk image  */
extern char *DiskB;                   /* Drive B disk image  */
extern char *DiskAZip;
extern char *DiskBZip;
extern char *PrnName;                 /* Printer redir. file */
extern char *CasName;                 /* Tape image file     */
extern char *CasNameZip;
extern int   CasPos;
extern char *ComName;                 /* Serial redir. file  */
extern char *StateName;               /* State save name     */
extern FILE *CasStream;               /* Cassette I/O stream */




/** StartMSX() ***********************************************/
/** Allocate memory, load ROM image, initialize hardware,   **/
/** CPU and start the emulation. This function returns 0 in **/
/** the case of failure.                                    **/
/*************************************************************/
void ResetMSX(int hard);
int StartMSX(void);

/** TrashMSX() ***********************************************/
/** Free memory allocated by StartMSX().                    **/
/*************************************************************/
void TrashMSX(void);

/** SaveState() **********************************************/
/** Save emulation state to a .STA file.                    **/
/*************************************************************/
int SaveState(const char *FileName);

/** LoadState() **********************************************/
/** Load emulation state from a .STA file.                  **/
/*************************************************************/
int LoadState(const char *FileName);

void ChangeCartridge(int drive, RomType romType, char* cart, char* cartZip);


/** InitMachine() ********************************************/
/** Allocate resources needed by the machine-dependent code.**/
/************************************ TO BE WRITTEN BY USER **/
int InitMachine(void);

/** TrashMachine() *******************************************/
/** Deallocate all resources taken by InitMachine().        **/
/************************************ TO BE WRITTEN BY USER **/
void TrashMachine(void);



void SetIRQ(byte IRQ);            /* Set/Reset IRQ                   */


/* The following two methods needs target dependent implementation */
void Keyboard(byte* keybardMap);
byte Joystick(byte N);
void Mouse(int* dx, int* dy, int* buttons);
void SetCapslockLed(int enable);
void SetKanaLed(int enable);

#endif /* MSX_H */

