/*
Copyright (C) 2004 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "title.h"

int XGetCustomLaunchData();
void XReturnToLaunchingXBE( );
float xbox_screenX = 0 ;
float xbox_screenY = 0 ;
float xbox_screenMaxX = 0;
float xbox_screenMaxY = 0 ;

/**
* Displays the skill level widgets and hide the others
*/
void showSkillLevels()
{
	engine.showWidgetGroup("skill", true);
	engine.showWidgetGroup("mainMenu", false);
	engine.showWidgetGroup("gameSlots", false);

	engine.showWidget("back", true);

	engine.highlightWidget("normal");
		  
	engine.enableWidget("extreme", engine.extremeAvailable);
}

/**
* Displays the save game widgets and hide the others
*/
void showGameSlots()
{
	engine.showWidgetGroup("gameSlots", true);
	engine.showWidgetGroup("mainMenu", false);

	engine.showWidget("back", true);

	engine.highlightWidget("slot1");
}

void showSaves()
{
	engine.showWidgetGroup("saveGames", true);
	engine.showWidgetGroup("mainMenu", false);

	engine.showWidget("back", true);

	engine.highlightWidget("save1");
}

/**
* Displays the manual widgets and hide the others
*/
void showManualHelp()
{
	#ifdef FRAMEWORK_SDL
	openHelpURL();
	#else
	engine.showWidgetGroup("help", true);
	engine.showWidgetGroup("mainMenu", false);
	
	engine.showWidget("back", true);

	engine.highlightWidget("back");
	#endif
}

/**
* Displays the title widgets and hide the others.
* Also disables Continue and Load Game if games are not
* available to be loaded.
*/
void showTitleWidgets()
{
	engine.showWidgetGroup("skill", false);
	engine.showWidgetGroup("saveGames", false);
	engine.showWidgetGroup("gameSlots", false);
	engine.showWidgetGroup("help", false);
	engine.showWidget("back", false);
	
	engine.showWidgetGroup("mainMenu", true);
	
	engine.highlightWidget("newGame");

	if (!engine.continueSaveSlot)
	{
		engine.enableWidget("loadGame", false);
		engine.enableWidget("continue", false);
	}
	else
	{
		engine.highlightWidget("continue");
	}
}

/**
* Creates the data labels for the save game slots
* according to the save game data available
*/
void setupSaveWidgets()
{
	char widgetName[10];
	strcpy(widgetName, "");
	
	for (int i = 0 ; i < 5 ; i++)
	{
		sprintf(widgetName, "save%d", i + 1);
		strcpy(engine.getWidgetByName(widgetName)->label, engine.saveSlot[i]);
		
		if ((strstr(engine.saveSlot[i], "Empty")) || (strstr(engine.saveSlot[i], "Corrupt")))
		{
			engine.enableWidget(widgetName, false);
		}
		
		sprintf(widgetName, "slot%d", i + 1);
		strcpy(engine.getWidgetByName(widgetName)->label, engine.saveSlot[i]);
	}
}

/**
* Loads the title widgets
*/
void loadTitleWidgets()
{
	if (!engine.loadWidgets("data/titleWidgets"))
	{
		graphics.showErrorAndExit(ERR_FILE, "data/titleWidgets");
	}

	initSaveSlots();

	setupSaveWidgets();
	
	Widget *widget = engine.getWidgetByName("labelManual");
	strcpy(widget->label, GAMEPLAYMANUAL);

	showTitleWidgets();
}

/**
* Does the main game title sequence
* @return The section to proceed to (see main.cpp)
*/
int title()
{
	audio.free();
	graphics.free();

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.delay(1000);

	newGame();

	loadTitleWidgets();

	float backAlpha = 0;
	float titleAlpha = 0;
	bool allFadedOn = false;

	graphics.quickSprite("cheatHeader", graphics.loadImage("gfx/main/cheats.png"));
	graphics.quickSprite("optionsHeader", graphics.loadImage("gfx/main/options.png"));
	graphics.quickSprite("keyHeader", graphics.loadImage("gfx/main/keyConfig.png"));
	graphics.quickSprite("joystickHeader", graphics.loadImage("gfx/main/joystickConfig.png"));
	graphics.quickSprite("optionsBackground", graphics.loadImage("gfx/main/optionsBackground.png"));

	SDL_Surface *prlogo = graphics.quickSprite("PRLogo", graphics.loadImage("gfx/main/prlogo.gif"));
	SDL_Surface *title = graphics.quickSprite("Title", graphics.loadImage("gfx/main/title.png"));
	
	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	graphics.setFontSize(3);
	SDL_Surface *presents = graphics.quickSprite("Presents", graphics.getString("Presents", true));
	SDL_Surface *sdl = graphics.quickSprite("SDL", graphics.getString("An SDL Game", true));

	graphics.setFontSize(2);
	SDL_Surface *subTitle = graphics.quickSprite("SubTitle", graphics.getString("Blob Wars : Episode I", true));

	graphics.setFontSize(0);
	SDL_Surface *copyright = graphics.quickSprite("Copyright", graphics.getString("Copyright (C) 2004, 2005 Parallel Realities", true));

	char v[50];
	sprintf(v, "Version %.2f", VERSION);
	SDL_Surface *version = graphics.quickSprite("Version", graphics.getString(v, true));

	SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, 0);

	audio.loadMusic("music/helmet-shake.mod");

	graphics.loadBackground("gfx/main/CircuitBoard.jpg");
	SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, 0);

	int startNewGame, options, quit, help, easy, normal, hard, extreme, back, practice;
	int load, cont, save[5], slot[6];
	int autoSaveSlot;

	startNewGame = options = quit = easy = normal = hard = extreme = back = help = practice = 0;
	load = cont = save[0] = save[1] = save[2] = save[3] = save[4] = 0;
	slot[0] = slot[1] = slot[2] = slot[3] = slot[4] = slot[5] = 0;
	autoSaveSlot = 0;

	engine.setWidgetVariable("newGame", &startNewGame);
	engine.setWidgetVariable("loadGame", &load);
	engine.setWidgetVariable("continue", &cont);
	engine.setWidgetVariable("options", &options);
	engine.setWidgetVariable("help", &help);
	engine.setWidgetVariable("quit", &quit);

	float offX = 0;

	engine.flushInput();
	engine.clearInput();

	audio.playMusic();

	Uint32 now = SDL_GetTicks();

	unsigned int frameLimit = SDL_GetTicks() + 16;

	while (true)
	{
		graphics.updateScreen();

		engine.getInput();

		if ( engine.isKey( KEY_PAUSE ) )
		{
			while ( engine.isKey( KEY_PAUSE ) )
				engine.getInput() ;

			SDL_Joystick *js;
			int value ;

			js = SDL_JoystickOpen( 0 ) ;

			while ( !engine.isKey( KEY_PAUSE ) )
			{
				graphics.updateScreen();
				engine.getInput();
				for ( int i = 0 ; (i < 4) && js ; i++ )
				{
					value = SDL_JoystickGetAxis( js, i ) ;

							if ( abs(value) > 9000 )
							{
								if ( value < 0 )
									value += 9000 ;
								else
									value -= 9000 ;

								switch ( i )
								{
									case 0 :
									{
										xbox_screenX += ( (float)value/5000.0f ) ;
										if ( xbox_screenX < 0 )
											xbox_screenX = 0 ;
										break ;
									}
									case 1 :
									{
										xbox_screenY += ( (float)value/5000.0f ) ;
										if ( xbox_screenY < 0 )
											xbox_screenY = 0 ;
										break ;
									}
									case 2 :
									{
										xbox_screenMaxX += ( (float)value/5000.0f ) ;
										//if ( xbox_screenMaxX < 0 )
											//xbox_screenMaxX = 0 ;
										break ;
									}
									case 3 :
									{
										xbox_screenMaxY += ( (float)value/5000.0f ) ;
										//if ( xbox_screenMaxY < 0 )
											//xbox_screenMaxY = 0 ;
										break ;
									}
								}
							}
				}
				SDL_XBOX_SetScreenPosition( xbox_screenX, xbox_screenY ) ;
				SDL_XBOX_SetScreenStretch( xbox_screenMaxX, xbox_screenMaxY );
			}
			while ( engine.isKey( KEY_PAUSE ) )
				engine.getInput() ;
		}

		for (int x = (int)offX ; x < 640 ; x += graphics.background->w)
		{
			for (int y = 0 ; y < 480 ; y += graphics.background->h)
			{
				graphics.blit(graphics.background, x, y, graphics.screen, false);
			}
		}

		if (!allFadedOn)
		{
			if ((SDL_GetTicks() >= now + 2000) && (SDL_GetTicks() <= now + 10000))
			{
				graphics.blit(prlogo, 320, 240, graphics.screen, true);
			}
			else if ((SDL_GetTicks() >= now + 13000) && (SDL_GetTicks() <= now + 19000))
			{
				graphics.blit(presents, 320, 240, graphics.screen, true);
			}
			else if ((SDL_GetTicks() >= now + 22000) && (SDL_GetTicks() <= now + 27000))
			{
				graphics.blit(sdl, 320, 240, graphics.screen, true);
			}

			if (engine.userAccepts())
			{
				allFadedOn = true;
				engine.flushInput();
				engine.clearInput();
				backAlpha = 255;
				titleAlpha = 255;
				SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, (int)backAlpha);
				SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, (int)titleAlpha);
			}
		}

		if ((SDL_GetTicks() >= now + 4000) || (allFadedOn))
		{
			if (backAlpha < 255)
			{
				backAlpha++;
				SDL_SetAlpha(graphics.background, SDL_SRCALPHA|SDL_RLEACCEL, (int)backAlpha);
			}
		}

		if ((SDL_GetTicks() >= now + 29000) || (allFadedOn))
		{
			if (titleAlpha < 255)
			{
				titleAlpha++;
				SDL_SetAlpha(title, SDL_SRCALPHA|SDL_RLEACCEL, (int)titleAlpha);
			}
			else
			{
				graphics.blit(subTitle, 320, 180, graphics.screen, true);
				graphics.blit(copyright, 10, 460, graphics.screen, false);
				graphics.blit(version, (630 - version->w), 460, graphics.screen, false);
				allFadedOn = true;
			}
		}

		Math::wrapFloat(&(offX -= 0.25), -graphics.background->w, 0);

		if (backAlpha > 0)
		{
			graphics.blit(title, 320, 100, graphics.screen, true);
		}

		if (allFadedOn)
		{
			drawWidgets();
			audio.playMenuSound(engine.processWidgets());
		}

		if (options)
		{
			showOptions();
			loadTitleWidgets();
			engine.setWidgetVariable("newGame", &startNewGame);
			engine.setWidgetVariable("loadGame", &load);
			engine.setWidgetVariable("continue", &cont);
			engine.setWidgetVariable("options", &options);
			engine.setWidgetVariable("help", &help);
			engine.setWidgetVariable("quit", &quit);
			options = 0;
			engine.flushInput();
		}

		if (help)
		{
			showManualHelp();
			engine.setWidgetVariable("back", &back);
			help = 0;
		}

		if (startNewGame)
		{
			showGameSlots();
			engine.setWidgetVariable("slot1", &slot[0]);
			engine.setWidgetVariable("slot2", &slot[1]);
			engine.setWidgetVariable("slot3", &slot[2]);
			engine.setWidgetVariable("slot4", &slot[3]);
			engine.setWidgetVariable("slot5", &slot[4]);
			engine.setWidgetVariable("slot6", &slot[5]);
			engine.setWidgetVariable("back", &back);
			startNewGame = 0;
		}

		for (int i = 0 ; i < 6 ; i++)
		{
			if (slot[i])
			{
				showSkillLevels();
				engine.setWidgetVariable("practice", &practice);
				engine.setWidgetVariable("easy", &easy);
				engine.setWidgetVariable("normal", &normal);
				engine.setWidgetVariable("hard", &hard);
				engine.setWidgetVariable("extreme", &extreme);
				engine.setWidgetVariable("back", &back);
				autoSaveSlot = i;
				slot[i] = 0;
			}
		}

		if (load)
		{
			showSaves();
			engine.setWidgetVariable("save1", &save[0]);
			engine.setWidgetVariable("save2", &save[1]);
			engine.setWidgetVariable("save3", &save[2]);
			engine.setWidgetVariable("save4", &save[3]);
			engine.setWidgetVariable("save5", &save[4]);
			engine.setWidgetVariable("back", &back);
			load = 0;
		}

		if (easy) {engine.skill = 0; break;}
		if (normal) {engine.skill = 1; break;}
		if (hard) {engine.skill = 2; break;}
		if (extreme) {engine.skill = 3; break;}
		if (practice) {engine.skill = -1; break;}

		if (cont) {load = engine.continueSaveSlot; break;}

		if (save[0]) {load = 1; break;}
		if (save[1]) {load = 2; break;}
		if (save[2]) {load = 3; break;}
		if (save[3]) {load = 4; break;}
		if (save[4]) {load = 5; break;}

		if (engine.keyState[SDLK_ESCAPE])
		{
			audio.playMenuSound(2);
			back = 1;
			engine.clearInput();
			engine.flushInput();
		}

		if (back)
		{
			showTitleWidgets();
			back = 0;
		}

		if (quit)
		{
			break;
		}

		while (SDL_GetTicks() < (frameLimit)){}
		frameLimit = SDL_GetTicks()  + 16;
	}

	engine.deleteWidgets();

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.updateScreen();
	audio.stopMusic();
	
	if (quit)
	{
		if (engine.useAudio)
		{
			SDL_Delay(1000);
		}
		XGetCustomLaunchData();
		XReturnToLaunchingXBE( );
		exit(0);
	}
	
	newGame();
	
	(autoSaveSlot < 5) ? game.autoSaveSlot = autoSaveSlot : game.autoSave = false;

	if (load)
	{
		loadGame(load - 1);
		
		debug(("Map Name = %s", game.mapName))
	}
		
	if (engine.skill == -1)
	{
		game.setMapName("data/practice");
		game.setStageName("Training Mission");
		engine.practice = true;
		game.skill = 1;
		return SECTION_GAME;
	}
	
	if (engine.skill == 3)
	{
		game.skill = 3;
		game.hasAquaLung = game.hasJetPack = true;
	}
	
	if (strcmp(game.mapName, "data/spaceStation") == 0)
	{
		game.setMapName("data/finalBattle");
		game.setStageName("Final Battle");
		return SECTION_GAME;
	}

	return SECTION_HUB;
}

/**
* Loads and shows the credits at the end of the game.
*/
void doCredits()
{
	map.clear();

	char *line;
	char string[100];
	int i = 0;
	int numberOfCredits = 0;
	int pos1 = 0, pos2 = 0, size = 0;
	float *y;

	SDL_Surface *backdrop = graphics.quickSprite("CreditsBackGround", graphics.loadImage("gfx/main/creditsBack.png"));

	engine.loadData("data/credits");

	line = strtok((char*)engine.dataBuffer, "\n");

	sscanf(line, "%d", &numberOfCredits);

	y = new float[numberOfCredits];
	 SDL_Surface **credit = new SDL_Surface*[numberOfCredits];

	line = strtok(NULL, "\n");

	pos1 = 520;

	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	while (line)
	{
		sscanf(line, "%d %d %[^\n\r]", &pos2, &size, string);

		pos1 += pos2;

		y[i] = pos1;

		graphics.setFontSize(size);
		credit[i] = graphics.quickSprite("credit", graphics.getString(string, true));

		i++;

		if (i == numberOfCredits)
		{
			break;
		}

		line = strtok(NULL, "\n");
	}
	
	SDL_Surface *device = graphics.quickSprite("credit", graphics.loadImage("gfx/main/creditsDevice.png"));
	float deviceY = y[numberOfCredits - 7] - 50;

	audio.loadMusic("music/autumnsDawning.s3m");
	audio.playMusic();

	engine.resetTimeDifference();

	while (y[numberOfCredits - 1] > 350)
	{
		graphics.updateScreen();
		engine.getInput();

		engine.doTimeDifference();

		SDL_FillRect(graphics.screen, NULL, graphics.black);
		graphics.blit(backdrop, 0, 365, graphics.screen, false);
		
		deviceY -= (0.25 * engine.getTimeDifference());
		
		if ((deviceY > 10) && (deviceY < 470))
		{
			graphics.blit(device, 320, (int)deviceY, graphics.screen, true);
		}

		for (i = 0 ; i < numberOfCredits ; i++)
		{
			y[i] -= (0.25 * engine.getTimeDifference());
			
			if ((y[i] > 10) && (y[i] < 470))
			{
				graphics.blit(credit[i], 320, (int)y[i], graphics.screen, true);
			}

			graphics.drawRect(0, 450, 640, 30, graphics.black, graphics.screen);
			graphics.drawRect(0, 0, 640, 30, graphics.black, graphics.screen);
		}
	}

	graphics.delay(12000);
	audio.fadeMusic();
	graphics.fadeToBlack();

	delete[] y;
	delete[] credit;
}
