/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "objectives.h"

void adjustObjectives()
{
	bool needRequired = false;

	Entity *mia = (Entity*)map.miaList.getHead();

	while (mia->next != NULL)
	{
		mia = (Entity*)mia->next;

		if (gameData.MIARescued(map.name, mia->name))
		{
			mia->health = 0;
			map.foundMIAs++;
		}
	}

	if (map.foundMIAs >= map.requiredMIAs)
	{
		map.requiredMIAs = map.totalMIAs;
		needRequired = true;
	}

	Objective *objective = (Objective*)map.objectiveList.getHead();
	Entity *item, *enemy;

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if (game.skill == 0)
			objective->required = false;

		if (game.skill >= 3)
			objective->required = true;

		if (needRequired)
			objective->required = true;

		if (gameData.objectiveCompleted(map.name, objective->description))
		{
			objective->currentValue = objective->targetValue;
			objective->completed = true;

			debug(("Objective %s has been completed\n", objective->description));

			item = (Entity*)map.itemList.getHead();
			while (item->next != NULL)
			{
				item = (Entity*)item->next;

				if (strcmp(item->name, objective->target) == 0)
				{
					item->health = 0;
					map.totalItems--;
				}
			}

			if (strcmp(objective->target, "Enemy"))
			{
				enemy = (Entity*)map.enemyList.getHead();
				while (enemy->next != NULL)
				{
					enemy = (Entity*)enemy->next;

					if (strcmp(enemy->name, objective->target) == 0)
					{
						enemy->health = 0;
					}
				}
			}
		}
	}
}

bool allObjectivesCompleted()
{
	if (map.foundMIAs < map.requiredMIAs)
		return false;

	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if ((objective->required) && (!objective->completed))
			return false;
	}

	return true;
}

bool perfectlyCompleted()
{
	if (map.foundMIAs < map.totalMIAs)
		return false;

	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if (!objective->completed)
			return false;
	}

	return true;
}

bool requiredEnemy(char *name)
{
	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if (strcmp(objective->target, name) == 0)
		{
			return true;
		}
	}

	return false;
}

bool requiredObjectivesCompleted()
{
	if (map.foundMIAs < map.requiredMIAs)
		return false;

	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if (strcmp(objective->target, "Exit") == 0)
			continue;

		if ((objective->required) && (!objective->completed))
			return false;
	}

	return true;
}

/*
Used by the skip level cheat
*/
void autoCompleteAllObjectives()
{
	map.foundMIAs = map.totalMIAs;
	map.requiredMIAs = map.totalMIAs;
	
	map.foundItems = map.totalItems;

	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;
		objective->completed = true;
		objective->currentValue = objective->targetValue;
	}

	Entity *mia = (Entity*)map.miaList.getHead();

	while (mia->next != NULL)
	{
		mia = (Entity*)mia->next;
		mia->health = 0;
	}
}

void checkObjectives(char *name, bool alwaysInform)
{
	Objective *objective = (Objective*)map.objectiveList.getHead();

	char message[100];
	
	int requiredValue;

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		if (!objective->completed)
		{
			if (strcmp(objective->target, name) == 0)
			{
				if (strstr(objective->target, "Combo-"))
				{
					objective->currentValue = game.currentComboHits;
					Math::limitInt(&objective->currentValue, 0, objective->targetValue);
				}
				else
				{
					objective->currentValue++;
				}

				requiredValue = objective->targetValue - objective->currentValue;

				if (objective->currentValue == objective->targetValue)
				{
					if (!map.isBossMission())
					{
						sprintf(message, engine.translate("%s - Objective Completed - Check Point Reached!"), objective->description);
						game.setObjectiveCheckPoint();
					}
					else
					{
						sprintf(message, engine.translate("%s - Objective Completed"), objective->description);
					}

					if (strcmp(objective->description, "Get the Aqua Lung") == 0)
					{
						sprintf(message, engine.translate("Got the Aqua Lung! You can now swim forever!"));
						game.hasAquaLung = true;
					}

					if (strcmp(objective->description, "Get the Jetpack") == 0)
					{
						sprintf(message, engine.translate("Got the Jetpack! Press SPACE to Activate!"));
						game.hasJetPack = true;
					}

					engine.setInfoMessage(message, 9, INFO_OBJECTIVE);
					objective->completed = true;
					game.totalObjectivesCompleted++;

				}
				else if (!strstr(objective->target, "Combo-"))
				{
					if ((requiredValue % 10 == 0) || (requiredValue <= 10) || (alwaysInform))
					{
						switch (rand() % 3)
						{
							case 0:
								sprintf(message, engine.translate("%s - %d more to go..."), objective->description, requiredValue);
								break;
							case 1:
								sprintf(message, engine.translate("%s - need %d more"), objective->description, requiredValue);
								break;
							case 2:
								sprintf(message, engine.translate("%s - %d of %d"), objective->description, objective->currentValue, objective->targetValue);
								break;
						}
						
						engine.setInfoMessage(message, 1, INFO_NORMAL);
					}
					else
					{
						return;
					}
				}
				else
				{
					continue;
				}
			}
		}
	}
}
