/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "loadSave.h"

void initSaveSlots()
{
	char filename[PATH_MAX];
	char string[100];
	struct stat fileInfo;
	int modTime = 0;

	Game tempGame;

	engine.continueSaveSlot = 0;

	FILE *fp;

	//READ SAVE GAME DATA
	for (int i = 0 ; i < 5 ; i++)
	{
		sprintf(filename, "%ssave%d.dat", engine.userHomeDirectory, i);

		fp = fopen(filename, "rb");

		if (!fp)
		{
			strcpy(string, engine.translate("%.2d - Empty"));
			sprintf(engine.saveSlot[i], string, (i + 1));
		}
		else
		{
			if (fread(&tempGame, sizeof(Game), 1, fp) != 1)
			{
				strcpy(string, engine.translate("%.2d - Corrupt Save Data"));
				sprintf(engine.saveSlot[i], string, (i + 1));
			}
			else
			{
				sprintf(engine.saveSlot[i], "%.2d - %s (%.2d:%.2d:%.2d)", (i + 1), tempGame.stageName, tempGame.totalHours, tempGame.totalMinutes, tempGame.totalSeconds);
			}

			if (stat(filename, &fileInfo) != -1)
			{
				if (fileInfo.st_mtime > modTime)
				{
					modTime = fileInfo.st_mtime;
					engine.continueSaveSlot = (i + 1);
				}
			}

			fclose(fp);
		}
	}
	
	debug(("Continue Save Slot = %d\n", engine.continueSaveSlot));
}

/*
Fill in later...
*/
bool loadGame(int slot)
{
	debug(("Loading Game #%d...\n", slot));
	game.clear();

	SDL_Delay(500);

	char filename[PATH_MAX];
	char string[3][100];
	bool complete;

	FILE *fp;

	sprintf(filename, "%ssave%d.dat", engine.userHomeDirectory, slot);

	fp = fopen(filename, "rb");
	if (!fp)
		return false;

	if (fread(&game, sizeof(Game), 1, fp) != 1)
	{
		fclose(fp);
		graphics.showErrorAndExit("The save data loaded was not in the format expected", "");
	}

	while (true)
	{
		if (fread(string[0], 50, 1, fp) != 1)
			break;

		fread(string[1], 50, 1, fp);
		fread(&complete, sizeof(bool), 1, fp);

		gameData.addCompletedObjective(string[0], string[1], complete);
	}

	fclose(fp);
	
	debug(("Loaded Successfully\n"));

	return true;
}

void saveGame(int slot)
{
	char message[100];

	SDL_FillRect(graphics.screen, NULL, graphics.black);
	graphics.updateScreen();
	SDL_Delay(500);

	graphics.setFontSize(1);
	sprintf(message, "Saving Game to Save Slot #%d. Please Wait...", (game.autoSaveSlot + 1));
	graphics.drawString(message, 320, 220, true, graphics.screen);
	graphics.updateScreen();

	gameData.setMIARescueCount(map.name, map.foundMIAs, map.totalMIAs);

	Objective *objective = (Objective*)map.objectiveList.getHead();
	Entity *mia = (Entity*)map.miaList.getHead();

	if (!gameData.stagePreviouslyCleared(game.stageName))
		game.stagesCleared++;

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		gameData.addCompletedObjective(map.name, objective->description, objective->completed);
	}

	bool miaFound;

	while (mia->next != NULL)
	{
		mia = (Entity*)mia->next;

		miaFound = true;

		if (mia->health > 0)
			miaFound = false;

		sprintf(message, "MIA_%s", mia->name);
		gameData.addCompletedObjective(map.name, message, miaFound);
	}

	game.totalUpStats();

	char filename[PATH_MAX];

	FILE *fp;

	sprintf(filename, "%ssave%d.dat", engine.userHomeDirectory, slot);

	fp = fopen(filename, "wb");
	if (!fp)
		graphics.showErrorAndExit("File write error whilst saving game", "");

	Data *data = (Data*)gameData.dataList.getHead();

	fwrite(&game, sizeof(Game), 1, fp);

	while (data->next != NULL)
	{
		data = (Data*)data->next;

		fwrite(data->key, 50, 1, fp);
		fwrite(data->value, 50, 1, fp);
		fwrite(&data->complete, sizeof(bool), 1, fp);
	}

	fclose(fp);
	
	map.clear();
	
	SDL_Delay(500);

	graphics.drawString("Auto Save Complete", 320, 260, true, graphics.screen);
	graphics.updateScreen();

	SDL_Delay(500);
}
