/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "headers.h"

void GameData::clear()
{
	dataList.clear();
}

void GameData::destroy()
{
	clear();
}

void GameData::addCompletedObjective(char *key, char *value, bool complete)
{
	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(key, data->key) == 0)
		{
			if (strcmp(value, data->value) == 0)
			{
				data->set(key, value, complete);
				return;
			}
		}
	}

	data = new Data();
	data->set(key, value, complete);

	dataList.add(data);
}

void GameData::setMIARescueCount(char *key, int rescues, int total)
{
	Data *data = (Data*)dataList.getHead();

	bool allRescued = false;

	char newKey[50];
	sprintf(newKey, "%s MIAs", key);

	char value[50];
	sprintf(value, "%d / %d", rescues, total);

	if (rescues == total)
		allRescued = true;

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(newKey, data->key) == 0)
		{
			strcpy(data->value, value);
			data->complete = allRescued;
			return;
		}
	}

	data = new Data();

	data->set(newKey, value, allRescued);

	dataList.add(data);
}

bool GameData::MIARescued(char *stageName, char *name)
{
	Data *data = (Data*)dataList.getHead();

	char newName[100];
	sprintf(newName, "MIA_%s", name);

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(data->key, stageName) == 0)
		{
			if (strcmp(data->value, newName) == 0)
			{
				return data->complete;
			}
		}
	}

	return false;
}

bool GameData::objectiveCompleted(char *stageName, char *name)
{
	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(data->key, stageName) == 0)
		{
			if (strcmp(data->value, name) == 0)
			{
				return data->complete;
			}
		}
	}

	return false;
}

bool GameData::stagePreviouslyCleared(char *stageName)
{
	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(data->key, stageName) == 0)
		{
			return true;
		}
	}

	return false;
}

bool GameData::isCompleted(char *key, char *value)
{
	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;
		if (strcmp(key, data->key) == 0)
		{
			if (strcmp(value, data->value) == 0)
				return true;
		}
	}

	return false;
}

bool GameData::levelPrefectlyCleared(char *level)
{
	Data *data = (Data*)dataList.getHead();
	
	bool found = false;

	while (data->next != NULL)
	{
		data = (Data*)data->next;

		if (strcmp(data->key, level) == 0)
		{
			found = true;

			if (!data->complete)
				return false;
		}
	}
	
	if (!found)
		return false;

	return true;
}

bool GameData::requiredLevelCleared(char *requiredLevel)
{
	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;

		if (strcmp(data->key, requiredLevel) == 0)
		{
			return true;
		}
	}

	return false;
}

int GameData::getPercentageComplete()
{
	float percentage, total, completed;

	total = completed = percentage = 0;

	Data *data = (Data*)dataList.getHead();

	while (data->next != NULL)
	{
		data = (Data*)data->next;

		total++;

		if (data->complete)
			completed++;
	}

	if ((total == 0) || (completed == 0))
		return 0;

	percentage = (completed / total);
	percentage *= 100;

	return (int)percentage;
}

GameData::GameData()
{
}
