
#include <iostream>
#include "Emulator.h"

#ifdef __cplusplus
extern "C" {
#endif
void sprintfx( const char *fmt, ... );

#ifdef __cplusplus
}
#endif

using namespace std;

Emulator::Emulator()
{
    videoProducer = NULL;
    processorBus.setAudioMixer(&audioMixer);
    processorBus.addProcessor(&audioMixer);
}

void Emulator::reset()
{
    processorBus.reset();
    controllerBus.reset();
}

void Emulator::setOutputSampleRate(UINT16 sampleRate)
{
    audioMixer.setClockSpeed(sampleRate);
}

void Emulator::getOutputImageSize(UINT16* width, UINT16* height)
{
    videoProducer->getOutputImageSize(width, height);
}

void Emulator::getPalette(const UINT32** palette, UINT16* numEntries)
{
    videoProducer->getPalette(palette, numEntries);
}

void Emulator::run()
{
	//sprintfx( "runstart\r\n") ;
    while (videoProducer->inVerticalBlank())
        processorBus.tick();
	//sprintfx( "runmiddle\r\n") ;
    while (!videoProducer->inVerticalBlank())
        processorBus.tick();
	//sprintfx( "runend\r\n") ;
}

void Emulator::updateControllers(InputDevice* inputDevice)
{
    controllerBus.updateControllers(inputDevice);
}

void Emulator::flushAudio(AudioOutputDevice* audioOutputDevice)
{
    audioMixer.flushAudio(audioOutputDevice);
}

void Emulator::render(VideoOutputDevice* videoOutputDevice)
{
    videoProducer->render(videoOutputDevice);
}

void Emulator::setVideoProducer(VideoProducer* vp)
{
    this->videoProducer = vp;
}

