
#include <fstream>
#include <stdio.h>
#include <string.h>
#include "CRC32.h"
#include "unzip.h"

#define CRC32_POLY 0x04C11DB7

using namespace std;

#ifndef _MAX_PATH
#define _MAX_PATH 255
#endif

UINT64 reflect(UINT64 ref, char ch)
{

      UINT64 value(0); 

      // Swap bit 0 for bit 7 
      // bit 1 for bit 6, etc. 
      for(int i = 1; i < (ch + 1); i++) 
      { 
            if(ref & 1) 
                  value |= 1 << (ch - i); 
            ref >>= 1; 
      } 
      return value; 
} 



CRC32::CRC32() {
    UINT32 i, j;
    for (i = 0; i < 256; ++i) {
        crc32_table[i]=reflect(i, 8) << 24; 
        for (j = 0; j < 8; j++) 
            crc32_table[i] = (crc32_table[i] << 1) ^
                    (crc32_table[i] & (1 << 31) ? CRC32_POLY : 0); 
        crc32_table[i] = reflect(crc32_table[i], 32); 
    }
    reset();
}
#ifdef __cplusplus
extern "C" {
#endif

void writexbox( char *msg) ;

#ifdef __cplusplus
}
#endif

UINT32 CRC32::getCrc(const CHAR* filename)
{
    CRC32 crc;
	char xmsg[100] ;

    if ( (strstr(filename, ".zip") != NULL) || (strstr(filename, ".ZIP") != NULL) )
    {
        unzFile file;

        file = unzOpen(filename);
        if(file != NULL)
        {

            
			
			char zfilename[1024];
			int filesize = 0;
			int port = unzGoToFirstFile(file);
			unz_file_info info;

			while(port == UNZ_OK)
			{
				char name[132];
				unzGetCurrentFileInfo(file, &info, name,128, NULL,0, NULL,0);

				if ((int) info.uncompressed_size > filesize)
				{
					strcpy(zfilename,name);
					filesize = info.uncompressed_size;
				}
				port = unzGoToNextFile(file);
			}

			if( !(port == UNZ_END_OF_LIST_OF_FILE || port == UNZ_OK) || filesize == 0)
			{
				unzClose(file) ;
				return  0;
			}

			//unzLocateFile(file,filename,1);
			//unzGetCurrentFileInfo(file, &info, filename,128, NULL,0, NULL,0);
			
			
            if(unzLocateFile(file, zfilename, 2) == UNZ_OK)
            {
                unsigned char next;
                unzOpenCurrentFile(file);
                while(unzReadCurrentFile(file, &next, 1) == 1)
                {
                    crc.update((UINT8)next);
                }
                unzCloseCurrentFile(file);
            }

			/*
            else if(unzLocateFile(file, name2, 2) == UNZ_OK)
            {
                int next;
                unzOpenCurrentFile(file);
                while(unzReadCurrentFile(file, &next, 1) == 1)
                {
                    crc.update((UINT8)next);
                }
                unzCloseCurrentFile(file);
            }*/
            unzClose(file);
        }
    }
    else
    {
        ifstream fileStream(filename, ios::in | ios::binary);
        int next = fileStream.get();
        while (next != EOF) {
            crc.update((UINT8)next);
            next = fileStream.get();
        }
        fileStream.close();
    }

			sprintf( xmsg, "crc=%u\r\n", crc.getValue() ) ;
			writexbox(xmsg) ;
    return crc.getValue();
}

void CRC32::formInternalFilename(CHAR* out, const CHAR* in, const CHAR* ext)
{
    strcpy(out, in);
    char *p = strstr(out, ".zip");
    *p = '\0';
    strcat(out, ext);
    p = &out[strlen((char *)out)];
    while(--p > out)
    {
        if(*p == '\\' || *p == '/')
            break;
    }
    strcpy(out, p+1);
}

void CRC32::reset() {
    crc = 0xFFFFFFFF;
}

void CRC32::update(UINT8 data) {
/*
    crc = (crc << 8) ^ crc32_table[(crc >> 24) ^ data];
*/
    crc = (crc >> 8) ^ crc32_table[(crc & 0xFF) ^ data]; 

}

void CRC32::update(UINT8* data, UINT32 length) {
    for (UINT32 i = 0; i < length; i++)
        //crc = (crc << 8) ^ crc32_table[(crc >> 24) ^ data[i]];
        crc = (crc >> 8) ^ crc32_table[(crc & 0xFF) ^ data[i]]; 
}

UINT32 CRC32::getValue() {
    return ~crc;
}

