
#ifndef MICROSEQUENCER_REGISTERS_H
#define MICROSEQUENCER_REGISTERS_H

#include "../../core/osd/types.h"
#include "../../core/Memory.h"

class MicroSequencer;

class MicroSequencer_Registers : public Memory16Bit
{

    friend class MicroSequencer;

    public:
        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        void poke(UINT16 location, UINT16 value);
        UINT16 peek(UINT16 location);

    private:
        void init(MicroSequencer* ms);
        MicroSequencer*  ms;

};

#endif
