
#ifdef _WIN32
#include <windows.h>
#include "Win32ReadDir.h"
#include <stdio.h>

Win32ReadDir::Win32ReadDir()
{
    memset(&m_Win32FindData, 0, sizeof(WIN32_FIND_DATA));
    m_Handle = NULL;
    m_files = NULL;
    m_fileCount = 0;
    m_currentFile = 0;
    m_path = NULL;
}

Win32ReadDir::Win32ReadDir(char* path)
{
    memset(&m_Win32FindData, 0, sizeof(WIN32_FIND_DATA));
    m_Handle = NULL;
    m_files = NULL;
    m_fileCount = 0;
    m_currentFile = 0;
    m_path = NULL;

    open(path);
}

Win32ReadDir::~Win32ReadDir()
{
	close();
}

void Win32ReadDir::getNext(char *nextPath)
{
	// Eliminate files that start with '.' if possible.
	// This is mostly to eliminate from the list '.' and '..'
	if(m_files[m_currentFile][0] == '.')
	{
		if(hasNext())
		{
			m_currentFile++;
            getNext(nextPath);
			return;		
		}
	}

	// prepend the directory that these files exist in.
	strcpy((char *)nextPath, m_path);
	strcat((char *)nextPath, "\\");
	strcat((char *)nextPath, m_files[m_currentFile++]);
}

int Win32ReadDir::hasNext()
{
	return(m_fileCount != -1 && (m_currentFile != m_fileCount));
}

int Win32ReadDir::open(char *path)
{
	char findpath[MAX_PATH];
	if(m_path != NULL)
	{
		free(m_path);
	}
	m_path = (char *)malloc(strlen(path)+1);
    strcpy(m_path, path);
	sprintf((char *)findpath, "%s\\*", m_path);

	// Get Count of files matching expression
	m_Handle = FindFirstFile(findpath, &m_Win32FindData);
	if(m_Handle == INVALID_HANDLE_VALUE)
	{
		m_fileCount = -1;
		return 0;
	}

	m_fileCount = 0;
	do
	{
		m_fileCount++;
	} while(FindNextFile(m_Handle, &m_Win32FindData));
	FindClose(m_Handle);

	m_files = (char **)malloc(sizeof(char *)*m_fileCount);

	m_currentFile = 0;
	// Actually handle these files now...
	m_Handle = FindFirstFile(findpath, &m_Win32FindData);
	do
	{
		m_files[m_currentFile] = (char *)malloc(strlen(m_Win32FindData.cFileName)+1);
		strcpy((char *)m_files[m_currentFile], (char *)m_Win32FindData.cFileName);
		m_currentFile++;
	} while(FindNextFile(m_Handle, &m_Win32FindData));
	FindClose(m_Handle);

	m_currentFile = 0;
	return(m_fileCount);
}

int Win32ReadDir::close()
{
	if(m_files != NULL && m_fileCount != -1)
	{
		m_fileCount--;
		while(m_fileCount)
		{
			if(m_files[m_fileCount] != NULL)
			{
				free(m_files[m_fileCount]);
			}
			m_fileCount--;
		}
		free(m_files);
		m_files = NULL;
	}
	if(m_path != NULL)
	{
		free(m_path);
		m_path = NULL;
	}
	return 0;
}

#endif
