
#ifndef GRAM_H
#define GRAM_H

#include "../core/Memory.h"

#define GRAM_SIZE 0x200

class GRAM : public Memory16Bit
{

    friend class AY38900;

    public:
        GRAM();
        void reset();
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        UINT16 peek(UINT16 location);
        void poke(UINT16 location, UINT16 value);
        void markClean();
        BOOL isDirty();
        BOOL isCardDirty(UINT16 cardLocation);

    private:
        UINT16    image[GRAM_SIZE];
        BOOL      visible;
        BOOL      dirtyCards[GRAM_SIZE>>3];
        BOOL      dirtyRAM;

        static const UINT16 locations[16];

};

#endif

