
#ifndef INTELLIVISIONCARTRIDGE_H
#define INTELLIVISIONCARTRIDGE_H

#include "../../core/Memory.h"
#include "../../core/cartridge/Cartridge.h"

class IntellivisionCartridge : public Cartridge
{

    public:
        IntellivisionCartridge(const CHAR* name, Memory16Bit** memories,
                INT32 memCount);
        IntellivisionCartridge(const CHAR* name, Memory16Bit** memories,
                INT32 memCount, BOOL requiresECS, BOOL usesIntellivoice);
        ~IntellivisionCartridge();

        UINT16 getMemoryCount();
        Memory16Bit* getMemory(UINT16 i);
        BOOL requiresECS();
        BOOL usesIntellivoice();
        static IntellivisionCartridge* loadCartridge(const CHAR* filename);

    private:
        Memory16Bit**  memories;
        UINT16         memCount;
        BOOL           ecs;
        BOOL           ivoice;

};

#endif
