#ifndef _WIN32
#include <dirent.h>
#include "UNIXReadDir.h"
#include <stdio.h>

UNIXReadDir::UNIXReadDir()
{
	m_NameList = NULL;
	m_fileCount = -1;
	m_currentFile = 0;
	m_path = NULL;
}

UNIXReadDir::UNIXReadDir(char *path)
{
	m_NameList = NULL;
	m_fileCount = -1;
	m_currentFile = 0;
	m_path = (char *)malloc(strlen(path)+1);
}

UNIXReadDir::~UNIXReadDir()
{
	close();
}

int UNIXReadDir::hasNext()
{
	return(m_fileCount != -1 && (m_currentFile != m_fileCount));
}

void UNIXReadDir::getNext(char *nextPath)
{
	// Eliminate files that start with '.' if possible.
	// This is mostly to eliminate from the list '.' and '..'
	if(m_NameList[m_currentFile]->d_name[0] == '.')
	{
		if(hasNext())
		{
			m_currentFile++;
			getNext(nextPath);		
            return;
		}
	}

	// prepend the directory that these files exist in.
	strcpy((char *)nextPath, m_path);
	strcat((char *)nextPath, "/");
	strcat((char *)nextPath, m_NameList[m_currentFile++]->d_name);
}

int UNIXReadDir::open(char *path)
{
	if(m_path != NULL)
	{
		free(m_path);
	}
	m_path = (char *)malloc(strlen(path)+1);
    strcpy(m_path, path);
	fprintf(stderr, "Searching path: %s...", m_path);
	m_fileCount = scandir(m_path, &m_NameList, 0, alphasort);
	fprintf(stderr, "found: %u entries\n", m_fileCount);
	m_currentFile = 0;
	return m_fileCount;
}

int UNIXReadDir::close()
{
	if(m_NameList != NULL && m_fileCount != -1)
	{
		m_fileCount--;
		while(m_fileCount)
		{
			if(m_NameList[m_fileCount] != NULL)
			{
				free(m_NameList[m_fileCount]);
			}
			m_fileCount--;
		}
		free(m_NameList);
		m_NameList = NULL;
	}
	if(m_path != NULL)
	{
		free(m_path);
		m_path = NULL;
	}
	return 0;
}

#endif
