
#include <stdio.h>
#include <string.h>
#include "AudioMixer.h"
#include "AudioOutputLine.h"

AudioMixer::AudioMixer()
{
    memset(lines, 0, sizeof(AudioOutputLine*) * MAX_LINES);
    lineCount = 0;
    outputSampleRate = 1;
    highQualityMixing = TRUE;

    memset(sampleBuffer, 0, sizeof(sampleBuffer));
    sampleCount = 0;

    clock = 1;
}

void AudioMixer::save(FileOutputStream* fos)
{
    for (UINT16 i = 0; i < lineCount; i++)
        fos->writeINT16(lines[i]->currentSample);
}

void AudioMixer::load(FileInputStream* fis)
{
    clock = 1;
    sampleCount = 0;
    for (UINT16 i = 0; i < lineCount; i++) {
        lines[i]->currentSample = fis->readINT16();
        lines[i]->lastWriteClockMark = 1;
        lines[i]->sampleBuffer = 0;
    }
}

void AudioMixer::createLine(AudioOutputLine** line) {
    (*line) = new AudioOutputLine(this);
}

void AudioMixer::releaseLine(AudioOutputLine** line) {
    delete (*line);
}

void AudioMixer::reset()
{
    memset(sampleBuffer, 0, sizeof(sampleBuffer));
    sampleCount = 0;

    clock = 1;
}

void AudioMixer::setClockSpeed(INT32 cs)
{
    outputSampleRate = cs;
}

INT32 AudioMixer::getClockSpeed() {
    return outputSampleRate;
}

INT32 AudioMixer::tick() {
#ifdef _TRACE_TICKS
    fprintf(stderr, "AudioMixer::tick()\n");
#endif

    INT64 totalSample = 0;	// 64?

    if (lineCount > 0) {
        //mix and flush the sample buffers
        for (INT32 i = 0; i < lineCount; i++) {
            AudioOutputLine* nextLine = lines[i];
    
            //calculate the sample for this line
            //if (highQualityMixing) {
                nextLine->sampleBuffer += nextLine->currentSample *
                        (clock - nextLine->lastWriteClockMark);
                totalSample += (INT16)(nextLine->sampleBuffer / clock);
            //}
            //else
                //totalSample += nextLine->currentSample;
    
            //clear the sample buffer for this line
            nextLine->sampleBuffer = 0;
            nextLine->lastWriteClockMark = 1;
        }
        clock = 1;

        totalSample = totalSample / lineCount;
    }

    sampleBuffer[sampleCount] = (INT16)totalSample;
    sampleCount++;

    return 1;
}

void AudioMixer::flushAudio(AudioOutputDevice* aod)
{
    aod->playSamples(sampleBuffer, sampleCount);
    sampleCount = 0;
}

