/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CHardDiskDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CHardDiskDlg.h"
#include "CMyFileDialog.h"
#include "winatari.h"
#include "graphics.h"
#include <iostream.h> 

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" 
{
#include "registry.h"
extern ULONG ulScreenMode;
extern char atari_h1_dir[];
extern char atari_h2_dir[];
extern char atari_h3_dir[];
extern char atari_h4_dir[];
extern HWND	MainhWnd;
}

// call back function 
// we only use it to set the current directory 
static int CALLBACK BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM , char* path) 
{ 
	switch (uMsg) 
	{ 
		case BFFM_INITIALIZED: 
		// Directory browser intializing - tell it where to start from 
		PostMessage (hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)path); 
		break; 
	} 
	return 0; 
} 

/////////////////////////////////////////////////////////////////////////////
// CHardDiskDlg dialog

	
CHardDiskDlg::CHardDiskDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHardDiskDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardDiskDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CHardDiskDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardDiskDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardDiskDlg, CDialog)
	//{{AFX_MSG_MAP(CHardDiskDlg)
	ON_BN_CLICKED(IDC_HD1, OnHd1)
	ON_BN_CLICKED(IDC_HD2, OnHd2)
	ON_BN_CLICKED(IDC_HD3, OnHd3)
	ON_BN_CLICKED(IDC_HD4, OnHd4)
	ON_EN_KILLFOCUS(IDC_HD2_EDIT, OnKillfocusHd2Edit)
	ON_EN_KILLFOCUS(IDC_HD1_EDIT, OnKillfocusHd1Edit)
	ON_EN_KILLFOCUS(IDC_HD3_EDIT, OnKillfocusHd3Edit)
	ON_EN_KILLFOCUS(IDC_HD4_EDIT, OnKillfocusHd4Edit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardDisk message handlers

BOOL CHardDiskDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDlgItemText( IDC_HD1_EDIT, atari_h1_dir );
	SetDlgItemText( IDC_HD2_EDIT, atari_h2_dir );
	SetDlgItemText( IDC_HD3_EDIT, atari_h3_dir );
	SetDlgItemText( IDC_HD4_EDIT, atari_h4_dir );

	memset (&bi, 0, sizeof(bi)); 

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHardDiskDlg::SetToDrive( char *drivestring , int item )
{
	if( ulScreenMode & DDRAW_FULL )
	{
		CMyFileDialog  cfdlg(TRUE, NULL, "*.*", OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_NOVALIDATE, NULL, AfxGetMainWnd() );
		
		cfdlg.m_ofn.hInstance = AfxGetInstanceHandle();
		if (IDOK==cfdlg.DoModal())
		{
			if( cfdlg.szLocalPath[0] )
			{
				SetDlgItemText( item, cfdlg.szLocalPath );
				strcpy( drivestring, cfdlg.szLocalPath );
			}
		}
	}
	else
	{
		// Initialize COM 
		CoInitialize(NULL); 

		strcpy( path, drivestring );

		// Get root point to browse from 
		// Can use NULL for all - which in effect is what we are doing here 
		LPITEMIDLIST pidlRoot = NULL; 
		SHGetSpecialFolderLocation(MainhWnd, CSIDL_DRIVES , &pidlRoot); 

		// Setup Browse parameter block 
		bi.pidlRoot = pidlRoot; 
		bi.ulFlags = BIF_RETURNONLYFSDIRS; 
		bi.lpfn = (BFFCALLBACK)BrowseCallbackProc; 
		bi.lParam = (LPARAM)path; 

		// Call browse 
		LPITEMIDLIST Selection; 
		Selection = SHBrowseForFolder(&bi); 

		// If went OK, decode return to produce the selected path 
		if (Selection != NULL) 
		{
			SHGetPathFromIDList(Selection, path); 
			SetDlgItemText( item, path );
			strcpy( drivestring, path );
		}

		// Now free up the memory allocated by the various COM 
		// objects we accessed indirectly 
		LPMALLOC lpMalloc = NULL; 
		if (!SHGetMalloc(&lpMalloc) && (NULL != lpMalloc)) 
		{ 
			if (pidlRoot) 
				lpMalloc->Free(pidlRoot); 
			if (Selection) 
				lpMalloc->Free(Selection); 
		} 
	}
}

void CHardDiskDlg::OnHd1() 
{
	SetToDrive( atari_h1_dir, IDC_HD1_EDIT );
}

void CHardDiskDlg::OnHd2() 
{
	SetToDrive( atari_h2_dir, IDC_HD2_EDIT );
}

void CHardDiskDlg::OnHd3() 
{
	SetToDrive( atari_h3_dir, IDC_HD3_EDIT );
}

void CHardDiskDlg::OnHd4() 
{
	SetToDrive( atari_h4_dir, IDC_HD4_EDIT );
}

void CHardDiskDlg::OnKillfocusHd1Edit() 
{
	GetDlgItemText( IDC_HD1_EDIT, atari_h1_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd2Edit() 
{
	GetDlgItemText( IDC_HD2_EDIT, atari_h2_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd3Edit() 
{
	GetDlgItemText( IDC_HD3_EDIT, atari_h3_dir, MAX_PATH );
}

void CHardDiskDlg::OnKillfocusHd4Edit() 
{
	GetDlgItemText( IDC_HD4_EDIT, atari_h4_dir, MAX_PATH );
}

void CHardDiskDlg::OnOK() 
{
	CDialog::OnOK();

	if( atari_h1_dir[0] == 0 )
		strcpy( atari_h1_dir, "." );
	if( atari_h2_dir[0] == 0 )
		strcpy( atari_h2_dir, "." );
	if( atari_h3_dir[0] == 0 )
		strcpy( atari_h3_dir, "." );
	if( atari_h4_dir[0] == 0 )
		strcpy( atari_h4_dir, "." );

	WriteRegString( NULL, REG_HD1, atari_h1_dir );
	WriteRegString( NULL, REG_HD2, atari_h2_dir );
	WriteRegString( NULL, REG_HD3, atari_h3_dir );
	WriteRegString( NULL, REG_HD4, atari_h4_dir );
}
