/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "windows.h"
#include "winatari.h"
#include "crtdbg.h"
#include "process.h"

#ifdef SUPPORT_UI
extern "C" {
extern void ui(unsigned char *);
extern ULONG	ulAtariState;
extern ULONG *atari_screen;
extern void Clear_Sound( BOOL bPermanent );
extern void Restart_Sound( void );
extern unsigned long hThread;
}
#endif

void Threadinterpret(void *dummy) 
{  
#ifdef SUPPORT_UI
    ui( (unsigned char *)atari_screen );
#endif
} 

BOOL	startThread( void )
{
#ifdef SUPPORT_UI
	_ASSERT( !hThread );
	if( !(ulAtariState & ATARI_RUNNING) )
		return FALSE;

	if( !hThread )
		hThread = _beginthread( Threadinterpret, 0, NULL );

	// Did it fail to spawn?
	if (!hThread)
		return FALSE;

	Clear_Sound( FALSE );
	ulAtariState |= ATARI_UI_ACTIVE;
#endif
	return TRUE;
}


void	TerminateUIThread( void )
{
#ifdef SUPPORT_UI
	if( hThread )
		hThread = 0L;
	ulAtariState &= ~ATARI_UI_ACTIVE;
#endif
}
