/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CGraphicsSmallDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Atari800Win.h"
#include "CGraphicsSmallDlg.h"
#include "winatari.h"
#include "CWarnDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C" {
#include "graphics.h"
#include "registry.h"
extern "C" ULONG	ulScreenMode;
extern "C" int Init_Graphics( void );
extern "C" ULONG	ulDontShowFlags;
extern "C" ULONG	ulModesAvail;
}
static ULONG ulNewDDrawMode;


/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg dialog


CGraphicsSmallDlg::CGraphicsSmallDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGraphicsSmallDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CGraphicsSmallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGraphicsSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsSmallDlg)
	ON_BN_CLICKED(IDC_NODDRAW_SMALL, OnNoddrawSmall)
	ON_CBN_SELCHANGE(IDC_GRAPHICS_COMBO_SMALL, OnSelchangeGraphicsComboSmall)
	ON_BN_CLICKED(IDC_FORCE_VSYNC_SMALL, OnForceVsyncSmall)
	ON_BN_CLICKED(IDC_SMALL_LOCALMEM, OnSmallLocalmem)
	ON_COMMAND(ID_OPTIONS_ARTIF, OnOptionsArtif)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg message handlers

void CGraphicsSmallDlg::SetDlgState( void )
{
	int iSelect = 0;
	HANDLE	icon = NULL;
	CStatic* iconDisp = (CStatic *)GetDlgItem( IDC_ICON_GRAPHICS_SMALL );

	if( ulNewDDrawMode & DDRAW_FULL )
	{
		icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
		iSelect = 5;		//Default case (800 x 600)

		if( ulNewDDrawMode & DDRAW_320_200 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 0;
		}
		if( ulNewDDrawMode & DDRAW_320_240 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			iSelect = 1;
		}
		if( ulNewDDrawMode & DDRAW_512_384 )
		{
			iSelect = 2;
		}
		if( ulNewDDrawMode & DDRAW_640_400 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 3;
		}
		if( ulNewDDrawMode & DDRAW_640_480 )
		{
			icon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			iSelect = 4;
		}
		if( ulNewDDrawMode & DDRAW_1024_768 )
		{
			iSelect = 6;
		}
	}
	else
	{
		if( ulNewDDrawMode & WINDOWED_NORMAL )
		{
			icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 7;
		}
		else
		{
			icon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 8;
		}
	}

	cbCheckBox = (CButton *)GetDlgItem( IDC_NODDRAW_SMALL );
	ASSERT( cbCheckBox );
	if( ulNewDDrawMode & DDRAW_NONE )
		cbCheckBox->SetCheck( 1 );
	else
		cbCheckBox->SetCheck( 0 );

	cbCheckBox = (CButton *)GetDlgItem( IDC_FORCE_VSYNC_SMALL );
	ASSERT( cbCheckBox );
	if( ulNewDDrawMode & DDRAW_DDBLT_WAIT )
		cbCheckBox->SetCheck( 1 );
	else
		cbCheckBox->SetCheck( 0 );

	ComboBox->SetCurSel( iSelect );
	if( icon && iconDisp )
		iconDisp->SetIcon( (HICON)icon );

	CButton *cbButton = (CButton *)GetDlgItem( IDC_SMALL_LOCALMEM );
	ASSERT( cbButton );	
	if( ulNewDDrawMode & DDRAW_USE_LOCALMEM )
		cbButton->SetCheck( 1 );
	else
		cbButton->SetCheck( 0 );
}

BOOL CGraphicsSmallDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	ulNewDDrawMode = ulScreenMode;

	ComboBox = (CComboBox *)GetDlgItem( IDC_GRAPHICS_COMBO_SMALL );
	
	if( !ComboBox )
		return FALSE;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGraphicsSmallDlg::OnSelchangeGraphicsComboSmall() 
{
	switch( ComboBox->GetCurSel() )
	{
		case	0:
			{
				int result = IDOK;
				if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
				{
					CWarnDlg Warning;
					char	message[LOADSTRING_STRING_SIZE];
					LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
					Warning.csWarnText = message;
					Warning.iWarnBit = DONT_SHOW_MENU_WARN;
					result = Warning.DoModal();
				}
				if( result == IDOK )
				{
					ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
					ulNewDDrawMode |= DDRAW_320_200 | DDRAW_FULL;
				}
				break;
			}

		case	1:
			ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
			ulNewDDrawMode |= DDRAW_320_240 | DDRAW_FULL;
			break;

		case	2:
			ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
			ulNewDDrawMode |= DDRAW_512_384 | DDRAW_FULL;
			break;

		case	3:
			{
				int result = IDOK;
				if( !(ulDontShowFlags & DONT_SHOW_MENU_WARN) )
				{
					CWarnDlg Warning;
					char	message[LOADSTRING_STRING_SIZE];
					LoadString( NULL, IDS_WARNING_NO_MENU, message, LOADSTRING_STRING_SIZE );
					Warning.csWarnText = message;
					Warning.iWarnBit = DONT_SHOW_MENU_WARN;
					Warning.DoModal();
				}
				if( result == IDOK )
				{
					ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
					ulNewDDrawMode |= DDRAW_640_400 | DDRAW_FULL;
				}
				break;
			}

		case	4:
			ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
			ulNewDDrawMode |= DDRAW_640_480 | DDRAW_FULL;
			break;

		case	5:
			ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
			ulNewDDrawMode |= DDRAW_800_600 | DDRAW_FULL;
			break;

		case	6:
			ulNewDDrawMode &= ~DDRAW_FULL_RES_MASK;
			ulNewDDrawMode |= DDRAW_1024_768 | DDRAW_FULL;
			break;

		case	7:
			ulNewDDrawMode &= ~WIND_RES_MASK;
			ulNewDDrawMode &= ~DDRAW_FULL;
			ulNewDDrawMode |= WINDOWED_NORMAL;
			break;

		case	8:
			{
				int result = IDOK;
				if( !(ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN ) )
				{
					CWarnDlg	Warning;
					char	message[LOADSTRING_STRING_SIZE];

					LoadString( NULL, IDS_WARNING_GRAPHICS_WINDOW, message, LOADSTRING_STRING_SIZE );
					Warning.csWarnText = message;
					Warning.iWarnBit = DONT_SHOW_GRAPHICS_WARN;
					result = Warning.DoModal();
				}

				if( result == IDOK )
				{
					ulNewDDrawMode &= ~WIND_RES_MASK;
					ulNewDDrawMode &= ~DDRAW_FULL;
					ulNewDDrawMode |= WINDOWED_STRETCH;	
				}
			}
			break;

		default:
			ulNewDDrawMode |= DDRAW_800_600 | DDRAW_FULL;
			break;
	}
	SetDlgState();
}

void CGraphicsSmallDlg::OnNoddrawSmall() 
{
	cbCheckBox = (CButton *)GetDlgItem( IDC_NODDRAW_SMALL );
	if( cbCheckBox )
	{
		if( cbCheckBox->GetCheck() )
		{
			ulNewDDrawMode &= ~DDRAW_WIND;
			ulNewDDrawMode |= DDRAW_NONE;
		}
		else
		{
			ulNewDDrawMode &= ~DDRAW_NONE;
			ulNewDDrawMode |= DDRAW_WIND;
		}
	}
	SetDlgState();
}

void CGraphicsSmallDlg::OnSmallLocalmem() 
{
	CButton *cbButton = (CButton *)GetDlgItem( IDC_SMALL_LOCALMEM );
	ASSERT( cbButton );	

	if( cbButton->GetCheck() )
		ulNewDDrawMode |= DDRAW_USE_LOCALMEM;
	else
		ulNewDDrawMode &= ~DDRAW_USE_LOCALMEM;
}

void CGraphicsSmallDlg::OnForceVsyncSmall() 
{
	CButton *cbButton = (CButton *)GetDlgItem( IDC_FORCE_VSYNC_SMALL );
	ASSERT( cbButton );

	if( cbButton->GetCheck() )
		ulNewDDrawMode |= DDRAW_DDBLT_WAIT;
	else
		ulNewDDrawMode &= ~DDRAW_DDBLT_WAIT;
	SetDlgState();
}

void CGraphicsSmallDlg::OnOK() 
{
	CDialog::OnOK();

	if( ulNewDDrawMode != ulScreenMode )
	{
		ULONG	savedmode = ulScreenMode;

		ulScreenMode = ulNewDDrawMode;
		if( !Init_Graphics() )
		{
			ulScreenMode = savedmode;
			Init_Graphics();
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, ulScreenMode );
	}
}

void CGraphicsSmallDlg::OnOptionsArtif() 
{
	// TODO: Add your command handler code here
	
}
