/* The minimum time you would want to sleep, in MS. Windows NT Sleep() functions have 5 ms granularity */
#define SLEEP_TIME_IN_MS 5

/* How many DirectInput devices to enumerate, how long their names can be */
#define MAX_INPUT_DEVICES	8
#define INPUT_DEV_NAMELEN	32

#define MAX_ATARI_JOYPORTS	4
#define KEYPAD_JOYSTICK		-1
#define NO_JOYSTICK			127

#define TIMER_READ_JOYSTICK	6969

#define SPECIAL_HANDLER_BIT		0x8000

#define TOGGLE_HANDLER_BIT		0x4000
#define TOGGLE_OPTION			0x4001
#define TOGGLE_SELECT			0x4002
#define TOGGLE_START			0x4003

#define TOGGLE_SHIFT			0x4004
#define TOGGLE_CONTROL			0x4005

#define TOGGLE_PAUSE			0x4006
#define TOGGLE_FULLSPEED		0x4007
#define TOGGLE_SIO_PATCH		0x4008

#define SPECIAL_STICK_BIT		0x2000
#define STICK_SELECT_MASK		0xff00
#define STICK_FIRE				0x0010
#define	STICK0					0x2100
#define STICK1					0x2200
#define STICK2					0x2300
#define STICK3					0x2400

#define SUSPEND_ATARI	0x01
#define SPEED_ATARI		0x02
#define SWITCH_SIO		0x03

/* Various machine states the Atari can be in */
#define ATARI_UNINITIALIZED		0x0001
#define ATARI_INITIALIZING		0x0002
#define ATARI_HW_READY			0x0004
#define ATARI_WINDOWS_READY		0x0008
#define ATARI_RUNNING			0x0010
#define	ATARI_PAUSED			0x0020
#define ATARI_NOFOCUS			0x0040
#define ATARI_UI_ACTIVE			0x0100
#define ATARI_JOYSTICK_FOUND	0x0200
#define ATARI_LOAD_FAILED		0x0400
#define ATARI_LOAD_WARNING		0x0800
#define ATARI_CRASHED			0x1000
#define ATARI_CLOSING			0x2000
#define ATARI_SHOW_PAUSE		0x4000

/* Misc states to be saved out to the Registry */
#define ATARI_FULL_SPEED		0x0001
#define ATARI_ENABLE_PILL		0x0002
#define ATARI_LAST_BOOT_FAILED	0x0004
#define ATARI_ANTICF_ARTIFACT	0x0008
#define ATARI_STICK_RELEASE		0x0010
#define ATARI_USE_KEYTEMPLATE	0x0020
#define ATARI_RAMBO_MODE		0x0040

/* Sound states and registry stuff */
#define SOUND_MMSOUND			0x0001
#define SOUND_DIRECTSOUND		0x0002
#define SOUND_CUSTOM_RATE		0x0004
#define SOUND_FORCE_PRIMARY		0x0008
#define SOUND_NOSOUND			0x0010
#define	SOUND_WRITING_FILE		0x0020

#define DONT_SHOW_SOUND_WARN		0x0001
#define DONT_SHOW_GRAPHICS_WARN		0x0002
#define DONT_SHOW_SOUNDFILE_WARN	0x0004
#define DONT_SHOW_MENU_WARN			0x0008
#define DONT_SHOW_OSA_WARN			0x0010
#define DONT_SHOW_OSB_WARN			0x0020
#define DONT_SHOW_XL_WARN			0x0040
#define DONT_SHOW_5200_WARN			0x0080
#define DONT_SHOW_BASIC_WARN		0x0100
#define DONT_SHOW_JOYSTICK_WARN		0x0200

#define LOADSTRING_STRING_SIZE		1024

#define NUM_PC_KEY_ELEMENTS		72
#define NUM_ATARI_KEY_ELEMENTS	94

#define KEYBOARD_TEMPLATE_VERSION 2

#ifdef TRACE_MODULE
#define TRACEBOX( v, x, y, z )	{::MessageBox( v, x, y, z );}
#else
#define TRACEBOX( v, x, y, z )
#endif