#include "atari.h"

#define ATARI_HORZ_CLIP					24
#define ATARI_FULL_HORZ_CLIP			ATARI_HORZ_CLIP * 2
#define ATARI_VIS_WIDTH					(ATARI_WIDTH - ATARI_FULL_HORZ_CLIP)
#define ATARI_STRETCH_VIS_WIDTH			(ATARI_WIDTH * 2 - (ATARI_FULL_HORZ_CLIP *2) )
#define ATARI_STRETCH_WIDTH				(ATARI_WIDTH * 2)
#define ATARI_STRETCH_HEIGHT			(ATARI_HEIGHT * 2)

#define ATARI_SCREEN_SIZE				(ATARI_WIDTH * ATARI_HEIGHT)
#define ATARI_VIS_SCREEN_SIZE			(ATARI_VIS_WIDTH * ATARI_HEIGHT)
#define ATARI_STRETCH_VIS_SCREEN_SIZE	(ATARI_STRETCH_VIS_WIDTH * ATARI_STRETCH_HEIGHT)

/* States for the modes available test */
#define MODE_1024_768	0x0040
#define	MODE_800_600	0x0020
#define MODE_640_480	0x0010
#define MODE_640_400	0x0008
#define MODE_512_384	0x0004
#define MODE_320_240	0x0002
#define MODE_320_200	0x0001

/* States for the ulScreenMode variable */
/* The full res flags always need to be in order of resolution size! */
#define SCANLINE_CAPABLE	0x01000000
#define SHOW_SCANLINES		0x02000000
#define SMALL_DIALOG_MODE	0x04000000
#define DDRAW_NO_MENU_MODE	0x08000000

#define	DDRAW_320_200		0x00000001
#define DDRAW_320_240		0x00000002
#define DDRAW_512_384		0x00000004
#define	DDRAW_640_400		0x00000008
#define DDRAW_640_480		0x00000010
#define DDRAW_800_600		0x00000020
#define DDRAW_1024_768		0x00000040
#define DDRAW_FULL_RES_MASK	0x000000FF

#define WINDOWED_NORMAL		0x00000100
#define WINDOWED_STRETCH	0x00000200
#define WIND_RES_MASK		0x00000F00

#define	DDRAW_8BPP			0x00001000
#define DDRAW_16BPP			0x00002000
#define DDRAW_24BPP			0x00004000
#define DDRAW_BPP_MASK		0x0000F000

#define DDRAW_FULL			0x00010000
#define DDRAW_WIND			0x00020000
#define DDRAW_MODE_MASK		0x000F0000

#define DDRAW_NONE			0x00100000
#define DDRAW_DDBLT_WAIT	0x00200000
#define DDRAW_USE_LOCALMEM	0x00400000

#define DISPLAY_MODE_DEFAULT (DDRAW_800_600 | WINDOWED_NORMAL | DDRAW_NONE)

/* RGB Modes we can be in when running DDraw windowed */
#define RGB_8BPP			0x0001
#define	RGB_16BPP			0x0002
#define RGB_555				0x0004
#define RGB_565				0x0008
#define	RGB_24BPP			0x0100
#define RGB_32BPP			0x0200
#define RGB_HAVEFOCUS		0x1000

