.TH ATARI800 1 "07 August 2002"
.SH NAME
atari800 \- Atari 800 Emulator, Version 1.3.0
.SH SYNOPSIS
\fBatari800\fP [options] [diskfiles...]
.SH DESCRIPTION
\fIatari800\fP emulates the Atari 800, Atari 800 XL, Atari 130 XE and
Atari 5200 Games System.
.SS Options
.TP
\fB-help
Print complete and up-to-date list of command line switches
.TP
\fB-v
Print emulator version.
.TP
\fB-verbose
Display framerate when exiting
.TP
\fB-configure
Starts emulator in run-time configuration mode.
.TP
\fB-config filename
Specify an alternative configuration filename.

.TP
\fB-osa_rom filename
Path to file containing Atari Rev.A Operating System.
Used to override paths defined at compile time.
.TP
\fB-osb_rom filename
Path to file containing Atari Rev.B Operating System.
Used to override paths defined at compile time.
.TP
\fB-xlxe_rom filename
Path to file containing Atari XL/XE Operating System.
Used to override paths defined at compile time.
.TP
\fB-5200_rom filename
Path to file containing Atari 5200 Games System ROM.
Used to override paths defined at compile time.
.TP
\fB-basic_rom filename
Path to file containing Atari BASIC ROM.
Used to override paths defined at compile time.

.TP
\fB-xl
Emulate Atari 800 XL.
.TP
\fB-xe
Emulate Atari 130 XE.
.TP
\fB-320xe
Emulate Atari 320 XE (Compy Shop)
.TP
\fB-rambo
Emulate Atari 320 XE (Rambo)
.TP
\fB-5200
Emulate Atari 5200 - Games controller emulation has not been implemented yet!
.TP
\fB-emuos
Use EmuOS

.TP
\fB-a
Use Atari OS/A.
.TP
\fB-b
Use Atari OS/B.
.TP
\fB-c
Enable RAM between $c000 and $d000.

.TP
\fB-pal                
Emulate PAL TV mode
.TP
\fB-ntsc               
Emulate NTSC TV mode

.TP
\fB-nobasic
Used to disable Basic when starting the emulator in XL/XE mode.
Simulates the Option key being held down during system boot.
.TP
\fB-basic
Turn on Atari BASIC ROM

.TP
\fB-cart <filename>    
Insert cartridge (CART or raw format)
.TP
\fB-run <filename>     
Run Atari executable file (EXE, COM, XEX)
.TP
\fB-tape <filename>    
Attach cassette image (CAS format or raw file)
.TP
\fB-boottape <filename>
Attach cassette image and boot it

.TP
\fB-nopatch
Normally the OS is patched giving very fast I/O. This options prevents
the patch from being applied so that the OS accesses the serial port
hardware directly. This option will probably never be needed since
programs that access the serial hardware should work even if the OS
has been patched.
.TP
\fB-nopatchall         
Don't patch OS at all, H: and P: devices won't work

.TP
\fB-H1 <path>          
Set path for H1: device
.TP
\fB-H2 <path>          
Set path for H2: device
.TP
\fB-H3 <path>          
Set path for H3: device
.TP
\fB-H4 <path>          
Set path for H4: device
.TP
\fB-hdreadonly <onoff> 
Enable (1) or disable (0) read-only mode for H: device
.TP
\fB-devbug             
Put debugging messages for H: and P: devices in log file

.TP
\fB-rtime <onoff>      
Enable (1) or disable (0) R-Time 8 emulation

.TP
\fB-mouse off          
Do not use mouse
.TP
\fB-mouse pad          
Emulate paddles
.TP
\fB-mouse touch        
Emulate Atari Touch Tablet
.TP
\fB-mouse koala        
Emulate Koala Pad
.TP
\fB-mouse pen          
Emulate Light Pen
.TP
\fB-mouse gun          
Emulate Light Gun
.TP
\fB-mouse amiga        
Emulate Amiga mouse
.TP
\fB-mouse st           
Emulate Atari ST mouse
.TP
\fB-mouse trak         
Emulate Atari Trak-Ball
.TP
\fB-mouse joy          
Emulate joystick using mouse
.TP
\fB-mouseport <num>    
Set mouse port 1-4 (default 1)
.TP
\fB-mousespeed <num>   
Set mouse speed 1-9 (default 3)

.TP
\fB-refresh
Controls screen refresh rate. A numerical value follows this option
which specifies how many emulated screen updates are required before
the actual screen is updated. This value effects the speed of the
emulation: A higher value results in faster CPU emulation but a
less frequently updated screen.

.TP
\fB-artif <mode>       
Set artifacting mode 0-4 (0 = disable)
.TP
\fB-palette <filename> 
Read Atari colors from ACT file
.TP
\fB-black <num>        
Set black level 0-255
.TP
\fB-while <num>        
Set white level 0-255
.TP
\fB-colors <num>       
Set color intensity
.TP
\fB-colshift <num>     
Set color shift
.TP
\fB-realpal            
Use palette created by Zdenek Eisenhammer
.TP
\fB-oldpal             
Use old Atari800 palette
.TP
\fB-foxpal             
Use palette created by Piotr Fusik

.TP
\fB-sound              
Enable sound
.TP
\fB-nosound            
Disable sound
.TP
\fB-dsprate <freq>     
Set mixing frequency (Hz)
.TP
\fB-snddelay <time>    
Set sound delay (milliseconds)


.SS Curses Options
.TP
\fB-left
Use columns 0 to 39.
.TP
\fB-central
Use columns 20 to 59.
.TP
\fB-right
Use columns 40 to 79.
.TP
\fB-wide1
Use columns 0 to 79. In this mode only the even character positions
are used. The odd locations are filled with spaces.
.TP
\fB-wide2
Use columns 0 to 79. This mode is similar to \fB-wide1\fP except that
the spaces are in reverse video if the previous character was also
in reverse video.


.SS Falcon Options
.TP
\fB-interlace <x>      
Generate Falcon screen only every x frame
.TP
\fB-videl              
Direct VIDEL programming (Falcon/VGA only)
.TP
\fB-double             
Double the screen size on NOVA
.TP
\fB-delta              
Delta screen output (differences only)

.SS SVGALIB Options
.TP
\fB-interlace
Enable screen interlace option


.SS DOS/VGA Options
.TP
\fB-interlace          
Generate screen with interlace
.TP
\fB-video <mode>       
0=320x200, 1=320x240, 2=320x480 interlaced with black lines, 3=320x480 interlaced with darker lines
.TP
\fB-novesa             
Do not use VESA 2 video modes
.TP
\fB-vretrace           
Use vertical retrace control

.TP
\fB-LPTjoy1            
Read joystick connected to LPT1
.TP
\fB-LPTjoy2            
Read joystick connected to LPT2
.TP
\fB-LPTjoy3            
Read joystick connected to LPT3
.TP
\fB-joyswap            
Swap joysticks

.TP
\fB-keyboard 0         
PC keyboard layout
.TP
\fB-keyboard 1         
Atari keyboard layout


.SS X11 Options
.TP
\fB-small
Runs the emulator in a small window where each Atari 800 pixel is
represented by one X Window pixel.
.TP
\fB-large
Runs the emulator in a large window where each Atari 800 pixel is
represented by a 2x2 X Window rectange. This mode is selected by
default.
.TP
\fB-huge
Runs the emulator in a huge window where each Atari 800 pixel is
represented by a 3x3 X Window rectange.
.TP
\fB-clip_x number-of-pixels
Sets left offset for clipping.
.TP
\fB-clip_width number-of-pixels
Sets the width of the clipping-area.
.TP
\fB-clip_y number-of-pixels
Sets top offset for clipping.
.TP
\fB-clip_height number-of-pixels
Sets the height of the clipping-area.
.TP
\fB-private_cmap
Tells the Emulator to use its own private colormap.
.TP
\fB-fps                
Show framerate
.TP
\fB-sio                
Show SIO monitor
.TP
\fB-x11bug             
Enable debug code in atari_x11.c

.TP
\fB-keypad             
Keypad mode

.SS SDL Options
.TP
\fB-rotate90
Runs the emulator with rotated display (useful for devices with 240x320
screen)
.TP
\fB-fullscreen
Runs in fullscreen (tries to switch to 336x240 resolution)
.TP
\fB-windowed
Runs in a window (does not change your working resolution)
.TP
\fB-width number-of-pixels
Host horizontal resolution for fullscreen
.TP
\fB-height number-of-pixels
Host vertical resolution for fullscreen
.TP
\fB-bpp number-of-bits
Host color depth for running in fullscreen
.TP
\fB-nojoystick
SDL Joysticks will not be initialized
.TP
\fB-joy0 path-to-device
Defines path to device used in LPTjoy 0. Available on linux-ia32 only.
.TP
\fB-joy1 path-to-device
Defines path to device used in LPTjoy 1. Available on linux-ia32 only.
.TP
\fB-audio16
16-bit sound output enabled.

.PD 0

.SH KEYBOARD, JOYSTICK & PADDLE CONTROLS

.SS Curses
.TP
\fBF1
Built in User Interface
.TP
\fBF2
Option
.TP
\fBF3
Select
.TP
\fBF4
Start
.TP
\fBF5
Warm Reset
.TP
\fBF6
Toggle RAM/ROM between 0x8000 and 0xbfff (PIL Mode)
.TP
\fBF7
Break Key
.TP
\fBF8
Cold Reset
.TP
\fBF9
Exit Emulator
.TP
\fBF10
---
.TP
\fBF11
---
.TP
\fBF12
---

.PP
Some control have special meaning within curses and should not be used.

    Avoid Control + C, J, M, Q, S and Z

The remaining control characters can be typed. Control characters are
displayed on the screen with the associated upper case character in bold.

No Joystick or Paddle support in this version.

.SS Falcon
.TP
\fBF1
Built in User Interface
.TP
\fBF2
Option
.TP
\fBF3
Select
.TP
\fBF4
Start
.TP
\fBF5
Warm Reset
.TP
\fBShft+F5
Cold Reset
.TP
\fBF6
Toggle RAM/ROM between 0x8000 and 0xbfff (PIL Mode)
.TP
\fBF7
Break Key
.TP
\fBF8
Enter monitor
.TP
\fBF9
EXIT Emulator
.TP
\fBHelp
HELP key (800XL/130XE)

.PP
Joystick 0 is operated by the numeric keypad (make sure that the numeric
keypad has been enabled).
 
        7 8 9
         \\|/
        4 5 6
         /|\\
        1 2 3
 
        And 0 is the fire key.
 
At the moment it is not possible to use a Paddle with this version.

.SS SVGALIB
.TP
\fBF1
Built in User Interface
.TP
\fBF2
Option
.TP
\fBF3
Select
.TP
\fBF4
Start
.TP
\fBF5
Warm Reset
.TP
\fBShft+F5
Cold Reset
.TP
\fBF6
Toggle RAM/ROM between 0x8000 and 0xbfff (PIL Mode)
.TP
\fBF7
Break Key
.TP
\fBF8
Enter monitor
.TP
\fBF9
Exit Emulator
.TP
\fBF10
Save Screenshot (+Shift=interlaced screenshot)
.TP
\fBF11
Joystick Autofire On/Off
.TP
\fBF12
---
.TP
\fB`
This character replaces the CAPS lock key because I have not found a
way of detecting it. A future solution maybe to automatically issue a
CAPS lock key when a transition is made between lower and upper case
keys. i.e. If svgalib return 'a' followed by 'A' it could send 'a'
'CAPS' 'A' to the Atari.

.PP
The CTRL+SHIFT keyboard combinations are implemented using the left
ALT key.

Joystick 0 is operated by the numeric keypad (make sure that the numeric
keypad has been enabled).

        7 8 9
         \\|/
        4 5 6
         /|\\
        1 2 3

        And 0 is the fire key.

At the moment it is not possible to use a Paddle with the SVGALIB
version.

.SS DOS/VGA
.TP
\fBF1
Built in User Interface
.TP
\fBF2
Option Key
.TP
\fBF3
Select Key
.TP
\fBF4
Start Key
.TP
\fBF5
Warm Reset
.TP
\fBShft+F5
Cold Reset
.TP
\fBF6
PIL Mode (Atari800) / Help Key (XL/XE)
.TP
\fBF7
Switch between Emulated joysticks mode and Normal keyboard
.TP
\fBF8
Enter monitor
.TP
\fBF9
EXIT Emulator
.TP
\fBF10
Save Screenshot (+Shift=interlaced screenshot)

.PP
Control-C terminates the program; to type Control-c, type ALT-c instead.
` is used as the Atari-Invers key

Joysticks can be either real one connected to game port, or old 8-bit
digital CX-40 joysticks connected to parallel port or keyboard joysticks
(try out JOYCFG.EXE).
 
At the moment it is not possible to use a Paddle with this version.

.SS X11
.TP
\fBF1
Built in User Interface
.TP
\fBF2
Option
.TP
\fBF3
Select
.TP
\fBF4
Start
.TP
\fBF5
Warm Reset
.TP
\fBShft+F5
Cold Reset
.TP
\fBF6
Toggle RAM/ROM between 0x8000 and 0xbfff (PIL Mode)
.TP
\fBF7
Break Key
.TP
\fBF8
---
.TP
\fBF9
Exit Emulator
.TP
\fBF10
---
.TP
\fBF11
Vertical Positioning: Scroll Screen Downwards
.TP
\fBF12
Vertical Positioning: Scroll Screen Upwards
.TP
\fBALT
Atari Key (Either ALT Key will work)

.PP
Joystick 0 is operated by the mouse position relative to the center of
the screen. The mouse button acts as the trigger.  On Linux, standard
joysticks are also supported.

Paddle 0 is operated by moving the mouse pointer across the window.

.SS SDL
.TP
\fBLALT+f
switching FULLSCREEN (probably doesn't work in Windows)
.TP
\fBLALT+g
switching WIDTH_MODE (so you can set 320x240)
.TP
\fBLALT+b
switching BLACK-AND-WHITE (feel to power of BW monitor!)
.TP
\fBLALT+j
swapping _keyboard_emulated_ joysticks
.TP
\fBLALT+e
switching bpp (for debug only, will be removed soon)

.PP
To redefine keys for joystick emulation you must modify SDL_TRIG_* and
SDL_JOY_* in atari_sdl.c, then recompile Atari800. In source you can
also turn off sound or change defaults (FULLSCREEN, BW,
SWAP_JOYSTICKS, WIDTH_MODE).

On Linux, standard joysticks are supported.


.PD 1

.SH FILES
.TP
\fI/usr/share/atari800/ATARIOSA.ROM\fR
Atari O/S A
.TP
\fI/usr/share/atari800/ATARIOSB.ROM\fR
Atari O/S B
.TP
\fI/usr/share/atari800/ATARIXL.ROM\fR
Atari 800 XL O/S
.TP
\fI/usr/share/atari800/ATARI5200.ROM\fR
Atari 5200 O/S
.TP
\fI/usr/share/atari800/ATARIBAS.ROM\fR
Atari Basic
.SH BUGS
A few programs cause the emulator to enter its built in debugger. The
reason for this is unknown at the moment.
