/*****************************************************************************
 *                                                                           *
 * Module: POKEY Chip Emulator Filter package                                *
 * Author: Michael Borisov                                                   *
 * Version: 1.2                                                              *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                                                                           *
 *                 License Information and Copyright Notice                  *
 *                 ========================================                  *
 *                                                                           *
 *  POKEY Chip Emulator is Copyright(c) 2002 by Michael Borisov              *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or modify     *
 *  it under the terms of the GNU General Public License as published by     *
 *  the Free Software Foundation; either version 2 of the License, or        *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public License        *
 *  along with this program; if not, write to the Free Software              *
 *  Foundation, Inc., 59 Temple Place - Suite 330,                           *
 *                Boston, MA 02111-1307, USA.                                *
 *                                                                           *
 *****************************************************************************/


#include "pokey_resample.h"

// Filter for 44100 sample rate, 8 bit (0.05db/45db ripple, transition 17000-22050)
 double filter_44_8[] = {
     0.99710033003364174,
     0.99479971880342255,
     0.99577282140158097,
     0.99656661228964882,
     0.99721751048385332,
     0.99775438513946879,
     0.99820037406470874,
     0.99857370501578435,
     0.99888900732753072,
     0.99915767937257660,
     0.99938889306038303,
     0.99958967202005056,
     0.99976569447398900,
     0.99992116557634736,
     1.00005953465372180,
     1.00018319436153180,
     1.00029419743386550,
     1.00039375553283220,
     1.00048316544656140,
     1.00056221191202230,
     1.00063409798412330,
     1.00069286900945560,
     1.00074725985867000,
     1.00079139009862470,
     1.00082432044997670,
     1.00084916920222680,
     1.00086622567981950,
     1.00087355528126290,
     1.00086988108070680,
     1.00085558969374340,
     1.00083161848492060,
     1.00079822447345570,
     1.00075485843828500,
     1.00070066444954800,
     1.00063525666680930,
     1.00055874191535340,
     1.00047172643777470,
     1.00037460639956550,
     1.00026792134239880,
     1.00015106528464370,
     1.00002520207929860,
     0.99988848422517718,
     0.99974314021733279,
     0.99958882453903974,
     0.99942569957999183,
     0.99925555565618740,
     0.99907909569519648,
     0.99889629691464243,
     0.99870777430676438,
     0.99851460970567152,
     0.99831751603928587,
     0.99811686515210241,
     0.99791336648260642,
     0.99770820721180187,
     0.99750277652585206,
     0.99729813270853629,
     0.99709520223986758,
     0.99689472122563672,
     0.99669797591271458,
     0.99650563351084886,
     0.99631945567100499,
     0.99613947855875040,
     0.99596716170939770,
     0.99580329501123388,
     0.99564850411710348,
     0.99550435886330779,
     0.99537200932330416,
     0.99525211003130631,
     0.99514556854932656,
     0.99505336328008553,
     0.99497610429345795,
     0.99491425224368690,
     0.99486852720613039,
     0.99483967378993121,
     0.99482820747548106,
     0.99483428818376562,
     0.99485819035332268,
     0.99490009124547285,
     0.99496050332562092,
     0.99503920798667600,
     0.99513664546466263,
     0.99525237368290986,
     0.99538654718612074,
     0.99553908997181584,
     0.99570931475148361,
     0.99589681501376970,
     0.99610098776939549,
     0.99632095294036294,
     0.99655605208364095,
     0.99680565729398074,
     0.99706878557971612,
     0.99734425101474022,
     0.99763099350053286,
     0.99792789375769153,
     0.99823370679070911,
     0.99854702318784339,
     0.99886661255079523,
     0.99919101041837610,
     0.99951893082309151,
     0.99984854517801891,
     1.00017858918447480,
     1.00050739516546660,
     1.00083343790530880,
     1.00115516987802540,
     1.00147062991709080,
     1.00177814423923310,
     1.00207615053552090,
     1.00236291706292180,
     1.00263684116254280,
     1.00289643713731170,
     1.00314014459692750,
     1.00336642518994660,
     1.00357395223140490,
     1.00376137504538860,
     1.00392733608118330,
     1.00407049765446430,
     1.00418988642102840,
     1.00428445138255600,
     1.00435343593597250,
     1.00439581466290240,
     1.00441104306094160,
     1.00439849797782180,
     1.00435765621903860,
     1.00428830402470680,
     1.00419016949230300,
     1.00406324743434690,
     1.00390771102041070,
     1.00372363545506160,
     1.00351127529105750,
     1.00327117082151180,
     1.00300397566992850,
     1.00271042494624000,
     1.00239149367905970,
     1.00204823702982120,
     1.00168186429482240,
     1.00129368532424670,
     1.00088534410370270,
     1.00045836785162100,
     1.00001454233413530,
     0.99955554602650598,
     0.99908341470652040,
     0.99860021276372324,
     0.99810796050579298,
     0.99760894335507544,
     0.99710543025084664,
     0.99659978938826943,
     0.99609452022359335,
     0.99559201803333430,
     0.99509471453431275,
     0.99460514501426700,
     0.99412579818685409,
     0.99365907841058521,
     0.99320750404157288,
     0.99277355206340068,
     0.99235966490401240,
     0.99196811133179497,
     0.99160122628808001,
     0.99126107643156536,
     0.99094980806182376,
     0.99066937395609078,
     0.99042172715266596,
     0.99020866897357518,
     0.99003170645035077,
     0.98989237436430522,
     0.98979203336344057,
     0.98973182353091604,
     0.98971277319839568,
     0.98973565685375353,
     0.98980106571864668,
     0.98990946455637630,
     0.99006108486006250,
     0.99025586067095905,
     0.99049362356169934,
     0.99077397022544045,
     0.99109630095325485,
     0.99145971215576434,
     0.99186325098020556,
     0.99230562127023303,
     0.99278541712033719,
     0.99330096108122179,
     0.99385039881705561,
     0.99443172859439499,
     0.99504264222885752,
     0.99568075624344199,
     0.99634349342381168,
     0.99702800197570540,
     0.99773136039091415,
     0.99845053259670757,
     0.99918236128190197,
     0.99992359702918265,
     1.00067086444293230,
     1.00142061181642640,
     1.00216931294920440,
     1.00291335935760960,
     1.00364912036724310,
     1.00437285939382880,
     1.00508098498239470,
     1.00576982148675920,
     1.00643576935379910,
     1.00707526143086470,
     1.00768478114356920,
     1.00826096282518420,
     1.00880044665564420,
     1.00930004669151870,
     1.00975674439633980,
     1.01016758431707140,
     1.01052984433699390,
     1.01084100614439000,
     1.01109870763429280,
     1.01130079909158920,
     1.01144540296909270,
     1.01153083753041750,
     1.01155575018944340,
     1.01151899960979640,
     1.01141973134366410,
     1.01125731554528860,
     1.01103155437949280,
     1.01074248075077880,
     1.01039041919323220,
     1.00997601017363590,
     1.00950016463471060,
     1.00896416727276850,
     1.00836955089850380,
     1.00771817305120900,
     1.00701224976619860,
     1.00625421083299170,
     1.00544679980818490,
     1.00459306177323790,
     1.00369627250954170,
     1.00275995905260170,
     1.00178796518729760,
     1.00078431863779670,
     0.99975331178312232,
     0.99869939825974474,
     0.99762724899085331,
     0.99654164333170858,
     0.99544757953681928,
     0.99435011453191946,
     0.99325437519065962,
     0.99216563261344637,
     0.99108919152519082,
     0.99003042600859326,
     0.98899466892760057,
     0.98798721758631525,
     0.98701339666257604,
     0.98607840651577328,
     0.98518735484726916,
     0.98434525125959749,
     0.98355692332081102,
     0.98282699158902154,
     0.98215994572934029,
     0.98156000254501308,
     0.98103116412220936,
     0.98057713843567251,
     0.98020137920620920,
     0.97990697319623865,
     0.97969671560284177,
     0.97957303093359283,
     0.97953794762467050,
     0.97959318275571183,
     0.97974001810003608,
     0.97997932409692901,
     0.98031153649842229,
     0.98073664057925125,
     0.98125424689607732,
     0.98186347182797717,
     0.98256296405192822,
     0.98335096335328886,
     0.98422526662852106,
     0.98518318445996378,
     0.98622164067756313,
     0.98733706691620637,
     0.98852548016305120,
     0.98978247150384979,
     0.99110327610146065,
     0.99248270832586871,
     0.99391523567144202,
     0.99539498622590017,
     0.99691572016322771,
     0.99847094759312527,
     1.00005387118821250,
     1.00165743335159910,
     1.00327437834038790,
     1.00489723313304040,
     1.00651840265475450,
     1.00813013116309150,
     1.00972455367960600,
     1.01129379315666770,
     1.01282996612481120,
     1.01432513600923380,
     1.01577145962175510,
     1.01716114914544620,
     1.01848655418671120,
     1.01974017995221830,
     1.02091476077899630,
     1.02200324041715350,
     1.02299884554831610,
     1.02389515220398920,
     1.02468604337391330,
     1.02536581268723760,
     1.02592914943860090,
     1.02637116753325300,
     1.02668749850068440,
     1.02687425596330910,
     1.02692810781416280,
     1.02684626729088730,
     1.02662651005905680,
     1.02626723711650000,
     1.02576748978276840,
     1.02512688389261730,
     1.02434574332907720,
     1.02342505593581070,
     1.02236648014552990,
     1.02117233224472010,
     1.01984562254810720,
     1.01839002738911690,
     1.01680989203897390,
     1.01511026805273170,
     1.01329682082485560,
     1.01137587191088250,
     1.00935438306800650,
     1.00723990591040470,
     1.00504061924602590,
     1.00276523598904820,
     1.00042300430783730,
     0.99802368067546010,
     0.99557747870743107,
     0.99309504706069562,
     0.99058745011907756,
     0.98806604426895694,
     0.98554253842006689,
     0.98302891444744300,
     0.98053735327031322,
     0.97808018345564873,
     0.97566986039234649,
     0.97331889527049009,
     0.97103977483671500,
     0.96884496436528522,
     0.96674679536686281,
     0.96475744208856573,
     0.96288888714383691,
     0.96115279889129790,
     0.95956052470062347,
     0.95812299257079658,
     0.95685067398910040,
     0.95575354996000672,
     0.95484102819783978,
     0.95412187803321413,
     0.95360422578495607,
     0.95329543101999026,
     0.95320210899873870,
     0.95333006871172588,
     0.95368423031461913,
     0.95426860013556647,
     0.95508626159375565,
     0.95613932845645233,
     0.95742886568835672,
     0.95895492024907547,
     0.96071646234191566,
     0.96271136043873451,
     0.96493640394446578,
     0.96738722323652937,
     0.97005832800104030,
     0.97294308708534161,
     0.97603372098299512,
     0.97932132527140203,
     0.98279585943294145,
     0.98644613718355600,
     0.99025990672738051,
     0.99422380023572432,
     0.99832338395021569,
     1.00254319702056430,
     1.00686675243404070,
     1.01127660180686640,
     1.01575439704016210,
     1.02028092587095490,
     1.02483610972430710,
     1.02939911448509710,
     1.03394839897807180,
     1.03846173678840550,
     1.04291633103122640,
     1.04728883057311760,
     1.05155543467819920,
     1.05569196938854580,
     1.05967393556581930,
     1.06347660238045160,
     1.06707508622920130,
     1.07044439839420400,
     1.07355959062840630,
     1.07639578472439860,
     1.07892825412024180,
     1.08113254721334600,
     1.08298453934918880,
     1.08446052793587410,
     1.08553732247886470,
     1.08619232837489000,
     1.08640359215769440,
     1.08614992752776620,
     1.08541100119624590,
     1.08416734337138500,
     1.08240048005656480,
     1.08009298210083180,
     1.07722854589062680,
     1.07379207167813950,
     1.06976969105944850,
     1.06514883962908580,
     1.05991833317371540,
     1.05406837689398340,
     1.04759066407812270,
     1.04047839347241000,
     1.03272628375939140,
     1.02433066097864240,
     1.01528945289871620,
     1.00560220429919210,
     0.99527010029178065,
     0.98429599308000115,
     0.97268438577810268,
     0.96044145636293377,
     0.94757507932428420,
     0.93409474734354980,
     0.92001161245233776,
     0.90533846233027115,
     0.89008967074893375,
     0.87428118409831490,
     0.85793046373982484,
     0.84105645706843546,
     0.82367958195259261,
     0.80582162375954935,
     0.78750571042566164,
     0.76875626132666319,
     0.74959888343258618,
     0.73006035807475311,
     0.71016854128939411,
     0.68995226873449667,
     0.66944128879373332,
     0.64866619925655344,
     0.62765834290565026,
     0.60644971310363238,
     0.58507290492624653,
     0.56356096409746281,
     0.54194733087871794,
     0.52026575754601090,
     0.49855016501682048,
     0.47683457248763006,
     0.45515299915492308,
     0.43353936593617814,
     0.41202742510739437,
     0.39065061693000852,
     0.36944198712799065,
     0.34843413077708746,
     0.32765904123990758,
     0.30714806129914418,
     0.28693178874424669,
     0.26703997195888768,
     0.24750144660105458,
     0.22834406870697763,
     0.20959461960797923,
     0.19127870627409152,
     0.17342074808104826,
     0.15604387296520539,
     0.13916986629381603,
     0.12281914593532593,
     0.10701065928470713,
     0.09176186770336968,
     0.07708871758130310,
     0.06300558269009104,
     0.04952525070935664,
     0.03665887367070709,
     0.02441594425553818,
     0.01280433695363976,
     0.00183022974186025,
    -0.00850187426555125,
    -0.01818912286507541,
    -0.02723033094500162,
    -0.03562595372575051,
    -0.04337806343876920,
    -0.05049033404448202,
    -0.05696804686034258,
    -0.06281800314007456,
    -0.06804850959544492,
    -0.07266936102580771,
    -0.07669174164449863,
    -0.08012821585698589,
    -0.08299265206719103,
    -0.08530015002292385,
    -0.08706701333774418,
    -0.08831067116260517,
    -0.08904959749412539,
    -0.08930326212405361,
    -0.08909199834124920,
    -0.08843699244522384,
    -0.08736019790223315,
    -0.08588420931554797,
    -0.08403221717970516,
    -0.08182792408660100,
    -0.07929545469075774,
    -0.07645926059476543,
    -0.07334406836056312,
    -0.06997475619556037,
    -0.06637627234681061,
    -0.06257360553217828,
    -0.05859163935490479,
    -0.05445510464455818,
    -0.05018850053947667,
    -0.04581600099758543,
    -0.04136140675476459,
    -0.03684806894443095,
    -0.03229878445145631,
    -0.02773577969066631,
    -0.02318059583731412,
    -0.01865406700652145,
    -0.01417627177322583,
    -0.00976642240040013,
    -0.00544286698692384,
    -0.00122305391657521,
     0.00287652979791616,
     0.00684042330626001,
     0.01065419285008453,
     0.01430447060069909,
     0.01777900476223848,
     0.02106660905064537,
     0.02415724294829887,
     0.02704200203260021,
     0.02971310679711117,
     0.03216392608917473,
     0.03438896959490596,
     0.03638386769172479,
     0.03814540978456503,
     0.03967146434528381,
     0.04096100157718823,
     0.04201406843988488,
     0.04283172989807410,
     0.04341609971902150,
     0.04377026132191470,
     0.04389822103490185,
     0.04380489901365031,
     0.04349610424868450,
     0.04297845200042648,
     0.04225930183580085,
     0.04134678007363396,
     0.04024965604454030,
     0.03897733746284410,
     0.03753980533301726,
     0.03594753114234282,
     0.03421144288980382,
     0.03234288794507501,
     0.03035353466677798,
     0.02825536566835553,
     0.02606055519692573,
     0.02378143476315059,
     0.02143046964129417,
     0.01902014657799194,
     0.01656297676332750,
     0.01407141558619770,
     0.01155779161357383,
     0.00903428576468383,
     0.00651287991456324,
     0.00400528297294523,
     0.00152285132620979,
    -0.00092335064181928,
    -0.00332267427419649,
    -0.00566490595540739,
    -0.00794028921238507,
    -0.01013957587676379,
    -0.01225405303436558,
    -0.01427554187724155,
    -0.01619649079121459,
    -0.01800993801909078,
    -0.01970956200533285,
    -0.02128969735547584,
    -0.02274529251446609,
    -0.02407200221107909,
    -0.02526615011188887,
    -0.02632472590216970,
    -0.02724541329543621,
    -0.02802655385897624,
    -0.02866715974912747,
    -0.02916690708285902,
    -0.02952618002541577,
    -0.02974593725724642,
    -0.02982777778052176,
    -0.02977392592966801,
    -0.02958716846704345,
    -0.02927083749961194,
    -0.02882881940495995,
    -0.02826548265359654,
    -0.02758571334027237,
    -0.02679482217034813,
    -0.02589851551467503,
    -0.02490291038351255,
    -0.02381443074535539,
    -0.02263984991857737,
    -0.02138622415307029,
    -0.02006081911180526,
    -0.01867112958811412,
    -0.01722480597559281,
    -0.01572963609117035,
    -0.01419346312302682,
    -0.01262422364596505,
    -0.01102980112945057,
    -0.00941807262111358,
    -0.00779690309939950,
    -0.00617404830674714,
    -0.00455710331795834,
    -0.00295354115457180,
    -0.00137061755948448,
     0.00018460987041307,
     0.00170534380774063,
     0.00318509436219880,
     0.00461762170777205,
     0.00599705393218012,
     0.00731785852979097,
     0.00857484987058953,
     0.00976326311743435,
     0.01087868935607760,
     0.01191714557367690,
     0.01287506340511962,
     0.01374936668035178,
     0.01453736598171246,
     0.01523685820566355,
     0.01584608313756346,
     0.01636368945438954,
     0.01678879353521850,
     0.01712100593671174,
     0.01736031193360467,
     0.01750714727792889,
     0.01756238240897021,
     0.01752729910004792,
     0.01740361443079896,
     0.01719335683740206,
     0.01689895082743154,
     0.01652319159796820,
     0.01606916591143130,
     0.01554032748862753,
     0.01494038430430031,
     0.01427333844461905,
     0.01354340671282952,
     0.01275507877404306,
     0.01191297518637142,
     0.01102192351786728,
     0.01008693337106448,
     0.00911311244732524,
     0.00810566110603995,
     0.00706990402504729,
     0.00601113850844971,
     0.00493469742019417,
     0.00384595484298092,
     0.00275021550172104,
     0.00165275049682124,
     0.00055868670193192,
    -0.00052691895721279,
    -0.00159906822610420,
    -0.00265298174948177,
    -0.00368398860415626,
    -0.00468763515365709,
    -0.00565962901896117,
    -0.00659594247590109,
    -0.00749273173959735,
    -0.00834646977454423,
    -0.00915388079935106,
    -0.00991191973255792,
    -0.01061784301756832,
    -0.01126922086486309,
    -0.01186383723912779,
    -0.01239983460106991,
    -0.01287568013999513,
    -0.01329008915959146,
    -0.01364215071713790,
    -0.01393122434585195,
    -0.01415698551164784,
    -0.01431940131002330,
    -0.01441866957615557,
    -0.01445542015580261,
    -0.01443050749677658,
    -0.01434507293545169,
    -0.01420046905794815,
    -0.01399837760065164,
    -0.01374067611074884,
    -0.01342951430335284,
    -0.01306725428343038,
    -0.01265641436269870,
    -0.01219971665787773,
    -0.01170011662200311,
    -0.01116063279154316,
    -0.01058445110992812,
    -0.00997493139722370,
    -0.00933543932015813,
    -0.00866949145311828,
    -0.00798065494875392,
    -0.00727252936018793,
    -0.00654879033360211,
    -0.00581302932396869,
    -0.00506898291556349,
    -0.00432028178278537,
    -0.00357053440929129,
    -0.00282326699554160,
    -0.00208203124826094,
    -0.00135020256306659,
    -0.00063103035727313,
     0.00007232805793557,
     0.00075683660982927,
     0.00141957379019897,
     0.00205768780478342,
     0.00266860143924592,
     0.00324993121658535,
     0.00379936895241914,
     0.00431491291330377,
     0.00479470876340795,
     0.00523707905343540,
     0.00564061787787662,
     0.00600402908038610,
     0.00632635980820050,
     0.00660670647194163,
     0.00684446936268197,
     0.00703924517357853,
     0.00719086547726478,
     0.00729926431499440,
     0.00736467317988752,
     0.00738755683524542,
     0.00736850650272510,
     0.00730829667020057,
     0.00720795566933598,
     0.00706862358329047,
     0.00689166106006606,
     0.00667860288097523,
     0.00643095607755038,
     0.00615052197181739,
     0.00583925360207582,
     0.00549910374556122,
     0.00513221870184628,
     0.00474066512962890,
     0.00432677797024057,
     0.00389282599206839,
     0.00344125162305609,
     0.00297453184678723,
     0.00249518501937428,
     0.00200561549932857,
     0.00150831200030697,
     0.00100580981004792,
     0.00050054064537188,
    -0.00000510021720529,
    -0.00050861332143407,
    -0.00100763047215160,
    -0.00149988273008190,
    -0.00198308467287910,
    -0.00245521599286468,
    -0.00291421230049393,
    -0.00335803781797961,
    -0.00378501407006123,
    -0.00419335529060513,
    -0.00458153426118093,
    -0.00494790699617962,
    -0.00529116364541816,
    -0.00561009491259851,
    -0.00590364563628709,
    -0.00617084078787042,
    -0.00641094525741611,
    -0.00662330542142012,
    -0.00680738098676911,
    -0.00696291740070549,
    -0.00708983945866153,
    -0.00718797399106537,
    -0.00725732618539724,
    -0.00729816794418049,
    -0.00731071302730038,
    -0.00729548462926118,
    -0.00725310590233133,
    -0.00718412134891488,
    -0.00708955638738724,
    -0.00697016762082324,
    -0.00682700604754216,
    -0.00666104501174753,
    -0.00647362219776383,
    -0.00626609515630557,
    -0.00603981456328648,
    -0.00579610710367070,
    -0.00553651112890187,
    -0.00526258702928093,
    -0.00497582050188001,
    -0.00467781420559223,
    -0.00437029988344991,
    -0.00405483984438457,
    -0.00373310787166800,
    -0.00340706513182573,
    -0.00307825915083395,
    -0.00274821514437812,
    -0.00241860078945069,
    -0.00209068038473532,
    -0.00176628251715446,
    -0.00144669315420265,
    -0.00113337675706832,
    -0.00082756372405074,
    -0.00053066346689203,
    -0.00024392098109945,
     0.00003154445392470,
     0.00029467273966008,
     0.00054427794999990,
     0.00077937709327794,
     0.00099934226424539,
     0.00120351501987113,
     0.00139101528215727,
     0.00156124006182508,
     0.00171378284752017,
     0.00184795635073109,
     0.00196368456897835,
     0.00206112204696501,
     0.00213982670802010,
     0.00220023878816821,
     0.00224213968031843,
     0.00226604184987552,
     0.00227212255816010,
     0.00226065624370992,
     0.00223180282751077,
     0.00218607778995425,
     0.00212422574018319,
     0.00204696675355565,
     0.00195476148431463,
     0.00184822000233493,
     0.00172832071033712,
     0.00159597117033354,
     0.00145182591653782,
     0.00129703502240743,
     0.00113316832424359,
     0.00096085147489087,
     0.00078087436263632,
     0.00059469652279244,
     0.00040235412092678,
     0.00020560880800470,
     0.00000512779377387,
    -0.00019780267489481,
    -0.00040244649221055,
    -0.00060787717816035,
    -0.00081303644896487,
    -0.00101653511846087,
    -0.00121718600564433,
    -0.00141427967202997,
    -0.00160744427312282,
    -0.00179596688100090,
    -0.00197876566155492,
    -0.00215522562254582,
    -0.00232536954635025,
    -0.00248849450539814,
    -0.00264281018369122,
    -0.00278815419153556,
    -0.00292487204565693,
    -0.00305073525100216,
    -0.00316759130875735,
    -0.00327427636592411,
    -0.00337139640413321,
    -0.00345841188171187,
    -0.00353492663316779,
    -0.00360033441590655,
    -0.00365452840464368,
    -0.00369789443981427,
    -0.00373128845127921,
    -0.00375525966010201,
    -0.00376955104706536,
    -0.00377322524762135,
    -0.00376589564617805,
    -0.00374883916858521,
    -0.00372399041633512,
    -0.00369106006498323,
    -0.00364692982502840,
    -0.00359253897581417,
    -0.00353376795048181,
    -0.00346188187838081,
    -0.00338283541291974,
    -0.00329342549919059,
    -0.00319386740022393,
    -0.00308286432789015,
    -0.00295920462008011,
    -0.00282083554270566,
    -0.00266536444034733,
    -0.00248934198640888,
    -0.00228856302674138,
    -0.00205734933893490,
    -0.00178867729388906,
    -0.00147337498214267,
    -0.00110004403106704,
    -0.00065405510582709,
    -0.00011718045021163,
     0.00053371774399288,
     0.00132750863206072,
     0.00230061123021915
};

// Filter for 44100 sample rate (0.02db/70db ripple, transition 17000-22050)
 double filter_44[] = {
    1.00151,
    1.00166,
    1.00167,
    1.00168,
    1.00169,
    1.0017,
    1.0017,
    1.00171,
    1.00172,
    1.00173,
    1.00173,
    1.00174,
    1.00175,
    1.00175,
    1.00175,
    1.00176,
    1.00176,
    1.00176,
    1.00176,
    1.00176,
    1.00175,
    1.00175,
    1.00174,
    1.00174,
    1.00173,
    1.00172,
    1.0017,
    1.00169,
    1.00167,
    1.00165,
    1.00163,
    1.00161,
    1.00159,
    1.00156,
    1.00153,
    1.0015,
    1.00147,
    1.00143,
    1.0014,
    1.00136,
    1.00132,
    1.00128,
    1.00124,
    1.00119,
    1.00115,
    1.0011,
    1.00105,
    1.001,
    1.00095,
    1.0009,
    1.00085,
    1.0008,
    1.00075,
    1.0007,
    1.00065,
    1.0006,
    1.00055,
    1.0005,
    1.00045,
    1.00041,
    1.00036,
    1.00032,
    1.00028,
    1.00024,
    1.0002,
    1.00016,
    1.00013,
    1.0001,
    1.00008,
    1.00005,
    1.00003,
    1.00002,
    1,
    0.999995,
    0.99999,
    0.999988,
    0.999991,
    0.999998,
    1.00001,
    1.00002,
    1.00004,
    1.00007,
    1.00009,
    1.00012,
    1.00016,
    1.0002,
    1.00024,
    1.00029,
    1.00034,
    1.00039,
    1.00045,
    1.00051,
    1.00057,
    1.00064,
    1.00071,
    1.00078,
    1.00085,
    1.00092,
    1.001,
    1.00107,
    1.00115,
    1.00122,
    1.0013,
    1.00137,
    1.00145,
    1.00152,
    1.00159,
    1.00166,
    1.00172,
    1.00179,
    1.00185,
    1.00191,
    1.00196,
    1.00201,
    1.00205,
    1.00209,
    1.00213,
    1.00216,
    1.00218,
    1.0022,
    1.00221,
    1.00221,
    1.00221,
    1.00221,
    1.00219,
    1.00217,
    1.00214,
    1.00211,
    1.00207,
    1.00202,
    1.00196,
    1.0019,
    1.00183,
    1.00176,
    1.00168,
    1.00159,
    1.0015,
    1.00141,
    1.0013,
    1.0012,
    1.00109,
    1.00097,
    1.00086,
    1.00074,
    1.00061,
    1.00049,
    1.00036,
    1.00024,
    1.00011,
    0.999983,
    0.999858,
    0.999734,
    0.999613,
    0.999494,
    0.999379,
    0.999267,
    0.999161,
    0.999059,
    0.998963,
    0.998873,
    0.99879,
    0.998715,
    0.998647,
    0.998588,
    0.998537,
    0.998495,
    0.998463,
    0.99844,
    0.998428,
    0.998426,
    0.998434,
    0.998453,
    0.998483,
    0.998523,
    0.998575,
    0.998637,
    0.998711,
    0.998794,
    0.998889,
    0.998993,
    0.999108,
    0.999232,
    0.999365,
    0.999507,
    0.999657,
    0.999815,
    0.99998,
    1.00015,
    1.00033,
    1.00051,
    1.0007,
    1.00089,
    1.00108,
    1.00128,
    1.00147,
    1.00167,
    1.00187,
    1.00206,
    1.00225,
    1.00244,
    1.00263,
    1.00281,
    1.00298,
    1.00314,
    1.0033,
    1.00345,
    1.00359,
    1.00372,
    1.00384,
    1.00394,
    1.00403,
    1.00411,
    1.00418,
    1.00423,
    1.00427,
    1.00429,
    1.00429,
    1.00428,
    1.00426,
    1.00421,
    1.00415,
    1.00408,
    1.00399,
    1.00388,
    1.00375,
    1.00361,
    1.00345,
    1.00328,
    1.0031,
    1.0029,
    1.00269,
    1.00246,
    1.00223,
    1.00198,
    1.00172,
    1.00146,
    1.00119,
    1.00091,
    1.00062,
    1.00034,
    1.00004,
    0.999752,
    0.999459,
    0.999168,
    0.998878,
    0.998593,
    0.998313,
    0.998039,
    0.997774,
    0.997517,
    0.997271,
    0.997038,
    0.996817,
    0.996611,
    0.99642,
    0.996246,
    0.996089,
    0.995952,
    0.995834,
    0.995737,
    0.995661,
    0.995606,
    0.995575,
    0.995567,
    0.995582,
    0.99562,
    0.995683,
    0.99577,
    0.995881,
    0.996016,
    0.996174,
    0.996356,
    0.996561,
    0.996788,
    0.997037,
    0.997306,
    0.997595,
    0.997903,
    0.998229,
    0.998571,
    0.998929,
    0.9993,
    0.999684,
    1.00008,
    1.00048,
    1.00089,
    1.00131,
    1.00173,
    1.00215,
    1.00257,
    1.00299,
    1.00341,
    1.00382,
    1.00422,
    1.00462,
    1.005,
    1.00537,
    1.00572,
    1.00605,
    1.00637,
    1.00666,
    1.00694,
    1.00718,
    1.00741,
    1.0076,
    1.00777,
    1.00791,
    1.00802,
    1.00809,
    1.00813,
    1.00814,
    1.00812,
    1.00806,
    1.00797,
    1.00785,
    1.00769,
    1.00749,
    1.00727,
    1.007,
    1.00671,
    1.00639,
    1.00603,
    1.00565,
    1.00524,
    1.0048,
    1.00433,
    1.00385,
    1.00334,
    1.00281,
    1.00227,
    1.00171,
    1.00114,
    1.00056,
    0.999967,
    0.999373,
    0.998777,
    0.998181,
    0.997588,
    0.997001,
    0.996422,
    0.995856,
    0.995303,
    0.994767,
    0.994251,
    0.993757,
    0.993288,
    0.992846,
    0.992434,
    0.992054,
    0.991709,
    0.9914,
    0.991129,
    0.990898,
    0.990709,
    0.990563,
    0.990461,
    0.990406,
    0.990396,
    0.990434,
    0.99052,
    0.990653,
    0.990835,
    0.991065,
    0.991342,
    0.991666,
    0.992036,
    0.992452,
    0.992911,
    0.993413,
    0.993956,
    0.994537,
    0.995156,
    0.995808,
    0.996493,
    0.997206,
    0.997947,
    0.99871,
    0.999494,
    1.0003,
    1.00111,
    1.00193,
    1.00276,
    1.0036,
    1.00443,
    1.00526,
    1.00608,
    1.00688,
    1.00767,
    1.00844,
    1.00918,
    1.0099,
    1.01059,
    1.01124,
    1.01185,
    1.01242,
    1.01294,
    1.01341,
    1.01384,
    1.01421,
    1.01452,
    1.01478,
    1.01497,
    1.0151,
    1.01517,
    1.01518,
    1.01511,
    1.01498,
    1.01479,
    1.01452,
    1.01419,
    1.0138,
    1.01333,
    1.01281,
    1.01222,
    1.01156,
    1.01085,
    1.01009,
    1.00927,
    1.00839,
    1.00748,
    1.00651,
    1.00551,
    1.00447,
    1.00339,
    1.00229,
    1.00117,
    1.00003,
    0.998871,
    0.997707,
    0.99654,
    0.995375,
    0.994217,
    0.993073,
    0.991947,
    0.990845,
    0.989772,
    0.988734,
    0.987736,
    0.986782,
    0.985879,
    0.985031,
    0.984242,
    0.983517,
    0.982861,
    0.982278,
    0.981771,
    0.981343,
    0.980999,
    0.98074,
    0.980569,
    0.980489,
    0.980501,
    0.980607,
    0.980807,
    0.981102,
    0.981492,
    0.981977,
    0.982555,
    0.983227,
    0.98399,
    0.984842,
    0.985781,
    0.986804,
    0.987907,
    0.989086,
    0.990338,
    0.991657,
    0.99304,
    0.99448,
    0.995971,
    0.997509,
    0.999086,
    1.0007,
    1.00233,
    1.00399,
    1.00565,
    1.00732,
    1.00899,
    1.01065,
    1.01229,
    1.0139,
    1.01547,
    1.01701,
    1.01849,
    1.01992,
    1.02128,
    1.02257,
    1.02378,
    1.0249,
    1.02593,
    1.02686,
    1.02769,
    1.0284,
    1.029,
    1.02948,
    1.02983,
    1.03005,
    1.03014,
    1.0301,
    1.02992,
    1.0296,
    1.02914,
    1.02853,
    1.02779,
    1.02691,
    1.02589,
    1.02474,
    1.02345,
    1.02203,
    1.02049,
    1.01883,
    1.01705,
    1.01516,
    1.01317,
    1.01108,
    1.00891,
    1.00666,
    1.00433,
    1.00195,
    0.99951,
    0.997031,
    0.994521,
    0.991991,
    0.989452,
    0.986915,
    0.984392,
    0.981896,
    0.979438,
    0.97703,
    0.974684,
    0.972413,
    0.970228,
    0.968142,
    0.966165,
    0.96431,
    0.962588,
    0.961009,
    0.959584,
    0.958323,
    0.957236,
    0.956331,
    0.955617,
    0.955102,
    0.954792,
    0.954694,
    0.954813,
    0.955154,
    0.955721,
    0.956516,
    0.957542,
    0.9588,
    0.960289,
    0.962009,
    0.963958,
    0.966133,
    0.968529,
    0.971141,
    0.973963,
    0.976988,
    0.980207,
    0.983612,
    0.98719,
    0.990931,
    0.994822,
    0.99885,
    1.003,
    1.00726,
    1.0116,
    1.01602,
    1.02049,
    1.025,
    1.02952,
    1.03404,
    1.03854,
    1.04298,
    1.04736,
    1.05165,
    1.05582,
    1.05985,
    1.06372,
    1.0674,
    1.07088,
    1.07412,
    1.07711,
    1.07981,
    1.08221,
    1.08429,
    1.08601,
    1.08736,
    1.08831,
    1.08885,
    1.08896,
    1.0886,
    1.08777,
    1.08645,
    1.08462,
    1.08225,
    1.07935,
    1.07588,
    1.07185,
    1.06724,
    1.06203,
    1.05622,
    1.0498,
    1.04277,
    1.03511,
    1.02684,
    1.01793,
    1.0084,
    0.998249,
    0.987472,
    0.976077,
    0.964071,
    0.951459,
    0.938252,
    0.92446,
    0.910095,
    0.895169,
    0.8797,
    0.863702,
    0.847194,
    0.830194,
    0.812724,
    0.794804,
    0.776459,
    0.757712,
    0.738588,
    0.719113,
    0.699315,
    0.679222,
    0.658863,
    0.638267,
    0.617464,
    0.596485,
    0.575362,
    0.554126,
    0.53281,
    0.511444,
    0.490063,
    0.468698,
    0.447381,
    0.426145,
    0.405022,
    0.384044,
    0.363241,
    0.342644,
    0.322285,
    0.302192,
    0.282394,
    0.26292,
    0.243796,
    0.225048,
    0.206703,
    0.188784,
    0.171313,
    0.154314,
    0.137805,
    0.121808,
    0.106338,
    0.0914128,
    0.0770474,
    0.0632552,
    0.0500482,
    0.0374368,
    0.02543,
    0.0140353,
    0.00325846,
    -0.00689619,
    -0.0164259,
    -0.0253296,
    -0.0336075,
    -0.0412616,
    -0.0482953,
    -0.0547134,
    -0.0605223,
    -0.0657296,
    -0.0703446,
    -0.0743776,
    -0.0778405,
    -0.0807461,
    -0.0831087,
    -0.0849435,
    -0.0862668,
    -0.0870961,
    -0.0874496,
    -0.0873465,
    -0.0868067,
    -0.085851,
    -0.0845007,
    -0.0827777,
    -0.0807045,
    -0.078304,
    -0.0755993,
    -0.0726139,
    -0.0693716,
    -0.0658962,
    -0.0622114,
    -0.0583412,
    -0.0543093,
    -0.0501391,
    -0.045854,
    -0.041477,
    -0.0370305,
    -0.0325368,
    -0.0280174,
    -0.0234934,
    -0.0189852,
    -0.0145124,
    -0.010094,
    -0.00574815,
    -0.00149222,
    0.00265736,
    0.00668505,
    0.0105763,
    0.0143174,
    0.0178958,
    0.0212999,
    0.0245192,
    0.0275442,
    0.0303665,
    0.0329787,
    0.0353747,
    0.0375491,
    0.0394978,
    0.0412179,
    0.0427073,
    0.0439651,
    0.0449912,
    0.0457866,
    0.0463534,
    0.0466945,
    0.0468136,
    0.0467155,
    0.0464055,
    0.04589,
    0.045176,
    0.0442712,
    0.0431839,
    0.0419231,
    0.0404984,
    0.0389196,
    0.0371973,
    0.0353423,
    0.0333658,
    0.0312793,
    0.0290944,
    0.0268231,
    0.0244774,
    0.0220694,
    0.0196112,
    0.0171149,
    0.0145924,
    0.0120557,
    0.00951653,
    0.00698626,
    0.00447614,
    0.00199707,
    -0.000440398,
    -0.0028261,
    -0.0051503,
    -0.00740372,
    -0.00957756,
    -0.0116635,
    -0.013654,
    -0.0155416,
    -0.01732,
    -0.018983,
    -0.0205254,
    -0.0219424,
    -0.0232299,
    -0.0243845,
    -0.0254034,
    -0.0262845,
    -0.0270263,
    -0.0276278,
    -0.028089,
    -0.0284101,
    -0.0285923,
    -0.0286372,
    -0.0285469,
    -0.0283242,
    -0.0279724,
    -0.0274953,
    -0.0268972,
    -0.0261829,
    -0.0253576,
    -0.0244269,
    -0.0233967,
    -0.0222734,
    -0.0210636,
    -0.0197743,
    -0.0184124,
    -0.0169855,
    -0.0155009,
    -0.0139664,
    -0.0123897,
    -0.0107785,
    -0.00914072,
    -0.00748415,
    -0.00581657,
    -0.00414567,
    -0.00247904,
    -0.000824122,
    0.000811806,
    0.00242167,
    0.00399864,
    0.0055361,
    0.00702777,
    0.00846763,
    0.00985001,
    0.0111696,
    0.0124214,
    0.0136008,
    0.0147036,
    0.0157261,
    0.0166649,
    0.0175171,
    0.0182801,
    0.0189518,
    0.0195308,
    0.0200156,
    0.0204057,
    0.0207006,
    0.0209006,
    0.0210061,
    0.0210181,
    0.0209379,
    0.0207674,
    0.0205086,
    0.0201641,
    0.0197366,
    0.0192294,
    0.0186459,
    0.0179898,
    0.0172654,
    0.0164767,
    0.0156284,
    0.0147251,
    0.0137717,
    0.0127734,
    0.0117351,
    0.0106623,
    0.00956021,
    0.0084343,
    0.00728997,
    0.00613266,
    0.00496779,
    0.00380072,
    0.00263674,
    0.00148106,
    0.000338786,
    -0.000785135,
    -0.00188589,
    -0.00295886,
    -0.0039996,
    -0.00500388,
    -0.00596769,
    -0.00688727,
    -0.00775911,
    -0.00857995,
    -0.00934685,
    -0.0100571,
    -0.0107083,
    -0.0112984,
    -0.0118256,
    -0.0122883,
    -0.0126856,
    -0.0130164,
    -0.0132802,
    -0.0134769,
    -0.0136064,
    -0.0136692,
    -0.013666,
    -0.0135976,
    -0.0134653,
    -0.0132706,
    -0.0130153,
    -0.0127014,
    -0.0123312,
    -0.0119071,
    -0.0114317,
    -0.0109081,
    -0.0103391,
    -0.00972812,
    -0.00907837,
    -0.00839339,
    -0.00767676,
    -0.00693215,
    -0.00616333,
    -0.00537411,
    -0.00456834,
    -0.00374988,
    -0.00292262,
    -0.0020904,
    -0.00125705,
    -0.000426361,
    0.000397973,
    0.00121232,
    0.00201313,
    0.00279701,
    0.00356063,
    0.00430086,
    0.00501467,
    0.00569921,
    0.00635182,
    0.00697,
    0.00755145,
    0.00809406,
    0.00859593,
    0.00905537,
    0.00947092,
    0.0098413,
    0.0101655,
    0.0104427,
    0.0106723,
    0.010854,
    0.0109876,
    0.0110732,
    0.0111111,
    0.0111017,
    0.0110459,
    0.0109445,
    0.0107986,
    0.0106095,
    0.0103786,
    0.0101077,
    0.00979852,
    0.00945294,
    0.00907308,
    0.00866113,
    0.00821942,
    0.00775036,
    0.00725645,
    0.00674028,
    0.00620449,
    0.00565179,
    0.0050849,
    0.00450659,
    0.00391962,
    0.00332678,
    0.00273082,
    0.00213448,
    0.00154044,
    0.00095136,
    0.000369823,
    -0.000201655,
    -0.000760641,
    -0.00130479,
    -0.00183187,
    -0.00233974,
    -0.00282638,
    -0.00328992,
    -0.00372859,
    -0.00414077,
    -0.00452498,
    -0.0048799,
    -0.00520436,
    -0.00549732,
    -0.00575792,
    -0.00598547,
    -0.00617941,
    -0.00633935,
    -0.00646508,
    -0.00655651,
    -0.00661375,
    -0.00663703,
    -0.00662675,
    -0.00658344,
    -0.00650777,
    -0.00640057,
    -0.00626279,
    -0.00609549,
    -0.00589987,
    -0.00567721,
    -0.00542893,
    -0.00515653,
    -0.00486158,
    -0.00454576,
    -0.00421079,
    -0.00385847,
    -0.00349065,
    -0.00310921,
    -0.00271609,
    -0.00231321,
    -0.00190256,
    -0.00148609,
    -0.00106578,
    -0.000643564,
    -0.000221387,
    0.000198853,
    0.000615286,
    0.00102609,
    0.00142951,
    0.00182382,
    0.0022074,
    0.00257867,
    0.00293614,
    0.00327841,
    0.00360418,
    0.00391222,
    0.00420141,
    0.00447074,
    0.00471929,
    0.00494627,
    0.00515098,
    0.00533284,
    0.00549138,
    0.00562624,
    0.00573718,
    0.00582408,
    0.0058869,
    0.00592574,
    0.0059408,
    0.00593238,
    0.00590087,
    0.00584678,
    0.00577071,
    0.00567334,
    0.00555544,
    0.00541787,
    0.00526155,
    0.00508749,
    0.00489675,
    0.00469044,
    0.00446975,
    0.00423589,
    0.00399014,
    0.00373378,
    0.00346813,
    0.00319455,
    0.0029144,
    0.00262903,
    0.00233982,
    0.00204814,
    0.00175533,
    0.00146274,
    0.00117168,
    0.000883433,
    0.000599256,
    0.000320363,
    4.79248e-005,
    -0.000216935,
    -0.000473149,
    -0.000719701,
    -0.000955641,
    -0.00118008,
    -0.00139219,
    -0.00159123,
    -0.0017765,
    -0.00194741,
    -0.00210342,
    -0.00224407,
    -0.00236899,
    -0.00247787,
    -0.00257049,
    -0.00264671,
    -0.00270645,
    -0.00274972,
    -0.00277661,
    -0.00278727,
    -0.00278191,
    -0.00276084,
    -0.00272442,
    -0.00267307,
    -0.00260728,
    -0.00252758,
    -0.00243458,
    -0.00232892,
    -0.00221128,
    -0.00208242,
    -0.00194309,
    -0.00179411,
    -0.00163631,
    -0.00147056,
    -0.00129774,
    -0.00111875,
    -0.000934503,
    -0.000745922,
    -0.00055393,
    -0.000359452,
    -0.000163404,
    3.33015e-005,
    0.00022977,
    0.000425118,
    0.00061849,
    0.000809048,
    0.000995982,
    0.00117853,
    0.00135592,
    0.00152747,
    0.00169251,
    0.00185041,
    0.00200059,
    0.00214251,
    0.00227568,
    0.00239966,
    0.00251407,
    0.00261855,
    0.00271283,
    0.00279666,
    0.00286986,
    0.00293229,
    0.00298387,
    0.00302457,
    0.00305441,
    0.00307345,
    0.00308182,
    0.00307966,
    0.00306718,
    0.00304464,
    0.00301232,
    0.00297056,
    0.00291971,
    0.00286018,
    0.0027924,
    0.00271683,
    0.00263396,
    0.0025443,
    0.00244839,
    0.00234675,
    0.00223998,
    0.00212865,
    0.00201335,
    0.00189466,
    0.00177319,
    0.00164953,
    0.00152429,
    0.00139806,
    0.00127143,
    0.00114496,
    0.00101922,
    0.000894769,
    0.000772131,
    0.000651822,
    0.000534338,
    0.000420147,
    0.000309695,
    0.0002034,
    0.000101656,
    4.82389e-006,
    -8.67604e-005,
    -0.000172795,
    -0.000253006,
    -0.000327156,
    -0.000395036,
    -0.000456473,
    -0.000511324,
    -0.000559486,
    -0.000600879,
    -0.000635454,
    -0.000663228,
    -0.000684186,
    -0.000698392,
    -0.000705931,
    -0.000706917,
    -0.00070148,
    -0.000689784,
    -0.000672014,
    -0.000648386,
    -0.000619136,
    -0.000584522,
    -0.000544817,
    -0.000500316,
    -0.000451323,
    -0.000398161,
    -0.000341161,
    -0.000280671,
    -0.000217042,
    -0.000150636,
    -8.18173e-005,
    -1.0957e-005,
    6.15776e-005,
    0.000135415,
    0.00021019,
    0.000285537,
    0.000361099,
    0.000436522,
    0.000511465,
    0.000585588,
    0.000658574,
    0.000730113,
    0.000799871,
    0.000867629,
    0.000933077,
    0.000995961,
    0.00105604,
    0.00111312,
    0.00116698,
    0.00121746,
    0.00126439,
    0.00130761,
    0.00134702,
    0.00138249,
    0.00141396,
    0.00144135,
    0.00146462,
    0.00148374,
    0.00149872,
    0.00150955,
    0.00151627,
    0.00151893,
    0.00151758,
    0.0015123,
    0.00150319,
    0.00149036,
    0.00147392,
    0.00145401,
    0.00143078,
    0.00140439,
    0.00137499,
    0.00134277,
    0.00130791,
    0.00127055,
    0.00123101,
    0.00118938,
    0.00114586,
    0.00110068,
    0.00105405,
    0.00100619,
    0.000957299,
    0.000907575,
    0.000857221,
    0.000806426,
    0.000755389,
    0.000704296,
    0.000653337,
    0.000602686,
    0.000552522,
    0.000503003,
    0.000454292,
    0.000406528,
    0.000359855,
    0.000314395,
    0.000270272,
    0.000227589,
    0.000186451,
    0.00014694,
    0.000109144,
    7.31225e-005,
    3.89463e-005,
    6.65106e-006,
    -2.37071e-005,
    -5.21266e-005,
    -7.86584e-005,
    -0.00010289,
    -0.000125359,
    -0.000145908,
    -0.000164518,
    -0.000181172,
    -0.000195912,
    -0.000208775,
    -0.000219826,
    -0.000229125,
    -0.000236749,
    -0.000242764,
    -0.000247252,
    -0.000250286,
    -0.000251952,
    -0.000252326,
    -0.000251496,
    -0.000249544,
    -0.000246562,
    -0.000242636,
    -0.000237859,
    -0.000232321,
    -0.000226115,
    -0.000219333,
    -0.000212068,
    -0.000204408,
    -0.000196445,
    -0.000188264,
    -0.000179954,
    -0.000171593,
    -0.000163264,
    -0.00015504
};

// Filter for 22050 sample rate (0.1db/45db ripple, transition 6500-11025)
 double filter_22_8[] = {
     0.99346257383417802,
     0.99022815725387459,
     0.99015543570188513,
     0.99008192200660372,
     0.99000821306220022,
     0.98993404335348867,
     0.98986001942530599,
     0.98978586015084802,
     0.98971219833790836,
     0.98963874369256055,
     0.98956613317733555,
     0.98949405828823034,
     0.98942318143470231,
     0.98935317146274737,
     0.98928471540688312,
     0.98921744486910057,
     0.98915207381705861,
     0.98908818817973931,
     0.98902654757632491,
     0.98896668177523106,
     0.98890940824295126,
     0.98885417501820405,
     0.98880188244307798,
     0.98875187772348516,
     0.98870519560117476,
     0.98866104586010972,
     0.98862067921109043,
     0.98858308373844073,
     0.98854990546836685,
     0.98851977695546156,
     0.98849523668007799,
     0.98847405861069504,
     0.98846280919076079,
     0.98845235365883477,
     0.98844375010074736,
     0.98844292436431147,
     0.98844593585925489,
     0.98845521387643132,
     0.98846918983630760,
     0.98848932979088866,
     0.98851467221461164,
     0.98854628243827147,
     0.98858349271701806,
     0.98862712318860180,
     0.98867667480179477,
     0.98873281457808693,
     0.98879516005957868,
     0.98886427225485440,
     0.98893985046204769,
     0.98902236751329253,
     0.98911158408849609,
     0.98920790674763170,
     0.98931115295196270,
     0.98942167043859930,
     0.98953931591779642,
     0.98966436904095867,
     0.98979671430135108,
     0.98993655055031937,
     0.99008378620495197,
     0.99023850327087826,
     0.99040060219124704,
     0.99056997922793000,
     0.99074658393236525,
     0.99092999217286903,
     0.99112078640686718,
     0.99132067891545395,
     0.99152647653079151,
     0.99174000600065038,
     0.99196042821983743,
     0.99218821615420838,
     0.99242283170743784,
     0.99266459969413712,
     0.99291304206457953,
     0.99316839735115148,
     0.99343023100895678,
     0.99369872870661236,
     0.99397346430050060,
     0.99425457560469666,
     0.99454163332863699,
     0.99483473689851454,
     0.99513345284424615,
     0.99543784529545087,
     0.99574746112048029,
     0.99606232443893983,
     0.99638195871081958,
     0.99670636159789139,
     0.99703503929119852,
     0.99736797309222358,
     0.99770465350657811,
     0.99804505973719304,
     0.99838867676815146,
     0.99873552524500919,
     0.99908508216630110,
     0.99943739423656919,
     0.99979182599520933,
     1.00014836769888920,
     1.00050550616605110,
     1.00086439728242230,
     1.00122418090915640,
     1.00158435791790360,
     1.00194471229307420,
     1.00230485026314020,
     1.00266438521769330,
     1.00302299137763160,
     1.00338023450111220,
     1.00373578804075230,
     1.00408917973665930,
     1.00444009244828350,
     1.00478803383622780,
     1.00513268852419400,
     1.00547354583327420,
     1.00581028671587620,
     1.00614238886761710,
     1.00646954269914370,
     1.00679122559220850,
     1.00710713789709990,
     1.00741674955541490,
     1.00771976557388700,
     1.00801564718249350,
     1.00830410510141970,
     1.00858458414716610,
     1.00885679350089140,
     1.00912013698774430,
     1.00937433001969620,
     1.00961877000611940,
     1.00985325970701420,
     1.01007723062076260,
     1.01029076841927030,
     1.01049299706092550,
     1.01068333140839720,
     1.01086191467227860,
     1.01102802892202240,
     1.01118142728034830,
     1.01132168975985910,
     1.01144847418611470,
     1.01156141270704560,
     1.01166016811961400,
     1.01174442099382420,
     1.01181383013738670,
     1.01186810638741380,
     1.01190692296515980,
     1.01193002435854050,
     1.01193710643017520,
     1.01192794281147360,
     1.01190224299563500,
     1.01185980204907940,
     1.01180034954633410,
     1.01172371131985070,
     1.01162964574316310,
     1.01151800979056690,
     1.01138859310221170,
     1.01124129113302400,
     1.01107593748565420,
     1.01089248003553900,
     1.01069079561691270,
     1.01047084436105220,
     1.01023250192454590,
     1.00997571473855370,
     1.00970034843207030,
     1.00940644253641070,
     1.00909436718203920,
     1.00876369050338120,
     1.00841464099325790,
     1.00804733106617480,
     1.00766177498903200,
     1.00725815655098390,
     1.00683656299233730,
     1.00639719429312870,
     1.00594017237301840,
     1.00546574827226890,
     1.00497409325073270,
     1.00446549421379650,
     1.00394016277456010,
     1.00339842227096490,
     1.00284052965126300,
     1.00226685714134310,
     1.00167771385373980,
     1.00107351479648070,
     1.00045461246690710,
     0.99982145984606019,
     0.99917445536014804,
     0.99851409042546724,
     0.99784080379162599,
     0.99715511429267722,
     0.99645749450740795,
     0.99574849389878661,
     0.99502865558008136,
     0.99429859034022605,
     0.99355891923003392,
     0.99281028147822470,
     0.99205332020520465,
     0.99128846881264243,
     0.99051659677672921,
     0.98973848349266091,
     0.98895459065746794,
     0.98816584995883272,
     0.98737285629158300,
     0.98657646440716495,
     0.98577735584731252,
     0.98497641123291768,
     0.98417433893930217,
     0.98337202977596716,
     0.98257023346432903,
     0.98176986534953459,
     0.98097170678172241,
     0.98017669011618769,
     0.97938561321829742,
     0.97859941846508414,
     0.97781892467901543,
     0.97704509122433225,
     0.97627875645381812,
     0.97552089010035037,
     0.97477234441909855,
     0.97403410229720078,
     0.97330703551586528,
     0.97259214023010698,
     0.97189029644729086,
     0.97120248123832109,
     0.97052955329617185,
     0.96987247492222695,
     0.96923211360580397,
     0.96860945608029969,
     0.96800546057223125,
     0.96742106849628595,
     0.96685693892945279,
     0.96631429141998126,
     0.96579381464706548,
     0.96529650567212777,
     0.96482317448520505,
     0.96437475664514227,
     0.96395202281817738,
     0.96355589832975419,
     0.96318714216632362,
     0.96284663814614135,
     0.96253510908895135,
     0.96225340435768536,
     0.96200221562010280,
     0.96178236292812869,
     0.96159450559361348,
     0.96143942095112289,
     0.96131772191588460,
     0.96123013980097527,
     0.96117724204995747,
     0.96115971251353627,
     0.96117806256316829,
     0.96123291618086903,
     0.96132472281609460,
     0.96145405298255615,
     0.96162131215473545,
     0.96182703379219847,
     0.96207156019863194,
     0.96235535262431526,
     0.96267865565388133,
     0.96304183221265327,
     0.96344505528312929,
     0.96388881440283869,
     0.96437307776804004,
     0.96489810438689905,
     0.96546402473474280,
     0.96607092160613339,
     0.96671882728800551,
     0.96740780689331740,
     0.96813777907775522,
     0.96890871797493727,
     0.96972046894943953,
     0.97057293690266855,
     0.97146587741937296,
     0.97239910807204999,
     0.97337228859096470,
     0.97438514597402937,
     0.97543725346559396,
     0.97652825510747432,
     0.97765763350726098,
     0.97882494138934928,
     0.98002956813474207,
     0.98127098101873778,
     0.98254848419220919,
     0.98386145904646760,
     0.98520911307719294,
     0.98659072400733883,
     0.98800538940837412,
     0.98945229969037241,
     0.99093047333311068,
     0.99243903111029741,
     0.99397691243206276,
     0.99554314252835396,
     0.99713646512740362,
     0.99875584350229119,
     1.00040012146242270,
     1.00206798329199960,
     1.00375819609217710,
     1.00546945425925300,
     1.00720034237310060,
     1.00894950434912030,
     1.01071545935136960,
     1.01249675412244140,
     1.01429180766184590,
     1.01609909344776890,
     1.01791695592730360,
     1.01974379769868810,
     1.02157788928689100,
     1.02341755472306820,
     1.02526098565934780,
     1.02710643629602410,
     1.02895203218893210,
     1.03079596175740120,
     1.03263628095711590,
     1.03447110777360440,
     1.03629843409322860,
     1.03811632316291270,
     1.03992272192840350,
     1.04171565039359940,
     1.04349300025653280,
     1.04525272456492680,
     1.04699265745849730,
     1.04871070042329580,
     1.05040466103846010,
     1.05207244966522250,
     1.05371185011848150,
     1.05532058240921160,
     1.05689650325237410,
     1.05843738313615380,
     1.05994090869429370,
     1.06140491935676760,
     1.06282708039470600,
     1.06420516782178100,
     1.06553686096664510,
     1.06681994506720160,
     1.06805208689791350,
     1.06923105733111880,
     1.07035452162352310,
     1.07142025223960120,
     1.07242592838548310,
     1.07336933801220980,
     1.07424817306817480,
     1.07506023323213880,
     1.07580323093170920,
     1.07647499341079820,
     1.07707326837328020,
     1.07759591514141830,
     1.07804071149543110,
     1.07840554351078040,
     1.07868822338827660,
     1.07888668496935170,
     1.07899880586218910,
     1.07902257670329060,
     1.07895593064982600,
     1.07879690107835070,
     1.07854345847318260,
     1.07819368897543200,
     1.07774573081350390,
     1.07719771586272460,
     1.07654772957628200,
     1.07579412105844410,
     1.07493501702175110,
     1.07396879660071500,
     1.07289375418908710,
     1.07170832713989260,
     1.07041087692822320,
     1.06899994630174170,
     1.06747401290029310,
     1.06583171991301180,
     1.06407164850489620,
     1.06219254136789940,
     1.06019308412158080,
     1.05807213386747970,
     1.05582849722403240,
     1.05346114791833600,
     1.05096900703597140,
     1.04835116246342190,
     1.04560665752160010,
     1.04273471112302270,
     1.03973450292668760,
     1.03660538614599580,
     1.03334666666122940,
     1.02995781667282340,
     1.02643827170357760,
     1.02278764642349640,
     1.01900552394184140,
     1.01509167377825870,
     1.01104581956016730,
     1.00686781905503130,
     1.00255752273789560,
     0.99811505662639433,
     0.99354032629828581,
     0.98883357070340150,
     0.98399494538778876,
     0.97902474504270987,
     0.97392328424373831,
     0.96869105384548049,
     0.96332849629018669,
     0.95783622879053154,
     0.95221484244590249,
     0.94646510906945236,
     0.94058777228106960,
     0.93458375632210500,
     0.92845394628545119,
     0.92219940565479830,
     0.91582116480250331,
     0.90932043865209744,
     0.90269840750174679,
     0.89595643081477960,
     0.88909582408573518,
     0.88211808064860198,
     0.87502465206852353,
     0.86781717636880884,
     0.86049725262550092,
     0.85306665869252296,
     0.84552711728771424,
     0.83788053153549369,
     0.83012874475292353,
     0.82227379365769204,
     0.81431767663109311,
     0.80626257578971405,
     0.79811052111493663,
     0.78986384113109331,
     0.78152476992419584,
     0.77309563212899790,
     0.76457883419709383,
     0.75597684426193124,
     0.74729209305307087,
     0.73852717932995127,
     0.72968466368197249,
     0.72076723928294395,
     0.71177754675837679,
     0.70271836683291555,
     0.69359242435223489,
     0.68440259159092998,
     0.67515168247086643,
     0.66584264674703941,
     0.65647836450820729,
     0.64706185070415578,
     0.63759605207950054,
     0.62808405418769753,
     0.61852887024238190,
     0.60893364339372158,
     0.59930143284822424,
     0.58963542104358557,
     0.57993870916723478,
     0.57021452977724429,
     0.56046602727319605,
     0.55069646862766009,
     0.54090902203221036,
     0.53110695897924776,
     0.52129345664108662,
     0.51147185513548621,
     0.50164535919226927,
     0.49181721464190709,
     0.48199071869869009,
     0.47216911719308968,
     0.46235561485492860,
     0.45255355180196605,
     0.44276610520651627,
     0.43299654656098030,
     0.42324804405693212,
     0.41352386466694169,
     0.40382715279059089,
     0.39416114098595229,
     0.38452893044045494,
     0.37493370359179462,
     0.36537851964647894,
     0.35586652175467587,
     0.34640072313002068,
     0.33698420932596918,
     0.32761992708713711,
     0.31831089136331014,
     0.30905998224324654,
     0.29987014948194168,
     0.29074420700126102,
     0.28168502707579979,
     0.27269533455123268,
     0.26377791015220414,
     0.25493539450422542,
     0.24617048078110582,
     0.23748572957224545,
     0.22888373963708289,
     0.22036694170517876,
     0.21193780390998088,
     0.20359873270308335,
     0.19535205271924005,
     0.18719999804446263,
     0.17914489720308358,
     0.17118878017648465,
     0.16333382908125316,
     0.15558204229868300,
     0.14793545654646248,
     0.14039591514165375,
     0.13296532120867580,
     0.12564539746536785,
     0.11843792176565310,
     0.11134449318557467,
     0.10436674974844146,
     0.09750614301939702,
     0.09076416633242983,
     0.08414213518207915,
     0.07764140903167334,
     0.07126316817937840,
     0.06500862754872551,
     0.05887881751207173,
     0.05287480155310709,
     0.04699746476472434,
     0.04124773138827426,
     0.03562634504364518,
     0.03013407754399006,
     0.02477151998869629,
     0.01953928959043845,
     0.01443782879146692,
     0.00946762844638807,
     0.00462900313077536,
    -0.00007775246410896,
    -0.00465248279221745,
    -0.00909494890371860,
    -0.01340524522085428,
    -0.01758324572599023,
    -0.02162909994408162,
    -0.02554295010766438,
    -0.02932507258931932,
    -0.03297569786940054,
    -0.03649524283864625,
    -0.03988409282705233,
    -0.04314281231181884,
    -0.04627192909251061,
    -0.04927213728884584,
    -0.05214408368742331,
    -0.05488858862924517,
    -0.05750643320179461,
    -0.05999857408415913,
    -0.06236592338985560,
    -0.06460956003330289,
    -0.06673051028740398,
    -0.06872996753372260,
    -0.07060907467071945,
    -0.07236914607883513,
    -0.07401143906611646,
    -0.07553737246756513,
    -0.07694830309404664,
    -0.07824575330571607,
    -0.07943118035491047,
    -0.08050622276653849,
    -0.08147244318757466,
    -0.08233154722426773,
    -0.08308515574210569,
    -0.08373514202854823,
    -0.08428315697932752,
    -0.08473111514125564,
    -0.08508088463900626,
    -0.08533432724417436,
    -0.08549335681564955,
    -0.08556000286911407,
    -0.08553623202801250,
    -0.08542411113517499,
    -0.08522564955410004,
    -0.08494296967660396,
    -0.08457813766125458,
    -0.08413334130724164,
    -0.08361069453910358,
    -0.08301241957662162,
    -0.08234065709753244,
    -0.08159765939796222,
    -0.08078559923399818,
    -0.07990676417803318,
    -0.07896335455130643,
    -0.07795767840542450,
    -0.07689194778934641,
    -0.07576848349694215,
    -0.07458951306373687,
    -0.07335737123302490,
    -0.07207428713246836,
    -0.07074259398760426,
    -0.06936450656052921,
    -0.06794234552259092,
    -0.06647833486011696,
    -0.06497480930197702,
    -0.06343392941819735,
    -0.06185800857503476,
    -0.06024927628430464,
    -0.05860987583104563,
    -0.05694208720428321,
    -0.05524812658911894,
    -0.05353008362432048,
    -0.05179015073074984,
    -0.05003042642235581,
    -0.04825307655942242,
    -0.04646014809422662,
    -0.04465374932873579,
    -0.04283586025905171,
    -0.04100853393942739,
    -0.03917370712293891,
    -0.03733338792322413,
    -0.03548945835475492,
    -0.03364386246184700,
    -0.03179841182517069,
    -0.02995498088889117,
    -0.02811531545271400,
    -0.02628122386451098,
    -0.02445438209312658,
    -0.02263651961359197,
    -0.02082923382766902,
    -0.01903418028826447,
    -0.01725288551719260,
    -0.01548693051494325,
    -0.01373776853892361,
    -0.01200688042507594,
    -0.01029562225799989,
    -0.00860540945782240,
    -0.00693754762824542,
    -0.00529326966811388,
    -0.00367389129322627,
    -0.00208056869417662,
    -0.00051433859788541,
     0.00102354272387993,
     0.00253210050106664,
     0.00401027414380497,
     0.00545718442580328,
     0.00687184982683852,
     0.00825346075698437,
     0.00960111478770972,
     0.01091408964196810,
     0.01219159281543951,
     0.01343300569943523,
     0.01463763244482805,
     0.01580494032691633,
     0.01693431872670300,
     0.01802532036858338,
     0.01907742786014799,
     0.02009028524321269,
     0.02106346576212737,
     0.02199669641480436,
     0.02288963693150874,
     0.02374210488473777,
     0.02455385585924003,
     0.02532479475642206,
     0.02605476694085984,
     0.02674374654617174,
     0.02739165222804383,
     0.02799854909943445,
     0.02856446944727816,
     0.02908949606613711,
     0.02957375943133847,
     0.03001751855104785,
     0.03042074162152387,
     0.03078391818029578,
     0.03110722120986184,
     0.03139101363554522,
     0.03163554004197870,
     0.03184126167944178,
     0.03200852085162104,
     0.03213785101808260,
     0.03222965765330819,
     0.03228451127100888,
     0.03230286132064095,
     0.03228533178421977,
     0.03223243403320196,
     0.03214485191829265,
     0.03202315288305436,
     0.03186806824056378,
     0.03168021090604862,
     0.03146035821407448,
     0.03120916947649191,
     0.03092746474522591,
     0.03061593568803589,
     0.03027543166785364,
     0.02990667550442304,
     0.02951055101599984,
     0.02908781718903496,
     0.02863939934897216,
     0.02816606816204947,
     0.02766875918711174,
     0.02714828241419602,
     0.02660563490472447,
     0.02604150533789134,
     0.02545711326194608,
     0.02485311775387764,
     0.02423046022837340,
     0.02359009891195038,
     0.02293302053800543,
     0.02226009259585620,
     0.02157227738688644,
     0.02087043360407031,
     0.02015553831831202,
     0.01942847153697650,
     0.01869022941507869,
     0.01794168373382684,
     0.01718381738035911,
     0.01641748260984497,
     0.01564364915516174,
     0.01486315536909302,
     0.01407696061587969,
     0.01328588371798946,
     0.01249086705245476,
     0.01169270848464259,
     0.01089234036984814,
     0.01009054405821006,
     0.00928823489487501,
     0.00848616260125953,
     0.00768521798686470,
     0.00688610942701225,
     0.00608971754259417,
     0.00529672387534442,
     0.00450798317670918,
     0.00372409034151616,
     0.00294597705744783,
     0.00217410502153460,
     0.00140925362897238,
     0.00065229235595236,
    -0.00009634539585690,
    -0.00083601650604907,
    -0.00156608174590439,
    -0.00228592006460964,
    -0.00299492067323101,
    -0.00369254045850034,
    -0.00437822995744913,
    -0.00505151659129040,
    -0.00571188152597121,
    -0.00635888601188335,
    -0.00699203863273029,
    -0.00761094096230375,
    -0.00821514001956293,
    -0.00880428330716630,
    -0.00937795581708616,
    -0.00993584843678790,
    -0.01047758894038321,
    -0.01100292037961968,
    -0.01151151941655581,
    -0.01200317443809190,
    -0.01247759853884134,
    -0.01293462045895165,
    -0.01337398915816032,
    -0.01379558271680701,
    -0.01419920115485507,
    -0.01458475723199787,
    -0.01495206715908091,
    -0.01530111666920412,
    -0.01563179334786195,
    -0.01594386870223350,
    -0.01623777459789330,
    -0.01651314090437661,
    -0.01676992809036884,
    -0.01700827052687516,
    -0.01722822178273568,
    -0.01742990620136204,
    -0.01761336365147724,
    -0.01777871729884703,
    -0.01792601926803472,
    -0.01805543595638984,
    -0.01816707190898605,
    -0.01826113748567381,
    -0.01833777571215720,
    -0.01839722821490252,
    -0.01843966916145809,
    -0.01846536897729675,
    -0.01847453259599848,
    -0.01846745052436376,
    -0.01844434913098297,
    -0.01840553255323697,
    -0.01835125630320991,
    -0.01828184715964754,
    -0.01819759428543736,
    -0.01809883887286891,
    -0.01798590035193806,
    -0.01785911592568258,
    -0.01771885344617171,
    -0.01756545508784587,
    -0.01739934083810208,
    -0.01722075757422065,
    -0.01703042322674892,
    -0.01682819458509367,
    -0.01661465678658603,
    -0.01639068587283769,
    -0.01615619617194288,
    -0.01591175618551962,
    -0.01565756315356775,
    -0.01539421966671483,
    -0.01512201031298951,
    -0.01484153126724299,
    -0.01455307334831671,
    -0.01425719173971022,
    -0.01395417572123816,
    -0.01364456406292307,
    -0.01332865175803165,
    -0.01300696886496678,
    -0.01267981503344012,
    -0.01234771288169934,
    -0.01201097199909718,
    -0.01167011469001707,
    -0.01132546000205080,
    -0.01097751861410645,
    -0.01062660590248241,
    -0.01027321420657534,
    -0.00991766066693529,
    -0.00956041754345462,
    -0.00920181138351621,
    -0.00884227642896312,
    -0.00848213845889708,
    -0.00812178408372652,
    -0.00776160707497937,
    -0.00740182344824510,
    -0.00704293233187385,
    -0.00668579386471204,
    -0.00632925216103219,
    -0.00597482040239205,
    -0.00562250833212400,
    -0.00527295141083214,
    -0.00492610293397443,
    -0.00458248590301597,
    -0.00424207967240099,
    -0.00390539925804647,
    -0.00357246545702136,
    -0.00324378776371423,
    -0.00291938487664246,
    -0.00259975060476274,
    -0.00228488728630315,
    -0.00197527146127373,
    -0.00167087901006903,
    -0.00137216306433738,
    -0.00107905949445986,
    -0.00079200177051954,
    -0.00051089046632345,
    -0.00023615487243524,
     0.00003234282522032,
     0.00029417648302560,
     0.00054953176959754,
     0.00079797414003990,
     0.00103974212673922,
     0.00127435767996869,
     0.00150214561433967,
     0.00172256783352678,
     0.00193609730338569,
     0.00214189491872323,
     0.00234178742730998,
     0.00253258166130813,
     0.00271598990181186,
     0.00289259460624710,
     0.00306197164293006,
     0.00322407056329885,
     0.00337878762922519,
     0.00352602328385783,
     0.00366585953282613,
     0.00379820479321857,
     0.00392325791638080,
     0.00404090339557795,
     0.00415142088221451,
     0.00425466708654553,
     0.00435098974568112,
     0.00444020632088472,
     0.00452272337212960,
     0.00459830157932284,
     0.00466741377459860,
     0.00472975925609036,
     0.00478589903238249,
     0.00483545064557548,
     0.00487908111715917,
     0.00491629139590578,
     0.00494790161956562,
     0.00497324404328864,
     0.00499338399786972,
     0.00500735995774604,
     0.00501663797492252,
     0.00501964946986595,
     0.00501882373343011,
     0.00501022017534275,
     0.00499976464341678,
     0.00498851522348254,
     0.00496733715409962,
     0.00494279687871603,
     0.00491266836581071,
     0.00487949009573681,
     0.00484189462308717,
     0.00480152797406787,
     0.00475737823300287,
     0.00471069611069250,
     0.00466069139109969,
     0.00460839881597362,
     0.00455316559122645,
     0.00449589205894668,
     0.00443602625785283,
     0.00437438565443844,
     0.00431050001711914,
     0.00424512896507719,
     0.00417785842729469,
     0.00410940237143049,
     0.00403939239947556,
     0.00396851554594759,
     0.00389644065684240,
     0.00382383014161744,
     0.00375037549626962,
     0.00367671368332994,
     0.00360255440887198,
     0.00352853048068931,
     0.00345436077197780,
     0.00338065182757425,
     0.00330713813229282,
     0.00323441658030338
};

// Filter for 22050 sample rate (0.07db/70db ripple, transition 6500-11025)
 double filter_22[] = {
    1.00527,
    1.00548,
    1.0055,
    1.00552,
    1.00554,
    1.00556,
    1.00558,
    1.0056,
    1.00562,
    1.00565,
    1.00567,
    1.00569,
    1.00572,
    1.00574,
    1.00577,
    1.0058,
    1.00583,
    1.00586,
    1.00588,
    1.00591,
    1.00595,
    1.00598,
    1.00601,
    1.00604,
    1.00607,
    1.00611,
    1.00614,
    1.00618,
    1.00621,
    1.00625,
    1.00628,
    1.00632,
    1.00636,
    1.00639,
    1.00643,
    1.00647,
    1.00651,
    1.00654,
    1.00658,
    1.00662,
    1.00666,
    1.0067,
    1.00673,
    1.00677,
    1.00681,
    1.00685,
    1.00689,
    1.00692,
    1.00696,
    1.007,
    1.00703,
    1.00707,
    1.00711,
    1.00714,
    1.00717,
    1.00721,
    1.00724,
    1.00727,
    1.0073,
    1.00733,
    1.00736,
    1.00739,
    1.00742,
    1.00744,
    1.00747,
    1.00749,
    1.00751,
    1.00753,
    1.00755,
    1.00757,
    1.00758,
    1.0076,
    1.00761,
    1.00762,
    1.00763,
    1.00764,
    1.00764,
    1.00764,
    1.00764,
    1.00764,
    1.00764,
    1.00763,
    1.00762,
    1.00761,
    1.00759,
    1.00758,
    1.00756,
    1.00754,
    1.00751,
    1.00748,
    1.00745,
    1.00742,
    1.00738,
    1.00734,
    1.0073,
    1.00726,
    1.00721,
    1.00716,
    1.0071,
    1.00705,
    1.00699,
    1.00692,
    1.00685,
    1.00678,
    1.00671,
    1.00663,
    1.00655,
    1.00647,
    1.00638,
    1.00629,
    1.0062,
    1.0061,
    1.006,
    1.0059,
    1.00579,
    1.00568,
    1.00557,
    1.00545,
    1.00533,
    1.00521,
    1.00508,
    1.00496,
    1.00482,
    1.00469,
    1.00455,
    1.00441,
    1.00427,
    1.00412,
    1.00398,
    1.00382,
    1.00367,
    1.00352,
    1.00336,
    1.0032,
    1.00304,
    1.00287,
    1.0027,
    1.00254,
    1.00237,
    1.0022,
    1.00202,
    1.00185,
    1.00167,
    1.0015,
    1.00132,
    1.00114,
    1.00096,
    1.00078,
    1.0006,
    1.00042,
    1.00024,
    1.00006,
    0.999884,
    0.999705,
    0.999526,
    0.999348,
    0.99917,
    0.998994,
    0.998819,
    0.998645,
    0.998473,
    0.998302,
    0.998134,
    0.997967,
    0.997803,
    0.997641,
    0.997482,
    0.997326,
    0.997172,
    0.997022,
    0.996875,
    0.996732,
    0.996593,
    0.996457,
    0.996326,
    0.996198,
    0.996076,
    0.995958,
    0.995844,
    0.995736,
    0.995633,
    0.995535,
    0.995443,
    0.995357,
    0.995276,
    0.995201,
    0.995133,
    0.995071,
    0.995015,
    0.994966,
    0.994924,
    0.994889,
    0.994861,
    0.99484,
    0.994826,
    0.99482,
    0.994822,
    0.994831,
    0.994848,
    0.994872,
    0.994905,
    0.994946,
    0.994995,
    0.995053,
    0.995118,
    0.995193,
    0.995275,
    0.995366,
    0.995466,
    0.995574,
    0.995691,
    0.995816,
    0.99595,
    0.996093,
    0.996245,
    0.996405,
    0.996573,
    0.996751,
    0.996936,
    0.997131,
    0.997334,
    0.997545,
    0.997764,
    0.997992,
    0.998228,
    0.998472,
    0.998724,
    0.998984,
    0.999251,
    0.999526,
    0.999809,
    1.0001,
    1.0004,
    1.0007,
    1.00101,
    1.00133,
    1.00165,
    1.00198,
    1.00232,
    1.00266,
    1.003,
    1.00336,
    1.00371,
    1.00407,
    1.00444,
    1.00481,
    1.00519,
    1.00556,
    1.00594,
    1.00633,
    1.00671,
    1.0071,
    1.00749,
    1.00789,
    1.00828,
    1.00868,
    1.00907,
    1.00947,
    1.00986,
    1.01026,
    1.01065,
    1.01105,
    1.01144,
    1.01183,
    1.01222,
    1.0126,
    1.01298,
    1.01336,
    1.01373,
    1.0141,
    1.01447,
    1.01482,
    1.01518,
    1.01553,
    1.01587,
    1.0162,
    1.01653,
    1.01684,
    1.01716,
    1.01746,
    1.01775,
    1.01803,
    1.01831,
    1.01857,
    1.01883,
    1.01907,
    1.0193,
    1.01952,
    1.01973,
    1.01992,
    1.0201,
    1.02027,
    1.02043,
    1.02057,
    1.02069,
    1.02081,
    1.02091,
    1.02099,
    1.02106,
    1.02111,
    1.02114,
    1.02116,
    1.02117,
    1.02115,
    1.02112,
    1.02107,
    1.02101,
    1.02093,
    1.02083,
    1.02071,
    1.02057,
    1.02042,
    1.02025,
    1.02006,
    1.01985,
    1.01962,
    1.01937,
    1.01911,
    1.01882,
    1.01852,
    1.0182,
    1.01786,
    1.01751,
    1.01713,
    1.01674,
    1.01632,
    1.01589,
    1.01544,
    1.01498,
    1.01449,
    1.01399,
    1.01348,
    1.01294,
    1.01239,
    1.01182,
    1.01124,
    1.01064,
    1.01002,
    1.00939,
    1.00875,
    1.00809,
    1.00741,
    1.00673,
    1.00603,
    1.00532,
    1.00459,
    1.00386,
    1.00311,
    1.00235,
    1.00158,
    1.00081,
    1.00002,
    0.999229,
    0.998428,
    0.997621,
    0.996806,
    0.995987,
    0.995162,
    0.994333,
    0.993501,
    0.992666,
    0.991828,
    0.99099,
    0.990151,
    0.989312,
    0.988474,
    0.987638,
    0.986805,
    0.985975,
    0.985149,
    0.984328,
    0.983513,
    0.982705,
    0.981904,
    0.981112,
    0.980329,
    0.979556,
    0.978794,
    0.978044,
    0.977306,
    0.976582,
    0.975872,
    0.975178,
    0.974499,
    0.973838,
    0.973194,
    0.972569,
    0.971964,
    0.971378,
    0.970814,
    0.970272,
    0.969752,
    0.969256,
    0.968785,
    0.968338,
    0.967917,
    0.967523,
    0.967157,
    0.966818,
    0.966509,
    0.966228,
    0.965978,
    0.965759,
    0.965572,
    0.965416,
    0.965293,
    0.965204,
    0.965148,
    0.965126,
    0.96514,
    0.965189,
    0.965274,
    0.965395,
    0.965553,
    0.965747,
    0.96598,
    0.96625,
    0.966558,
    0.966904,
    0.967289,
    0.967713,
    0.968176,
    0.968677,
    0.969218,
    0.969798,
    0.970418,
    0.971077,
    0.971775,
    0.972512,
    0.973288,
    0.974104,
    0.974958,
    0.975851,
    0.976782,
    0.977751,
    0.978758,
    0.979802,
    0.980883,
    0.982001,
    0.983155,
    0.984344,
    0.985568,
    0.986827,
    0.988119,
    0.989444,
    0.990802,
    0.992191,
    0.993611,
    0.995061,
    0.996539,
    0.998046,
    0.999581,
    1.00114,
    1.00273,
    1.00434,
    1.00597,
    1.00762,
    1.0093,
    1.01099,
    1.01271,
    1.01443,
    1.01618,
    1.01794,
    1.01971,
    1.02149,
    1.02329,
    1.02509,
    1.0269,
    1.02871,
    1.03053,
    1.03235,
    1.03417,
    1.03599,
    1.0378,
    1.03961,
    1.04142,
    1.04321,
    1.045,
    1.04677,
    1.04853,
    1.05028,
    1.05201,
    1.05372,
    1.0554,
    1.05707,
    1.0587,
    1.06032,
    1.0619,
    1.06345,
    1.06497,
    1.06645,
    1.06789,
    1.0693,
    1.07067,
    1.07199,
    1.07326,
    1.07449,
    1.07567,
    1.0768,
    1.07787,
    1.07889,
    1.07985,
    1.08076,
    1.0816,
    1.08237,
    1.08308,
    1.08373,
    1.0843,
    1.0848,
    1.08523,
    1.08559,
    1.08586,
    1.08606,
    1.08618,
    1.08621,
    1.08616,
    1.08602,
    1.0858,
    1.08548,
    1.08508,
    1.08458,
    1.08398,
    1.08329,
    1.0825,
    1.08161,
    1.08062,
    1.07953,
    1.07834,
    1.07704,
    1.07563,
    1.07411,
    1.07249,
    1.07076,
    1.06891,
    1.06695,
    1.06488,
    1.0627,
    1.0604,
    1.05798,
    1.05544,
    1.05279,
    1.05002,
    1.04713,
    1.04412,
    1.04099,
    1.03774,
    1.03437,
    1.03087,
    1.02726,
    1.02352,
    1.01966,
    1.01567,
    1.01157,
    1.00734,
    1.00299,
    0.998511,
    0.993914,
    0.989194,
    0.984353,
    0.97939,
    0.974305,
    0.9691,
    0.963774,
    0.95833,
    0.952766,
    0.947083,
    0.941284,
    0.935368,
    0.929336,
    0.92319,
    0.91693,
    0.910557,
    0.904073,
    0.897479,
    0.890776,
    0.883966,
    0.87705,
    0.870028,
    0.862904,
    0.855678,
    0.848353,
    0.840928,
    0.833408,
    0.825793,
    0.818084,
    0.810285,
    0.802397,
    0.794422,
    0.786362,
    0.778219,
    0.769995,
    0.761692,
    0.753313,
    0.74486,
    0.736336,
    0.727742,
    0.719081,
    0.710355,
    0.701568,
    0.69272,
    0.683816,
    0.674857,
    0.665846,
    0.656786,
    0.64768,
    0.638529,
    0.629338,
    0.620108,
    0.610842,
    0.601543,
    0.592215,
    0.582858,
    0.573478,
    0.564076,
    0.554655,
    0.545218,
    0.535768,
    0.526308,
    0.516841,
    0.507369,
    0.497896,
    0.488425,
    0.478958,
    0.469498,
    0.460048,
    0.450611,
    0.44119,
    0.431788,
    0.422407,
    0.413051,
    0.403722,
    0.394424,
    0.385158,
    0.375928,
    0.366736,
    0.357586,
    0.348479,
    0.339419,
    0.330409,
    0.32145,
    0.312545,
    0.303698,
    0.29491,
    0.286185,
    0.277524,
    0.26893,
    0.260405,
    0.251952,
    0.243574,
    0.235271,
    0.227047,
    0.218904,
    0.210844,
    0.202869,
    0.19498,
    0.187181,
    0.179473,
    0.171858,
    0.164337,
    0.156913,
    0.149587,
    0.142362,
    0.135237,
    0.128216,
    0.1213,
    0.114489,
    0.107786,
    0.101192,
    0.0947084,
    0.0883359,
    0.0820759,
    0.0759295,
    0.0698978,
    0.0639817,
    0.0581822,
    0.0525001,
    0.0469362,
    0.0414912,
    0.0361658,
    0.0309606,
    0.0258762,
    0.020913,
    0.0160714,
    0.0113517,
    0.0067544,
    0.00227956,
    -0.00207262,
    -0.00630204,
    -0.0104087,
    -0.0143925,
    -0.0182536,
    -0.0219922,
    -0.0256085,
    -0.0291027,
    -0.0324751,
    -0.0357262,
    -0.0388563,
    -0.041866,
    -0.0447559,
    -0.0475265,
    -0.0501785,
    -0.0527127,
    -0.0551298,
    -0.0574307,
    -0.0596162,
    -0.0616873,
    -0.063645,
    -0.0654903,
    -0.0672243,
    -0.0688482,
    -0.070363,
    -0.0717702,
    -0.0730709,
    -0.0742664,
    -0.0753581,
    -0.0763475,
    -0.0772358,
    -0.0780248,
    -0.0787158,
    -0.0793104,
    -0.0798102,
    -0.0802168,
    -0.0805319,
    -0.0807572,
    -0.0808944,
    -0.0809453,
    -0.0809116,
    -0.0807951,
    -0.0805976,
    -0.0803211,
    -0.0799674,
    -0.0795383,
    -0.0790358,
    -0.0784619,
    -0.0778184,
    -0.0771074,
    -0.0763308,
    -0.0754906,
    -0.0745888,
    -0.0736274,
    -0.0726085,
    -0.071534,
    -0.070406,
    -0.0692266,
    -0.0679978,
    -0.0667215,
    -0.0654,
    -0.0640351,
    -0.062629,
    -0.0611836,
    -0.059701,
    -0.0581833,
    -0.0566324,
    -0.0550503,
    -0.053439,
    -0.0518006,
    -0.050137,
    -0.0484501,
    -0.0467419,
    -0.0450143,
    -0.0432692,
    -0.0415086,
    -0.0397342,
    -0.0379479,
    -0.0361516,
    -0.0343471,
    -0.0325361,
    -0.0307205,
    -0.0289018,
    -0.027082,
    -0.0252625,
    -0.0234451,
    -0.0216314,
    -0.019823,
    -0.0180215,
    -0.0162283,
    -0.014445,
    -0.0126731,
    -0.0109139,
    -0.00916888,
    -0.00743942,
    -0.00572682,
    -0.00403238,
    -0.00235737,
    -0.000702984,
    0.000929573,
    0.00253916,
    0.00412467,
    0.00568504,
    0.00721922,
    0.00872623,
    0.0102051,
    0.0116549,
    0.0130748,
    0.014464,
    0.0158216,
    0.0171469,
    0.0184391,
    0.0196976,
    0.0209218,
    0.0221111,
    0.0232648,
    0.0243825,
    0.0254636,
    0.0265079,
    0.0275147,
    0.0284839,
    0.0294149,
    0.0303077,
    0.0311619,
    0.0319772,
    0.0327536,
    0.0334909,
    0.034189,
    0.0348478,
    0.0354673,
    0.0360475,
    0.0365884,
    0.0370902,
    0.0375528,
    0.0379765,
    0.0383615,
    0.0387079,
    0.039016,
    0.039286,
    0.0395183,
    0.0397131,
    0.0398709,
    0.0399919,
    0.0400767,
    0.0401257,
    0.0401392,
    0.0401179,
    0.0400621,
    0.0399726,
    0.0398497,
    0.0396941,
    0.0395065,
    0.0392873,
    0.0390373,
    0.0387571,
    0.0384474,
    0.0381089,
    0.0377423,
    0.0373483,
    0.0369276,
    0.0364811,
    0.0360095,
    0.0355135,
    0.034994,
    0.0344517,
    0.0338875,
    0.0333022,
    0.0326966,
    0.0320715,
    0.0314278,
    0.0307663,
    0.0300878,
    0.0293933,
    0.0286836,
    0.0279595,
    0.0272219,
    0.0264717,
    0.0257096,
    0.0249366,
    0.0241535,
    0.0233612,
    0.0225605,
    0.0217523,
    0.0209374,
    0.0201166,
    0.0192908,
    0.0184608,
    0.0176273,
    0.0167913,
    0.0159535,
    0.0151147,
    0.0142757,
    0.0134372,
    0.0126,
    0.0117649,
    0.0109325,
    0.0101037,
    0.00927905,
    0.00845932,
    0.00764517,
    0.00683728,
    0.00603629,
    0.00524284,
    0.00445755,
    0.00368104,
    0.00291387,
    0.00215664,
    0.00140989,
    0.000674163,
    -5.0026e-005,
    -0.000762165,
    -0.00146178,
    -0.00214839,
    -0.00282155,
    -0.00348084,
    -0.00412584,
    -0.00475615,
    -0.00537141,
    -0.00597126,
    -0.00655536,
    -0.00712339,
    -0.00767506,
    -0.00821009,
    -0.00872821,
    -0.00922919,
    -0.0097128,
    -0.0101788,
    -0.0106271,
    -0.0110575,
    -0.0114698,
    -0.0118639,
    -0.0122398,
    -0.0125972,
    -0.0129361,
    -0.0132566,
    -0.0135585,
    -0.0138418,
    -0.0141065,
    -0.0143527,
    -0.0145803,
    -0.0147895,
    -0.0149802,
    -0.0151526,
    -0.0153068,
    -0.0154428,
    -0.0155609,
    -0.0156611,
    -0.0157436,
    -0.0158086,
    -0.0158562,
    -0.0158867,
    -0.0159003,
    -0.0158971,
    -0.0158775,
    -0.0158417,
    -0.01579,
    -0.0157225,
    -0.0156396,
    -0.0155417,
    -0.0154289,
    -0.0153016,
    -0.0151602,
    -0.0150049,
    -0.0148361,
    -0.0146541,
    -0.0144594,
    -0.0142522,
    -0.0140329,
    -0.0138019,
    -0.0135596,
    -0.0133063,
    -0.0130425,
    -0.0127686,
    -0.0124848,
    -0.0121917,
    -0.0118897,
    -0.0115791,
    -0.0112603,
    -0.0109339,
    -0.0106001,
    -0.0102593,
    -0.00991214,
    -0.00955884,
    -0.00919988,
    -0.00883566,
    -0.0084666,
    -0.0080931,
    -0.00771558,
    -0.00733443,
    -0.00695007,
    -0.0065629,
    -0.00617331,
    -0.00578169,
    -0.00538846,
    -0.00499397,
    -0.00459863,
    -0.0042028,
    -0.00380687,
    -0.00341119,
    -0.00301613,
    -0.00262205,
    -0.0022293,
    -0.00183821,
    -0.00144914,
    -0.00106241,
    -0.000678334,
    -0.000297242,
    8.05573e-005,
    0.000454771,
    0.000825098,
    0.00119126,
    0.00155296,
    0.00190995,
    0.00226197,
    0.00260875,
    0.00295005,
    0.00328564,
    0.00361529,
    0.00393879,
    0.00425592,
    0.00456649,
    0.00487029,
    0.00516717,
    0.00545693,
    0.00573942,
    0.00601448,
    0.00628197,
    0.00654176,
    0.00679371,
    0.0070377,
    0.00727365,
    0.00750143,
    0.00772097,
    0.00793218,
    0.00813499,
    0.00832934,
    0.00851518,
    0.00869245,
    0.00886114,
    0.00902119,
    0.0091726,
    0.00931536,
    0.00944947,
    0.00957492,
    0.00969174,
    0.00979994,
    0.00989955,
    0.00999061,
    0.0100732,
    0.0101473,
    0.010213,
    0.0102704,
    0.0103195,
    0.0103604,
    0.0103933,
    0.0104181,
    0.010435,
    0.0104441,
    0.0104456,
    0.0104394,
    0.0104258,
    0.0104049,
    0.0103767,
    0.0103415,
    0.0102993,
    0.0102504,
    0.0101948,
    0.0101327,
    0.0100642,
    0.00998962,
    0.00990899,
    0.00982249,
    0.00973029,
    0.00963257,
    0.0095295,
    0.00942125,
    0.00930801,
    0.00918993,
    0.00906721,
    0.00894002,
    0.00880855,
    0.00867297,
    0.00853348,
    0.00839025,
    0.00824348,
    0.00809333,
    0.00794,
    0.00778367,
    0.00762453,
    0.00746275,
    0.00729853,
    0.00713204,
    0.00696347,
    0.00679298,
    0.00662077,
    0.006447,
    0.00627186,
    0.00609552,
    0.00591814,
    0.0057399,
    0.00556096,
    0.00538148,
    0.00520164,
    0.00502158,
    0.00484147,
    0.00466146,
    0.00448169,
    0.00430233,
    0.0041235,
    0.00394536,
    0.00376805,
    0.00359169,
    0.00341642,
    0.00324237,
    0.00306966,
    0.0028984,
    0.00272874,
    0.00256076,
    0.00239459,
    0.00223033,
    0.00206809,
    0.00190794,
    0.00175,
    0.00159436,
    0.0014411,
    0.00129029,
    0.00114204,
    0.000996396,
    0.000853436,
    0.000713249,
    0.000575857,
    0.000441339,
    0.000309762,
    0.000181167,
    5.55972e-005,
    -6.69084e-005,
    -0.000186301,
    -0.000302546,
    -0.000415606,
    -0.000525462,
    -0.000632087,
    -0.000735468,
    -0.00083558,
    -0.000932412,
    -0.00102595,
    -0.00111618,
    -0.00120311,
    -0.00128674,
    -0.00136707,
    -0.00144411,
    -0.00151787,
    -0.00158836,
    -0.00165558,
    -0.00171958,
    -0.00178035,
    -0.00183794,
    -0.00189235,
    -0.00194363,
    -0.0019918,
    -0.00203689,
    -0.00207899,
    -0.00211805,
    -0.00215415,
    -0.00218736,
    -0.0022177,
    -0.00224522,
    -0.00226995,
    -0.00229195,
    -0.00231127,
    -0.00232799,
    -0.00234214,
    -0.00235378,
    -0.00236296,
    -0.00236974,
    -0.00237417,
    -0.00237633,
    -0.00237626,
    -0.00237405,
    -0.00236974,
    -0.0023634,
    -0.00235509,
    -0.00234489,
    -0.00233283,
    -0.002319,
    -0.00230346,
    -0.00228628,
    -0.0022675,
    -0.00224722,
    -0.00222548,
    -0.00220237,
    -0.00217795,
    -0.00215218,
    -0.00212533,
    -0.00209732,
    -0.00206822,
    -0.0020381,
    -0.00200703,
    -0.0019751,
    -0.00194237,
    -0.00190888,
    -0.00187469,
    -0.00183986,
    -0.00180443,
    -0.00176848,
    -0.00173205,
    -0.00169521,
    -0.00165802,
    -0.00162053,
    -0.00158278,
    -0.00154484,
    -0.00150672,
    -0.0014685,
    -0.00143021,
    -0.0013919,
    -0.00135361,
    -0.00131539,
    -0.00127727,
    -0.00123932,
    -0.00120154,
    -0.001164,
    -0.00112671,
    -0.00108965,
    -0.00105326,
    -0.00101681,
    -0.00098078,
    -0.000945235,
    -0.00091022,
    -0.000875696,
    -0.000841671,
    -0.000808133,
    -0.000775112,
    -0.000742626,
    -0.000710715,
    -0.000679403,
    -0.000648727,
    -0.000618705,
    -0.00058936,
    -0.000560701,
    -0.000532742,
    -0.000505483,
    -0.000478931,
    -0.000453084,
    -0.000427947,
    -0.000403515,
    -0.000379795,
    -0.000356783,
    -0.000334486,
    -0.0003129,
    -0.000292033,
    -0.000271881,
    -0.000252452,
    -0.000233741,
    -0.000215753,
};

// Filter for 11025 sample rate, 8-bit (0.4/45db ripple, transition 2000-5512
 double filter_11_8[] = {
     0.98245761126257036,
     0.98523342954552928,
     0.98536009317054163,
     0.98548983304522442,
     0.98562232825952656,
     0.98575799353555449,
     0.98589649297130322,
     0.98603823984952121,
     0.98618289377045343,
     0.98633087239925721,
     0.98648180584925838,
     0.98663611283130759,
     0.98679340279827776,
     0.98695409459981331,
     0.98711776630807524,
     0.98728484793179616,
     0.98745487115288488,
     0.98762829099301108,
     0.98780459373554208,
     0.98798428136760241,
     0.98816679467026625,
     0.98835271492901133,
     0.98854143469413847,
     0.98873367372696030,
     0.98892876987865197,
     0.98912764625303706,
     0.98932955088883501,
     0.98953567045029689,
     0.98974498612766193,
     0.98995903328432266,
     0.99017589573590203,
     0.99039749647453013,
     0.99061704938041995,
     0.99084231598364414,
     0.99107326579962451,
     0.99130576440574480,
     0.99154271241665237,
     0.99178239963167680,
     0.99202614811479972,
     0.99227294513832409,
     0.99252364258137671,
     0.99277753980926442,
     0.99303525493288014,
     0.99329624758129276,
     0.99356098715359842,
     0.99382904076973977,
     0.99410076989498886,
     0.99437582929075086,
     0.99465450785530951,
     0.99493653346176902,
     0.99522214697465106,
     0.99551114916808026,
     0.99580374805415384,
     0.99609981547342619,
     0.99639951203179289,
     0.99670274818397075,
     0.99700960156556395,
     0.99731996626253472,
     0.99763379054663304,
     0.99795096302800745,
     0.99827129909495338,
     0.99859488303481159,
     0.99892165669914457,
     0.99925261130812604,
     0.99958737964485322,
     0.99992413657418033,
     1.00026513492541660,
     1.00060904726480020,
     1.00095655748673810,
     1.00130711555880470,
     1.00166114144706690,
     1.00201822578555920,
     1.00237868385608890,
     1.00274216021310350,
     1.00310892026955930,
     1.00347865051756720,
     1.00385158180250070,
     1.00422744036538920,
     1.00460643597895550,
     1.00498832331263380,
     1.00537330306193360,
     1.00576114877776820,
     1.00615204269488290,
     1.00654575456220250,
     1.00694242869189910,
     1.00734181418109190,
     1.00774402885313560,
     1.00814880901747590,
     1.00855629811488570,
     1.00896627356457610,
     1.00937894248158020,
     1.00979414722741370,
     1.01021210450006920,
     1.01063248439342180,
     1.01105524262588430,
     1.01147981630316840,
     1.01190745377393370,
     1.01233703954327360,
     1.01276888786251540,
     1.01320287501509810,
     1.01363900327485830,
     1.01407712960006770,
     1.01451727756952460,
     1.01495928797068840,
     1.01540320507651740,
     1.01584886402212550,
     1.01629631308650190,
     1.01674539132783900,
     1.01719614616166520,
     1.01764841214431570,
     1.01810223500577220,
     1.01855743003772360,
     1.01901402925912740,
     1.01947182828180890,
     1.01993085561276800,
     1.02039090639195500,
     1.02085203342270780,
     1.02131404100166720,
     1.02177701965981150,
     1.02224076408318080,
     1.02270535408254170,
     1.02317053498244780,
     1.02363633340730730,
     1.02410243536218590,
     1.02456897247055380,
     1.02503575803676350,
     1.02550311238829670,
     1.02597029552837430,
     1.02643749538787650,
     1.02690477821247120,
     1.02737181360216100,
     1.02783863500364700,
     1.02830508978253770,
     1.02877111324882020,
     1.02923661066799200,
     1.02970147717287190,
     1.03016563740410330,
     1.03062897128039400,
     1.03109140550847230,
     1.03155280091077460,
     1.03201308524260530,
     1.03247209810815250,
     1.03292977532181120,
     1.03338595660900980,
     1.03384059590378950,
     1.03429353820746980,
     1.03474474919262490,
     1.03519405922836620,
     1.03564142878791790,
     1.03608665536405710,
     1.03652968272385390,
     1.03697031050003010,
     1.03740849460312550,
     1.03784407836639780,
     1.03827706858147390,
     1.03870726360935840,
     1.03913455757784150,
     1.03955863839501130,
     1.03997959348739410,
     1.04039740729980790,
     1.04081163080262720,
     1.04122238900750610,
     1.04162946797165530,
     1.04203276814161390,
     1.04243216479696720,
     1.04282751503890370,
     1.04321871053428070,
     1.04360559460462720,
     1.04398805511035550,
     1.04436592625155810,
     1.04473910353130810,
     1.04510741779266890,
     1.04547078093038710,
     1.04582902617817370,
     1.04618206535312090,
     1.04652972217390490,
     1.04687189766857670,
     1.04720840154457790,
     1.04753913152180610,
     1.04786389848916460,
     1.04818261016560400,
     1.04849510461864640,
     1.04880128124050280,
     1.04910098137903970,
     1.04939406726644210,
     1.04968033079882430,
     1.04995963413808080,
     1.05023186278361310,
     1.05049694542374490,
     1.05075471428805930,
     1.05100483660475090,
     1.05124741353209770,
     1.05148221182271920,
     1.05170903247281070,
     1.05192781007978200,
     1.05213831557031190,
     1.05234047166573790,
     1.05253405897340070,
     1.05271898837650930,
     1.05289505482071100,
     1.05306217304150770,
     1.05322014088323450,
     1.05336887311165150,
     1.05350816086488040,
     1.05363790546745410,
     1.05375789818467910,
     1.05386803748729970,
     1.05396812339294650,
     1.05405806076730600,
     1.05413765995455640,
     1.05420682151951530,
     1.05426535774043550,
     1.05431313761994510,
     1.05434997460452530,
     1.05437573041168900,
     1.05439023421978550,
     1.05439339673529830,
     1.05438506713014250,
     1.05436509046686510,
     1.05433325914471230,
     1.05428943237589070,
     1.05423357422722020,
     1.05416546315761070,
     1.05408485673663770,
     1.05399178056434620,
     1.05388593017663260,
     1.05376727958501530,
     1.05363558133100300,
     1.05349078165370050,
     1.05333265977535100,
     1.05316114802573880,
     1.05297602512825850,
     1.05277721544826220,
     1.05256449906840350,
     1.05233779843292540,
     1.05209691011801660,
     1.05184175674981930,
     1.05157214216163710,
     1.05128798419510620,
     1.05098908420466500,
     1.05067534807220890,
     1.05034657968613660,
     1.05000267927336390,
     1.04964347462548700,
     1.04926887964236240,
     1.04887872498491120,
     1.04847293427804740,
     1.04805129585905710,
     1.04761370658430410,
     1.04715999523535030,
     1.04669011680370590,
     1.04620389254850420,
     1.04570117840708730,
     1.04518177787088580,
     1.04464575439954550,
     1.04409277673880440,
     1.04352286466177050,
     1.04293579908916770,
     1.04233153562843080,
     1.04170988199091540,
     1.04107077609005680,
     1.04041403095068200,
     1.03973959103365860,
     1.03904727888717140,
     1.03833704309167210,
     1.03760871434555440,
     1.03686223214256420,
     1.03609742647509510,
     1.03531423490178340,
     1.03451248955855650,
     1.03369213385989970,
     1.03285301316600100,
     1.03199507924788470,
     1.03111818711981410,
     1.03022228576909240,
     1.02930721066247970,
     1.02837291982045010,
     1.02741923068919560,
     1.02644613286859700,
     1.02545348228074200,
     1.02444124931237450,
     1.02340923889915090,
     1.02235742911019180,
     1.02128569218495510,
     1.02019406240910860,
     1.01908226798545230,
     1.01795037404459990,
     1.01679822918952680,
     1.01562578462668300,
     1.01443293045144370,
     1.01321962236791370,
     1.01198575424193990,
     1.01073129886324290,
     1.00945614444055960,
     1.00816026478007070,
     1.00684354598381960,
     1.00550596081110280,
     1.00414740290478280,
     1.00276785734981000,
     1.00136722289082210,
     0.99994549578012959,
     0.99850257740515980,
     0.99703846416928943,
     0.99555305187153142,
     0.99404633734716497,
     0.99251821231472348,
     0.99096870144233629,
     0.98939769364179075,
     0.98780523476811855,
     0.98619121244583241,
     0.98455563339379282,
     0.98289840248628024,
     0.98121958021334355,
     0.97951908253847275,
     0.97779692547865249,
     0.97605297884530218,
     0.97428734520835802,
     0.97249994488233427,
     0.97069075168380703,
     0.96885976839318511,
     0.96700698661147821,
     0.96513238203362284,
     0.96323596882368578,
     0.96131770304386988,
     0.95937761257012433,
     0.95741565823433517,
     0.95543188036572624,
     0.95342624867997006,
     0.95139881220531364,
     0.94934953610049999,
     0.94727847583111580,
     0.94518559296341687,
     0.94307094599211627,
     0.94093449998913059,
     0.93877632678368750,
     0.93659639750354973,
     0.93439480126930996,
     0.93217149826034096,
     0.92992658147905916,
     0.92766001424245059,
     0.92537187817886712,
     0.92306218809536200,
     0.92073102970094445,
     0.91837837703829250,
     0.91600430348556983,
     0.91360882911014396,
     0.91119207330830010,
     0.90875402454250920,
     0.90629473287492790,
     0.90381429638234267,
     0.90131275386755094,
     0.89879014685756509,
     0.89624656576049844,
     0.89368203524157397,
     0.89109667191149311,
     0.88849050525903028,
     0.88586365543157830,
     0.88321615232521655,
     0.88054811652117704,
     0.87785957604782239,
     0.87515066188078472,
     0.87242140532825441,
     0.86967194552103266,
     0.86690232349300067,
     0.86411268538097918,
     0.86130307288980446,
     0.85847363516480513,
     0.85562441034593439,
     0.85275555570105477,
     0.84986712677182952,
     0.84695927288156203,
     0.84403208151540765,
     0.84108566975892618,
     0.83812011104196271,
     0.83513557231612501,
     0.83213215547253272,
     0.82910999921587014,
     0.82606917282042391,
     0.82300983385559612,
     0.81993212519478786,
     0.81683615095905748,
     0.81372201897128482,
     0.81058992159263510,
     0.80743993574044981,
     0.80427226665723184,
     0.80108699033536290,
     0.79788430333709282,
     0.79466429112383330,
     0.79142715334766034,
     0.78817298457755580,
     0.78490199319081289,
     0.78161427747412537,
     0.77831004839473050,
     0.77498941164205082,
     0.77165257564742928,
     0.76829964925067484,
     0.76493084471600170,
     0.76154627867343516,
     0.75814616903403798,
     0.75473064334116036,
     0.75129990382824663,
     0.74785409852902174,
     0.74439341136931825,
     0.74091800803239949,
     0.73742811797948582,
     0.73392386686688804,
     0.73040545725789585,
     0.72687304225226523,
     0.72332686529823342,
     0.71976707624696190,
     0.71619387020638503,
     0.71260741811166362,
     0.70900798895813977,
     0.70539568463792990,
     0.70177078054954733,
     0.69813339557025544,
     0.69448379494104107,
     0.69082212235302642,
     0.68714863918085101,
     0.68346349588918764,
     0.67976695271420307,
     0.67605916166710944,
     0.67234038325780665,
     0.66861077693369031,
     0.66487059947103622,
     0.66112001828121414,
     0.65735929360965784,
     0.65358859729414231,
     0.64980818782923089,
     0.64601824179541412,
     0.64221900997513870,
     0.63841068837603365,
     0.63459352204225805,
     0.63076771368096740,
     0.62693352376086098,
     0.62309109909982896,
     0.61924073388422229,
     0.61538261962896912,
     0.61151703500157395,
     0.60764413678227103,
     0.60376420920164575,
     0.59987744996643888,
     0.59598415033142826,
     0.59208443583895398,
     0.58817863652184699,
     0.58426691277991949,
     0.58034956549725958,
     0.57642677844523482,
     0.57249883432747595,
     0.56856592085161517,
     0.56462832155541709,
     0.56068622690324954,
     0.55673992244204140,
     0.55278960207272065,
     0.54883554760161479,
     0.54487795859056365,
     0.54091711725400371,
     0.53695322133960710,
     0.53298655367912207,
     0.52901731541646413,
     0.52504578842616390,
     0.52107218057112548,
     0.51709676691617179,
     0.51311974858766651,
     0.50914141545124880,
     0.50516193802072207,
     0.50118166292778965,
     0.49720075801484642,
     0.49321951016635390,
     0.48923810109621624,
     0.48525685324772372,
     0.48127594833478055,
     0.47729567324184813,
     0.47331619581132139,
     0.46933786267490363,
     0.46536084434639841,
     0.46138543069144466,
     0.45741182283640625,
     0.45344029584610601,
     0.44947105758344813,
     0.44550438992296310,
     0.44154049400856654,
     0.43757965267200666,
     0.43362206366095546,
     0.42966800918984954,
     0.42571768882052879,
     0.42177138435932060,
     0.41782928970715300,
     0.41389169041095497,
     0.40995877693509425,
     0.40603083281733532,
     0.40210804576531056,
     0.39819069848265065,
     0.39427897474072315,
     0.39037317542361616,
     0.38647346093114188,
     0.38258016129613120,
     0.37869340206092433,
     0.37481347448029900,
     0.37094057626099608,
     0.36707499163360097,
     0.36321687737834774,
     0.35936651216274113,
     0.35552408750170911,
     0.35168989758160268,
     0.34786408922031209,
     0.34404692288653654,
     0.34023860128743144,
     0.33643936946715597,
     0.33264942343333920,
     0.32886901396842777,
     0.32509831765291219,
     0.32133759298135589,
     0.31758701179153376,
     0.31384683432887966,
     0.31011722800476332,
     0.30639844959546053,
     0.30269065854836691,
     0.29899411537338239,
     0.29530897208171908,
     0.29163548890954372,
     0.28797381632152913,
     0.28432421569231475,
     0.28068683071302292,
     0.27706192662464030,
     0.27344962230443043,
     0.26985019315090664,
     0.26626374105618517,
     0.26269053501560835,
     0.25913074596433688,
     0.25558456901030513,
     0.25205215400467451,
     0.24853374439568227,
     0.24502949328308446,
     0.24153960323017082,
     0.23806419989325203,
     0.23460351273354849,
     0.23115770743432365,
     0.22772696792140992,
     0.22431144222853236,
     0.22091133258913520,
     0.21752676654656866,
     0.21415796201189549,
     0.21080503561514108,
     0.20746819962051957,
     0.20414756286783983,
     0.20084333378844499,
     0.19755561807175753,
     0.19428462668501462,
     0.19103045791491005,
     0.18779332013873706,
     0.18457330792547755,
     0.18137062092720743,
     0.17818534460533847,
     0.17501767552212052,
     0.17186768966993526,
     0.16873559229128560,
     0.16562146030351296,
     0.16252548606778253,
     0.15944777740697430,
     0.15638843844214650,
     0.15334761204670033,
     0.15032545579003770,
     0.14732203894644541,
     0.14433750022060773,
     0.14137194150364424,
     0.13842552974716271,
     0.13549833838100830,
     0.13259048449074076,
     0.12970205556151557,
     0.12683320091663591,
     0.12398397609776518,
     0.12115453837276587,
     0.11834492588159116,
     0.11555528776956962,
     0.11278566574153764,
     0.11003620593431587,
     0.10730694938178555,
     0.10459803521474789,
     0.10190949474139328,
     0.09924145893735377,
     0.09659395583099203,
     0.09396710600354008,
     0.09136093935107723,
     0.08877557602099634,
     0.08621104550207182,
     0.08366746440500517,
     0.08114485739501928,
     0.07864331488022758,
     0.07616287838764232,
     0.07370358672006108,
     0.07126553795427019,
     0.06884878215242639,
     0.06645330777700056,
     0.06407923422427787,
     0.06172658156162596,
     0.05939542316720846,
     0.05708573308370337,
     0.05479759702011989,
     0.05253102978351130,
     0.05028611300222947,
     0.04806280999326050,
     0.04586121375902068,
     0.04368128447888289,
     0.04152311127343975,
     0.03938666527045403,
     0.03727201829915348,
     0.03517913543145458,
     0.03310807516207043,
     0.03105879905725677,
     0.02903136258260031,
     0.02702573089684415,
     0.02504195302823527,
     0.02307999869244611,
     0.02113990821870054,
     0.01922164243888462,
     0.01732522922894760,
     0.01545062465109222,
     0.01359784286938528,
     0.01176685957876330,
     0.00995766638023601,
     0.00817026605421226,
     0.00640463241726809,
     0.00466068578391777,
     0.00293852872409756,
     0.00123803104922676,
    -0.00044079122370993,
    -0.00209802213122252,
    -0.00373360118326210,
    -0.00534762350554824,
    -0.00694008237922050,
    -0.00851109017976599,
    -0.01006060105215314,
    -0.01158872608459460,
    -0.01309544060896102,
    -0.01458085290671905,
    -0.01604496614258945,
    -0.01748788451755920,
    -0.01890961162825166,
    -0.02031024608723959,
    -0.02168979164221233,
    -0.02304834954853231,
    -0.02438593472124912,
    -0.02570265351750016,
    -0.02699853317798907,
    -0.02827368760067224,
    -0.02952814297936920,
    -0.03076201110534294,
    -0.03197531918887276,
    -0.03316817336411196,
    -0.03434061792695582,
    -0.03549276278202899,
    -0.03662465672288146,
    -0.03773645114653765,
    -0.03882808092238418,
    -0.03989981784762080,
    -0.04095162763657997,
    -0.04198363804980352,
    -0.04299587101817097,
    -0.04398852160602606,
    -0.04496161942662479,
    -0.04591530855787920,
    -0.04684959939990877,
    -0.04776467450652158,
    -0.04866057585724318,
    -0.04953746798531384,
    -0.05039540190343007,
    -0.05123452259732875,
    -0.05205487829598559,
    -0.05285662363921265,
    -0.05363981521252429,
    -0.05440462087999351,
    -0.05515110308298369,
    -0.05587943182910150,
    -0.05658966762460087,
    -0.05728197977108811,
    -0.05795641968811145,
    -0.05861316482748640,
    -0.05925227072834500,
    -0.05987392436586040,
    -0.06047818782659727,
    -0.06106525339919996,
    -0.06163516547623388,
    -0.06218814313697507,
    -0.06272416660831530,
    -0.06324356714451675,
    -0.06374628128593371,
    -0.06423250554113542,
    -0.06470238397277969,
    -0.06515609532173358,
    -0.06559368459648649,
    -0.06601532301547683,
    -0.06642111372234050,
    -0.06681126837979176,
    -0.06718586336291650,
    -0.06754506801079339,
    -0.06788896842356613,
    -0.06821773680963832,
    -0.06853147294209448,
    -0.06883037293253566,
    -0.06911453089906663,
    -0.06938414548724887,
    -0.06963929885544636,
    -0.06988018717035513,
    -0.07010688780583327,
    -0.07031960418569187,
    -0.07051841386568822,
    -0.07070353676316855,
    -0.07087504851278065,
    -0.07103317039113027,
    -0.07117797006843268,
    -0.07130966832244487,
    -0.07142831891406215,
    -0.07153416930177579,
    -0.07162724547406733,
    -0.07170785189504034,
    -0.07177596296464978,
    -0.07183182111332030,
    -0.07187564788214190,
    -0.07190747920429459,
    -0.07192745586757195,
    -0.07193578547272790,
    -0.07193262295721506,
    -0.07191811914911860,
    -0.07189236334195490,
    -0.07185552635737465,
    -0.07180774647786503,
    -0.07174921025694470,
    -0.07168004869198578,
    -0.07160044950473528,
    -0.07151051213037575,
    -0.07141042622472883,
    -0.07130028692210820,
    -0.07118029420488314,
    -0.07105054960230955,
    -0.07091126184908056,
    -0.07076252962066358,
    -0.07060456177893681,
    -0.07043744355814001,
    -0.07026137711393832,
    -0.07007644771082976,
    -0.06988286040316695,
    -0.06968070430774108,
    -0.06947019881721124,
    -0.06925142121024004,
    -0.06902460056014848,
    -0.06878980226952693,
    -0.06854722534217998,
    -0.06829710302548847,
    -0.06803933416117407,
    -0.06777425152104218,
    -0.06750202287550976,
    -0.06722271953625318,
    -0.06693645600387110,
    -0.06664337011646863,
    -0.06634366997793173,
    -0.06603749335607526,
    -0.06572499890303281,
    -0.06540628722659342,
    -0.06508152025923483,
    -0.06475079028200678,
    -0.06441428640600547,
    -0.06407211091133373,
    -0.06372445409054962,
    -0.06337141491560250,
    -0.06301316966781598,
    -0.06264980653009779,
    -0.06228149226873701,
    -0.06190831498898705,
    -0.06153044384778457,
    -0.06114798334205627,
    -0.06076109927170980,
    -0.06036990377633274,
    -0.05997455353439625,
    -0.05957515687904290,
    -0.05917185670908420,
    -0.05876477774493502,
    -0.05835401954005618,
    -0.05793979603723697,
    -0.05752198222482310,
    -0.05710102713244038,
    -0.05667694631527060,
    -0.05624965234678756,
    -0.05581945731890320,
    -0.05538646710382703,
    -0.05495088334055460,
    -0.05451269923745914,
    -0.05407207146128300,
    -0.05362904410148621,
    -0.05318381752534701,
    -0.05273644796579538,
    -0.05228713793005421,
    -0.05183592694489917,
    -0.05138298464121887,
    -0.05092834534643923,
    -0.05047216405924055,
    -0.05001448684558199,
    -0.04955547398003474,
    -0.04909518964820403,
    -0.04863379424590168,
    -0.04817136001782338,
    -0.04770802614153256,
    -0.04724386591030125,
    -0.04677899940542133,
    -0.04631350198624956,
    -0.04584747851996703,
    -0.04538102374107639,
    -0.04491420233959043,
    -0.04444716694990054,
    -0.04397988412530592,
    -0.04351268426580363,
    -0.04304550112572615,
    -0.04257814677419294,
    -0.04211136120798329,
    -0.04164482409961554,
    -0.04117872214473695,
    -0.04071292371987746,
    -0.04024774281997145,
    -0.03978315282061048,
    -0.03931940839724130,
    -0.03885642973909707,
    -0.03839442216013774,
    -0.03793329512938486,
    -0.03747324435019787,
    -0.03701421701923892,
    -0.03655641799655743,
    -0.03609981877515357,
    -0.03564462374320226,
    -0.03519080088174558,
    -0.03473853489909502,
    -0.03428778006526888,
    -0.03383870182393182,
    -0.03339125275955542,
    -0.03294559381394730,
    -0.03250167670811824,
    -0.03205966630695450,
    -0.03161951833749758,
    -0.03118139201228815,
    -0.03074526375252799,
    -0.03031127659994520,
    -0.02987942828070345,
    -0.02944984251136359,
    -0.02902220504059826,
    -0.02859763136331410,
    -0.02817487313085160,
    -0.02775449323749896,
    -0.02733653596484358,
    -0.02692133121901001,
    -0.02650866230200585,
    -0.02609868685231539,
    -0.02569119775490567,
    -0.02528641759056534,
    -0.02488420291852164,
    -0.02448481742932873,
    -0.02408814329963219,
    -0.02369443143231267,
    -0.02330353751519801,
    -0.02291569179936333,
    -0.02253071205006358,
    -0.02214882471638527,
    -0.02176982910281903,
    -0.02139397053993052,
    -0.02102103925499716,
    -0.02065130900698921,
    -0.02028454895053336,
    -0.01992107259351867,
    -0.01956061452298893,
    -0.01920353018449667,
    -0.01884950429623443,
    -0.01849894622416774,
    -0.01815143600222988,
    -0.01780752366284628,
    -0.01746652531160999,
    -0.01712976838228293,
    -0.01679500004555577,
    -0.01646404543657427,
    -0.01613727177224134,
    -0.01581368783238318,
    -0.01549335176543731,
    -0.01517617928406293,
    -0.01486235499996459,
    -0.01455199030299383,
    -0.01424513692140060,
    -0.01394190076922271,
    -0.01364220421085604,
    -0.01334613679158374,
    -0.01305353790551017,
    -0.01276453571208099,
    -0.01247892219919900,
    -0.01219689659273944,
    -0.01191821802818080,
    -0.01164315863241884,
    -0.01137142950716978,
    -0.01110337589102840,
    -0.01083863631872273,
    -0.01057764367031009,
    -0.01031992854669441,
    -0.01006603131880669,
    -0.00981533387575403,
    -0.00956853685222963,
    -0.00932478836910675,
    -0.00908510115408230,
    -0.00884815314317470,
    -0.00861565453705442,
    -0.00838470472107402,
    -0.00815943811784984,
    -0.00793988521195997,
    -0.00771828447333182,
    -0.00750142202175241,
    -0.00728737486509171,
    -0.00707805918772665,
    -0.00687193962626482,
    -0.00667003499046691,
    -0.00647115861608179,
    -0.00627606246439013,
    -0.00608382343156832,
    -0.00589510366644117,
    -0.00570918340769605,
    -0.00552667010503218,
    -0.00534698247297190,
    -0.00517067973044085,
    -0.00499725989031461,
    -0.00482723666922585,
    -0.00466015504550490,
    -0.00449648333724299,
    -0.00433579153570741,
    -0.00417850156873724,
    -0.00402419458668805,
    -0.00387326113668688,
    -0.00372528250788314,
    -0.00358062858695092,
    -0.00343888170873291,
    -0.00330038227298419,
    -0.00316471699695629,
    -0.00303222178265417,
    -0.00290248190797133,
    -0.00277581828295897
};

// Filter for 11025 sample rate (0.4db/70db ripple, transition 2000-5512)
 double filter_11[] = {
    0.963783,
    0.963536,
    0.963541,
    0.963545,
    0.963549,
    0.963553,
    0.963557,
    0.963561,
    0.963566,
    0.96357,
    0.963574,
    0.963579,
    0.963584,
    0.963589,
    0.963594,
    0.963599,
    0.963605,
    0.96361,
    0.963616,
    0.963622,
    0.963629,
    0.963636,
    0.963643,
    0.96365,
    0.963658,
    0.963666,
    0.963674,
    0.963683,
    0.963692,
    0.963701,
    0.963711,
    0.963721,
    0.963732,
    0.963743,
    0.963755,
    0.963767,
    0.96378,
    0.963793,
    0.963807,
    0.963821,
    0.963836,
    0.963851,
    0.963867,
    0.963884,
    0.963901,
    0.963918,
    0.963937,
    0.963956,
    0.963976,
    0.963996,
    0.964018,
    0.96404,
    0.964062,
    0.964086,
    0.96411,
    0.964135,
    0.964161,
    0.964188,
    0.964215,
    0.964244,
    0.964273,
    0.964304,
    0.964335,
    0.964367,
    0.9644,
    0.964434,
    0.964469,
    0.964505,
    0.964542,
    0.96458,
    0.96462,
    0.96466,
    0.964701,
    0.964744,
    0.964787,
    0.964832,
    0.964878,
    0.964925,
    0.964974,
    0.965023,
    0.965074,
    0.965126,
    0.96518,
    0.965235,
    0.965291,
    0.965348,
    0.965407,
    0.965467,
    0.965529,
    0.965592,
    0.965656,
    0.965722,
    0.965789,
    0.965858,
    0.965928,
    0.966,
    0.966074,
    0.966149,
    0.966226,
    0.966304,
    0.966384,
    0.966465,
    0.966548,
    0.966633,
    0.96672,
    0.966808,
    0.966898,
    0.96699,
    0.967084,
    0.967179,
    0.967277,
    0.967376,
    0.967477,
    0.96758,
    0.967685,
    0.967791,
    0.9679,
    0.968011,
    0.968123,
    0.968238,
    0.968354,
    0.968473,
    0.968594,
    0.968717,
    0.968841,
    0.968968,
    0.969097,
    0.969229,
    0.969362,
    0.969498,
    0.969635,
    0.969775,
    0.969917,
    0.970062,
    0.970209,
    0.970358,
    0.970509,
    0.970662,
    0.970818,
    0.970977,
    0.971137,
    0.9713,
    0.971465,
    0.971633,
    0.971803,
    0.971976,
    0.972151,
    0.972328,
    0.972508,
    0.972691,
    0.972876,
    0.973063,
    0.973253,
    0.973446,
    0.973641,
    0.973838,
    0.974039,
    0.974241,
    0.974447,
    0.974655,
    0.974865,
    0.975078,
    0.975294,
    0.975513,
    0.975734,
    0.975958,
    0.976184,
    0.976413,
    0.976645,
    0.976879,
    0.977117,
    0.977356,
    0.977599,
    0.977844,
    0.978092,
    0.978343,
    0.978596,
    0.978853,
    0.979111,
    0.979373,
    0.979637,
    0.979904,
    0.980174,
    0.980447,
    0.980722,
    0.981,
    0.981281,
    0.981564,
    0.981851,
    0.98214,
    0.982431,
    0.982726,
    0.983023,
    0.983323,
    0.983625,
    0.983931,
    0.984238,
    0.984549,
    0.984862,
    0.985178,
    0.985497,
    0.985819,
    0.986143,
    0.986469,
    0.986798,
    0.98713,
    0.987465,
    0.987802,
    0.988141,
    0.988484,
    0.988828,
    0.989176,
    0.989526,
    0.989878,
    0.990233,
    0.99059,
    0.99095,
    0.991312,
    0.991677,
    0.992044,
    0.992413,
    0.992785,
    0.993159,
    0.993535,
    0.993913,
    0.994294,
    0.994677,
    0.995063,
    0.99545,
    0.99584,
    0.996231,
    0.996625,
    0.997021,
    0.997419,
    0.997819,
    0.998221,
    0.998624,
    0.99903,
    0.999438,
    0.999847,
    1.00026,
    1.00067,
    1.00109,
    1.0015,
    1.00192,
    1.00234,
    1.00276,
    1.00318,
    1.00361,
    1.00403,
    1.00446,
    1.00489,
    1.00532,
    1.00575,
    1.00618,
    1.00661,
    1.00705,
    1.00748,
    1.00792,
    1.00836,
    1.0088,
    1.00924,
    1.00968,
    1.01012,
    1.01056,
    1.011,
    1.01144,
    1.01189,
    1.01233,
    1.01277,
    1.01322,
    1.01366,
    1.01411,
    1.01455,
    1.015,
    1.01544,
    1.01589,
    1.01633,
    1.01678,
    1.01722,
    1.01767,
    1.01811,
    1.01856,
    1.019,
    1.01944,
    1.01988,
    1.02033,
    1.02077,
    1.02121,
    1.02164,
    1.02208,
    1.02252,
    1.02295,
    1.02339,
    1.02382,
    1.02425,
    1.02468,
    1.02511,
    1.02554,
    1.02597,
    1.02639,
    1.02681,
    1.02723,
    1.02765,
    1.02806,
    1.02848,
    1.02889,
    1.0293,
    1.0297,
    1.03011,
    1.03051,
    1.0309,
    1.0313,
    1.03169,
    1.03208,
    1.03247,
    1.03285,
    1.03323,
    1.03361,
    1.03398,
    1.03435,
    1.03471,
    1.03508,
    1.03543,
    1.03579,
    1.03614,
    1.03648,
    1.03682,
    1.03716,
    1.03749,
    1.03782,
    1.03815,
    1.03846,
    1.03878,
    1.03909,
    1.03939,
    1.03969,
    1.03998,
    1.04027,
    1.04055,
    1.04083,
    1.0411,
    1.04136,
    1.04162,
    1.04188,
    1.04212,
    1.04236,
    1.0426,
    1.04283,
    1.04305,
    1.04326,
    1.04347,
    1.04367,
    1.04387,
    1.04405,
    1.04423,
    1.0444,
    1.04457,
    1.04473,
    1.04488,
    1.04502,
    1.04515,
    1.04528,
    1.0454,
    1.04551,
    1.04561,
    1.0457,
    1.04578,
    1.04586,
    1.04593,
    1.04598,
    1.04603,
    1.04607,
    1.0461,
    1.04612,
    1.04614,
    1.04614,
    1.04613,
    1.04611,
    1.04609,
    1.04605,
    1.046,
    1.04594,
    1.04588,
    1.0458,
    1.04571,
    1.04561,
    1.0455,
    1.04538,
    1.04524,
    1.0451,
    1.04495,
    1.04478,
    1.0446,
    1.04441,
    1.04421,
    1.044,
    1.04378,
    1.04354,
    1.04329,
    1.04303,
    1.04276,
    1.04247,
    1.04217,
    1.04186,
    1.04154,
    1.0412,
    1.04085,
    1.04049,
    1.04012,
    1.03973,
    1.03933,
    1.03891,
    1.03848,
    1.03804,
    1.03758,
    1.03711,
    1.03663,
    1.03613,
    1.03562,
    1.03509,
    1.03455,
    1.034,
    1.03343,
    1.03284,
    1.03225,
    1.03163,
    1.031,
    1.03036,
    1.0297,
    1.02903,
    1.02834,
    1.02764,
    1.02692,
    1.02618,
    1.02543,
    1.02467,
    1.02388,
    1.02309,
    1.02227,
    1.02145,
    1.0206,
    1.01974,
    1.01886,
    1.01797,
    1.01706,
    1.01613,
    1.01519,
    1.01423,
    1.01325,
    1.01226,
    1.01125,
    1.01023,
    1.00918,
    1.00812,
    1.00705,
    1.00595,
    1.00484,
    1.00372,
    1.00257,
    1.00141,
    1.00023,
    0.999032,
    0.997818,
    0.996586,
    0.995337,
    0.99407,
    0.992786,
    0.991484,
    0.990164,
    0.988827,
    0.987472,
    0.9861,
    0.984709,
    0.983301,
    0.981874,
    0.98043,
    0.978968,
    0.977488,
    0.97599,
    0.974474,
    0.972939,
    0.971387,
    0.969817,
    0.968228,
    0.966622,
    0.964997,
    0.963354,
    0.961693,
    0.960014,
    0.958317,
    0.956601,
    0.954867,
    0.953115,
    0.951345,
    0.949556,
    0.947749,
    0.945924,
    0.944081,
    0.94222,
    0.94034,
    0.938442,
    0.936526,
    0.934592,
    0.93264,
    0.930669,
    0.92868,
    0.926673,
    0.924649,
    0.922605,
    0.920544,
    0.918465,
    0.916368,
    0.914253,
    0.91212,
    0.909969,
    0.9078,
    0.905613,
    0.903409,
    0.901186,
    0.898946,
    0.896688,
    0.894413,
    0.89212,
    0.889809,
    0.887481,
    0.885135,
    0.882772,
    0.880391,
    0.877993,
    0.875578,
    0.873146,
    0.870697,
    0.86823,
    0.865747,
    0.863246,
    0.860729,
    0.858194,
    0.855643,
    0.853076,
    0.850491,
    0.847891,
    0.845273,
    0.84264,
    0.83999,
    0.837324,
    0.834641,
    0.831943,
    0.829229,
    0.826499,
    0.823753,
    0.820991,
    0.818214,
    0.815421,
    0.812613,
    0.809789,
    0.80695,
    0.804097,
    0.801228,
    0.798344,
    0.795445,
    0.792532,
    0.789604,
    0.786662,
    0.783705,
    0.780734,
    0.777749,
    0.77475,
    0.771737,
    0.76871,
    0.765669,
    0.762615,
    0.759548,
    0.756467,
    0.753373,
    0.750266,
    0.747146,
    0.744013,
    0.740867,
    0.737709,
    0.734539,
    0.731356,
    0.728162,
    0.724955,
    0.721736,
    0.718506,
    0.715264,
    0.712011,
    0.708746,
    0.70547,
    0.702184,
    0.698886,
    0.695578,
    0.692259,
    0.68893,
    0.685591,
    0.682241,
    0.678882,
    0.675513,
    0.672134,
    0.668746,
    0.665348,
    0.661941,
    0.658526,
    0.655101,
    0.651668,
    0.648226,
    0.644776,
    0.641318,
    0.637852,
    0.634378,
    0.630896,
    0.627407,
    0.623911,
    0.620407,
    0.616896,
    0.613379,
    0.609855,
    0.606324,
    0.602787,
    0.599244,
    0.595695,
    0.592141,
    0.588581,
    0.585015,
    0.581444,
    0.577868,
    0.574287,
    0.570702,
    0.567112,
    0.563517,
    0.559919,
    0.556316,
    0.55271,
    0.5491,
    0.545486,
    0.54187,
    0.53825,
    0.534628,
    0.531002,
    0.527375,
    0.523745,
    0.520112,
    0.516478,
    0.512842,
    0.509205,
    0.505566,
    0.501926,
    0.498285,
    0.494643,
    0.491,
    0.487357,
    0.483713,
    0.48007,
    0.476427,
    0.472784,
    0.469141,
    0.465499,
    0.461858,
    0.458218,
    0.454579,
    0.450941,
    0.447305,
    0.443671,
    0.440039,
    0.436409,
    0.432781,
    0.429156,
    0.425533,
    0.421914,
    0.418297,
    0.414684,
    0.411074,
    0.407467,
    0.403865,
    0.400266,
    0.396672,
    0.393082,
    0.389496,
    0.385916,
    0.38234,
    0.378769,
    0.375203,
    0.371643,
    0.368088,
    0.364539,
    0.360996,
    0.357459,
    0.353929,
    0.350405,
    0.346887,
    0.343377,
    0.339873,
    0.336376,
    0.332887,
    0.329406,
    0.325932,
    0.322466,
    0.319007,
    0.315557,
    0.312116,
    0.308682,
    0.305258,
    0.301842,
    0.298436,
    0.295038,
    0.29165,
    0.288271,
    0.284902,
    0.281542,
    0.278193,
    0.274853,
    0.271524,
    0.268205,
    0.264897,
    0.2616,
    0.258313,
    0.255037,
    0.251773,
    0.248519,
    0.245278,
    0.242047,
    0.238829,
    0.235622,
    0.232427,
    0.229244,
    0.226074,
    0.222916,
    0.219771,
    0.216638,
    0.213518,
    0.210411,
    0.207317,
    0.204236,
    0.201168,
    0.198114,
    0.195074,
    0.192047,
    0.189034,
    0.186035,
    0.183049,
    0.180078,
    0.177122,
    0.174179,
    0.171251,
    0.168338,
    0.16544,
    0.162556,
    0.159687,
    0.156833,
    0.153994,
    0.151171,
    0.148363,
    0.14557,
    0.142793,
    0.140031,
    0.137285,
    0.134555,
    0.13184,
    0.129142,
    0.12646,
    0.123794,
    0.121144,
    0.11851,
    0.115893,
    0.113292,
    0.110708,
    0.10814,
    0.105589,
    0.103055,
    0.100537,
    0.098037,
    0.0955534,
    0.0930869,
    0.0906375,
    0.0882052,
    0.0857901,
    0.0833922,
    0.0810117,
    0.0786486,
    0.0763029,
    0.0739746,
    0.0716639,
    0.0693708,
    0.0670953,
    0.0648374,
    0.0625973,
    0.0603749,
    0.0581703,
    0.0559835,
    0.0538146,
    0.0516636,
    0.0495305,
    0.0474154,
    0.0453182,
    0.0432391,
    0.041178,
    0.039135,
    0.03711,
    0.0351032,
    0.0331145,
    0.0311439,
    0.0291915,
    0.0272573,
    0.0253413,
    0.0234434,
    0.0215638,
    0.0197024,
    0.0178592,
    0.0160342,
    0.0142274,
    0.0124389,
    0.0106686,
    0.0089165,
    0.00718264,
    0.00546699,
    0.00376954,
    0.0020903,
    0.000429234,
    -0.00121365,
    -0.00283838,
    -0.00444495,
    -0.0060334,
    -0.00760374,
    -0.00915598,
    -0.0106902,
    -0.0122063,
    -0.0137044,
    -0.0151845,
    -0.0166466,
    -0.0180908,
    -0.0195171,
    -0.0209255,
    -0.022316,
    -0.0236888,
    -0.0250438,
    -0.026381,
    -0.0277005,
    -0.0290024,
    -0.0302866,
    -0.0315533,
    -0.0328025,
    -0.0340341,
    -0.0352484,
    -0.0364452,
    -0.0376247,
    -0.0387869,
    -0.0399319,
    -0.0410597,
    -0.0421703,
    -0.0432639,
    -0.0443405,
    -0.0454002,
    -0.0464429,
    -0.0474688,
    -0.048478,
    -0.0494704,
    -0.0504462,
    -0.0514054,
    -0.0523481,
    -0.0532744,
    -0.0541843,
    -0.0550779,
    -0.0559553,
    -0.0568165,
    -0.0576616,
    -0.0584908,
    -0.059304,
    -0.0601013,
    -0.0608829,
    -0.0616488,
    -0.062399,
    -0.0631338,
    -0.063853,
    -0.064557,
    -0.0652456,
    -0.065919,
    -0.0665773,
    -0.0672206,
    -0.0678489,
    -0.0684624,
    -0.0690611,
    -0.0696451,
    -0.0702146,
    -0.0707696,
    -0.0713101,
    -0.0718364,
    -0.0723484,
    -0.0728464,
    -0.0733303,
    -0.0738002,
    -0.0742564,
    -0.0746988,
    -0.0751276,
    -0.0755428,
    -0.0759446,
    -0.0763331,
    -0.0767083,
    -0.0770704,
    -0.0774195,
    -0.0777556,
    -0.0780789,
    -0.0783895,
    -0.0786875,
    -0.0789729,
    -0.079246,
    -0.0795067,
    -0.0797552,
    -0.0799917,
    -0.0802161,
    -0.0804287,
    -0.0806294,
    -0.0808186,
    -0.0809961,
    -0.0811622,
    -0.081317,
    -0.0814606,
    -0.081593,
    -0.0817144,
    -0.0818249,
    -0.0819246,
    -0.0820136,
    -0.0820921,
    -0.0821601,
    -0.0822177,
    -0.0822651,
    -0.0823024,
    -0.0823296,
    -0.082347,
    -0.0823545,
    -0.0823524,
    -0.0823407,
    -0.0823195,
    -0.082289,
    -0.0822493,
    -0.0822004,
    -0.0821426,
    -0.0820758,
    -0.0820002,
    -0.081916,
    -0.0818232,
    -0.081722,
    -0.0816124,
    -0.0814946,
    -0.0813686,
    -0.0812347,
    -0.0810929,
    -0.0809432,
    -0.080786,
    -0.0806211,
    -0.0804488,
    -0.0802692,
    -0.0800823,
    -0.0798883,
    -0.0796873,
    -0.0794794,
    -0.0792648,
    -0.0790434,
    -0.0788155,
    -0.0785811,
    -0.0783403,
    -0.0780933,
    -0.0778402,
    -0.077581,
    -0.0773159,
    -0.077045,
    -0.0767684,
    -0.0764861,
    -0.0761984,
    -0.0759053,
    -0.0756068,
    -0.0753032,
    -0.0749945,
    -0.0746809,
    -0.0743623,
    -0.074039,
    -0.073711,
    -0.0733784,
    -0.0730414,
    -0.0726999,
    -0.0723542,
    -0.0720044,
    -0.0716505,
    -0.0712926,
    -0.0709308,
    -0.0705652,
    -0.070196,
    -0.0698232,
    -0.0694468,
    -0.0690671,
    -0.0686841,
    -0.0682979,
    -0.0679086,
    -0.0675162,
    -0.0671209,
    -0.0667228,
    -0.0663219,
    -0.0659184,
    -0.0655123,
    -0.0651037,
    -0.0646928,
    -0.0642795,
    -0.063864,
    -0.0634464,
    -0.0630267,
    -0.0626051,
    -0.0621816,
    -0.0617563,
    -0.0613293,
    -0.0609007,
    -0.0604705,
    -0.0600388,
    -0.0596058,
    -0.0591714,
    -0.0587358,
    -0.0582991,
    -0.0578613,
    -0.0574225,
    -0.0569827,
    -0.0565421,
    -0.0561007,
    -0.0556586,
    -0.0552159,
    -0.0547726,
    -0.0543289,
    -0.0538847,
    -0.0534401,
    -0.0529953,
    -0.0525503,
    -0.0521051,
    -0.0516598,
    -0.0512145,
    -0.0507692,
    -0.0503241,
    -0.0498791,
    -0.0494343,
    -0.0489899,
    -0.0485458,
    -0.0481021,
    -0.0476589,
    -0.0472162,
    -0.0467741,
    -0.0463327,
    -0.0458919,
    -0.0454519,
    -0.0450128,
    -0.0445744,
    -0.044137,
    -0.0437006,
    -0.0432651,
    -0.0428308,
    -0.0423975,
    -0.0419654,
    -0.0415346,
    -0.0411049,
    -0.0406766,
    -0.0402497,
    -0.0398241,
    -0.0394,
    -0.0389773,
    -0.0385562,
    -0.0381366,
    -0.0377186,
    -0.0373023,
    -0.0368877,
    -0.0364747,
    -0.0360636,
    -0.0356542,
    -0.0352466,
    -0.034841,
    -0.0344372,
    -0.0340353,
    -0.0336355,
    -0.0332376,
    -0.0328417,
    -0.0324479,
    -0.0320562,
    -0.0316666,
    -0.0312792,
    -0.0308939,
    -0.0305108,
    -0.03013,
    -0.0297514,
    -0.0293751,
    -0.0290011,
    -0.0286294,
    -0.02826,
    -0.0278931,
    -0.0275285,
    -0.0271663,
    -0.0268066,
    -0.0264493,
    -0.0260945,
    -0.0257421,
    -0.0253923,
    -0.025045,
    -0.0247002,
    -0.024358,
    -0.0240183,
    -0.0236813,
    -0.0233468,
    -0.0230149,
    -0.0226856,
    -0.022359,
    -0.022035,
    -0.0217137,
    -0.021395,
    -0.021079,
    -0.0207656,
    -0.020455,
    -0.020147,
    -0.0198418,
    -0.0195392,
    -0.0192394,
    -0.0189422,
    -0.0186478,
    -0.0183561,
    -0.0180672,
    -0.017781,
    -0.0174975,
    -0.0172167,
    -0.0169387,
    -0.0166634,
    -0.0163908,
    -0.016121,
    -0.0158539,
    -0.0155896,
    -0.015328,
    -0.0150691,
    -0.0148129,
    -0.0145595,
    -0.0143088,
    -0.0140608,
    -0.0138156,
    -0.013573,
    -0.0133331,
    -0.013096,
    -0.0128615,
    -0.0126297,
    -0.0124006,
    -0.0121742,
    -0.0119504,
    -0.0117293,
    -0.0115108,
    -0.011295,
    -0.0110818,
    -0.0108712,
    -0.0106633,
    -0.0104579,
    -0.0102551,
    -0.010055,
    -0.00985734,
    -0.00966228,
    -0.00946976,
    -0.00927979,
    -0.00909233,
    -0.00890739,
    -0.00872494,
    -0.00854498,
    -0.00836749,
    -0.00819246,
    -0.00801987,
    -0.00784971,
    -0.00768196,
    -0.00751661,
    -0.00735364,
    -0.00719305,
    -0.00703481,
    -0.00687891,
    -0.00672533,
    -0.00657407,
    -0.0064251,
    -0.00627842,
    -0.00613399,
    -0.00599181,
    -0.00585185,
    -0.00571408,
    -0.00557853,
    -0.00544515,
    -0.00531393,
    -0.00518485,
    -0.00505789,
    -0.00493304,
    -0.00481028,
    -0.00468959,
    -0.00457094,
    -0.00445434,
    -0.00433974,
    -0.00422715,
    -0.00411653,
    -0.00400787,
    -0.00390115,
    -0.00379635,
    -0.00369345,
    -0.00359243,
    -0.00349328,
    -0.00339598,
    -0.0033005,
    -0.00320683,
    -0.00311495,
    -0.00302485,
    -0.0029365,
    -0.00284988,
    -0.00276498,
    -0.00268177,
    -0.00260024,
    -0.00252035,
    -0.00244208,
    -0.0023654,
    -0.00229038,
    -0.00221691,
    -0.002145,
    -0.00207462,
    -0.00200576,
    -0.0019384,
    -0.00187252,
    -0.0018081,
    -0.00174511,
    -0.00168355,
    -0.00162339,
    -0.00156461,
    -0.0015072,
    -0.00145113,
    -0.00139639,
    -0.00134295,
    -0.0012908,
    -0.00123993,
    -0.0011903,
    -0.00114192,
    -0.00109474,
    -0.00104877,
    -0.00100397,
    -0.00096033,
    -0.000917831,
    -0.000876457,
    -0.000836179,
    -0.000796985,
    -0.00075884,
    -0.000721732,
    -0.000685617,
    -0.000650492,
    -0.000616507,
    -0.000583413,
    -0.000551283,
    -0.000520092,
    -0.000489824,
    -0.000460463,
    -0.000431989,
    -0.000404387,
    -0.000377639,
    -0.00035173,
    -0.000326639,
    -0.000302354,
    -0.000278855,
    -0.000256128,
    -0.000234152,
    -0.000212916,
    -0.000192398,
    -0.000172586,
    -0.000153458,
    -0.000135004,
    -0.0001172,
    -0.000100034,
    -8.34839e-005,
    -6.75382e-005,
    -5.21704e-005,
    -3.73712e-005,
    -2.31111e-005,
    -9.38171e-006,
    3.85052e-006,
    1.65911e-005,
    2.88819e-005,
    4.0709e-005,
    5.15277e-005,
    6.2273e-005,
    7.25614e-005,
    8.24312e-005,
    9.18861e-005,
    0.000100949,
    0.000109629,
    0.000117946,
    0.00012591,
    0.00013354,
    0.000140849,
    0.000147852,
    0.000154564,
    0.000161,
    0.000167176,
    0.000173105,
    0.000178803,
    0.000184285,
    0.000189567,
    0.000194663,
    0.000199589,
    0.000204361,
    0.000208993,
    0.000213502,
    0.000217903,
    0.000222213,
    0.000226447,
    0.000230622,
    0.000234754,
    0.000238859,
    0.000242957,
    0.000247061
};

// Filter for 48000 sample rate (0.05db/45db ripple, transition 17000-24000)
 double filter_48_8[] = {
     1.00287685711006770,
     1.00570603068948560,
     1.00573476625335530,
     1.00576192248155460,
     1.00578688730006260,
     1.00580823091797630,
     1.00582535656315760,
     1.00583685039642520,
     1.00584215949551490,
     1.00583991485611680,
     1.00582963721446190,
     1.00581001364909550,
     1.00578065905784950,
     1.00574034013377300,
     1.00568882803743320,
     1.00562496638283120,
     1.00554869478340910,
     1.00545898262441890,
     1.00535596218178470,
     1.00523873649995290,
     1.00510767460633700,
     1.00496200354766470,
     1.00480239614909510,
     1.00462818838685890,
     1.00444037214528260,
     1.00423840307785130,
     1.00402367341732290,
     1.00379566707247280,
     1.00355630622140990,
     1.00330494001324790,
     1.00304439559759740,
     1.00277337969196780,
     1.00249790911697880,
     1.00221120681212890,
     1.00191565032454830,
     1.00161808597299080,
     1.00131587682534160,
     1.00101261094968890,
     1.00070818134143740,
     1.00040543116020420,
     1.00010496085273860,
     0.99980933389406412,
     0.99951949565956999,
     0.99923785562980427,
     0.99896555183537461,
     0.99870489415954644,
     0.99845710284053579,
     0.99822435939034682,
     0.99800792146475370,
     0.99780982376471083,
     0.99763127923437134,
     0.99747416429948788,
     0.99733957777653237,
     0.99722922192365970,
     0.99714403471883883,
     0.99708547019654870,
     0.99705429353292196,
     0.99705170605566962,
     0.99707820783269530,
     0.99713472225347299,
     0.99722144105769883,
     0.99733900820414079,
     0.99748722311146798,
     0.99766646582345464,
     0.99787580628371475,
     0.99811387973845656,
     0.99838269413460956,
     0.99867994147868899,
     0.99900497272869782,
     0.99935651659407676,
     0.99973331507369889,
     1.00013382071423900,
     1.00055635801124620,
     1.00099905462588980,
     1.00145986904926890,
     1.00193662093386940,
     1.00242695182338410,
     1.00292839635149970,
     1.00343829912726150,
     1.00395397316285600,
     1.00447252807951040,
     1.00499108039638880,
     1.00550657625810100,
     1.00601599433619440,
     1.00651617861992730,
     1.00700405336974750,
     1.00747638630922600,
     1.00793014401692460,
     1.00836212909812040,
     1.00876936634666700,
     1.00914875214872720,
     1.00949747628582640,
     1.00981258785148190,
     1.01009151828460600,
     1.01033147302555550,
     1.01053022727729470,
     1.01068488954644860,
     1.01079457962608670,
     1.01085706508700700,
     1.01087034407066610,
     1.01083343216272860,
     1.01074499739561690,
     1.01060437238528510,
     1.01041085111180990,
     1.01016427076896130,
     1.00986454205794460,
     1.00951208169021880,
     1.00910743018317680,
     1.00865161296646090,
     1.00814579377025830,
     1.00759163380688150,
     1.00699093619208120,
     1.00634596988957890,
     1.00565916916230650,
     1.00493340460650700,
     1.00417169926505890,
     1.00337750871421630,
     1.00255437307104090,
     1.00170628732091480,
     1.00083730523596690,
     0.99995183226878148,
     0.99905433562621004,
     0.99814960817548437,
     0.99724243481738484,
     0.99633789440773690,
     0.99544096606189747,
     0.99455693788148791,
     0.99369086399416873,
     0.99284833607169654,
     0.99203474311374773,
     0.99125470977709496,
     0.99051382130021715,
     0.98981697652873124,
     0.98916919373018564,
     0.98857518418871893,
     0.98803957167786916,
     0.98756668553589899,
     0.98716067042327682,
     0.98682534093774943,
     0.98656424782614571,
     0.98638056971422372,
     0.98627716524557196,
     0.98625649006707428,
     0.98632059630223257,
     0.98647112240079615,
     0.98670925202469617,
     0.98703571460105533,
     0.98745076583114866,
     0.98795415963116906,
     0.98854515937773424,
     0.98922256206003745,
     0.98998455650511497,
     0.99082891460062494,
     0.99175282393695630,
     0.99275303455663511,
     0.99382571276092035,
     0.99496661489306426,
     0.99617093590922368,
     0.99743353304599891,
     0.99874871538777199,
     1.00011064909266570,
     1.00151236995270640,
     1.00294727302953700,
     1.00440818292725620,
     1.00588751819267740,
     1.00737751957117320,
     1.00887012501927550,
     1.01035711197549860,
     1.01183007217870280,
     1.01328049348511360,
     1.01469977404293470,
     1.01607929421904570,
     1.01741044173504960,
     1.01868468820377790,
     1.01989358888245920,
     1.02102889091005020,
     1.02208253262313110,
     1.02304672222330130,
     1.02391397040161050,
     1.02467714977482820,
     1.02532951310006060,
     1.02586483076067970,
     1.02627725611861180,
     1.02656156312010880,
     1.02671307586386560,
     1.02672775430016630,
     1.02660218000239370,
     1.02633365790665800,
     1.02592018040293830,
     1.02536055280153240,
     1.02465428243010700,
     1.02380178137533200,
     1.02280399495672050,
     1.02166285747522180,
     1.02038138793785830,
     1.01896299126628940,
     1.01741223634858910,
     1.01573432608489170,
     1.01393543769648580,
     1.01202243709926390,
     1.01000309495455780,
     1.00788584609129290,
     1.00567997767630880,
     1.00339538987716060,
     1.00104276650455560,
     0.99863332526938653,
     0.99617897809316247,
     0.99369209950471460,
     0.99118563475831190,
     0.98867289111099088,
     0.98616763930672813,
     0.98368386616771952,
     0.98123593702369982,
     0.97883825913257327,
     0.97650543358075992,
     0.97425209537480106,
     0.97209283721076278,
     0.97004210887563247,
     0.96811420050530483,
     0.96632310545044220,
     0.96468250309824322,
     0.96320560158427826,
     0.96190511569293613,
     0.96079310856610167,
     0.95988093864558643,
     0.95917951466623330,
     0.95869856910984141,
     0.95844707932480666,
     0.95843308466347621,
     0.95866353358382150,
     0.95914433471004346,
     0.95988018727654301,
     0.96087462234930321,
     0.96212986546231871,
     0.96364687450243436,
     0.96542520729751669,
     0.96746307876694471,
     0.96975722609966386,
     0.97230300514031476,
     0.97509423393774941,
     0.97812331435286404,
     0.98138110497266851,
     0.98485702468473058,
     0.98853896788083384,
     0.99241341772535308,
     0.99646528283525992,
     1.00067825050960100,
     1.00503443816731000,
     1.00951472240460680,
     1.01409858766621590,
     1.01876437249561170,
     1.02348912729770870,
     1.02824887095540270,
     1.03301844671600150,
     1.03777183380119280,
     1.04248196766041980,
     1.04712124984586420,
     1.05166112814354770,
     1.05607244967538880,
     1.06032567025287520,
     1.06439074491057270,
     1.06823736856491620,
     1.07183503593284190,
     1.07515316533633150,
     1.07816122984517190,
     1.08082885622168940,
     1.08312595746201490,
     1.08502284343120260,
     1.08649034720040930,
     1.08749994430905940,
     1.08802387012643260,
     1.08803522790270190,
     1.08750812957667800,
     1.08641777713792000,
     1.08474059462097830,
     1.08245434432752340,
     1.07953814444739640,
     1.07597274559120600,
     1.07174047004693930,
     1.06682527335587300,
     1.06121299301330810,
     1.05489127129262680,
     1.04784973694789830,
     1.04007995105531380,
     1.03157556731475690,
     1.02233229200404360,
     1.01234802280565320,
     1.00162282049177520,
     0.99015900433270509,
     0.97796087637638562,
     0.96503526005429263,
     0.95139099799366011,
     0.93703925465389903,
     0.92199331064036261,
     0.90626868819060646,
     0.88988297321514953,
     0.87285592249261867,
     0.85520925154075167,
     0.83696674020342332,
     0.81815400701052843,
     0.79879858769787238,
     0.77892970772305392,
     0.75857832722931462,
     0.73777692462362920,
     0.71655951689504715,
     0.69496141395387723,
     0.67301926897668030,
     0.65077076247922927,
     0.62825469507910636,
     0.60551074581550102,
     0.58257922964946340,
     0.55950120198255360,
     0.53631818230263184,
     0.51307203417363323,
     0.48980482293643551,
     0.46655867480743685,
     0.44337565512751509,
     0.42029762746060528,
     0.39736611129456761,
     0.37462216203096227,
     0.35210609463083931,
     0.32985758813338828,
     0.30791544315619129,
     0.28631734021502137,
     0.26509993248643932,
     0.24429852988075390,
     0.22394714938701463,
     0.20407826941219617,
     0.18472285009954009,
     0.16591011690664526,
     0.14766760556931685,
     0.13002093461744982,
     0.11299388389491896,
     0.09660816891946203,
     0.08088354646970594,
     0.06583760245616949,
     0.05148585911640839,
     0.03784159705577585,
     0.02491598073368286,
     0.01271785277736340,
     0.00125403661829335,
    -0.00947116569558456,
    -0.01945543489397491,
    -0.02869871020468822,
    -0.03720309394524510,
    -0.04497287983782954,
    -0.05201441418255817,
    -0.05833613590323934,
    -0.06394841624580423,
    -0.06886361293687045,
    -0.07309588848113717,
    -0.07666128733732741,
    -0.07957748721745436,
    -0.08186373751090920,
    -0.08354092002785096,
    -0.08463127246660904,
    -0.08515837079263298,
    -0.08514701301636371,
    -0.08462308719899038,
    -0.08361349009034030,
    -0.08214598632113357,
    -0.08024910035194595,
    -0.07795199911162042,
    -0.07528437273510286,
    -0.07227630822626242,
    -0.06895817882277278,
    -0.06536051145484703,
    -0.06151388780050345,
    -0.05744881314280597,
    -0.05319559256531956,
    -0.04878427103347850,
    -0.04424439273579500,
    -0.03960511055035053,
    -0.03489497669112344,
    -0.03014158960593223,
    -0.02537201384533348,
    -0.02061227018763934,
    -0.01588751538554244,
    -0.01122173055614656,
    -0.00663786529453761,
    -0.00215758105724065,
     0.00219860660046828,
     0.00641157427480938,
     0.01046343938471625,
     0.01433788922923549,
     0.01801983242533871,
     0.02149575213740080,
     0.02475354275720528,
     0.02778262317231986,
     0.03057385196975451,
     0.03311963101040547,
     0.03541377834312465,
     0.03745164981255272,
     0.03922998260763500,
     0.04074699164775069,
     0.04200223476076617,
     0.04299666983352632,
     0.04373252240002587,
     0.04421332352624783,
     0.04444377244659309,
     0.04442977778526266,
     0.04417828800022789,
     0.04369734244383597,
     0.04299591846448287,
     0.04208374854396763,
     0.04097174141713317,
     0.03967125552579104,
     0.03819435401182605,
     0.03655375165962709,
     0.03476265660476445,
     0.03283474823443677,
     0.03078401989930649,
     0.02862476173526825,
     0.02637142352930942,
     0.02403859797749610,
     0.02164092008636954,
     0.01919299094234989,
     0.01670921780334129,
     0.01420396599907856,
     0.01169122235175752,
     0.00918475760535480,
     0.00669787901690689,
     0.00424353184068287,
     0.00183409060551384,
    -0.00051853276709116,
    -0.00280312056623925,
    -0.00500898898122347,
    -0.00712623784448823,
    -0.00914557998919426,
    -0.01105858058641618,
    -0.01285746897482205,
    -0.01453537923851942,
    -0.01608613415621968,
    -0.01750453082778862,
    -0.01878600036515209,
    -0.01992713784665087,
    -0.02092492426526235,
    -0.02177742532003747,
    -0.02248369569146288,
    -0.02304332329286878,
    -0.02345680079658847,
    -0.02372532289232420,
    -0.02385089719009687,
    -0.02383621875379629,
    -0.02368470601003939,
    -0.02340039900854240,
    -0.02298797365061040,
    -0.02245265598999136,
    -0.02180029266475891,
    -0.02103711329154125,
    -0.02016986511323215,
    -0.01920567551306205,
    -0.01815203379998123,
    -0.01701673177239017,
    -0.01580783109370881,
    -0.01453358462498050,
    -0.01320243710897662,
    -0.01182291693286560,
    -0.01040363637504464,
    -0.00895321506863391,
    -0.00748025486542970,
    -0.00599326790920655,
    -0.00450066246110426,
    -0.00301066108260854,
    -0.00153132581718727,
    -0.00007041591946819,
     0.00136448715736233,
     0.00276620801740306,
     0.00412814172229669,
     0.00544332406406972,
     0.00670592120084495,
     0.00791024221700433,
     0.00905114434914824,
     0.01012382255343348,
     0.01112403317311232,
     0.01204794250944367,
     0.01289230060495360,
     0.01365429505003109,
     0.01433169773233430,
     0.01492269747889951,
     0.01542609127891991,
     0.01584114250901323,
     0.01616760508537238,
     0.01640573470927238,
     0.01655626080783594,
     0.01662036704299422,
     0.01659969186449648,
     0.01649628739584474,
     0.01631260928392275,
     0.01605151617231898,
     0.01571618668679155,
     0.01531017157416935,
     0.01483728543219917,
     0.01430167292134936,
     0.01370766337988259,
     0.01305988058133698,
     0.01236303580985106,
     0.01162214733297327,
     0.01084211399632047,
     0.01002852103837161,
     0.00918599311589938,
     0.00831991922858015,
     0.00743589104817056,
     0.00653896270233116,
     0.00563442229268317,
     0.00472724893458369,
     0.00382252148385806,
     0.00292502484128665,
     0.00203955187410123,
     0.00117056978915329,
     0.00032248403902712,
    -0.00050065160414827,
    -0.00129484215499092,
    -0.00205654749643906,
    -0.00278231205223840,
    -0.00346911277951089,
    -0.00411407908201311,
    -0.00471477669681349,
    -0.00526893666019029,
    -0.00577475585639288,
    -0.00623057307310875,
    -0.00663522458015069,
    -0.00698768494787650,
    -0.00728741365889310,
    -0.00753399400174173,
    -0.00772751527521698,
    -0.00786814028554878,
    -0.00795657505266049,
    -0.00799348696059802,
    -0.00798020797693888,
    -0.00791772251601853,
    -0.00780803243638051,
    -0.00765337016722662,
    -0.00745461591548742,
    -0.00721466117453795,
    -0.00693573074141383,
    -0.00662061917575849,
    -0.00627189503865922,
    -0.00589250923659892,
    -0.00548527198805235,
    -0.00505328690685661,
    -0.00459952919915808,
    -0.00412719625967951,
    -0.00363932150985935,
    -0.00313913722612657,
    -0.00262971914803317,
    -0.00211422328632094,
    -0.00159567096944241,
    -0.00107711605278789,
    -0.00056144201719345,
    -0.00005153924143158,
     0.00044990528668404,
     0.00094023617619880,
     0.00141698806079920,
     0.00187780248417826,
     0.00232049909882183,
     0.00274303639582903,
     0.00314354203636908,
     0.00352034051599116,
     0.00387188438137010,
     0.00419691563137894,
     0.00449416297545835,
     0.00476297737161137,
     0.00500105082635322,
     0.00521039128661338,
     0.00538963399860009,
     0.00553784890592725,
     0.00565541605236921,
     0.00574213485659508,
     0.00579864927737280,
     0.00582515105439845,
     0.00582256357714607,
     0.00579138691351937,
     0.00573282239122918,
     0.00564763518640832,
     0.00553727933353566,
     0.00540269281058019,
     0.00524557787569672,
     0.00506703334535721,
     0.00486893564531433,
     0.00465249771972117,
     0.00441975426953219,
     0.00417196295052153,
     0.00391130527469339,
     0.00363900148026379,
     0.00335736145049807,
     0.00306752321600390,
     0.00277189625732937,
     0.00247142594986378,
     0.00216867576863070,
     0.00186424616037914,
     0.00156098028472640,
     0.00125877113707715,
     0.00096120678551958,
     0.00066565029793896,
     0.00037894799308921,
     0.00010347741810012,
    -0.00016753848752953,
    -0.00042808290317997,
    -0.00067944911134191,
    -0.00091880996240489,
    -0.00114681630725492,
    -0.00136154596778326,
    -0.00156351503521465,
    -0.00175133127679099,
    -0.00192553903902722,
    -0.00208514643759681,
    -0.00223081749626907,
    -0.00236187938988501,
    -0.00247910507171675,
    -0.00258212551435090,
    -0.00267183767334113,
    -0.00274810927276324,
    -0.00281197092736533,
    -0.00286348302370502,
    -0.00290380194778163,
    -0.00293315653902754,
    -0.00295278010439405,
    -0.00296305774604895,
    -0.00296530238544715,
    -0.00295999328635747,
    -0.00294849945308996,
    -0.00293137380790861,
    -0.00291003018999486,
    -0.00288506537148690,
    -0.00285790914328774,
    -0.00282917357941791
};

// Filter for 48000 sample rate (0.02db/70db ripple, transition 17000-24000)
 double filter_48[] = {
    0.998616,
    0.998433,
    0.998447,
    0.99846,
    0.998475,
    0.998489,
    0.998504,
    0.998521,
    0.998538,
    0.998557,
    0.998577,
    0.998599,
    0.998622,
    0.998648,
    0.998675,
    0.998705,
    0.998737,
    0.998771,
    0.998807,
    0.998845,
    0.998886,
    0.998929,
    0.998974,
    0.999021,
    0.99907,
    0.999121,
    0.999174,
    0.999229,
    0.999285,
    0.999342,
    0.999401,
    0.99946,
    0.99952,
    0.99958,
    0.999641,
    0.999701,
    0.999762,
    0.999821,
    0.999879,
    0.999936,
    0.999991,
    1.00004,
    1.0001,
    1.00014,
    1.00019,
    1.00023,
    1.00027,
    1.0003,
    1.00033,
    1.00036,
    1.00038,
    1.0004,
    1.00041,
    1.00041,
    1.00041,
    1.0004,
    1.00039,
    1.00037,
    1.00034,
    1.00031,
    1.00027,
    1.00022,
    1.00017,
    1.00011,
    1.00005,
    0.999977,
    0.9999,
    0.999817,
    0.999728,
    0.999635,
    0.999536,
    0.999433,
    0.999326,
    0.999215,
    0.999101,
    0.998985,
    0.998866,
    0.998746,
    0.998625,
    0.998504,
    0.998382,
    0.998262,
    0.998144,
    0.998028,
    0.997915,
    0.997806,
    0.997701,
    0.997602,
    0.997508,
    0.997421,
    0.997341,
    0.997269,
    0.997206,
    0.997152,
    0.997107,
    0.997073,
    0.997049,
    0.997036,
    0.997035,
    0.997046,
    0.997069,
    0.997105,
    0.997153,
    0.997213,
    0.997287,
    0.997373,
    0.997472,
    0.997583,
    0.997706,
    0.997842,
    0.997988,
    0.998146,
    0.998314,
    0.998493,
    0.99868,
    0.998876,
    0.99908,
    0.99929,
    0.999506,
    0.999727,
    0.999952,
    1.00018,
    1.00041,
    1.00064,
    1.00087,
    1.00109,
    1.00132,
    1.00154,
    1.00175,
    1.00195,
    1.00215,
    1.00234,
    1.00252,
    1.00268,
    1.00283,
    1.00297,
    1.00309,
    1.00319,
    1.00328,
    1.00334,
    1.00339,
    1.00342,
    1.00343,
    1.00341,
    1.00338,
    1.00332,
    1.00324,
    1.00313,
    1.00301,
    1.00286,
    1.00269,
    1.00249,
    1.00228,
    1.00204,
    1.00179,
    1.00151,
    1.00122,
    1.00091,
    1.00059,
    1.00025,
    0.999893,
    0.999528,
    0.999154,
    0.998771,
    0.998382,
    0.997989,
    0.997593,
    0.997197,
    0.996803,
    0.996413,
    0.996029,
    0.995654,
    0.995288,
    0.994936,
    0.994598,
    0.994277,
    0.993975,
    0.993694,
    0.993437,
    0.993204,
    0.992998,
    0.99282,
    0.992673,
    0.992557,
    0.992474,
    0.992425,
    0.992411,
    0.992432,
    0.992491,
    0.992586,
    0.992719,
    0.99289,
    0.993097,
    0.993343,
    0.993625,
    0.993943,
    0.994296,
    0.994683,
    0.995103,
    0.995554,
    0.996035,
    0.996543,
    0.997077,
    0.997635,
    0.998213,
    0.998809,
    0.999421,
    1.00005,
    1.00068,
    1.00132,
    1.00196,
    1.00261,
    1.00325,
    1.00388,
    1.0045,
    1.00511,
    1.0057,
    1.00627,
    1.00681,
    1.00733,
    1.00782,
    1.00827,
    1.00868,
    1.00905,
    1.00938,
    1.00967,
    1.0099,
    1.01009,
    1.01022,
    1.01029,
    1.01031,
    1.01028,
    1.01018,
    1.01003,
    1.00981,
    1.00954,
    1.0092,
    1.00881,
    1.00836,
    1.00785,
    1.00729,
    1.00667,
    1.00601,
    1.00529,
    1.00453,
    1.00372,
    1.00287,
    1.00199,
    1.00108,
    1.00014,
    0.999171,
    0.998186,
    0.997187,
    0.996179,
    0.995167,
    0.994156,
    0.993152,
    0.99216,
    0.991185,
    0.990234,
    0.98931,
    0.988421,
    0.987572,
    0.986766,
    0.986011,
    0.985311,
    0.98467,
    0.984093,
    0.983585,
    0.98315,
    0.982791,
    0.982512,
    0.982316,
    0.982206,
    0.982183,
    0.982251,
    0.982411,
    0.982662,
    0.983007,
    0.983445,
    0.983976,
    0.984599,
    0.985312,
    0.986114,
    0.987002,
    0.987973,
    0.989024,
    0.99015,
    0.991349,
    0.992614,
    0.99394,
    0.995322,
    0.996754,
    0.998228,
    0.999739,
    1.00128,
    1.00284,
    1.00441,
    1.00599,
    1.00757,
    1.00914,
    1.01068,
    1.0122,
    1.01368,
    1.01512,
    1.0165,
    1.01782,
    1.01907,
    1.02024,
    1.02133,
    1.02232,
    1.02321,
    1.02399,
    1.02465,
    1.0252,
    1.02562,
    1.02591,
    1.02606,
    1.02607,
    1.02594,
    1.02567,
    1.02525,
    1.02468,
    1.02396,
    1.0231,
    1.02209,
    1.02094,
    1.01964,
    1.01821,
    1.01665,
    1.01496,
    1.01314,
    1.01121,
    1.00917,
    1.00704,
    1.00481,
    1.00251,
    1.00013,
    0.997692,
    0.995208,
    0.992688,
    0.990144,
    0.98759,
    0.985038,
    0.982503,
    0.979998,
    0.977536,
    0.975133,
    0.972802,
    0.970557,
    0.968413,
    0.966383,
    0.96448,
    0.962719,
    0.961111,
    0.959671,
    0.958408,
    0.957336,
    0.956464,
    0.955803,
    0.955361,
    0.955147,
    0.955168,
    0.955431,
    0.955941,
    0.956701,
    0.957716,
    0.958986,
    0.960513,
    0.962296,
    0.964332,
    0.966619,
    0.969152,
    0.971924,
    0.974929,
    0.978157,
    0.981599,
    0.985242,
    0.989074,
    0.99308,
    0.997245,
    1.00155,
    1.00598,
    1.01052,
    1.01514,
    1.01982,
    1.02454,
    1.02928,
    1.034,
    1.0387,
    1.04333,
    1.04788,
    1.05231,
    1.0566,
    1.06072,
    1.06464,
    1.06833,
    1.07176,
    1.07491,
    1.07774,
    1.08023,
    1.08234,
    1.08406,
    1.08535,
    1.08618,
    1.08654,
    1.08639,
    1.08571,
    1.08448,
    1.08268,
    1.08028,
    1.07727,
    1.07363,
    1.06934,
    1.06439,
    1.05877,
    1.05246,
    1.04545,
    1.03774,
    1.02933,
    1.0202,
    1.01035,
    0.999796,
    0.988527,
    0.976552,
    0.963876,
    0.950507,
    0.936458,
    0.921739,
    0.906365,
    0.890354,
    0.873723,
    0.856492,
    0.838685,
    0.820324,
    0.801436,
    0.782048,
    0.762188,
    0.741887,
    0.721176,
    0.700089,
    0.67866,
    0.656924,
    0.634917,
    0.612676,
    0.590239,
    0.567645,
    0.544932,
    0.52214,
    0.499308,
    0.476476,
    0.453684,
    0.430971,
    0.408377,
    0.38594,
    0.363699,
    0.341692,
    0.319956,
    0.298527,
    0.27744,
    0.256729,
    0.236428,
    0.216568,
    0.19718,
    0.178292,
    0.159931,
    0.142124,
    0.124893,
    0.108262,
    0.0922507,
    0.0768773,
    0.0621584,
    0.0481086,
    0.0347404,
    0.0220644,
    0.0100889,
    -0.00117961,
    -0.0117367,
    -0.0215802,
    -0.0307096,
    -0.0391269,
    -0.0468356,
    -0.0538413,
    -0.0601518,
    -0.0657763,
    -0.0707261,
    -0.0750142,
    -0.0786551,
    -0.0816651,
    -0.0840619,
    -0.0858647,
    -0.0870941,
    -0.0877718,
    -0.0879208,
    -0.0875653,
    -0.0867301,
    -0.0854411,
    -0.083725,
    -0.0816091,
    -0.0791213,
    -0.0762897,
    -0.073143,
    -0.06971,
    -0.0660197,
    -0.0621009,
    -0.0579827,
    -0.0536935,
    -0.0492617,
    -0.0447154,
    -0.0400818,
    -0.035388,
    -0.03066,
    -0.0259233,
    -0.0212024,
    -0.0165211,
    -0.0119021,
    -0.00736686,
    -0.00293606,
    0.00137097,
    0.00553609,
    0.00954237,
    0.0133742,
    0.0170173,
    0.0204588,
    0.0236869,
    0.0266916,
    0.029464,
    0.0319967,
    0.0342837,
    0.0363201,
    0.0381028,
    0.0396298,
    0.0409002,
    0.0419149,
    0.0426755,
    0.043185,
    0.0434478,
    0.0434691,
    0.0432551,
    0.0428133,
    0.0421518,
    0.04128,
    0.0402075,
    0.0389453,
    0.0375045,
    0.0358972,
    0.0341359,
    0.0322334,
    0.0302032,
    0.0280587,
    0.0258139,
    0.0234829,
    0.0210796,
    0.0186183,
    0.016113,
    0.0135777,
    0.0110262,
    0.00847206,
    0.00592846,
    0.00340829,
    0.000924015,
    -0.00151239,
    -0.00388945,
    -0.00619627,
    -0.00842255,
    -0.0105586,
    -0.0125956,
    -0.014525,
    -0.0163395,
    -0.0180322,
    -0.0195971,
    -0.0210289,
    -0.0223232,
    -0.0234764,
    -0.0244856,
    -0.0253488,
    -0.0260646,
    -0.0266325,
    -0.027053,
    -0.0273269,
    -0.0274559,
    -0.0274427,
    -0.0272902,
    -0.0270022,
    -0.0265831,
    -0.0260378,
    -0.0253719,
    -0.0245913,
    -0.0237024,
    -0.0227122,
    -0.0216278,
    -0.0204569,
    -0.0192073,
    -0.0178871,
    -0.0165045,
    -0.0150681,
    -0.0135864,
    -0.0120679,
    -0.0105212,
    -0.00895504,
    -0.00737777,
    -0.00579781,
    -0.00422339,
    -0.00266253,
    -0.00112301,
    0.000387624,
    0.00186217,
    0.00329373,
    0.00467577,
    0.00600216,
    0.00726717,
    0.0084655,
    0.0095923,
    0.0106432,
    0.0116143,
    0.0125021,
    0.0133038,
    0.014017,
    0.0146397,
    0.0151705,
    0.0156086,
    0.0159535,
    0.0162054,
    0.0163647,
    0.0164326,
    0.0164104,
    0.0163002,
    0.0161042,
    0.0158252,
    0.0154663,
    0.0150309,
    0.0145229,
    0.0139463,
    0.0133054,
    0.0126049,
    0.0118496,
    0.0110444,
    0.0101946,
    0.0093055,
    0.00838238,
    0.00743074,
    0.00645607,
    0.0054639,
    0.00445969,
    0.00344889,
    0.00243685,
    0.00142886,
    0.000430025,
    -0.000554651,
    -0.00152036,
    -0.00246249,
    -0.00337662,
    -0.00425861,
    -0.00510452,
    -0.0059107,
    -0.00667378,
    -0.00739069,
    -0.00805863,
    -0.00867514,
    -0.00923808,
    -0.00974559,
    -0.0101962,
    -0.0105887,
    -0.0109222,
    -0.0111963,
    -0.0114107,
    -0.0115655,
    -0.0116611,
    -0.0116982,
    -0.0116779,
    -0.0116014,
    -0.0114702,
    -0.0112862,
    -0.0110514,
    -0.0107681,
    -0.0104386,
    -0.0100658,
    -0.00965231,
    -0.00920122,
    -0.00871562,
    -0.00819873,
    -0.00765389,
    -0.0070845,
    -0.00649401,
    -0.00588592,
    -0.00526376,
    -0.00463103,
    -0.00399123,
    -0.00334783,
    -0.00270424,
    -0.0020638,
    -0.00142975,
    -0.000805244,
    -0.00019332,
    0.000403119,
    0.000981309,
    0.00153865,
    0.00207268,
    0.00258114,
    0.00306194,
    0.00351318,
    0.00393316,
    0.00432036,
    0.00467349,
    0.00499144,
    0.00527334,
    0.00551849,
    0.00572643,
    0.00589689,
    0.00602979,
    0.00612527,
    0.00618365,
    0.00620543,
    0.00619132,
    0.00614216,
    0.00605899,
    0.005943,
    0.0057955,
    0.00561796,
    0.00541197,
    0.00517923,
    0.00492154,
    0.00464081,
    0.004339,
    0.00401814,
    0.00368035,
    0.00332774,
    0.00296248,
    0.00258675,
    0.00220275,
    0.00181264,
    0.0014186,
    0.00102276,
    0.000627206,
    0.000233992,
    -0.0001549,
    -0.000537554,
    -0.000912129,
    -0.00127687,
    -0.00163011,
    -0.0019703,
    -0.00229596,
    -0.00260576,
    -0.00289846,
    -0.00317295,
    -0.00342824,
    -0.00366345,
    -0.00387785,
    -0.00407082,
    -0.00424187,
    -0.00439065,
    -0.00451691,
    -0.00462056,
    -0.0047016,
    -0.00476016,
    -0.00479648,
    -0.00481092,
    -0.00480395,
    -0.00477612,
    -0.00472809,
    -0.00466062,
    -0.00457455,
    -0.00447077,
    -0.00435027,
    -0.0042141,
    -0.00406335,
    -0.00389918,
    -0.00372279,
    -0.00353539,
    -0.00333825,
    -0.00313262,
    -0.0029198,
    -0.00270109,
    -0.00247776,
    -0.00225111,
    -0.00202239,
    -0.00179284,
    -0.00156368,
    -0.00133609,
    -0.00111122,
    -0.000890142,
    -0.000673931,
    -0.000463566,
    -0.00025999,
    -6.40804e-005,
    0.000123355,
    0.000301569,
    0.000469885,
    0.000627695,
    0.000774464,
    0.000909731,
    0.00103311,
    0.0011443,
    0.00124304,
    0.00132918,
    0.0014026,
    0.0014633,
    0.00151132,
    0.00154674,
    0.00156976,
    0.0015806,
    0.00157955,
    0.00156697,
    0.00154326,
    0.00150885,
    0.00146423,
    0.00140994,
    0.00134654,
    0.00127463,
    0.00119484,
    0.00110782,
    0.00101422,
    0.000914733,
    0.000810069,
    0.000700916,
    0.000587975,
    0.000471972,
    0.000353587,
    0.000233524,
    0.000112452,
    -8.96083e-006,
    -0.000130077,
    -0.000250265,
    -0.000368929,
    -0.000485485,
    -0.000599394,
    -0.000710138,
    -0.00081725,
    -0.000920275,
    -0.0010188,
    -0.00111242,
    -0.00120085,
    -0.00128376,
    -0.0013609,
    -0.00143205,
    -0.00149703,
    -0.0015557,
    -0.00160795,
    -0.00165371,
    -0.00169294,
    -0.00172566,
    -0.00175188,
    -0.0017717,
    -0.00178522,
    -0.00179258,
    -0.00179393,
    -0.00178944,
    -0.00177931,
    -0.00176385,
    -0.00174323,
    -0.00171776,
    -0.00168771,
    -0.00165338,
    -0.00161508,
    -0.00157311,
    -0.00152781,
    -0.00147951,
    -0.00142855,
    -0.00137526,
    -0.00131999,
    -0.00126307,
    -0.00120481,
    -0.00114552,
    -0.00108545,
    -0.001025,
    -0.000964478,
    -0.000904024,
    -0.000844031,
    -0.000784664,
    -0.000726217,
    -0.000668856,
    -0.000612833,
    -0.000558285,
    -0.000505427,
    -0.000454352,
    -0.000405237,
    -0.000358109,
    -0.000313103,
    -0.000270157,
    -0.000229397,
    -0.000190689,
    -0.00015461,
    -0.000120686,
    -8.88258e-005,
    -5.92367e-005,
    -3.16742e-005,
    -6.1755e-006,
    1.74561e-005,
    3.92595e-005,
    5.94405e-005,
    7.80909e-005,
    9.54382e-005,
    0.000111619,
    0.000126888,
    0.000141424,
    0.000155515,
    0.000169378,
    0.00018334
};

// Filter for 8000 sample rate, 8 bit (1db/45db ripple, transition 1700-4000)
 double filter_8_8[] = {
     1.07840156905687160,
     1.08244918844731130,
     1.08256301022164660,
     1.08267906806727800,
     1.08279627235765940,
     1.08291584806126600,
     1.08303665320907410,
     1.08315998642532780,
     1.08328459460010480,
     1.08341189152104710,
     1.08354040635211550,
     1.08367172967283070,
     1.08380394840422460,
     1.08393895214229770,
     1.08407378418930800,
     1.08421103270185060,
     1.08434313816258520,
     1.08448412581256640,
     1.08462787877887660,
     1.08477080396995080,
     1.08491648983985710,
     1.08506303943240660,
     1.08521172522207850,
     1.08536161364381960,
     1.08551333271419080,
     1.08566642231222010,
     1.08582118795495860,
     1.08597754612695900,
     1.08613559258240060,
     1.08629566112726140,
     1.08645752717544600,
     1.08662204165140470,
     1.08678690239665430,
     1.08695246958415130,
     1.08712131104236210,
     1.08729095552435170,
     1.08746278691256020,
     1.08763592175389530,
     1.08781108980770340,
     1.08798772472240410,
     1.08816631773814220,
     1.08834643240488990,
     1.08852838624459960,
     1.08871180750849560,
     1.08889688820121530,
     1.08908339299669050,
     1.08927155616392120,
     1.08946166305932950,
     1.08965413319435300,
     1.08984718939912930,
     1.09004250056102150,
     1.09023920434630810,
     1.09043774240637780,
     1.09063771755902070,
     1.09083945733057420,
     1.09104264574101810,
     1.09124758963132700,
     1.09145403184564250,
     1.09166227555975760,
     1.09187206550869130,
     1.09208364177883910,
     1.09229662697694560,
     1.09251115541513770,
     1.09272681319069440,
     1.09294470068233740,
     1.09316378205632850,
     1.09338444470897380,
     1.09360661385557110,
     1.09383035614043390,
     1.09405555785808950,
     1.09428231754291900,
     1.09451047536126730,
     1.09474013203636080,
     1.09497110785634220,
     1.09520354579576070,
     1.09543729746038570,
     1.09567259965393090,
     1.09590928848991400,
     1.09614756150511860,
     1.09638681105898780,
     1.09662755538778200,
     1.09686971929162320,
     1.09711308322013970,
     1.09735777037028240,
     1.09760371193845050,
     1.09785091535965630,
     1.09809938926775170,
     1.09834911048868530,
     1.09860010595949250,
     1.09885230195728070,
     1.09910570449563800,
     1.09936019015820570,
     1.09961580608604610,
     1.09987249508259490,
     1.10013048164617260,
     1.10038953640308980,
     1.10064951078696090,
     1.10091071741142990,
     1.10117290482925710,
     1.10143615878090540,
     1.10170039473500010,
     1.10196561504431840,
     1.10223176526061240,
     1.10249884257535570,
     1.10276683007273140,
     1.10303574120864400,
     1.10330556923403900,
     1.10357628805164890,
     1.10384782398502850,
     1.10412010317125110,
     1.10439314954400310,
     1.10466712454139810,
     1.10494167223958640,
     1.10521698689996910,
     1.10549297507819170,
     1.10576964023538340,
     1.10604695358163530,
     1.10632490643545920,
     1.10660345209909080,
     1.10688256264360160,
     1.10716217466817770,
     1.10744227380883610,
     1.10772282463777900,
     1.10800386270272980,
     1.10828534101159690,
     1.10856723123338500,
     1.10884935659014410,
     1.10913193771785880,
     1.10941480350889530,
     1.10969790853735280,
     1.10998126730624640,
     1.11026480033250930,
     1.11054850096054310,
     1.11083232898208340,
     1.11111627544868230,
     1.11140031323520330,
     1.11168440598624470,
     1.11196850656825320,
     1.11225254762620310,
     1.11253651106963770,
     1.11282037337013360,
     1.11310416874852260,
     1.11338771831569330,
     1.11367103404309330,
     1.11395417568805000,
     1.11423699064665070,
     1.11451953299135780,
     1.11480170513944080,
     1.11508350164365290,
     1.11536484009792550,
     1.11564570580089550,
     1.11592604362072700,
     1.11620585085713820,
     1.11648508277110950,
     1.11676370613048230,
     1.11704164361880040,
     1.11731885564124720,
     1.11759535427180380,
     1.11787111810696850,
     1.11814596316272970,
     1.11841999909559540,
     1.11869308192302100,
     1.11896523458487530,
     1.11923638192976970,
     1.11950652581524900,
     1.11977558982875820,
     1.12004355474750090,
     1.12031033473677240,
     1.12057591417004350,
     1.12084022938264210,
     1.12110328550930700,
     1.12136500033650030,
     1.12162532952408390,
     1.12188418403170420,
     1.12214166385333080,
     1.12239758146697800,
     1.12265197044459080,
     1.12290474879430290,
     1.12315588038426650,
     1.12340529759562190,
     1.12365297790598030,
     1.12389886118246850,
     1.12414293184744140,
     1.12438511553913730,
     1.12462538225099990,
     1.12486364565928460,
     1.12509990060694420,
     1.12533408475109440,
     1.12556618435064610,
     1.12579603997256480,
     1.12602370663741010,
     1.12624910163390380,
     1.12647216672670350,
     1.12669287762107430,
     1.12691117480561980,
     1.12712700364367870,
     1.12734031001660330,
     1.12755103184589080,
     1.12775913185294960,
     1.12796455388842200,
     1.12816726288631220,
     1.12836717920186590,
     1.12856425666401020,
     1.12875843394990080,
     1.12894972078991840,
     1.12913800654667720,
     1.12932322557015750,
     1.12950537369000050,
     1.12968434264896310,
     1.12986010975713460,
     1.13003261085921540,
     1.13020180514428300,
     1.13036763320492660,
     1.13053003826120140,
     1.13068895858706030,
     1.13084434109904540,
     1.13099613955337630,
     1.13114430316884260,
     1.13128876158381990,
     1.13142943675279880,
     1.13156629428809690,
     1.13169931786158370,
     1.13182838038305890,
     1.13195348863925840,
     1.13207455177022150,
     1.13219152111602780,
     1.13230432981183200,
     1.13241292824482540,
     1.13251725837209260,
     1.13261727100983060,
     1.13271289924591720,
     1.13280408616421830,
     1.13289076661023900,
     1.13297290654987390,
     1.13305044847232810,
     1.13312332877837620,
     1.13319144628676870,
     1.13325481118423420,
     1.13331331495833960,
     1.13336691756600700,
     1.13341556998102670,
     1.13345920803551970,
     1.13349777573452240,
     1.13353120966085920,
     1.13355945182808380,
     1.13358244971396060,
     1.13360014565315130,
     1.13361248259076830,
     1.13361938464340220,
     1.13362079779484140,
     1.13361667152414400,
     1.13360697621134830,
     1.13359160568871830,
     1.13357052705084270,
     1.13354369056666870,
     1.13351100613068610,
     1.13347244162306700,
     1.13342792382900150,
     1.13337740875521910,
     1.13332082763846230,
     1.13325812577661120,
     1.13318923879054200,
     1.13311411778436600,
     1.13303270963874870,
     1.13294495741224230,
     1.13285078619142740,
     1.13275013081904200,
     1.13264295673544630,
     1.13252920604962240,
     1.13240878909600420,
     1.13228169748985240,
     1.13214783451634180,
     1.13200716459516080,
     1.13185961284628660,
     1.13170513747625410,
     1.13154367164632160,
     1.13137516779796200,
     1.13119955302771120,
     1.13101677607662190,
     1.13082677368945390,
     1.13062951247404840,
     1.13042492639981180,
     1.13021295362067130,
     1.12999352282609490,
     1.12976662060299590,
     1.12953213721806730,
     1.12929005548350750,
     1.12904030193711690,
     1.12878283173659360,
     1.12851757800649420,
     1.12824449387331340,
     1.12796351729293030,
     1.12767460813558510,
     1.12737770237063990,
     1.12707275171262200,
     1.12675968003630760,
     1.12643844887262800,
     1.12610900308780000,
     1.12577130542136560,
     1.12542526327915130,
     1.12507086793378350,
     1.12470804050223800,
     1.12433673191992730,
     1.12395689339835990,
     1.12356847313548760,
     1.12317141778845580,
     1.12276567552873900,
     1.12235118743448090,
     1.12192790902460900,
     1.12149578856552810,
     1.12105478912788460,
     1.12060484789759920,
     1.12014591379689810,
     1.11967792930315820,
     1.11920087111576880,
     1.11871466273472220,
     1.11821926309443610,
     1.11771463750564660,
     1.11720071889717750,
     1.11667747092566550,
     1.11614484044067170,
     1.11560278726239170,
     1.11505126414495480,
     1.11449022274844100,
     1.11391961197464260,
     1.11333938241542410,
     1.11274949466198160,
     1.11214991021352950,
     1.11154058138726990,
     1.11092145256182250,
     1.11029249095207990,
     1.10965366074030400,
     1.10900489229319340,
     1.10834617097678410,
     1.10767743696967490,
     1.10699865576862240,
     1.10630977737010830,
     1.10561076472390710,
     1.10490157681531560,
     1.10418218028116070,
     1.10345253225024890,
     1.10271259158988630,
     1.10196230986208190,
     1.10120165793702580,
     1.10043059895881150,
     1.09964909311143240,
     1.09885708823629760,
     1.09805457691649980,
     1.09724149486017670,
     1.09641782026923410,
     1.09558351543557490,
     1.09473854783267920,
     1.09388288079285310,
     1.09301647772545380,
     1.09213930090162270,
     1.09125132066728110,
     1.09035250572705600,
     1.08944283059869630,
     1.08852225385514380,
     1.08759074524617080,
     1.08664827511000000,
     1.08569482559197490,
     1.08473034339863370,
     1.08375481823280540,
     1.08276821742528880,
     1.08177050437216480,
     1.08076165913826890,
     1.07974165063820720,
     1.07871046005753830,
     1.07766805941850170,
     1.07661442322633730,
     1.07554952234565930,
     1.07447333192026280,
     1.07338583343149320,
     1.07228700579620420,
     1.07117682117279460,
     1.07005525345718570,
     1.06892229457688480,
     1.06777791747927300,
     1.06662209424233190,
     1.06545482484372500,
     1.06427607346294950,
     1.06308583171458480,
     1.06188407072469990,
     1.06067078098341660,
     1.05944594285246430,
     1.05820954784729840,
     1.05696157599464820,
     1.05570201325210240,
     1.05443084018034710,
     1.05314805391375590,
     1.05185363811961200,
     1.05054757719367080,
     1.04922985636668220,
     1.04790048116313870,
     1.04655941620033070,
     1.04520667319717390,
     1.04384223237685900,
     1.04246609580462410,
     1.04107824740209960,
     1.03967868401703710,
     1.03826739237313160,
     1.03684437365005120,
     1.03540961956318010,
     1.03396313224585130,
     1.03250489597102480,
     1.03103491525143930,
     1.02955318653426840,
     1.02805971505768620,
     1.02655448167158860,
     1.02503750976281100,
     1.02350878103279450,
     1.02196830246133710,
     1.02041607146033140,
     1.01885209463339140,
     1.01727637406293290,
     1.01568891619583050,
     1.01408972042038200,
     1.01247879379116350,
     1.01085613775856700,
     1.00922176766382910,
     1.00757568366042150,
     1.00591789361064100,
     1.00424840100630660,
     1.00256722829446710,
     1.00087436824223270,
     0.99916984153596244,
     0.99745366136458857,
     0.99572583426517114,
     0.99398637474457407,
     0.99223529169725411,
     0.99047260127567838,
     0.98869831825342791,
     0.98691245846776721,
     0.98511503743089068,
     0.98330606753423089,
     0.98148556877142556,
     0.97965356225189371,
     0.97781006578984409,
     0.97595509210751019,
     0.97408866893986301,
     0.97221081554596134,
     0.97032154279244598,
     0.96842088572007345,
     0.96650885918869400,
     0.96458549393076332,
     0.96265080781140444,
     0.96070482860929829,
     0.95874757878219763,
     0.95677908785383547,
     0.95479938236868822,
     0.95280849050023408,
     0.95080643417199628,
     0.94879324763172024,
     0.94676896127243149,
     0.94473360427690822,
     0.94268720288133345,
     0.94062980351309045,
     0.93856142211682847,
     0.93648210117062092,
     0.93439186788707829,
     0.93229076268600553,
     0.93017881757307785,
     0.92805607083230968,
     0.92592255572476079,
     0.92377831116627196,
     0.92162337362201874,
     0.91945778814187440,
     0.91728158746681721,
     0.91509481277659910,
     0.91289750376043532,
     0.91068970771346891,
     0.90847145295813725,
     0.90624279648692874,
     0.90400377549819655,
     0.90175443557747936,
     0.89949481980362567,
     0.89722497343401941,
     0.89494494343199882,
     0.89265477651191683,
     0.89035452003417670,
     0.88804422142097483,
     0.88572392564998781,
     0.88339368626348291,
     0.88105355356299420,
     0.87870357695025725,
     0.87634380453495020,
     0.87397429667257198,
     0.87159509739796259,
     0.86920625962688192,
     0.86680784248521292,
     0.86439989553980701,
     0.86198247837450037,
     0.85955564120973105,
     0.85711944439328136,
     0.85467394151719456,
     0.85221919341625929,
     0.84975525775816674,
     0.84728219250864645,
     0.84480005328461838,
     0.84230890470434139,
     0.83980880583169448,
     0.83729981515985996,
     0.83478199616489746,
     0.83225541723400553,
     0.82972012981447996,
     0.82717620712840145,
     0.82462370533613205,
     0.82206269692834100,
     0.81949324021421088,
     0.81691540606633661,
     0.81432925585291149,
     0.81173485932246536,
     0.80913228204106069,
     0.80652159769712151,
     0.80390286763729879,
     0.80127616528556234,
     0.79864155892981348,
     0.79599912100546355,
     0.79334891310132616,
     0.79069102010758774,
     0.78802550258195880,
     0.78535244040465824,
     0.78267189944090143,
     0.77998395919341201,
     0.77728868922508443,
     0.77458616743000219,
     0.77187646617600558,
     0.76915966247329748,
     0.76643582696412238,
     0.76370504266585304,
     0.76096738206309500,
     0.75822292401395386,
     0.75547174360414948,
     0.75271392700367679,
     0.74994954113423484,
     0.74717867347795186,
     0.74440139967756547,
     0.74161780212080486,
     0.73882795874377760,
     0.73603195094199980,
     0.73322986010439695,
     0.73042176709391238,
     0.72760775466395478,
     0.72478790742440158,
     0.72196230422783414,
     0.71913102974749199,
     0.71629416839472992,
     0.71345180396023722,
     0.71060401654020400,
     0.70775089756657017,
     0.70489252876422515,
     0.70202899366860827,
     0.69916038135924197,
     0.69628677512949477,
     0.69340826511747011,
     0.69052493340668153,
     0.68763687161151399,
     0.68474416324376164,
     0.68184689703853629,
     0.67894516152387074,
     0.67603904681243054,
     0.67312863736011275,
     0.67021402555579435,
     0.66729530054773400,
     0.66437255001537432,
     0.66144586201376898,
     0.65851533318817812,
     0.65558104581572041,
     0.65264309703977497,
     0.64970157106360471,
     0.64675656613461874,
     0.64380816674239560,
     0.64085646968533494,
     0.63790156416010058,
     0.63494354327877645,
     0.63198249564525832,
     0.62901851949223575,
     0.62605170215822759,
     0.62308213865383644,
     0.62010992097740691,
     0.61713514638483002,
     0.61415789966120782,
     0.61117828363662319,
     0.60819638464088710,
     0.60521230268766735,
     0.60222612525206698,
     0.59923795227257759,
     0.59624787413124969,
     0.59325598619832765,
     0.59026238291470545,
     0.58726716149124369,
     0.58427041165074201,
     0.58127223246870441,
     0.57827271734850028,
     0.57527196179838602,
     0.57227005760024952,
     0.56926710692026661,
     0.56626319785773205,
     0.56325843036964718,
     0.56025289708036208,
     0.55724669602132326,
     0.55423992063570926,
     0.55123266636008572,
     0.54822503167471592,
     0.54521710884264263,
     0.54220899384527443,
     0.53920078452843678,
     0.53619257521159913,
     0.53318446021423094,
     0.53017653738215764,
     0.52716890269678784,
     0.52416164842116431,
     0.52115487303555030,
     0.51814867197651149,
     0.51514313868722639,
     0.51213837119914152,
     0.50913446213660696,
     0.50613151145662405,
     0.50312960725848754,
     0.50012885170837329,
     0.49712933658816916,
     0.49413115740613156,
     0.49113440756562987,
     0.48813918614216811,
     0.48514558285854598,
     0.48215369492562393,
     0.47916361678429598,
     0.47617544380480659,
     0.47318926636920616,
     0.47020518441598635,
     0.46722328542025027,
     0.46424366939566564,
     0.46126642267204343,
     0.45829164807946660,
     0.45531943040303707,
     0.45234986689864587,
     0.44938304956463770,
     0.44641907341161513,
     0.44345802577809701,
     0.44050000489677282,
     0.43754509937153840,
     0.43459340231447774,
     0.43164500292225466,
     0.42869999799326869,
     0.42575847201709849,
     0.42282052324115305,
     0.41988623586869528,
     0.41695570704310442,
     0.41402901904149908,
     0.41110626850913939,
     0.40818754350107911,
     0.40527293169676065,
     0.40236252224444286,
     0.39945640753300271,
     0.39655467201833716,
     0.39365740581311187,
     0.39076469744535947,
     0.38787663565019187,
     0.38499330393940329,
     0.38211479392737863,
     0.37924118769763143,
     0.37637257538826513,
     0.37350904029264825,
     0.37065067149030323,
     0.36779755251666946,
     0.36494976509663629,
     0.36210740066214353,
     0.35927053930938146,
     0.35643926482903926,
     0.35361366163247188,
     0.35079381439291868,
     0.34797980196296113,
     0.34517170895247656,
     0.34236961811487371,
     0.33957361031309596,
     0.33678376693606876,
     0.33400016937930821,
     0.33122289557892182,
     0.32845202792263883,
     0.32568764205319689,
     0.32292982545272425,
     0.32017864504291987,
     0.31743418699377873,
     0.31469652639102069,
     0.31196574209275135,
     0.30924190658357625,
     0.30652510288086815,
     0.30381540162687154,
     0.30111287983178930,
     0.29841760986346172,
     0.29572966961597230,
     0.29304912865221550,
     0.29037606647491493,
     0.28771054894928605,
     0.28505265595554768,
     0.28240244805141029,
     0.27976001012706037,
     0.27712540377131156,
     0.27449870141957511,
     0.27187997135975234,
     0.26926928701581315,
     0.26666670973440854,
     0.26407231320396241,
     0.26148616299053729,
     0.25890832884266296,
     0.25633887212853285,
     0.25377786372074179,
     0.25122536192847245,
     0.24868143924239389,
     0.24614615182286836,
     0.24361957289197642,
     0.24110175389701391,
     0.23859276322517939,
     0.23609266435253251,
     0.23360151577225555,
     0.23111937654822745,
     0.22864631129870722,
     0.22618237564061469,
     0.22372762753967937,
     0.22128212466359257,
     0.21884592784714293,
     0.21641909068237361,
     0.21400167351706700,
     0.21159372657166106,
     0.20919530942999209,
     0.20680647165891144,
     0.20442727238430203,
     0.20205776452192378,
     0.19969799210661679,
     0.19734801549387984,
     0.19500788279339118,
     0.19267764340688628,
     0.19035734763589926,
     0.18804704902269737,
     0.18574679254495724,
     0.18345662562487527,
     0.18117659562285462,
     0.17890674925324840,
     0.17664713347939470,
     0.17439779355867749,
     0.17215877256994525,
     0.16993011609873673,
     0.16771186134340513,
     0.16550406529643866,
     0.16330675628027494,
     0.16111998159005680,
     0.15894378091499958,
     0.15677819543485527,
     0.15462325789060205,
     0.15247901333211322,
     0.15034549822456431,
     0.14822275148379613,
     0.14611080637086846,
     0.14400970116979564,
     0.14191946788625301,
     0.13984014694004548,
     0.13777176554378351,
     0.13571436617554050,
     0.13366796477996576,
     0.13163260778444244,
     0.12960832142515372,
     0.12759513488487761,
     0.12559307855663979,
     0.12360218668818569,
     0.12162248120303838,
     0.11965399027467627,
     0.11769674044757562,
     0.11575076124546944,
     0.11381607512611054,
     0.11189270986817985,
     0.10998068333680035,
     0.10808002626442779,
     0.10619075351091244,
     0.10431290011701072,
     0.10244647694936350,
     0.10059150326702961,
     0.09874800680497997,
     0.09691600028544808,
     0.09509550152264279,
     0.09328653162598304,
     0.09148911058910650,
     0.08970325080344585,
     0.08792896778119534,
     0.08616627735961961,
     0.08441519431229969,
     0.08267573479170262,
     0.08094790769228519,
     0.07923172752091129,
     0.07752720081464097,
     0.07583434076240661,
     0.07415316805056714,
     0.07248367544623274,
     0.07082588539645213,
     0.06917980139304451,
     0.06754543129830654,
     0.06592277526570999,
     0.06431184863649148,
     0.06271265286104306,
     0.06112519499394054,
     0.05954947442348201,
     0.05798549759654199,
     0.05643326659553626,
     0.05489278802407892,
     0.05336405929406233,
     0.05184708738528479,
     0.05034185399918709,
     0.04884838252260495,
     0.04736665380543410,
     0.04589667308584869,
     0.04443843681102214,
     0.04299194949369327,
     0.04155719540682210,
     0.04013417668374179,
     0.03872288503983635,
     0.03732332165477378,
     0.03593547325224932,
     0.03455933668001442,
     0.03319489585969950,
     0.03184215285654278,
     0.03050108789373469,
     0.02917171269019121,
     0.02785399186320261,
     0.02654793093726144,
     0.02525351514311751,
     0.02397072887652629,
     0.02269955580477082,
     0.02143999306222503,
     0.02019202120957488,
     0.01895562620440891,
     0.01773078807345655,
     0.01651749833217332,
     0.01531573734228838,
     0.01412549559392375,
     0.01294674421314821,
     0.01177947481454141,
     0.01062365157760025,
     0.00947927447998830,
     0.00834631559968740,
     0.00722474788407854,
     0.00611456326066896,
     0.00501573562537993,
     0.00392823713661032,
     0.00285204671121397,
     0.00178714583053594,
     0.00073350963837140,
    -0.00030889100066518,
    -0.00134008158133407,
    -0.00236009008139596,
    -0.00336893531529183,
    -0.00436664836841584,
    -0.00535324917593241,
    -0.00632877434176063,
    -0.00729325653510192,
    -0.00824670605312704,
    -0.00918917618929792,
    -0.01012068479827098,
    -0.01104126154182344,
    -0.01195093667018317,
    -0.01284975161040842,
    -0.01373773184475003,
    -0.01461490866858124,
    -0.01548131173598054,
    -0.01633697877580653,
    -0.01718194637870208,
    -0.01801625121236138,
    -0.01883992580330402,
    -0.01965300785962715,
    -0.02045551917942498,
    -0.02124752405455979,
    -0.02202902990193885,
    -0.02280008888015319,
    -0.02356074080520912,
    -0.02431102253301367,
    -0.02505096319337613,
    -0.02578061122428792,
    -0.02650000775844297,
    -0.02720919566703430,
    -0.02790820831323548,
    -0.02859708671174956,
    -0.02927586791280209,
    -0.02994460191991132,
    -0.03060332323632063,
    -0.03125209168343119,
    -0.03189092189520699,
    -0.03251988350494954,
    -0.03313901233039695,
    -0.03374834115665654,
    -0.03434792560510870,
    -0.03493781335855114,
    -0.03551804291776978,
    -0.03608865369156818,
    -0.03664969508808205,
    -0.03720121820551890,
    -0.03774327138379903,
    -0.03827590186879283,
    -0.03879914984030487,
    -0.03931306844877391,
    -0.03981769403756337,
    -0.04031309367784949,
    -0.04079930205889612,
    -0.04127636024628546,
    -0.04174434474002532,
    -0.04220327884072628,
    -0.04265322007101174,
    -0.04309421950865534,
    -0.04352633996773628,
    -0.04394961837760826,
    -0.04436410647186632,
    -0.04476984873158321,
    -0.04516690407861498,
    -0.04555532434148736,
    -0.04593516286305485,
    -0.04630647144536563,
    -0.04666929887691113,
    -0.04702369422227885,
    -0.04736973636449318,
    -0.04770743403092764,
    -0.04803687981575568,
    -0.04835811097943529,
    -0.04867118265574975,
    -0.04897613331376780,
    -0.04927303907871289,
    -0.04956194823605822,
    -0.04984292481644122,
    -0.05011600894962197,
    -0.05038126267972137,
    -0.05063873288024470,
    -0.05088848642663532,
    -0.05113056816119523,
    -0.05136505154612391,
    -0.05159195376922283,
    -0.05181138456379934,
    -0.05202335734293994,
    -0.05222794341717654,
    -0.05242520463258213,
    -0.05261520701975000,
    -0.05279798397083942,
    -0.05297359874109016,
    -0.05314210258944987,
    -0.05330356841938243,
    -0.05345804378941481,
    -0.05360559553828913,
    -0.05374626545947014,
    -0.05388012843298078,
    -0.05400722003913247,
    -0.05412763699275072,
    -0.05424138767857465,
    -0.05434856176217019,
    -0.05444921713455556,
    -0.05454338835537055,
    -0.05463114058187702,
    -0.05471254872749432,
    -0.05478766973367039,
    -0.05485655671973951,
    -0.05491925858159056,
    -0.05497583969834723,
    -0.05502635477212953,
    -0.05507087256619515,
    -0.05510943707381427,
    -0.05514212150979697,
    -0.05516895799397098,
    -0.05519003663184656,
    -0.05520540715447661,
    -0.05521510246727227,
    -0.05521922873796961,
    -0.05521781558653039,
    -0.05521091353389648,
    -0.05519857659627936,
    -0.05518088065708878,
    -0.05515788277121196,
    -0.05512964060398740,
    -0.05509620667765058,
    -0.05505763897864792,
    -0.05501400092415498,
    -0.05496534850913539,
    -0.05491174590146805,
    -0.05485324212736269,
    -0.05478987722989712,
    -0.05472175972150468,
    -0.05464887941545658,
    -0.05457133749300239,
    -0.05448919755336752,
    -0.05440251710734675,
    -0.05431133018904558,
    -0.05421570195295891,
    -0.05411568931522105,
    -0.05401135918795396,
    -0.05390276075496050,
    -0.05378995205915625,
    -0.05367298271335005,
    -0.05355191958238693,
    -0.05342681132618746,
    -0.05329774880471236,
    -0.05316472523122558,
    -0.05302786769592764,
    -0.05288719252694858,
    -0.05274273411197133,
    -0.05259457049650496,
    -0.05244277204217401,
    -0.05228738953018900,
    -0.05212846920432997,
    -0.05196606414805531,
    -0.05180023608741181,
    -0.05163104180234419,
    -0.05145854070026341,
    -0.05128277359209195,
    -0.05110380463312942,
    -0.05092165651328656,
    -0.05073643748980612,
    -0.05054815173304730,
    -0.05035686489302969,
    -0.05016268760713902,
    -0.04996561014499484,
    -0.04976569382944104,
    -0.04956298483155081,
    -0.04935756279607844,
    -0.04914946278901962,
    -0.04893874095973214,
    -0.04872543458680752,
    -0.04850960574874854,
    -0.04829130856420312,
    -0.04807059766983235,
    -0.04784753257703257,
    -0.04762213758053896,
    -0.04739447091569361,
    -0.04716461529377485,
    -0.04693251569422307,
    -0.04669833155007295,
    -0.04646207660241337,
    -0.04622381319412864,
    -0.04598354648226613,
    -0.04574136279057021,
    -0.04549729212559733,
    -0.04525140884910904,
    -0.04500372853875064,
    -0.04475431132739513,
    -0.04450317973743145,
    -0.04425040138771922,
    -0.04399601241010644,
    -0.04374009479645917,
    -0.04348261497483251,
    -0.04322376046721225,
    -0.04296343127962862,
    -0.04270171645243540,
    -0.04243866032577048,
    -0.04217434511317197,
    -0.04190876567990086,
    -0.04164198569062934,
    -0.04137402077188664,
    -0.04110495675837740,
    -0.04083481287289815,
    -0.04056366552800377,
    -0.04029151286614954,
    -0.04001843003872398,
    -0.03974439410585828,
    -0.03946954905009698,
    -0.03919378521493234,
    -0.03891728658437570,
    -0.03864007456192888,
    -0.03836213707361069,
    -0.03808351371423786,
    -0.03780428180026665,
    -0.03752447456385549,
    -0.03724413674402392,
    -0.03696327104105394,
    -0.03668193258678127,
    -0.03640013608256926,
    -0.03611796393448614,
    -0.03583542158977918,
    -0.03555260663117841,
    -0.03526946498622163,
    -0.03498614925882150,
    -0.03470259969165077,
    -0.03441880431326174,
    -0.03413494201276573,
    -0.03385097856933112,
    -0.03356693751138133,
    -0.03328283692937297,
    -0.03299874417833161,
    -0.03271470639181064,
    -0.03243075992521174,
    -0.03214693190367159,
    -0.03186323127563785,
    -0.03157969824937489,
    -0.03129633948048146,
    -0.03101323445202399,
    -0.03073036866098739,
    -0.03044778753327274,
    -0.03016566217651368,
    -0.02988377195472575,
    -0.02960229364585866,
    -0.02932125558090796,
    -0.02904070475196503,
    -0.02876060561130656,
    -0.02848099358673059,
    -0.02820188304221971,
    -0.02792333737858812,
    -0.02764538452476423,
    -0.02736807117851236,
    -0.02709140602132070,
    -0.02681541784309812,
    -0.02654010318271542,
    -0.02626555548452721,
    -0.02599158048713216,
    -0.02571853411438001,
    -0.02544625492815747,
    -0.02517471899477794,
    -0.02490400017716806,
    -0.02463417215177311,
    -0.02436526101586045,
    -0.02409727351848469,
    -0.02383019620374140,
    -0.02356404598744754,
    -0.02329882567812916,
    -0.02303458972403445,
    -0.02277133577238617,
    -0.02250914835455890,
    -0.02224794173008998,
    -0.02198796734621884,
    -0.02172891258930159,
    -0.02147092602572387,
    -0.02121423702917514,
    -0.02095862110133467,
    -0.02070413543876696,
    -0.02045073290040964,
    -0.02019853690262145,
    -0.01994754143181421,
    -0.01969782021088071,
    -0.01944934630278515,
    -0.01920214288157936,
    -0.01895620131341124,
    -0.01871151416326846,
    -0.01846815023475208,
    -0.01822598633091074,
    -0.01798524200211665,
    -0.01774599244824739,
    -0.01750771943304287,
    -0.01727103059705971,
    -0.01703572840351436,
    -0.01680197673888940,
    -0.01656953879947098,
    -0.01633856297948959,
    -0.01610890630439613,
    -0.01588074848604793,
    -0.01565398880121835,
    -0.01542878708356265,
    -0.01520504479869998,
    -0.01498287565210273,
    -0.01476221299945748,
    -0.01454313162546643,
    -0.01432524413382340,
    -0.01410958635826673,
    -0.01389505792007464,
    -0.01368207272196819,
    -0.01347049645182034,
    -0.01326070650288658,
    -0.01305246278877144,
    -0.01284602057445595,
    -0.01264107668414700,
    -0.01243788827370316,
    -0.01223614850214967,
    -0.01203617334950668,
    -0.01183763528943690,
    -0.01164093150415023,
    -0.01144562034225801,
    -0.01125256413748181,
    -0.01106009400245833,
    -0.01086998710705017,
    -0.01068182393981958,
    -0.01049531914434442,
    -0.01031023845162475,
    -0.01012681718772876,
    -0.00994486334801908,
    -0.00976474868127132,
    -0.00958615566553324,
    -0.00940952075083252,
    -0.00923435269702442,
    -0.00906121785568924,
    -0.00888938646748075,
    -0.00871974198549106,
    -0.00855090052728014,
    -0.00838533333978321,
    -0.00822047259453355,
    -0.00805595811857487,
    -0.00789409207039028,
    -0.00773402352552935,
    -0.00757597707008774,
    -0.00741961889808731,
    -0.00726485325534877,
    -0.00711176365731951,
    -0.00696004458694825,
    -0.00681015616520724,
    -0.00666147037553529,
    -0.00651492078298576,
    -0.00636923491307950,
    -0.00622630972200520,
    -0.00608255675569505,
    -0.00594156910571379,
    -0.00580946364497917,
    -0.00567221513243665,
    -0.00553738308542638,
    -0.00540237934735323,
    -0.00527016061595939,
    -0.00513883729524409,
    -0.00501032246417567,
    -0.00488302554323334,
    -0.00475841736845631,
    -0.00463508415220261,
    -0.00451427900439452,
    -0.00439470330078790,
    -0.00427749901040637,
    -0.00416144116477504,
    -0.00404761939043973
};

// Filter for 8000 sample rate (1db/50db ripple, transition 1700-4000)
 double filter_8[] = {
    1.06573,
    1.06797,
    1.06804,
    1.06812,
    1.0682,
    1.06828,
    1.06836,
    1.06845,
    1.06853,
    1.06862,
    1.0687,
    1.06879,
    1.06888,
    1.06897,
    1.06907,
    1.06916,
    1.06926,
    1.06935,
    1.06945,
    1.06955,
    1.06965,
    1.06976,
    1.06986,
    1.06996,
    1.07007,
    1.07018,
    1.07029,
    1.0704,
    1.07051,
    1.07063,
    1.07074,
    1.07086,
    1.07098,
    1.0711,
    1.07122,
    1.07135,
    1.07147,
    1.0716,
    1.07173,
    1.07186,
    1.07199,
    1.07212,
    1.07226,
    1.07239,
    1.07253,
    1.07267,
    1.07281,
    1.07295,
    1.0731,
    1.07324,
    1.07339,
    1.07354,
    1.07369,
    1.07384,
    1.074,
    1.07415,
    1.07431,
    1.07447,
    1.07463,
    1.07479,
    1.07495,
    1.07512,
    1.07528,
    1.07545,
    1.07562,
    1.07579,
    1.07597,
    1.07614,
    1.07632,
    1.0765,
    1.07667,
    1.07686,
    1.07704,
    1.07722,
    1.07741,
    1.0776,
    1.07779,
    1.07798,
    1.07817,
    1.07836,
    1.07856,
    1.07876,
    1.07896,
    1.07916,
    1.07936,
    1.07956,
    1.07977,
    1.07998,
    1.08018,
    1.08039,
    1.08061,
    1.08082,
    1.08103,
    1.08125,
    1.08147,
    1.08169,
    1.08191,
    1.08213,
    1.08236,
    1.08258,
    1.08281,
    1.08304,
    1.08327,
    1.0835,
    1.08373,
    1.08397,
    1.0842,
    1.08444,
    1.08468,
    1.08492,
    1.08516,
    1.08541,
    1.08565,
    1.0859,
    1.08614,
    1.08639,
    1.08664,
    1.08689,
    1.08715,
    1.0874,
    1.08766,
    1.08791,
    1.08817,
    1.08843,
    1.08869,
    1.08895,
    1.08921,
    1.08948,
    1.08974,
    1.09001,
    1.09028,
    1.09055,
    1.09082,
    1.09109,
    1.09136,
    1.09163,
    1.09191,
    1.09218,
    1.09246,
    1.09273,
    1.09301,
    1.09329,
    1.09357,
    1.09385,
    1.09413,
    1.09442,
    1.0947,
    1.09498,
    1.09527,
    1.09555,
    1.09584,
    1.09613,
    1.09642,
    1.09671,
    1.097,
    1.09729,
    1.09758,
    1.09787,
    1.09816,
    1.09845,
    1.09875,
    1.09904,
    1.09933,
    1.09963,
    1.09992,
    1.10022,
    1.10051,
    1.10081,
    1.10111,
    1.1014,
    1.1017,
    1.102,
    1.10229,
    1.10259,
    1.10289,
    1.10319,
    1.10348,
    1.10378,
    1.10408,
    1.10438,
    1.10468,
    1.10497,
    1.10527,
    1.10557,
    1.10587,
    1.10616,
    1.10646,
    1.10676,
    1.10705,
    1.10735,
    1.10765,
    1.10794,
    1.10824,
    1.10853,
    1.10882,
    1.10912,
    1.10941,
    1.1097,
    1.10999,
    1.11028,
    1.11057,
    1.11086,
    1.11115,
    1.11144,
    1.11172,
    1.11201,
    1.11229,
    1.11258,
    1.11286,
    1.11314,
    1.11342,
    1.1137,
    1.11398,
    1.11426,
    1.11453,
    1.11481,
    1.11508,
    1.11535,
    1.11562,
    1.11589,
    1.11615,
    1.11642,
    1.11668,
    1.11694,
    1.1172,
    1.11746,
    1.11772,
    1.11797,
    1.11823,
    1.11848,
    1.11873,
    1.11897,
    1.11922,
    1.11946,
    1.1197,
    1.11994,
    1.12018,
    1.12041,
    1.12064,
    1.12087,
    1.1211,
    1.12132,
    1.12154,
    1.12176,
    1.12197,
    1.12219,
    1.1224,
    1.12261,
    1.12281,
    1.12301,
    1.12321,
    1.12341,
    1.1236,
    1.12379,
    1.12398,
    1.12416,
    1.12434,
    1.12452,
    1.12469,
    1.12486,
    1.12503,
    1.12519,
    1.12535,
    1.12551,
    1.12566,
    1.12581,
    1.12596,
    1.1261,
    1.12623,
    1.12637,
    1.1265,
    1.12662,
    1.12674,
    1.12686,
    1.12697,
    1.12708,
    1.12719,
    1.12729,
    1.12738,
    1.12748,
    1.12756,
    1.12764,
    1.12772,
    1.12779,
    1.12786,
    1.12793,
    1.12798,
    1.12804,
    1.12809,
    1.12813,
    1.12817,
    1.1282,
    1.12823,
    1.12825,
    1.12827,
    1.12828,
    1.12829,
    1.12829,
    1.12829,
    1.12828,
    1.12827,
    1.12825,
    1.12822,
    1.12819,
    1.12815,
    1.12811,
    1.12806,
    1.128,
    1.12794,
    1.12787,
    1.1278,
    1.12772,
    1.12763,
    1.12754,
    1.12744,
    1.12733,
    1.12722,
    1.1271,
    1.12698,
    1.12685,
    1.12671,
    1.12656,
    1.12641,
    1.12625,
    1.12609,
    1.12591,
    1.12573,
    1.12555,
    1.12535,
    1.12515,
    1.12495,
    1.12473,
    1.12451,
    1.12428,
    1.12404,
    1.12379,
    1.12354,
    1.12328,
    1.12301,
    1.12274,
    1.12246,
    1.12217,
    1.12187,
    1.12156,
    1.12125,
    1.12092,
    1.12059,
    1.12025,
    1.11991,
    1.11955,
    1.11919,
    1.11882,
    1.11844,
    1.11805,
    1.11765,
    1.11725,
    1.11683,
    1.11641,
    1.11598,
    1.11554,
    1.11509,
    1.11464,
    1.11417,
    1.11369,
    1.11321,
    1.11272,
    1.11222,
    1.11171,
    1.11119,
    1.11066,
    1.11012,
    1.10957,
    1.10902,
    1.10845,
    1.10788,
    1.10729,
    1.1067,
    1.10609,
    1.10548,
    1.10486,
    1.10423,
    1.10359,
    1.10293,
    1.10227,
    1.1016,
    1.10092,
    1.10023,
    1.09953,
    1.09882,
    1.0981,
    1.09737,
    1.09663,
    1.09588,
    1.09512,
    1.09435,
    1.09357,
    1.09278,
    1.09198,
    1.09117,
    1.09035,
    1.08952,
    1.08867,
    1.08782,
    1.08696,
    1.08609,
    1.0852,
    1.08431,
    1.0834,
    1.08249,
    1.08156,
    1.08063,
    1.07968,
    1.07872,
    1.07775,
    1.07677,
    1.07578,
    1.07478,
    1.07377,
    1.07275,
    1.07172,
    1.07067,
    1.06962,
    1.06855,
    1.06748,
    1.06639,
    1.06529,
    1.06418,
    1.06306,
    1.06193,
    1.06079,
    1.05963,
    1.05847,
    1.05729,
    1.0561,
    1.05491,
    1.0537,
    1.05248,
    1.05124,
    1.05,
    1.04875,
    1.04748,
    1.04621,
    1.04492,
    1.04362,
    1.04231,
    1.04099,
    1.03966,
    1.03831,
    1.03696,
    1.03559,
    1.03421,
    1.03282,
    1.03142,
    1.03001,
    1.02859,
    1.02715,
    1.02571,
    1.02425,
    1.02278,
    1.0213,
    1.01981,
    1.01831,
    1.0168,
    1.01527,
    1.01374,
    1.01219,
    1.01063,
    1.00906,
    1.00748,
    1.00589,
    1.00428,
    1.00267,
    1.00104,
    0.999402,
    0.997753,
    0.996092,
    0.994421,
    0.992738,
    0.991044,
    0.989339,
    0.987622,
    0.985895,
    0.984156,
    0.982406,
    0.980645,
    0.978873,
    0.977089,
    0.975295,
    0.97349,
    0.971673,
    0.969845,
    0.968007,
    0.966157,
    0.964297,
    0.962425,
    0.960543,
    0.95865,
    0.956745,
    0.95483,
    0.952904,
    0.950968,
    0.94902,
    0.947062,
    0.945093,
    0.943113,
    0.941123,
    0.939122,
    0.93711,
    0.935088,
    0.933055,
    0.931012,
    0.928958,
    0.926893,
    0.924819,
    0.922734,
    0.920638,
    0.918532,
    0.916416,
    0.91429,
    0.912153,
    0.910007,
    0.90785,
    0.905683,
    0.903506,
    0.901319,
    0.899122,
    0.896915,
    0.894698,
    0.892471,
    0.890235,
    0.887988,
    0.885732,
    0.883467,
    0.881191,
    0.878906,
    0.876612,
    0.874308,
    0.871995,
    0.869672,
    0.86734,
    0.864998,
    0.862648,
    0.860288,
    0.857919,
    0.855541,
    0.853153,
    0.850757,
    0.848352,
    0.845938,
    0.843516,
    0.841084,
    0.838644,
    0.836195,
    0.833738,
    0.831272,
    0.828797,
    0.826314,
    0.823823,
    0.821324,
    0.818816,
    0.8163,
    0.813776,
    0.811244,
    0.808704,
    0.806155,
    0.8036,
    0.801036,
    0.798464,
    0.795885,
    0.793298,
    0.790704,
    0.788102,
    0.785493,
    0.782877,
    0.780253,
    0.777622,
    0.774984,
    0.772339,
    0.769687,
    0.767027,
    0.764361,
    0.761689,
    0.759009,
    0.756323,
    0.753631,
    0.750931,
    0.748226,
    0.745514,
    0.742796,
    0.740071,
    0.737341,
    0.734604,
    0.731862,
    0.729113,
    0.726359,
    0.723599,
    0.720833,
    0.718062,
    0.715285,
    0.712503,
    0.709716,
    0.706923,
    0.704125,
    0.701322,
    0.698514,
    0.6957,
    0.692882,
    0.69006,
    0.687232,
    0.6844,
    0.681563,
    0.678722,
    0.675877,
    0.673027,
    0.670173,
    0.667315,
    0.664453,
    0.661587,
    0.658717,
    0.655843,
    0.652965,
    0.650084,
    0.647199,
    0.644311,
    0.64142,
    0.638525,
    0.635627,
    0.632726,
    0.629822,
    0.626915,
    0.624005,
    0.621092,
    0.618177,
    0.615259,
    0.612338,
    0.609415,
    0.60649,
    0.603563,
    0.600633,
    0.597702,
    0.594768,
    0.591833,
    0.588895,
    0.585956,
    0.583016,
    0.580074,
    0.57713,
    0.574185,
    0.571239,
    0.568292,
    0.565343,
    0.562394,
    0.559444,
    0.556492,
    0.553541,
    0.550588,
    0.547635,
    0.544682,
    0.541728,
    0.538774,
    0.53582,
    0.532865,
    0.529911,
    0.526957,
    0.524003,
    0.521049,
    0.518095,
    0.515142,
    0.51219,
    0.509238,
    0.506287,
    0.503337,
    0.500387,
    0.497439,
    0.494491,
    0.491545,
    0.4886,
    0.485657,
    0.482715,
    0.479774,
    0.476835,
    0.473898,
    0.470962,
    0.468029,
    0.465097,
    0.462168,
    0.45924,
    0.456315,
    0.453392,
    0.450472,
    0.447554,
    0.444638,
    0.441726,
    0.438816,
    0.435909,
    0.433005,
    0.430104,
    0.427206,
    0.424311,
    0.421419,
    0.418531,
    0.415646,
    0.412765,
    0.409888,
    0.407014,
    0.404144,
    0.401278,
    0.398415,
    0.395557,
    0.392703,
    0.389854,
    0.387008,
    0.384167,
    0.38133,
    0.378498,
    0.375671,
    0.372848,
    0.37003,
    0.367217,
    0.364409,
    0.361606,
    0.358808,
    0.356015,
    0.353227,
    0.350445,
    0.347668,
    0.344897,
    0.342131,
    0.339371,
    0.336617,
    0.333869,
    0.331126,
    0.32839,
    0.325659,
    0.322935,
    0.320217,
    0.317505,
    0.314799,
    0.3121,
    0.309407,
    0.306721,
    0.304042,
    0.301369,
    0.298703,
    0.296044,
    0.293392,
    0.290747,
    0.288108,
    0.285477,
    0.282854,
    0.280237,
    0.277628,
    0.275026,
    0.272432,
    0.269845,
    0.267266,
    0.264695,
    0.262131,
    0.259575,
    0.257027,
    0.254487,
    0.251955,
    0.249431,
    0.246915,
    0.244407,
    0.241907,
    0.239416,
    0.236933,
    0.234459,
    0.231993,
    0.229535,
    0.227086,
    0.224646,
    0.222215,
    0.219792,
    0.217378,
    0.214973,
    0.212577,
    0.21019,
    0.207812,
    0.205443,
    0.203083,
    0.200732,
    0.198391,
    0.196059,
    0.193736,
    0.191423,
    0.189119,
    0.186824,
    0.184539,
    0.182264,
    0.179998,
    0.177742,
    0.175496,
    0.173259,
    0.171033,
    0.168816,
    0.166609,
    0.164412,
    0.162225,
    0.160048,
    0.157881,
    0.155724,
    0.153577,
    0.15144,
    0.149314,
    0.147198,
    0.145092,
    0.142997,
    0.140912,
    0.138837,
    0.136773,
    0.134719,
    0.132675,
    0.130643,
    0.12862,
    0.126609,
    0.124608,
    0.122617,
    0.120638,
    0.118669,
    0.11671,
    0.114763,
    0.112826,
    0.1109,
    0.108985,
    0.107081,
    0.105188,
    0.103305,
    0.101434,
    0.0995731,
    0.0977235,
    0.0958849,
    0.0940574,
    0.0922409,
    0.0904354,
    0.088641,
    0.0868577,
    0.0850855,
    0.0833245,
    0.0815745,
    0.0798357,
    0.0781081,
    0.0763917,
    0.0746865,
    0.0729924,
    0.0713096,
    0.069638,
    0.0679777,
    0.0663286,
    0.0646908,
    0.0630642,
    0.0614489,
    0.0598449,
    0.0582522,
    0.0566708,
    0.0551007,
    0.0535418,
    0.0519943,
    0.0504582,
    0.0489333,
    0.0474197,
    0.0459175,
    0.0444266,
    0.042947,
    0.0414787,
    0.0400218,
    0.0385761,
    0.0371418,
    0.0357188,
    0.0343072,
    0.0329068,
    0.0315177,
    0.03014,
    0.0287735,
    0.0274183,
    0.0260744,
    0.0247418,
    0.0234204,
    0.0221103,
    0.0208114,
    0.0195238,
    0.0182474,
    0.0169822,
    0.0157283,
    0.0144855,
    0.0132539,
    0.0120335,
    0.0108242,
    0.00962607,
    0.00843907,
    0.00726317,
    0.00609838,
    0.00494466,
    0.003802,
    0.00267039,
    0.00154981,
    0.000440231,
    -0.000658358,
    -0.00174597,
    -0.00282265,
    -0.00388838,
    -0.00494321,
    -0.00598716,
    -0.00702024,
    -0.00804249,
    -0.00905391,
    -0.0100545,
    -0.0110444,
    -0.0120235,
    -0.0129919,
    -0.0139496,
    -0.0148967,
    -0.0158331,
    -0.0167588,
    -0.017674,
    -0.0185787,
    -0.0194728,
    -0.0203564,
    -0.0212296,
    -0.0220923,
    -0.0229446,
    -0.0237865,
    -0.024618,
    -0.0254393,
    -0.0262503,
    -0.027051,
    -0.0278415,
    -0.0286218,
    -0.029392,
    -0.0301521,
    -0.0309021,
    -0.031642,
    -0.032372,
    -0.0330919,
    -0.033802,
    -0.0345021,
    -0.0351924,
    -0.0358728,
    -0.0365435,
    -0.0372044,
    -0.0378557,
    -0.0384972,
    -0.0391291,
    -0.0397515,
    -0.0403643,
    -0.0409675,
    -0.0415614,
    -0.0421458,
    -0.0427208,
    -0.0432864,
    -0.0438428,
    -0.04439,
    -0.0449279,
    -0.0454566,
    -0.0459762,
    -0.0464868,
    -0.0469883,
    -0.0474808,
    -0.0479644,
    -0.0484391,
    -0.0489049,
    -0.0493619,
    -0.0498101,
    -0.0502497,
    -0.0506805,
    -0.0511028,
    -0.0515165,
    -0.0519216,
    -0.0523183,
    -0.0527065,
    -0.0530864,
    -0.0534579,
    -0.0538211,
    -0.0541762,
    -0.054523,
    -0.0548617,
    -0.0551923,
    -0.0555148,
    -0.0558294,
    -0.056136,
    -0.0564348,
    -0.0567257,
    -0.0570088,
    -0.0572842,
    -0.0575519,
    -0.057812,
    -0.0580645,
    -0.0583095,
    -0.0585469,
    -0.058777,
    -0.0589997,
    -0.0592151,
    -0.0594232,
    -0.0596241,
    -0.0598178,
    -0.0600044,
    -0.0601839,
    -0.0603565,
    -0.0605221,
    -0.0606808,
    -0.0608326,
    -0.0609777,
    -0.061116,
    -0.0612477,
    -0.0613727,
    -0.0614911,
    -0.061603,
    -0.0617084,
    -0.0618074,
    -0.0619001,
    -0.0619864,
    -0.0620665,
    -0.0621404,
    -0.0622082,
    -0.0622698,
    -0.0623254,
    -0.062375,
    -0.0624188,
    -0.0624566,
    -0.0624886,
    -0.0625149,
    -0.0625354,
    -0.0625503,
    -0.0625596,
    -0.0625633,
    -0.0625616,
    -0.0625544,
    -0.0625418,
    -0.0625239,
    -0.0625008,
    -0.0624724,
    -0.0624389,
    -0.0624002,
    -0.0623565,
    -0.0623078,
    -0.0622542,
    -0.0621956,
    -0.0621323,
    -0.0620641,
    -0.0619912,
    -0.0619136,
    -0.0618315,
    -0.0617447,
    -0.0616535,
    -0.0615578,
    -0.0614576,
    -0.0613532,
    -0.0612444,
    -0.0611314,
    -0.0610142,
    -0.0608928,
    -0.0607674,
    -0.060638,
    -0.0605045,
    -0.0603672,
    -0.060226,
    -0.0600809,
    -0.0599321,
    -0.0597796,
    -0.0596234,
    -0.0594636,
    -0.0593002,
    -0.0591334,
    -0.0589631,
    -0.0587893,
    -0.0586123,
    -0.0584319,
    -0.0582483,
    -0.0580615,
    -0.0578715,
    -0.0576784,
    -0.0574823,
    -0.0572832,
    -0.0570812,
    -0.0568762,
    -0.0566684,
    -0.0564578,
    -0.0562445,
    -0.0560285,
    -0.0558098,
    -0.0555885,
    -0.0553646,
    -0.0551383,
    -0.0549095,
    -0.0546783,
    -0.0544447,
    -0.0542088,
    -0.0539706,
    -0.0537303,
    -0.0534877,
    -0.053243,
    -0.0529962,
    -0.0527474,
    -0.0524966,
    -0.0522439,
    -0.0519892,
    -0.0517327,
    -0.0514744,
    -0.0512143,
    -0.0509525,
    -0.0506891,
    -0.0504239,
    -0.0501572,
    -0.0498889,
    -0.0496191,
    -0.0493479,
    -0.0490752,
    -0.0488012,
    -0.0485258,
    -0.0482491,
    -0.0479712,
    -0.047692,
    -0.0474117,
    -0.0471303,
    -0.0468477,
    -0.0465641,
    -0.0462795,
    -0.0459939,
    -0.0457073,
    -0.0454199,
    -0.0451317,
    -0.0448426,
    -0.0445527,
    -0.0442621,
    -0.0439708,
    -0.0436788,
    -0.0433862,
    -0.043093,
    -0.0427992,
    -0.0425049,
    -0.0422102,
    -0.041915,
    -0.0416194,
    -0.0413234,
    -0.041027,
    -0.0407304,
    -0.0404335,
    -0.0401363,
    -0.039839,
    -0.0395414,
    -0.0392437,
    -0.038946,
    -0.0386481,
    -0.0383502,
    -0.0380523,
    -0.0377544,
    -0.0374565,
    -0.0371588,
    -0.0368611,
    -0.0365636,
    -0.0362662,
    -0.0359691,
    -0.0356722,
    -0.0353755,
    -0.0350791,
    -0.0347831,
    -0.0344874,
    -0.034192,
    -0.0338971,
    -0.0336025,
    -0.0333085,
    -0.0330149,
    -0.0327218,
    -0.0324292,
    -0.0321372,
    -0.0318458,
    -0.0315549,
    -0.0312647,
    -0.0309752,
    -0.0306864,
    -0.0303982,
    -0.0301107,
    -0.029824,
    -0.0295381,
    -0.029253,
    -0.0289687,
    -0.0286852,
    -0.0284026,
    -0.0281209,
    -0.02784,
    -0.0275601,
    -0.0272812,
    -0.0270031,
    -0.0267261,
    -0.02645,
    -0.026175,
    -0.025901,
    -0.025628,
    -0.0253562,
    -0.0250854,
    -0.0248157,
    -0.0245471,
    -0.0242797,
    -0.0240134,
    -0.0237482,
    -0.0234843,
    -0.0232215,
    -0.0229599,
    -0.0226996,
    -0.0224406,
    -0.0221828,
    -0.0219262,
    -0.0216709,
    -0.0214169,
    -0.0211642,
    -0.0209128,
    -0.0206628,
    -0.0204141,
    -0.0201667,
    -0.0199207,
    -0.0196761,
    -0.0194329,
    -0.0191911,
    -0.0189507,
    -0.0187117,
    -0.0184741,
    -0.018238,
    -0.0180033,
    -0.0177701,
    -0.0175384,
    -0.0173081,
    -0.0170794,
    -0.0168521,
    -0.0166264,
    -0.0164022,
    -0.0161795,
    -0.0159583,
    -0.0157387,
    -0.0155205,
    -0.0153041,
    -0.0150891,
    -0.0148757,
    -0.0146639,
    -0.0144537,
    -0.014245,
    -0.014038,
    -0.0138326,
    -0.0136288,
    -0.0134265,
    -0.0132259,
    -0.0130268,
    -0.0128294,
    -0.0126335,
    -0.0124395,
    -0.0122469,
    -0.0120559,
    -0.0118666,
    -0.011679,
    -0.0114929,
    -0.0113085,
    -0.0111257,
    -0.0109445,
    -0.0107649,
    -0.0105869,
    -0.0104105,
    -0.0102359,
    -0.0100628,
    -0.00989136,
    -0.00972156,
    -0.00955315,
    -0.00938665,
    -0.00922169,
    -0.00905831,
    -0.00889644,
    -0.0087362,
    -0.00857756,
    -0.0084206,
    -0.00826525,
    -0.00811156,
    -0.00795943,
    -0.00780894,
    -0.00765996,
    -0.00751267,
    -0.0073667,
    -0.00722276,
    -0.00708027,
    -0.00693904,
    -0.00679959,
    -0.00666177,
    -0.0065257,
    -0.00639117,
    -0.00625827,
    -0.00612684,
    -0.005997,
    -0.00586865,
    -0.00574189,
    -0.00561666,
    -0.00549302,
    -0.00537102,
    -0.00525072,
    -0.00513092,
    -0.00501401,
    -0.00489838,
    -0.00478436,
    -0.00467141,
    -0.00456007,
    -0.0044499,
    -0.00434148,
    -0.00423427,
    -0.00412892,
    -0.00402465,
    -0.00392238,
    -0.0038209,
    -0.00372172,
    -0.00362218,
    -0.0035274,
    -0.00343338,
    -0.00333724,
    -0.00324385,
    -0.00315127,
    -0.00306111,
    -0.00297204,
    -0.00288504,
    -0.00279909,
    -0.00271496,
    -0.00263182,
    -0.00255035,
    -0.00246984,
    -0.00239093,
    -0.00231298,
    -0.00223662
};
