/*
	WinSTon
*/

// Decode table setup structure
typedef struct  {
	char szOpCode[17+1];
	int EffAddr;
	void *pDisassFunction;
	void *pDecodeFunction;
	unsigned long Cycles;
	int Size;
} TABLE_POPULATE;

// <ea> Decode functions settings
#define	OP_CYCLES(op,r,w)		(op)		// Not rounded to 4 - this is done when add <ea> in table

#define	TBL_EA_BYTE			0x00000001
#define	TBL_EA_WORD			0x00000002
#define	TBL_EA_LONG			0x00000003
#define	TBL_EA_LOAD			0x00000004
#define	TBL_EA_ADDCYCLES	0x80000000
	#define	TBL_EA_MASK		0x000000ff

#define	TBL_DN_1			0x00000100			// <ea> as Dn
#define	TBL_DNUPR_1			0x00000200
#define	TBL_AN_1			0x00000300			// <ea> as An
#define	TBL_ANUPR_1			0x00000400
#define	TBL_SOFFSET_1		0x00000500
#define	TBL_TRAP_1			0x00000600
	#define	TBL_MASK_1		0x0000ff00

#define	TBL_DN_2			0x00010000
#define	TBL_DNUPR_2			0x00020000
#define	TBL_AN_2			0x00030000
#define	TBL_ANUPR_2			0x00040000
#define TBL_DATA_2			0x00050000			// 'Q'uick data 0..7 (0 is '8')
	#define	TBL_MASK_2		0x00ff0000

extern void Tables_Init(void);
