/*
	WinSTon
*/

// Store flags if DirectDraw resolutions are available
typedef struct {
	BOOL Mode_320x200x256;
	BOOL Mode_320x240x256;
	BOOL Mode_640x400x256;
	BOOL Mode_640x480x256;
	BOOL Mode_320x200x16Bit;
	BOOL Mode_320x240x16Bit;
	BOOL Mode_640x400x16Bit;
	BOOL Mode_640x480x16Bit;
} AVAILABLE_DDRAW_MODES;

enum {
	MODE_320x200x256,
	MODE_320x240x256,
	MODE_640x400x256,
	MODE_640x480x256,
	MODE_800x600x256,
	MODE_1024x768x256,
	MODE_320x200x16BIT,
	MODE_320x240x16BIT,
	MODE_640x400x16BIT,
	MODE_640x480x16BIT,
	MODE_800x600x16BIT,
	MODE_1024x768x16BIT,
	NUM_AVAILABLE_DDRAW_MODES
};

typedef struct {
	int Width,Height,BitDepth;
} DISPLAYMODE_DETAILS;

#define NUM_DISPLAYMODEOPTIONS	6
enum {
	DISPLAYMODE_16COL_LOWRES,		// (fastest)
	DISPLAYMODE_16COL_HIGHRES,
	DISPLAYMODE_16COL_FULL,
	DISPLAYMODE_HICOL_LOWRES,
	DISPLAYMODE_HICOL_HIGHRES,
	DISPLAYMODE_HICOL_FULL			// (slowest)
};

#define NUM_VDIMODEOPTIONS		3
enum {
	VDIMODE_640x480,
	VDIMODE_800x600,
	VDIMODE_1024x768,
};

extern BOOL bDisableDirectDraw;
//extern IDirectDraw *pDDraw;
//extern IDirectDrawSurface *pPrimarySurface;
//extern IDirectDrawSurface *pBackSurface;
extern BOOL bDirectDrawWorking;
extern BOOL bAvailableDDrawModes[NUM_AVAILABLE_DDRAW_MODES];
extern int DisplayModeOptions[NUM_DISPLAYMODEOPTIONS];
extern char szDisplayModeTextNames[NUM_DISPLAYMODEOPTIONS][48];
extern char *pszAvailableDisplayModeTextNames[NUM_DISPLAYMODEOPTIONS+1];
extern int VDIModeOptions[NUM_VDIMODEOPTIONS];
extern char *pszAvailableVDIModeTextNames[NUM_VDIMODEOPTIONS+1];
//extern IDirectDrawPalette *pDDrawPalette;
extern unsigned short int RedMask,GreenMask,BlueMask,RedMaskShift,GreenMaskShift,BlueMaskShift;

extern void DSurface_SetPalette(void);
extern BOOL DSurface_IsHighResolutionMode(void);
extern BOOL DSurface_EnterDDrawFullScreen(int Mode);
extern BOOL DSurface_ReturnFromDDrawFullScreen(void);
extern void DSurface_Init(void);
extern void DSurface_UnInit(void);
extern void DSurface_FreeGDIScreen(void);
extern void DSurface_BlitGDIScreen(void);
extern BOOL DSurface_FlipToGDI(void);
