/*
	WinSTon
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggerdisass.h"
#include "..\includes\debuggerregisters.h"
#include "..\includes\debuggertab.h"
#include "..\includes\debuggertabmemory.h"
#include "..\includes\debuggertabmfp.h"
#include "..\includes\debuggertabikbd.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\disass.h"
#include "..\includes\file.h"
#include "..\includes\ikbd.h"
#include "..\includes\int.h"
#include "..\includes\m68000.h"
#include "..\includes\misc.h"
#include "..\includes\mfp.h"
#include "..\includes\screen.h"
#include "..\includes\stmemory.h"
#include "..\includes\view.h"
#include "..\includes\video.h"

#ifdef USE_DEBUGGER

char szBreakPointStrings[NUM_BREAKPOINTS+1][256];
char *pszBreakPointStrings[NUM_BREAKPOINTS+1] = {
	szBreakPointStrings[0],
	szBreakPointStrings[1],
	szBreakPointStrings[2],
	szBreakPointStrings[3],
	szBreakPointStrings[4],
	szBreakPointStrings[5],
	szBreakPointStrings[6],
	szBreakPointStrings[7],
	szBreakPointStrings[8]
};

unsigned long BreakpointAddress;

//-----------------------------------------------------------------------
/*
*/
void Debugger_Brk_Init(void)
{
	int i;

	for(i=0; i<NUM_BREAKPOINTS; i++)
		AddressBreakpoints[i] = BRK_DISABLED;
}

//-----------------------------------------------------------------------
/*
*/
BOOL PASCAL Debugger_Brk_Add_DlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char TmpStr[256];
	unsigned long Address;

	switch(Message) {
		case WM_INITDIALOG:
			// Set default entry in dialog
			sprintf(TmpStr,"%X",BreakpointAddress);
			SetDlgItemText(hWnd,IDC_EDIT_INSBREAKPOINT,TmpStr);
			return(FALSE);

		case WM_COMMAND:
			switch(wParam) {
				case IDOK:
					// Find hex address entered into dialog
					GetDlgItemText(hWnd,IDC_EDIT_INSBREAKPOINT,TmpStr,256);
					Address = 0;
					sscanf(TmpStr,"%X",&Address);
					// And set/clear breakpoint
					BreakpointAddress = Address&0xffffff;
					// And add to our list

				case IDCANCEL:
					EndDialog(hWnd,0);
					return(TRUE);
				}
			break;
	}

	return(FALSE);
}

//-----------------------------------------------------------------------
/*
*/
void Debugger_Brk_Add(void)
{
	PROC lpfnDlgProc;

	// Open add breakpoint dialog
	lpfnDlgProc = MakeProcInstance((PROC)Debugger_Brk_Add_DlgProc,hInst);
	DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_DIALOG10),NULL,(DLGPROC)lpfnDlgProc,NULL);
}

//-----------------------------------------------------------------------
/*
*/
BOOL PASCAL Debugger_Brk_DlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
	char TmpStr[256];
	unsigned long Address;
	int i;

	switch(Message) {
		case WM_INITDIALOG:
			// Set list of breakpoints
			for(i=0; i<NUM_BREAKPOINTS; i++) {
				if (AddressBreakpoints[i]!=BRK_DISABLED) {
					sprintf(szBreakPointStrings[i],"0x%8.8X",AddressBreakpoints[i]);
					pszBreakPointStrings[i] = szBreakPointStrings[i];
				}
			}
			pszBreakPointStrings[i] = NULL;
			Dialog_SetListBoxItems(hWnd,IDC_LIST_BRK,pszBreakPointStrings,0);
			return(FALSE);

		case WM_COMMAND:
			switch(wParam) {
				case ID_BRK_ADD:
					Debugger_Brk_Add();
					return(TRUE);

				case IDOK:
					// Find hex address entered into dialog
//					GetDlgItemText(hWnd,IDC_EDIT_INSBREAKPOINT,TmpStr,256);
//					Address = 0;
//					sscanf(TmpStr,"%X",&Address);
//					// And set/clear breakpoint
//					if (Address==BRK_DISABLED)
//						AddressBreakpoint = BRK_DISABLED;
//					else
//						AddressBreakpoint = Address&0xffffff;

				case IDCANCEL:
					EndDialog(hWnd,0);
					return(TRUE);
			}
			break;
	}

	return(FALSE);
}

//-----------------------------------------------------------------------
/*
*/
void Debugger_Brk_Dialog(void)
{
	PROC lpfnDlgProc;

	// Open breakpoint dialog
	lpfnDlgProc = MakeProcInstance((PROC)Debugger_Brk_DlgProc,hInst);
	DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_DIALOG10),NULL,(DLGPROC)lpfnDlgProc,NULL);
}


#endif	//USE_DEBUGGER
