;	WinSTon

;	SBCD Dx,Dy
;	SBCD -(Ax),-(Ay)

;	XNZVC
;	*U*U*

PUBLIC _sbcd_dn_dn
PUBLIC _sbcd_an_an

;-----------------------------------------------------------------------
;SBCD Dx,Dy
_sbcd_dn_dn PROC NEAR
	mov		edx,DECODE_2[ecx]						;Rx(src 'opcode' bits 0-2)
	mov		bl,BYTE PTR [edx]
	call	BCDtoDEC								;dl = RegX as decimal
	mov		edx,ebx

	mov		ecx,DECODE_1[ecx]						;Ry(dest 'opcode' bits 9-11)
	mov		bl,BYTE PTR [ecx]
	call	BCDtoDEC								;bl = RegY as decimal

	test	eax,EMU_X
	je		no_carry
	sub		ebx,edx
	dec		ebx										;RegY-(RegX+1)
	jmp		result
no_carry:
	sub		ebx,edx									;RegY-RegX
result:

	and		eax,NOT (EMU_X+EMU_C)
	cmp		ebx,0
	jge		no_overflow
	add		ebx,100
	or		eax,EMU_C+EMU_X
no_overflow:
	cmp		ebx,0
	je		not_zero
	and		eax,EMU_CLEAR_Z
not_zero:

	call	DECtoBCD								;bl = Reg as binary coded decimal
	mov		BYTE PTR [ecx],bl

	FRET
_sbcd_dn_dn ENDP

;-----------------------------------------------------------------------
;SBCD -(Ax),-(Ay)
_sbcd_an_an PROC NEAR
	mov		edx,DECODE_2[ecx]						;RegX
	cmp		edx,OFFSET _Regs+(15*4)
	jl		no_ay_a7								;Is (a7) or (a8)?
	sub		DWORD PTR [edx],SIZE_BYTE				;Yes, add SIZE_WORD
no_ay_a7:
	sub		DWORD PTR [edx],SIZE_BYTE
	mov		ebp,[edx]								;Look up contents
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		bl,BYTE PTR _STRam[ebp]
	call	BCDtoDEC								;dl = RegX as decimal
	mov		edx,ebx

	mov		ebp,DECODE_1[ecx]						;RegY
	cmp		ebp,OFFSET _Regs+(15*4)
	jl		no_ax_a7								;Is (a7) or (a8)?
	sub		DWORD PTR [ebp],SIZE_BYTE				;Yes, add SIZE_WORD
no_ax_a7:
	sub		DWORD PTR [ebp],SIZE_BYTE
	mov		ebp,[ebp]								;Look up contents
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		bl,BYTE PTR _STRam[ebp]
	call	BCDtoDEC								;bl = RegY as decimal

	test	eax,EMU_X
	je		no_carry
	sub		ebx,edx
	dec		ebx										;RegY-(RegX+1)
	jmp		result
no_carry:
	sub		ebx,edx									;RegY-RegX
result:

	and		eax,NOT (EMU_X+EMU_C)
	cmp		ebx,0
	jge		no_overflow
	add		ebx,100
	or		eax,EMU_C+EMU_X
no_overflow:
	cmp		ebx,0
	je		not_zero
	and		eax,EMU_CLEAR_Z
not_zero:

	call	DECtoBCD								;bl = Reg as binary coded decimal
	mov		BYTE PTR _STRam[ebp],bl
	FRET
_sbcd_an_an ENDP
