;	WinSTon

;	ROR Dx,Dy
;	ROR #<data>,Dy
;	ROR <ea>

;	XNZVC
;	-**0*

PUBLIC _ror_dn_dn_byte
PUBLIC _ror_dn_dn_word
PUBLIC _ror_dn_dn_long
PUBLIC _ror_imm_dn_byte
PUBLIC _ror_imm_dn_word
PUBLIC _ror_imm_dn_long
PUBLIC _ror_ea_word

;-----------------------------------------------------------------------
;ROR.B Dx,Dy
_ror_dn_dn_byte PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_byte							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	ror		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		bl,bl									;Test NZ value
	SET_NZ
_ror_dn_dn_byte ENDP

;ROR.W Dx,Dy
_ror_dn_dn_word PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_word							;Check shift count 0
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	ror		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		bx,bx									;Test NZ value
	SET_NZ
_ror_dn_dn_word ENDP

;ROR.L Dx,Dy
_ror_dn_dn_long PROC NEAR
	mov		ebx,DECODE_1[ecx]						;Dx
	mov		edx,DECODE_2[ecx]						;Dy(can corrupt 'ecx')
	mov		cl,BYTE PTR [ebx]
	and		ecx,63									;Modulus 64
	je		zero_shift_long							;Check shift count 0
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	ror		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		ebx,ebx									;Test NZ value
	SET_NZ
_ror_dn_dn_long ENDP

;-----------------------------------------------------------------------
;ROR.B #<data>,Dy
_ror_imm_dn_byte PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		bl,BYTE PTR [edx]						;And shift
shift_loop:
	ror		bl,1
	loop	shift_loop

	mov		BYTE PTR [edx],bl
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		bl,bl									;Test NZ value
	SET_NZ
_ror_imm_dn_byte ENDP

;ROR.W #<data>,Dy
_ror_imm_dn_word PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_BYTEWORD	ecx					;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		bx,WORD PTR [edx]						;And shift
shift_loop:
	ror		bx,1
	loop	shift_loop

	mov		WORD PTR [edx],bx
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		bx,bx									;Test NZ value
	SET_NZ
_ror_imm_dn_word ENDP

;ROR.L #<data>,Dy
_ror_imm_dn_long PROC NEAR
	mov		edx,DECODE_1[ecx]						;DReg
	mov		ecx,DECODE_2[ecx]						;Count		
	ADD_SHIFT_CYCLES_LONG	ecx						;NOTE corrupts 'ebx'

	xor		al,al									;Clear NZVC
	mov		ebx,DWORD PTR [edx]						;And shift
shift_loop:
	ror		ebx,1
	loop	shift_loop

	mov		DWORD PTR [edx],ebx
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		ebx,ebx									;Test NZ value
	SET_NZ
_ror_imm_dn_long ENDP

;-----------------------------------------------------------------------
;ROR.W <ea>
_ror_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>

	xor		al,al									;Clear NZVC
	ror		bx,1									;Rotate and get carry
	jnc		no_carry
	or		ax,EMU_C
no_carry:
	or		bx,bx									;Test NZ value
	WRITE_WORD_NZ
_ror_ea_word ENDP
